/*
 * Decompiled with CFR 0.152.
 */
package plugin.sample2.dialog;

import java.util.ArrayList;
import jp.sbi.celldesigner.plugin.PluginAlgebraicRule;
import jp.sbi.celldesigner.plugin.PluginAntiSenseRNA;
import jp.sbi.celldesigner.plugin.PluginAssignmentRule;
import jp.sbi.celldesigner.plugin.PluginCompartment;
import jp.sbi.celldesigner.plugin.PluginEvent;
import jp.sbi.celldesigner.plugin.PluginFunctionDefinition;
import jp.sbi.celldesigner.plugin.PluginGene;
import jp.sbi.celldesigner.plugin.PluginKineticLaw;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModel;
import jp.sbi.celldesigner.plugin.PluginModificationResidue;
import jp.sbi.celldesigner.plugin.PluginModifierSpeciesReference;
import jp.sbi.celldesigner.plugin.PluginParameter;
import jp.sbi.celldesigner.plugin.PluginProtein;
import jp.sbi.celldesigner.plugin.PluginRNA;
import jp.sbi.celldesigner.plugin.PluginRateRule;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginRule;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import jp.sbi.celldesigner.plugin.PluginSpeciesReference;
import jp.sbi.celldesigner.plugin.PluginUnitDefinition;
import jp.sbi.celldesigner.plugin.util.PluginReactionSymbolType;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.libsbml;
import plugin.sample2.dialog.BaseTabPanel;
import plugin.sample2.dialog.PluginSampleDialog;
import plugin.sample2.dialog.editdialog.PluginEventDialog;
import plugin.sample2.dialog.editdialog.PluginGeneRNADialog;
import plugin.sample2.dialog.editdialog.PluginProteinDialog;
import plugin.sample2.dialog.editdialog.PluginReactionDialog;
import plugin.sample2.dialog.editdialog.PluginSpeciesNodeDialog;
import plugin.sample2.dialog.editdialog.PluginUnitDefinitionDialog;

public class CommonSBaseViewingTab
extends BaseTabPanel {
    PluginSampleDialog parent;
    public static final int SPECIES = 0;
    public static final int SPECIES_ALIAS = 1;
    public static final int PROTEINS = 2;
    public static final int GENES = 3;
    public static final int RNAS = 4;
    public static final int ASRNAS = 5;
    public static final int REACTIONS = 6;
    public static final int KINETICLAWS = 7;
    public static final int COMPARTMENTS = 8;
    public static final int G_PARAMETERS = 9;
    public static final int FUNCTIONS = 10;
    public static final int UNITDEFINITIONS = 11;
    public static final int RULES = 12;
    public static final int EVENTS = 13;

    public CommonSBaseViewingTab(PluginSampleDialog parent, String tabName, PluginListOf listOfSBase) {
        this.parent = parent;
        this.tabName = tabName;
        this.listOfSBase = listOfSBase;
        this.initTabPanel();
        if (tabName.equals("KineticLaws")) {
            this.setAllButtonEnable(false);
        } else if (tabName.equals("Proteins") || tabName.equals("Genes") || tabName.equals("RNAs") || tabName.equals("AsRNAs")) {
            this.setDeleteButtonEnable(false);
        }
    }

    protected void addData() {
        PluginSpecies sbase = null;
        PluginModel model = PluginSampleDialog.model;
        if (PluginSampleDialog.tabPane.getSelectedIndex() == 0) {
            PluginSpecies species = sbase = new PluginSpecies("PROTEIN", "TEST" + ++PluginSampleDialog.idCount);
            species.getSpeciesAlias(0).setFramePosition(40.0, 40.0);
            model.addSpecies(species);
            PluginModificationResidue r = new PluginModificationResidue(species.getSpeciesAlias(0).getProtein());
            r.setName("bb");
            species.getSpeciesAlias(0).getProtein().addPluginModificationResidue(r);
            System.out.println(PluginSampleDialog.plug.notifySBaseAdded((PluginSBase)sbase));
            PluginSampleDialog.updateTable();
            return;
        }
        if (1 == PluginSampleDialog.tabPane.getSelectedIndex()) {
            if (((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow() == -1) {
                return;
            }
            PluginSpeciesAlias selectedAlias = (PluginSpeciesAlias)model.getListOfAllSpeciesAlias().get(this.getViewTabel().getSelectedRow());
            PluginSpeciesAlias alias = new PluginSpeciesAlias(selectedAlias.getSpecies(), selectedAlias.getExtensionType());
            PluginSpeciesAlias palias = selectedAlias.getSpecies().getSpeciesAlias(0);
            alias.setFramePosition(palias.getX() + 1.0, palias.getY() + 1.0);
            if (palias.getProtein() != null) {
                alias.setProtein(palias.getProtein());
            } else if (palias.getGene() != null) {
                alias.setGene(palias.getGene());
            } else if (palias.getRNA() != null) {
                alias.setRNA(palias.getRNA());
            } else if (palias.getAntiSenseRNA() != null) {
                alias.setAntiSenseRNA(palias.getAntiSenseRNA());
            }
            selectedAlias.getSpecies().addSpeciesAlias(alias);
            System.out.println(PluginSampleDialog.plug.notifySBaseAdded((PluginSBase)alias));
            PluginSampleDialog.updateTable();
            return;
        }
        if (2 == PluginSampleDialog.tabPane.getSelectedIndex()) {
            PluginSpecies species = sbase = new PluginSpecies("GENERIC", "TEST" + ++PluginSampleDialog.idCount);
            species.getSpeciesAlias(0).setFramePosition(40.0, 40.0);
            model.addSpecies(species);
            System.out.println(PluginSampleDialog.plug.notifySBaseAdded((PluginSBase)sbase));
            PluginSampleDialog.updateTable();
            return;
        }
        if (3 == PluginSampleDialog.tabPane.getSelectedIndex()) {
            PluginSpecies species = sbase = new PluginSpecies("GENE", "TEST" + ++PluginSampleDialog.idCount);
            species.getSpeciesAlias(0).setFramePosition(40.0, 40.0);
            model.addSpecies(species);
            System.out.println(PluginSampleDialog.plug.notifySBaseAdded((PluginSBase)sbase));
            PluginSampleDialog.updateTable();
            return;
        }
        if (4 == PluginSampleDialog.tabPane.getSelectedIndex()) {
            PluginSpecies species = sbase = new PluginSpecies("RNA", "TEST" + ++PluginSampleDialog.idCount);
            species.getSpeciesAlias(0).setFramePosition(40.0, 40.0);
            model.addSpecies(species);
            System.out.println(PluginSampleDialog.plug.notifySBaseAdded((PluginSBase)sbase));
            PluginSampleDialog.updateTable();
            return;
        }
        if (5 == PluginSampleDialog.tabPane.getSelectedIndex()) {
            PluginSpecies species = sbase = new PluginSpecies("ANTISENSE_RNA", "TEST" + ++PluginSampleDialog.idCount);
            species.getSpeciesAlias(0).setFramePosition(40.0, 40.0);
            model.addSpecies(species);
            System.out.println(PluginSampleDialog.plug.notifySBaseAdded((PluginSBase)sbase));
            PluginSampleDialog.updateTable();
            return;
        }
        if (6 == PluginSampleDialog.tabPane.getSelectedIndex()) {
            sbase = new PluginReaction();
            boolean reactionAddTest = true;
            if (reactionAddTest) {
                PluginReaction re = (PluginReaction)sbase;
                re.setReactionType("TRANSPORT");
                PluginSpecies newSp1 = new PluginSpecies("GENERIC", "test1");
                PluginSpeciesReference nref1 = new PluginSpeciesReference(re, newSp1.getSpeciesAlias(0));
                re.addReactant(nref1);
                model.addSpecies(newSp1);
                PluginSpecies newSp2 = new PluginSpecies("GENERIC", "test2");
                PluginSpeciesReference nref2 = new PluginSpeciesReference(re, newSp2.getSpeciesAlias(0));
                newSp2.getSpeciesAlias(0).setFramePosition(10.0, 10.0);
                re.addProduct(nref2);
                model.addSpecies(newSp2);
                PluginSpecies newSp3 = new PluginSpecies("GENERIC", "test3");
                PluginModifierSpeciesReference nref3 = new PluginModifierSpeciesReference(re, newSp3.getSpeciesAlias(0));
                newSp3.getSpeciesAlias(0).setFramePosition(20.0, 20.0);
                nref3.setModificationType("TRANSPORT");
                re.addModifier(nref3);
                model.addSpecies(newSp3);
                model.addReaction(re);
            }
        } else if (7 != PluginSampleDialog.tabPane.getSelectedIndex()) {
            if (8 == PluginSampleDialog.tabPane.getSelectedIndex()) {
                sbase = new PluginCompartment("SQUARE");
                ((PluginCompartment)sbase).setName("test");
                ((PluginCompartment)sbase).setX(100.0);
                ((PluginCompartment)sbase).setY(100.0);
                ((PluginCompartment)sbase).setWidth(100.0);
                ((PluginCompartment)sbase).setHeight(100.0);
                model.addCompartment((PluginCompartment)sbase);
            } else if (9 == PluginSampleDialog.tabPane.getSelectedIndex()) {
                sbase = new PluginParameter(model);
                ((PluginParameter)sbase).setId("test1");
                model.addParameter((PluginParameter)sbase);
            } else if (10 == PluginSampleDialog.tabPane.getSelectedIndex()) {
                sbase = new PluginFunctionDefinition("test1");
                model.addFunctionDefinition((PluginFunctionDefinition)sbase);
            } else if (11 == PluginSampleDialog.tabPane.getSelectedIndex()) {
                sbase = new PluginUnitDefinition("test1");
                model.addUnitDefinition((PluginUnitDefinition)sbase);
            } else if (12 == PluginSampleDialog.tabPane.getSelectedIndex()) {
                sbase = new PluginAlgebraicRule(model);
                model.addRule((PluginRule)sbase);
                System.out.println("sbase PARENT MODEL " + ((PluginAlgebraicRule)sbase).getParentModel().getNumRules());
                System.out.println("MODEL " + model.getNumRules());
            } else if (13 == PluginSampleDialog.tabPane.getSelectedIndex()) {
                sbase = new PluginEvent("test1");
                model.addEvent((PluginEvent)sbase);
            }
        }
        System.out.println(PluginSampleDialog.plug.notifySBaseAdded((PluginSBase)sbase));
        PluginSampleDialog.updateTable();
    }

    protected void deleteData() {
        PluginSpecies sbase = null;
        if (((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow() == -1) {
            return;
        }
        PluginModel model = PluginSampleDialog.model;
        if (PluginSampleDialog.tabPane.getSelectedIndex() == 0) {
            sbase = model.getSpecies(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
            model.removeSpecies(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
            PluginListOf list = new PluginListOf();
            PluginSpecies target = sbase;
            int i = 0;
            while (i < target.getListOfSpeciesAlias().size()) {
                PluginSpeciesAlias alias = target.getSpeciesAlias(i);
                int k = 0;
                while (k < model.getNumReactions()) {
                    PluginSpeciesReference ref;
                    PluginReaction re = model.getReaction(k);
                    int j = 0;
                    while (j < re.getNumReactants()) {
                        ref = re.getReactant(j);
                        if (ref.getAlias().getAliasID().equals(alias.getAliasID())) {
                            re.removeReactant(j);
                            break;
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < re.getNumProducts()) {
                        ref = re.getProduct(j);
                        if (ref.getAlias().getAliasID().equals(alias.getAliasID())) {
                            re.removeProduct(j);
                            break;
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < re.getNumModifiers()) {
                        ref = re.getModifier(j);
                        if (ref.getAlias().getAliasID().equals(alias.getAliasID())) {
                            re.removeModifier(j);
                            break;
                        }
                        ++j;
                    }
                    if (!PluginReactionSymbolType.isValidReaction((PluginReaction)re)) {
                        list.append((PluginSBase)re);
                    }
                    ++k;
                }
                ++i;
            }
            i = 0;
            while (i < list.size()) {
                model.removeReaction(((PluginReaction)list.get(i)).getId());
                ++i;
            }
        } else if (1 == PluginSampleDialog.tabPane.getSelectedIndex()) {
            PluginSpeciesAlias alias = (PluginSpeciesAlias)model.getListOfAllSpeciesAlias().get(this.getViewTabel().getSelectedRow());
            alias.getSpecies().removeSpeciesAlias(alias.getAliasID());
            if (alias.getSpecies().getNumSpeciesAlias() == 0) {
                model.removeSpecies(alias.getSpecies().getId());
                if (alias.getProtein() != null) {
                    if (model.getListOfSpecies(alias.getProtein()).size() == 0) {
                        model.removeProtein(alias.getProtein());
                    }
                } else if (alias.getRNA() != null) {
                    if (model.getListOfSpecies(alias.getRNA()).size() == 0) {
                        model.removeRNA(alias.getRNA());
                    }
                } else if (alias.getGene() != null) {
                    if (model.getListOfSpecies(alias.getGene()).size() == 0) {
                        model.removeGene(alias.getGene());
                    }
                } else if (alias.getAntiSenseRNA() != null && model.getListOfSpecies(alias.getAntiSenseRNA()).size() == 0) {
                    model.removeAntiSenseRNA(alias.getAntiSenseRNA());
                }
            }
            sbase = alias;
            PluginListOf list = new PluginListOf();
            int k = 0;
            while (k < model.getNumReactions()) {
                PluginSpeciesReference ref;
                PluginReaction re = model.getReaction(k);
                int j = 0;
                while (j < re.getNumReactants()) {
                    ref = re.getReactant(j);
                    if (ref.getAlias().getAliasID().equals(alias.getAliasID())) {
                        re.removeReactant(j);
                        break;
                    }
                    ++j;
                }
                j = 0;
                while (j < re.getNumProducts()) {
                    ref = re.getProduct(j);
                    if (ref.getAlias().getAliasID().equals(alias.getAliasID())) {
                        re.removeProduct(j);
                        break;
                    }
                    ++j;
                }
                j = 0;
                while (j < re.getNumModifiers()) {
                    ref = re.getModifier(j);
                    if (ref.getAlias().getAliasID().equals(alias.getAliasID())) {
                        re.removeModifier(j);
                        break;
                    }
                    ++j;
                }
                if (!PluginReactionSymbolType.isValidReaction((PluginReaction)re)) {
                    list.append((PluginSBase)re);
                }
                ++k;
            }
            int i = 0;
            while (i < list.size()) {
                model.removeReaction(((PluginReaction)list.get(i)).getId());
                ++i;
            }
        } else if (6 == PluginSampleDialog.tabPane.getSelectedIndex()) {
            sbase = model.getReaction(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
            model.removeReaction(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
        } else if (7 != PluginSampleDialog.tabPane.getSelectedIndex()) {
            if (8 == PluginSampleDialog.tabPane.getSelectedIndex()) {
                sbase = model.getCompartment(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
                model.removeCompartment(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
            } else if (9 == PluginSampleDialog.tabPane.getSelectedIndex()) {
                sbase = model.getParameter(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
                model.removeParameter(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
            } else if (10 == PluginSampleDialog.tabPane.getSelectedIndex()) {
                sbase = model.getFunctionDefinition(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
                model.removeFunctionDefinition(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
            } else if (11 == PluginSampleDialog.tabPane.getSelectedIndex()) {
                sbase = model.getUnitDefinition(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
                model.removeUnitDefinition(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
            } else if (12 == PluginSampleDialog.tabPane.getSelectedIndex()) {
                sbase = model.getRule(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
                model.removeRule(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
            } else if (13 == PluginSampleDialog.tabPane.getSelectedIndex()) {
                sbase = model.getEvent(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
                model.removeEvent(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
            }
        }
        System.out.println(PluginSampleDialog.plug.notifySBaseDeleted((PluginSBase)sbase));
        sbase = null;
        PluginSampleDialog.updateTable();
    }

    protected Object[][] formatForTableData() {
        ArrayList newData = new ArrayList();
        if (this.listOfSBase == null) {
            return new Object[0][0];
        }
        int i = 0;
        while (i < this.listOfSBase.size()) {
            PluginUnitDefinition unitsDefinition;
            PluginParameter parameter;
            PluginKineticLaw compartment;
            PluginSpecies species;
            ArrayList<Object> rowData = new ArrayList<Object>();
            if (this.tabName.equals("Species")) {
                species = (PluginSpecies)this.listOfSBase.get(i);
                if (species.getSpeciesAlias(0) != null) {
                    rowData.add(species.getSpeciesAlias(0).getExtensionType());
                    if (species.getSpeciesAlias(0).getExtensionId() != null) {
                        rowData.add(species.getSpeciesAlias(0).getExtensionId());
                    } else {
                        rowData.add("null");
                    }
                } else {
                    rowData.add("NULL");
                    rowData.add("null");
                }
                rowData.add(species.getPositionToCompartment());
                rowData.add(species.getId());
                rowData.add(species.getName());
                rowData.add(species.getCompartment());
                if (species.isSetInitialAmount()) {
                    rowData.add("Amount");
                    rowData.add(String.valueOf(species.getInitialAmount()));
                } else if (species.isSetInitialConcentration()) {
                    rowData.add("Concentration");
                    rowData.add(String.valueOf(species.getInitialConcentration()));
                } else {
                    rowData.add("");
                    rowData.add("");
                }
                rowData.add(species.getSubstanceUnits());
                rowData.add(species.getSpatialSizeUnits());
                rowData.add(new Boolean(species.getHasOnlySubstanceUnits()));
                rowData.add(new Boolean(species.getBoundaryCondition()));
                rowData.add(String.valueOf(species.getCharge()));
                rowData.add(new Boolean(species.getConstant()));
                rowData.add(String.valueOf(species.getNotesString()));
                newData.add(rowData);
            } else if (this.tabName.equals("SpeciesAlias")) {
                species = (PluginSpeciesAlias)this.listOfSBase.get(i);
                rowData.add(String.valueOf(species.getSpecies().getId()) + "//" + species.getModifications().size());
                rowData.add(species.getAliasID());
                rowData.add(species.getExtensionType());
                rowData.add(species.getName());
                rowData.add(Double.toString(species.getX()));
                rowData.add(Double.toString(species.getY()));
                newData.add(rowData);
            } else if (this.tabName.equals("Proteins")) {
                species = (PluginProtein)this.listOfSBase.get(i);
                rowData.add(species.getType());
                rowData.add(species.getExtensionId());
                rowData.add(species.getName());
                rowData.add(species.getNotesString());
                newData.add(rowData);
            } else if (this.tabName.equals("Genes")) {
                species = (PluginGene)this.listOfSBase.get(i);
                rowData.add(species.getType());
                rowData.add(species.getExtensionId());
                rowData.add(species.getName());
                rowData.add(species.getNotesString());
                newData.add(rowData);
            } else if (this.tabName.equals("RNAs")) {
                species = (PluginRNA)this.listOfSBase.get(i);
                rowData.add(species.getType());
                rowData.add(species.getExtensionId());
                rowData.add(species.getName());
                rowData.add(species.getNotesString());
                newData.add(rowData);
            } else if (this.tabName.equals("AsRNAs")) {
                species = (PluginAntiSenseRNA)this.listOfSBase.get(i);
                rowData.add(species.getType());
                rowData.add(species.getExtensionId());
                rowData.add(species.getName());
                rowData.add(species.getNotesString());
                newData.add(rowData);
            } else if (this.tabName.equals("Reactions")) {
                PluginReaction reaction = (PluginReaction)this.listOfSBase.get(i);
                rowData.add(reaction.getReactionType());
                rowData.add(reaction.getId());
                rowData.add(reaction.getName());
                rowData.add(new Boolean(reaction.getReversible()));
                rowData.add(new Boolean(reaction.getFast()));
                String reactants = "";
                int k = 0;
                while (k < reaction.getNumReactants()) {
                    reactants = String.valueOf(reactants) + reaction.getReactant(k).getSpecies();
                    if (k + 1 < reaction.getNumReactants()) {
                        reactants = String.valueOf(reactants) + ",";
                    }
                    ++k;
                }
                rowData.add(reactants);
                String products = "";
                int k2 = 0;
                while (k2 < reaction.getNumProducts()) {
                    products = String.valueOf(products) + reaction.getProduct(k2).getSpecies();
                    if (k2 + 1 < reaction.getNumProducts()) {
                        products = String.valueOf(products) + ",";
                    }
                    ++k2;
                }
                rowData.add(products);
                String modifiers = "";
                int k3 = 0;
                while (k3 < reaction.getNumModifiers()) {
                    modifiers = String.valueOf(modifiers) + reaction.getModifier(k3).getSpecies();
                    if (k3 + 1 < reaction.getNumModifiers()) {
                        modifiers = String.valueOf(modifiers) + ",";
                    }
                    ++k3;
                }
                rowData.add(modifiers);
                if (reaction.getKineticLaw() != null) {
                    rowData.add(reaction.getKineticLaw().getFormula());
                } else {
                    rowData.add("");
                }
                rowData.add(String.valueOf(reaction.getLineWidth()));
                rowData.add(String.valueOf(reaction.getNotesString()));
                newData.add(rowData);
            } else if (this.tabName.equals("KineticLaws")) {
                compartment = (PluginKineticLaw)this.listOfSBase.get(i);
                if (compartment == null) {
                    rowData.add("");
                    rowData.add("");
                    rowData.add("");
                } else {
                    if (compartment.getFormula() == null) {
                        rowData.add("");
                    } else {
                        rowData.add(compartment.getFormula());
                    }
                    rowData.add(compartment.getSubstanceUnits());
                    rowData.add(compartment.getTimeUnits());
                }
                newData.add(rowData);
            } else if (this.tabName.equals("Compartments")) {
                compartment = (PluginCompartment)this.listOfSBase.get(i);
                rowData.add(compartment.getId());
                rowData.add(compartment.getName());
                rowData.add(String.valueOf(compartment.getSpatialDimensions()));
                rowData.add(String.valueOf(compartment.getSize()));
                rowData.add(compartment.getUnits());
                rowData.add(compartment.getOutside());
                rowData.add(new Boolean(compartment.getConstant()));
                rowData.add(String.valueOf(compartment.getX()));
                rowData.add(String.valueOf(compartment.getY()));
                rowData.add(String.valueOf(compartment.getWidth()));
                rowData.add(String.valueOf(compartment.getHeight()));
                rowData.add(String.valueOf(compartment.getNotesString()));
                newData.add(rowData);
            } else if (this.tabName.equals("Lacal_Parameter")) {
                parameter = (PluginParameter)this.listOfSBase.get(i);
                rowData.add(String.valueOf(parameter.getParentSBaseID()) + ":" + parameter.getId());
                rowData.add(parameter.getName());
                rowData.add(String.valueOf(parameter.getValue()));
                rowData.add(parameter.getUnits());
                rowData.add(new Boolean(parameter.getConstant()));
                newData.add(rowData);
            } else if (this.tabName.equals("Global_Parameters")) {
                parameter = (PluginParameter)this.listOfSBase.get(i);
                rowData.add(parameter.getId());
                rowData.add(parameter.getName());
                rowData.add(String.valueOf(parameter.getValue()));
                rowData.add(parameter.getUnits());
                rowData.add(new Boolean(parameter.getConstant()));
                newData.add(rowData);
            } else if (this.tabName.equals("Functions")) {
                PluginFunctionDefinition function = (PluginFunctionDefinition)this.listOfSBase.get(i);
                rowData.add(function.getId());
                rowData.add(function.getName());
                rowData.add("argument");
                rowData.add("math");
                if (function.getMath() != null) {
                    rowData.add(libsbml.formulaToString((ASTNode)function.getMath()));
                }
                newData.add(rowData);
            } else if (this.tabName.equals("UnitDefinitions")) {
                unitsDefinition = (PluginUnitDefinition)this.listOfSBase.get(i);
                rowData.add(unitsDefinition.getId());
                rowData.add(unitsDefinition.getName());
                String units = "";
                int k = 0;
                while (k < unitsDefinition.getNumUnits()) {
                    units = String.valueOf(units) + unitsDefinition.getUnit(k);
                    if (k + 1 < unitsDefinition.getNumUnits()) {
                        units = String.valueOf(units) + ",";
                    }
                    ++k;
                }
                rowData.add(units);
                newData.add(rowData);
            } else if (this.tabName.equals("Rules")) {
                PluginAssignmentRule r;
                PluginRule rule = (PluginRule)this.listOfSBase.get(i);
                if (rule instanceof PluginAssignmentRule) {
                    r = (PluginAssignmentRule)rule;
                    rowData.add("AssignmentRule");
                    rowData.add(r.getFormula());
                    rowData.add(r.getVariable());
                } else if (rule instanceof PluginRateRule) {
                    r = (PluginRateRule)rule;
                    rowData.add("RateRule");
                    rowData.add(r.getFormula());
                    rowData.add(r.getVariable());
                } else {
                    rowData.add("AlgebraicRule");
                    rowData.add(rule.getFormula());
                    rowData.add("");
                }
                newData.add(rowData);
            } else if (this.tabName.equals("Events")) {
                unitsDefinition = (PluginEvent)this.listOfSBase.get(i);
                rowData.add(unitsDefinition.getId());
                rowData.add(unitsDefinition.getName());
                if (unitsDefinition.getTrigger() != null) {
                    rowData.add(libsbml.formulaToString((ASTNode)unitsDefinition.getTrigger().getMath()));
                } else {
                    rowData.add("");
                }
                if (unitsDefinition.getDelay() != null) {
                    rowData.add(libsbml.formulaToString((ASTNode)unitsDefinition.getDelay().getMath()));
                } else {
                    rowData.add("");
                }
                rowData.add(unitsDefinition.getTimeUnits());
                newData.add(rowData);
            }
            ++i;
        }
        Object[][] arrayData = new Object[newData.size()][1];
        int i2 = 0;
        while (i2 < newData.size()) {
            ArrayList data = (ArrayList)newData.get(i2);
            arrayData[i2] = data.toArray();
            ++i2;
        }
        return arrayData;
    }

    protected PluginListOf formatForArrayList() {
        return this.listOfSBase;
    }

    protected void buttonAdd_actionPerformed() {
        this.addData();
    }

    protected void buttonDelete_actionPerformed() {
        this.deleteData();
    }

    protected void buttonEdit_actionPerformed() {
        PluginModel model = PluginSampleDialog.model;
        if (1 == PluginSampleDialog.tabPane.getSelectedIndex()) {
            PluginSpeciesNodeDialog d = new PluginSpeciesNodeDialog((PluginSpeciesAlias)model.getListOfAllSpeciesAlias().get(this.getViewTabel().getSelectedRow()));
        } else if (6 == PluginSampleDialog.tabPane.getSelectedIndex()) {
            PluginReactionDialog d = new PluginReactionDialog(model.getReaction(this.getViewTabel().getSelectedRow()), false);
        } else if (11 == PluginSampleDialog.tabPane.getSelectedIndex()) {
            PluginUnitDefinitionDialog d = new PluginUnitDefinitionDialog(model.getUnitDefinition(this.getViewTabel().getSelectedRow()), false);
        } else if (13 == PluginSampleDialog.tabPane.getSelectedIndex()) {
            PluginEventDialog d = new PluginEventDialog(model.getEvent(this.getViewTabel().getSelectedRow()), false);
        } else if (2 == PluginSampleDialog.tabPane.getSelectedIndex()) {
            PluginProteinDialog d = new PluginProteinDialog(model.getListOfProteins().get(this.getViewTabel().getSelectedRow()));
        } else if (3 == PluginSampleDialog.tabPane.getSelectedIndex()) {
            PluginGeneRNADialog d = new PluginGeneRNADialog(model.getListOfGenes().get(this.getViewTabel().getSelectedRow()));
        } else if (4 == PluginSampleDialog.tabPane.getSelectedIndex()) {
            PluginGeneRNADialog d = new PluginGeneRNADialog(model.getListOfRNAs().get(this.getViewTabel().getSelectedRow()));
        } else if (5 == PluginSampleDialog.tabPane.getSelectedIndex()) {
            PluginGeneRNADialog pluginGeneRNADialog = new PluginGeneRNADialog(model.getListOfAntiSenseRNAs().get(this.getViewTabel().getSelectedRow()));
        }
    }
}

