/*
 * Decompiled with CFR 0.152.
 */
package plugin.sample1;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModel;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import plugin.sample1.SamplePlugin;

public class SamplePluginDialog
extends JDialog {
    private JPanel jContentPane = null;
    private JLabel jLabelName = null;
    private JLabel jLabelId = null;
    private JLabel jLabelX = null;
    private JLabel jLabelY = null;
    private JTextField textName = null;
    private JTextField textId = null;
    private JTextField textX = null;
    private JTextField textY = null;
    private JPanel jPanel = null;
    private JButton jButtonGET = null;
    private JButton jButtonADD = null;
    public static SamplePlugin plug;

    public SamplePluginDialog(SamplePlugin _plugin) {
        plug = _plugin;
        this.initialize();
    }

    public SamplePluginDialog(Frame arg0) throws HeadlessException {
        super(arg0);
        this.initialize();
    }

    public SamplePluginDialog(Frame arg0, boolean arg1) throws HeadlessException {
        super(arg0, arg1);
        this.initialize();
    }

    public SamplePluginDialog(Frame arg0, String arg1) throws HeadlessException {
        super(arg0, arg1);
        this.initialize();
    }

    public SamplePluginDialog(Frame arg0, String arg1, boolean arg2) throws HeadlessException {
        super(arg0, arg1, arg2);
        this.initialize();
    }

    public SamplePluginDialog(Frame arg0, String arg1, boolean arg2, GraphicsConfiguration arg3) {
        super(arg0, arg1, arg2, arg3);
        this.initialize();
    }

    public SamplePluginDialog(Dialog arg0) throws HeadlessException {
        super(arg0);
        this.initialize();
    }

    public SamplePluginDialog(Dialog arg0, boolean arg1) throws HeadlessException {
        super(arg0, arg1);
        this.initialize();
    }

    public SamplePluginDialog(Dialog arg0, String arg1) throws HeadlessException {
        super(arg0, arg1);
        this.initialize();
    }

    public SamplePluginDialog(Dialog arg0, String arg1, boolean arg2) throws HeadlessException {
        super(arg0, arg1, arg2);
        this.initialize();
    }

    public SamplePluginDialog(Dialog arg0, String arg1, boolean arg2, GraphicsConfiguration arg3) throws HeadlessException {
        super(arg0, arg1, arg2, arg3);
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setTitle("Species Information");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
            gridBagConstraints28.gridx = 1;
            gridBagConstraints28.gridy = 5;
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.fill = 2;
            gridBagConstraints27.gridy = 4;
            gridBagConstraints27.weightx = 1.0;
            gridBagConstraints27.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints27.gridx = 1;
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.fill = 2;
            gridBagConstraints26.gridy = 3;
            gridBagConstraints26.weightx = 1.0;
            gridBagConstraints26.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints26.gridx = 1;
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.fill = 2;
            gridBagConstraints25.gridy = 2;
            gridBagConstraints25.weightx = 1.0;
            gridBagConstraints25.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints25.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 4;
            this.jLabelY = new JLabel();
            this.jLabelY.setText("Y");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 3;
            this.jLabelX = new JLabel();
            this.jLabelX.setText("X");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 2;
            this.jLabelId = new JLabel();
            this.jLabelId.setText("ID");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.jLabelName = new JLabel();
            this.jLabelName.setText("Name");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jLabelName, gridBagConstraints);
            this.jContentPane.add((Component)this.jLabelId, gridBagConstraints1);
            this.jContentPane.add((Component)this.jLabelX, gridBagConstraints2);
            this.jContentPane.add((Component)this.jLabelY, gridBagConstraints3);
            this.jContentPane.add((Component)this.getTextName(), gridBagConstraints4);
            this.jContentPane.add((Component)this.getTextId(), gridBagConstraints25);
            this.jContentPane.add((Component)this.getTextX(), gridBagConstraints26);
            this.jContentPane.add((Component)this.getTextY(), gridBagConstraints27);
            this.jContentPane.add((Component)this.getJPanel(), gridBagConstraints28);
        }
        return this.jContentPane;
    }

    private JTextField getTextName() {
        if (this.textName == null) {
            this.textName = new JTextField();
        }
        return this.textName;
    }

    private JTextField getTextId() {
        if (this.textId == null) {
            this.textId = new JTextField();
        }
        return this.textId;
    }

    private JTextField getTextX() {
        if (this.textX == null) {
            this.textX = new JTextField();
        }
        return this.textX;
    }

    private JTextField getTextY() {
        if (this.textY == null) {
            this.textY = new JTextField();
        }
        return this.textY;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.add((Component)this.getJButtonGET(), null);
            this.jPanel.add((Component)this.getJButtonADD(), null);
        }
        return this.jPanel;
    }

    private JButton getJButtonGET() {
        if (this.jButtonGET == null) {
            this.jButtonGET = new JButton();
            this.jButtonGET.setText("GET");
            this.jButtonGET.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SamplePluginDialog.this.getSelectedSpecies();
                }
            });
        }
        return this.jButtonGET;
    }

    private void getSelectedSpecies() {
        PluginListOf listOf = plug.getSelectedSpeciesNode();
        if (listOf != null) {
            PluginSpeciesAlias alias = (PluginSpeciesAlias)listOf.get(0);
            if (!(alias instanceof PluginSpeciesAlias)) {
                JOptionPane.showMessageDialog(this, "No species selected!!", "error", 0);
                return;
            }
            double pos_x = alias.getX();
            double pos_y = alias.getY();
            PluginSpecies sp = alias.getSpecies();
            this.textName.setText(sp.getName());
            this.textId.setText(sp.getId());
            this.textX.setText(String.valueOf(pos_x).toString());
            this.textY.setText(String.valueOf(pos_y).toString());
        } else {
            JOptionPane.showMessageDialog(this, "No species selected!!", "error", 0);
        }
    }

    private JButton getJButtonADD() {
        if (this.jButtonADD == null) {
            this.jButtonADD = new JButton();
            this.jButtonADD.setText("ADD");
            this.jButtonADD.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SamplePluginDialog.this.addSpecies();
                }
            });
        }
        return this.jButtonADD;
    }

    private void addSpecies() {
        PluginModel model = plug.getSelectedModel();
        String name = this.textName.getText();
        PluginSpecies sbase = new PluginSpecies("GENERIC", name);
        String x = this.textX.getText();
        String y = this.textY.getText();
        try {
            double pos_x = Double.valueOf(x);
            double pos_y = Double.valueOf(y);
            PluginSpecies species = sbase;
            PluginSpeciesAlias psa = species.getSpeciesAlias(0);
            psa.setFramePosition(pos_x, pos_y);
            model.addSpecies(species);
            plug.notifySBaseAdded((PluginSBase)species);
            this.textX.setText(null);
            this.textY.setText(null);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Input number!!", "error", 0);
        }
    }
}

