/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.media.jai.DataBufferDouble;
import javax.media.jai.DataBufferFloat;
import javax.media.jai.JaiI18N;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;

public class LookupTableJAI
implements Serializable {
    transient DataBuffer data;
    private int[] tableOffsets;

    public LookupTableJAI(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.data = new DataBufferByte(byArray, byArray.length);
        this.initOffsets(1, 0);
    }

    public LookupTableJAI(byte[] byArray, int n) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n);
        this.data = new DataBufferByte(byArray, byArray.length);
    }

    public LookupTableJAI(byte[][] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(byArray.length, 0);
        this.data = new DataBufferByte(byArray, byArray[0].length);
    }

    public LookupTableJAI(byte[][] byArray, int n) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(byArray.length, n);
        this.data = new DataBufferByte(byArray, byArray[0].length);
    }

    public LookupTableJAI(byte[][] byArray, int[] nArray) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(byArray.length, nArray);
        this.data = new DataBufferByte(byArray, byArray[0].length);
    }

    public LookupTableJAI(short[] sArray, boolean bl) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, 0);
        this.data = bl ? new DataBufferUShort(sArray, sArray.length) : new DataBufferShort(sArray, sArray.length);
    }

    public LookupTableJAI(short[] sArray, int n, boolean bl) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n);
        this.data = bl ? new DataBufferUShort(sArray, sArray.length) : new DataBufferShort(sArray, sArray.length);
    }

    public LookupTableJAI(short[][] sArray, boolean bl) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(sArray.length, 0);
        this.data = bl ? new DataBufferUShort(sArray, sArray[0].length) : new DataBufferShort(sArray, sArray[0].length);
    }

    public LookupTableJAI(short[][] sArray, int n, boolean bl) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(sArray.length, n);
        this.data = bl ? new DataBufferUShort(sArray, sArray[0].length) : new DataBufferShort(sArray, sArray[0].length);
    }

    public LookupTableJAI(short[][] sArray, int[] nArray, boolean bl) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(sArray.length, nArray);
        this.data = bl ? new DataBufferUShort(sArray, sArray[0].length) : new DataBufferShort(sArray, sArray[0].length);
    }

    public LookupTableJAI(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, 0);
        this.data = new DataBufferInt(nArray, nArray.length);
    }

    public LookupTableJAI(int[] nArray, int n) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n);
        this.data = new DataBufferInt(nArray, nArray.length);
    }

    public LookupTableJAI(int[][] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(nArray.length, 0);
        this.data = new DataBufferInt(nArray, nArray[0].length);
    }

    public LookupTableJAI(int[][] nArray, int n) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(nArray.length, n);
        this.data = new DataBufferInt(nArray, nArray[0].length);
    }

    public LookupTableJAI(int[][] nArray, int[] nArray2) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(nArray.length, nArray2);
        this.data = new DataBufferInt(nArray, nArray[0].length);
    }

    public LookupTableJAI(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, 0);
        this.data = new DataBufferFloat(fArray, fArray.length);
    }

    public LookupTableJAI(float[] fArray, int n) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n);
        this.data = new DataBufferFloat(fArray, fArray.length);
    }

    public LookupTableJAI(float[][] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(fArray.length, 0);
        this.data = new DataBufferFloat(fArray, fArray[0].length);
    }

    public LookupTableJAI(float[][] fArray, int n) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(fArray.length, n);
        this.data = new DataBufferFloat(fArray, fArray[0].length);
    }

    public LookupTableJAI(float[][] fArray, int[] nArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(fArray.length, nArray);
        this.data = new DataBufferFloat(fArray, fArray[0].length);
    }

    public LookupTableJAI(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, 0);
        this.data = new DataBufferDouble(dArray, dArray.length);
    }

    public LookupTableJAI(double[] dArray, int n) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n);
        this.data = new DataBufferDouble(dArray, dArray.length);
    }

    public LookupTableJAI(double[][] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(dArray.length, 0);
        this.data = new DataBufferDouble(dArray, dArray[0].length);
    }

    public LookupTableJAI(double[][] dArray, int n) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(dArray.length, n);
        this.data = new DataBufferDouble(dArray, dArray[0].length);
    }

    public LookupTableJAI(double[][] dArray, int[] nArray) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(dArray.length, nArray);
        this.data = new DataBufferDouble(dArray, dArray[0].length);
    }

    public DataBuffer getData() {
        return this.data;
    }

    public byte[][] getByteData() {
        return this.data instanceof DataBufferByte ? ((DataBufferByte)this.data).getBankData() : null;
    }

    public byte[] getByteData(int n) {
        return this.data instanceof DataBufferByte ? ((DataBufferByte)this.data).getData(n) : null;
    }

    public short[][] getShortData() {
        if (this.data instanceof DataBufferUShort) {
            return ((DataBufferUShort)this.data).getBankData();
        }
        if (this.data instanceof DataBufferShort) {
            return ((DataBufferShort)this.data).getBankData();
        }
        return null;
    }

    public short[] getShortData(int n) {
        if (this.data instanceof DataBufferUShort) {
            return ((DataBufferUShort)this.data).getData(n);
        }
        if (this.data instanceof DataBufferShort) {
            return ((DataBufferShort)this.data).getData(n);
        }
        return null;
    }

    public int[][] getIntData() {
        return this.data instanceof DataBufferInt ? ((DataBufferInt)this.data).getBankData() : null;
    }

    public int[] getIntData(int n) {
        return this.data instanceof DataBufferInt ? ((DataBufferInt)this.data).getData(n) : null;
    }

    public float[][] getFloatData() {
        return this.data instanceof DataBufferFloat ? ((DataBufferFloat)this.data).getBankData() : null;
    }

    public float[] getFloatData(int n) {
        return this.data instanceof DataBufferFloat ? ((DataBufferFloat)this.data).getData(n) : null;
    }

    public double[][] getDoubleData() {
        return this.data instanceof DataBufferDouble ? ((DataBufferDouble)this.data).getBankData() : null;
    }

    public double[] getDoubleData(int n) {
        return this.data instanceof DataBufferDouble ? ((DataBufferDouble)this.data).getData(n) : null;
    }

    public int[] getOffsets() {
        return this.tableOffsets;
    }

    public int getOffset() {
        return this.tableOffsets[0];
    }

    public int getOffset(int n) {
        return this.tableOffsets[n];
    }

    public int getNumBands() {
        return this.data.getNumBanks();
    }

    public int getNumEntries() {
        return this.data.getSize();
    }

    public int getDataType() {
        return this.data.getDataType();
    }

    public int getDestNumBands(int n) {
        int n2 = this.getNumBands();
        return n == 1 ? n2 : n;
    }

    public SampleModel getDestSampleModel(SampleModel sampleModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.getDestSampleModel(sampleModel, sampleModel.getWidth(), sampleModel.getHeight());
    }

    public SampleModel getDestSampleModel(SampleModel sampleModel, int n, int n2) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!this.isIntegralDataType(sampleModel)) {
            return null;
        }
        return RasterFactory.createComponentSampleModel(sampleModel, this.getDataType(), n, n2, this.getDestNumBands(sampleModel.getNumBands()));
    }

    public boolean isIntegralDataType(SampleModel sampleModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.isIntegralDataType(sampleModel.getTransferType());
    }

    public boolean isIntegralDataType(int n) {
        return n == 0 || n == 1 || n == 2 || n == 3;
    }

    public int lookup(int n, int n2) {
        return this.data.getElem(n, n2 - this.tableOffsets[n]);
    }

    public float lookupFloat(int n, int n2) {
        return this.data.getElemFloat(n, n2 - this.tableOffsets[n]);
    }

    public double lookupDouble(int n, int n2) {
        return this.data.getElemDouble(n, n2 - this.tableOffsets[n]);
    }

    public WritableRaster lookup(WritableRaster writableRaster) {
        if (writableRaster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.lookup(writableRaster, writableRaster, writableRaster.getBounds());
    }

    public WritableRaster lookup(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        Object object;
        Object object2;
        Object[] objectArray;
        int n;
        Object object3;
        Object object4;
        SampleModel sampleModel;
        if (raster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("LookupTableJAI1"));
        }
        SampleModel sampleModel2 = raster.getSampleModel();
        if (!this.isIntegralDataType(sampleModel2)) {
            throw new IllegalArgumentException(JaiI18N.getString("LookupTableJAI2"));
        }
        rectangle = rectangle == null ? raster.getBounds() : rectangle.intersection(raster.getBounds());
        if (writableRaster != null) {
            rectangle = rectangle.intersection(writableRaster.getBounds());
        }
        if (writableRaster == null) {
            sampleModel = this.getDestSampleModel(sampleModel2, rectangle.width, rectangle.height);
            writableRaster = RasterFactory.createWritableRaster(sampleModel, new Point(rectangle.x, rectangle.y));
        } else {
            sampleModel = writableRaster.getSampleModel();
            if (sampleModel.getTransferType() != this.getDataType() || sampleModel.getNumBands() != this.getDestNumBands(sampleModel2.getNumBands())) {
                throw new IllegalArgumentException(JaiI18N.getString("LookupTableJAI3"));
            }
        }
        int n2 = RasterAccessor.findCompatibleTag(null, sampleModel2);
        int n3 = RasterAccessor.findCompatibleTag(null, sampleModel);
        RasterFormatTag rasterFormatTag = new RasterFormatTag(sampleModel2, n2);
        RasterFormatTag rasterFormatTag2 = new RasterFormatTag(sampleModel, n3);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle, rasterFormatTag, null);
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTag2, null);
        int n4 = rasterAccessor.getNumBands();
        int n5 = rasterAccessor.getDataType();
        int n6 = this.getNumBands();
        int n7 = this.getDataType();
        int n8 = rasterAccessor2.getWidth();
        int n9 = rasterAccessor2.getHeight();
        int n10 = rasterAccessor2.getNumBands();
        int n11 = rasterAccessor2.getDataType();
        int n12 = rasterAccessor.getScanlineStride();
        int n13 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        Object object5 = rasterAccessor.getByteDataArrays();
        Object object6 = rasterAccessor.getShortDataArrays();
        Object object7 = rasterAccessor.getIntDataArrays();
        if (n4 < n10) {
            int n14 = nArray[0];
            nArray = new int[n10];
            int n15 = 0;
            while (n15 < n10) {
                nArray[n15] = n14;
                ++n15;
            }
            switch (n5) {
                case 0: {
                    object4 = object5[0];
                    object5 = new byte[n10][];
                    int n16 = 0;
                    while (n16 < n10) {
                        object5[n16] = (byte[])object4;
                        ++n16;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    object3 = object6[0];
                    object6 = new short[n10][];
                    int n17 = 0;
                    while (n17 < n10) {
                        object6[n17] = (short[])object3;
                        ++n17;
                    }
                    break;
                }
                case 3: {
                    int[] nArray2 = object7[0];
                    object7 = new int[n10][];
                    n = 0;
                    while (n < n10) {
                        object7[n] = nArray2;
                        ++n;
                    }
                    break;
                }
            }
        }
        int[] nArray3 = this.getOffsets();
        Object object8 = this.getByteData();
        object4 = this.getShortData();
        Object object9 = this.getIntData();
        object3 = this.getFloatData();
        Object object10 = this.getDoubleData();
        if (n6 < n10) {
            int n18 = nArray3[0];
            nArray3 = new int[n10];
            n = 0;
            while (n < n10) {
                nArray3[n] = n18;
                ++n;
            }
            switch (n7) {
                case 0: {
                    objectArray = object8[0];
                    object8 = new byte[n10][];
                    int n19 = 0;
                    while (n19 < n10) {
                        object8[n19] = (byte[])objectArray;
                        ++n19;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    object2 = object4[0];
                    object4 = new short[n10][];
                    int n20 = 0;
                    while (n20 < n10) {
                        object4[n20] = (short[])object2;
                        ++n20;
                    }
                    break;
                }
                case 3: {
                    object = object9[0];
                    object9 = new int[n10][];
                    int n21 = 0;
                    while (n21 < n10) {
                        object9[n21] = object;
                        ++n21;
                    }
                    break;
                }
                case 4: {
                    float[] fArray = object3[0];
                    object3 = new float[n10][];
                    int n22 = 0;
                    while (n22 < n10) {
                        object3[n22] = fArray;
                        ++n22;
                    }
                    break;
                }
                case 5: {
                    double[] dArray = object10[0];
                    object10 = new double[n10][];
                    int n23 = 0;
                    while (n23 < n10) {
                        object10[n23] = dArray;
                        ++n23;
                    }
                    break;
                }
            }
        }
        int n24 = rasterAccessor2.getScanlineStride();
        n = rasterAccessor2.getPixelStride();
        objectArray = rasterAccessor2.getBandOffsets();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        object2 = rasterAccessor2.getShortDataArrays();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        object = rasterAccessor2.getFloatDataArrays();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        block12 : switch (n11) {
            case 0: {
                switch (n5) {
                    case 0: {
                        this.lookup(n12, n13, nArray, (byte[][])object5, n8, n9, n10, n24, n, (int[])objectArray, byArray, nArray3, (byte[][])object8);
                        break;
                    }
                    case 1: {
                        this.lookupU(n12, n13, nArray, (short[][])object6, n8, n9, n10, n24, n, (int[])objectArray, byArray, nArray3, (byte[][])object8);
                        break;
                    }
                    case 2: {
                        this.lookup(n12, n13, nArray, (short[][])object6, n8, n9, n10, n24, n, (int[])objectArray, byArray, nArray3, (byte[][])object8);
                        break;
                    }
                    case 3: {
                        this.lookup(n12, n13, nArray, (int[][])object7, n8, n9, n10, n24, n, (int[])objectArray, byArray, nArray3, (byte[][])object8);
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                switch (n5) {
                    case 0: {
                        this.lookup(n12, n13, nArray, (byte[][])object5, n8, n9, n10, n24, n, (int[])objectArray, (short[][])object2, nArray3, (short[][])object4);
                        break;
                    }
                    case 1: {
                        this.lookupU(n12, n13, nArray, (short[][])object6, n8, n9, n10, n24, n, (int[])objectArray, (short[][])object2, nArray3, (short[][])object4);
                        break;
                    }
                    case 2: {
                        this.lookup(n12, n13, nArray, (short[][])object6, n8, n9, n10, n24, n, (int[])objectArray, (short[][])object2, nArray3, (short[][])object4);
                        break;
                    }
                    case 3: {
                        this.lookup(n12, n13, nArray, (int[][])object7, n8, n9, n10, n24, n, (int[])objectArray, (short[][])object2, nArray3, (short[][])object4);
                    }
                }
                break;
            }
            case 3: {
                switch (n5) {
                    case 0: {
                        this.lookup(n12, n13, nArray, (byte[][])object5, n8, n9, n10, n24, n, (int[])objectArray, nArray4, nArray3, (int[][])object9);
                        break;
                    }
                    case 1: {
                        this.lookupU(n12, n13, nArray, (short[][])object6, n8, n9, n10, n24, n, (int[])objectArray, nArray4, nArray3, (int[][])object9);
                        break;
                    }
                    case 2: {
                        this.lookup(n12, n13, nArray, (short[][])object6, n8, n9, n10, n24, n, (int[])objectArray, nArray4, nArray3, (int[][])object9);
                        break;
                    }
                    case 3: {
                        this.lookup(n12, n13, nArray, (int[][])object7, n8, n9, n10, n24, n, (int[])objectArray, nArray4, nArray3, (int[][])object9);
                    }
                }
                break;
            }
            case 4: {
                switch (n5) {
                    case 0: {
                        this.lookup(n12, n13, nArray, (byte[][])object5, n8, n9, n10, n24, n, (int[])objectArray, (float[][])object, nArray3, (float[][])object3);
                        break;
                    }
                    case 1: {
                        this.lookupU(n12, n13, nArray, (short[][])object6, n8, n9, n10, n24, n, (int[])objectArray, (float[][])object, nArray3, (float[][])object3);
                        break;
                    }
                    case 2: {
                        this.lookup(n12, n13, nArray, (short[][])object6, n8, n9, n10, n24, n, (int[])objectArray, (float[][])object, nArray3, (float[][])object3);
                        break;
                    }
                    case 3: {
                        this.lookup(n12, n13, nArray, (int[][])object7, n8, n9, n10, n24, n, (int[])objectArray, (float[][])object, nArray3, (float[][])object3);
                    }
                }
                break;
            }
            case 5: {
                switch (n5) {
                    case 0: {
                        this.lookup(n12, n13, nArray, (byte[][])object5, n8, n9, n10, n24, n, (int[])objectArray, dArray, nArray3, (double[][])object10);
                        break block12;
                    }
                    case 1: {
                        this.lookupU(n12, n13, nArray, (short[][])object6, n8, n9, n10, n24, n, (int[])objectArray, dArray, nArray3, (double[][])object10);
                        break block12;
                    }
                    case 2: {
                        this.lookup(n12, n13, nArray, (short[][])object6, n8, n9, n10, n24, n, (int[])objectArray, dArray, nArray3, (double[][])object10);
                        break block12;
                    }
                    case 3: {
                        this.lookup(n12, n13, nArray, (int[][])object7, n8, n9, n10, n24, n, (int[])objectArray, dArray, nArray3, (double[][])object10);
                    }
                }
            }
        }
        rasterAccessor2.copyDataToRaster();
        return writableRaster;
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, byte[][] byArray2, int[] nArray3, byte[][] byArray3) {
        int n8 = 0;
        while (n8 < n5) {
            byte[] byArray4 = byArray[n8];
            byte[] byArray5 = byArray2[n8];
            byte[] byArray6 = byArray3[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    byArray5[n14] = byArray6[(byArray4[n13] & 0xFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, byte[][] byArray, int[] nArray3, byte[][] byArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    byArray3[n14] = byArray4[(sArray2[n13] & 0xFFFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, byte[][] byArray, int[] nArray3, byte[][] byArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    byArray3[n14] = byArray4[sArray2[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, byte[][] byArray, int[] nArray4, byte[][] byArray2) {
        int n8 = 0;
        while (n8 < n5) {
            int[] nArray5 = nArray2[n8];
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray3[n8];
            int n11 = nArray4[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    byArray3[n14] = byArray4[nArray5[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, short[][] sArray, int[] nArray3, short[][] sArray2) {
        int n8 = 0;
        while (n8 < n5) {
            byte[] byArray2 = byArray[n8];
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    sArray3[n14] = sArray4[(byArray2[n13] & 0xFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, short[][] sArray2, int[] nArray3, short[][] sArray3) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray4 = sArray[n8];
            short[] sArray5 = sArray2[n8];
            short[] sArray6 = sArray3[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    sArray5[n14] = sArray6[(sArray4[n13] & 0xFFFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, short[][] sArray2, int[] nArray3, short[][] sArray3) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray4 = sArray[n8];
            short[] sArray5 = sArray2[n8];
            short[] sArray6 = sArray3[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    sArray5[n14] = sArray6[sArray4[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, short[][] sArray, int[] nArray4, short[][] sArray2) {
        int n8 = 0;
        while (n8 < n5) {
            int[] nArray5 = nArray2[n8];
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray3[n8];
            int n11 = nArray4[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    sArray3[n14] = sArray4[nArray5[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, int[][] nArray3, int[] nArray4, int[][] nArray5) {
        if (nArray5 == null) {
            int n8 = 0;
            while (n8 < n5) {
                byte[] byArray2 = byArray[n8];
                int[] nArray6 = nArray3[n8];
                int n9 = nArray[n8];
                int n10 = nArray2[n8];
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = n9;
                    int n13 = n10;
                    n9 += n;
                    n10 += n6;
                    int n14 = 0;
                    while (n14 < n3) {
                        nArray6[n13] = this.data.getElem(n8, byArray2[n12] & 0xFF);
                        n12 += n2;
                        n13 += n7;
                        ++n14;
                    }
                    ++n11;
                }
                ++n8;
            }
        } else {
            int n15 = 0;
            while (n15 < n5) {
                byte[] byArray3 = byArray[n15];
                int[] nArray7 = nArray3[n15];
                int[] nArray8 = nArray5[n15];
                int n16 = nArray[n15];
                int n17 = nArray2[n15];
                int n18 = nArray4[n15];
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = n16;
                    int n21 = n17;
                    n16 += n;
                    n17 += n6;
                    int n22 = 0;
                    while (n22 < n3) {
                        nArray7[n21] = nArray8[(byArray3[n20] & 0xFF) - n18];
                        n20 += n2;
                        n21 += n7;
                        ++n22;
                    }
                    ++n19;
                }
                ++n15;
            }
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, int[][] nArray3, int[] nArray4, int[][] nArray5) {
        if (nArray5 == null) {
            int n8 = 0;
            while (n8 < n5) {
                short[] sArray2 = sArray[n8];
                int[] nArray6 = nArray3[n8];
                int n9 = nArray[n8];
                int n10 = nArray2[n8];
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = n9;
                    int n13 = n10;
                    n9 += n;
                    n10 += n6;
                    int n14 = 0;
                    while (n14 < n3) {
                        nArray6[n13] = this.data.getElem(n8, sArray2[n12] & 0xFFFF);
                        n12 += n2;
                        n13 += n7;
                        ++n14;
                    }
                    ++n11;
                }
                ++n8;
            }
        } else {
            int n15 = 0;
            while (n15 < n5) {
                short[] sArray3 = sArray[n15];
                int[] nArray7 = nArray3[n15];
                int[] nArray8 = nArray5[n15];
                int n16 = nArray[n15];
                int n17 = nArray2[n15];
                int n18 = nArray4[n15];
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = n16;
                    int n21 = n17;
                    n16 += n;
                    n17 += n6;
                    int n22 = 0;
                    while (n22 < n3) {
                        nArray7[n21] = nArray8[(sArray3[n20] & 0xFFFF) - n18];
                        n20 += n2;
                        n21 += n7;
                        ++n22;
                    }
                    ++n19;
                }
                ++n15;
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, int[][] nArray3, int[] nArray4, int[][] nArray5) {
        if (nArray5 == null) {
            int n8 = 0;
            while (n8 < n5) {
                short[] sArray2 = sArray[n8];
                int[] nArray6 = nArray3[n8];
                int n9 = nArray[n8];
                int n10 = nArray2[n8];
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = n9;
                    int n13 = n10;
                    n9 += n;
                    n10 += n6;
                    int n14 = 0;
                    while (n14 < n3) {
                        nArray6[n13] = this.data.getElem(n8, sArray2[n12]);
                        n12 += n2;
                        n13 += n7;
                        ++n14;
                    }
                    ++n11;
                }
                ++n8;
            }
        } else {
            int n15 = 0;
            while (n15 < n5) {
                short[] sArray3 = sArray[n15];
                int[] nArray7 = nArray3[n15];
                int[] nArray8 = nArray5[n15];
                int n16 = nArray[n15];
                int n17 = nArray2[n15];
                int n18 = nArray4[n15];
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = n16;
                    int n21 = n17;
                    n16 += n;
                    n17 += n6;
                    int n22 = 0;
                    while (n22 < n3) {
                        nArray7[n21] = nArray8[sArray3[n20] - n18];
                        n20 += n2;
                        n21 += n7;
                        ++n22;
                    }
                    ++n19;
                }
                ++n15;
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, int[][] nArray4, int[] nArray5, int[][] nArray6) {
        if (nArray6 == null) {
            int n8 = 0;
            while (n8 < n5) {
                int[] nArray7 = nArray2[n8];
                int[] nArray8 = nArray4[n8];
                int n9 = nArray[n8];
                int n10 = nArray3[n8];
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = n9;
                    int n13 = n10;
                    n9 += n;
                    n10 += n6;
                    int n14 = 0;
                    while (n14 < n3) {
                        nArray8[n13] = this.data.getElem(n8, nArray7[n12]);
                        n12 += n2;
                        n13 += n7;
                        ++n14;
                    }
                    ++n11;
                }
                ++n8;
            }
        } else {
            int n15 = 0;
            while (n15 < n5) {
                int[] nArray9 = nArray2[n15];
                int[] nArray10 = nArray4[n15];
                int[] nArray11 = nArray6[n15];
                int n16 = nArray[n15];
                int n17 = nArray3[n15];
                int n18 = nArray5[n15];
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = n16;
                    int n21 = n17;
                    n16 += n;
                    n17 += n6;
                    int n22 = 0;
                    while (n22 < n3) {
                        nArray10[n21] = nArray11[nArray9[n20] - n18];
                        n20 += n2;
                        n21 += n7;
                        ++n22;
                    }
                    ++n19;
                }
                ++n15;
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, float[][] fArray, int[] nArray3, float[][] fArray2) {
        int n8 = 0;
        while (n8 < n5) {
            byte[] byArray2 = byArray[n8];
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    fArray3[n14] = fArray4[(byArray2[n13] & 0xFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, float[][] fArray, int[] nArray3, float[][] fArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    fArray3[n14] = fArray4[(sArray2[n13] & 0xFFFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, float[][] fArray, int[] nArray3, float[][] fArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    fArray3[n14] = fArray4[sArray2[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, float[][] fArray, int[] nArray4, float[][] fArray2) {
        int n8 = 0;
        while (n8 < n5) {
            int[] nArray5 = nArray2[n8];
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray3[n8];
            int n11 = nArray4[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    fArray3[n14] = fArray4[nArray5[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, double[][] dArray, int[] nArray3, double[][] dArray2) {
        int n8 = 0;
        while (n8 < n5) {
            byte[] byArray2 = byArray[n8];
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    dArray3[n14] = dArray4[(byArray2[n13] & 0xFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, double[][] dArray, int[] nArray3, double[][] dArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    dArray3[n14] = dArray4[(sArray2[n13] & 0xFFFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, double[][] dArray, int[] nArray3, double[][] dArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    dArray3[n14] = dArray4[sArray2[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, double[][] dArray, int[] nArray4, double[][] dArray2) {
        int n8 = 0;
        while (n8 < n5) {
            int[] nArray5 = nArray2[n8];
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray3[n8];
            int n11 = nArray4[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    dArray3[n14] = dArray4[nArray5[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    public int findNearestEntry(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = this.data.getDataType();
        int n2 = this.getNumBands();
        int n3 = this.getNumEntries();
        int n4 = -1;
        if (n == 0) {
            byte[][] byArray = this.getByteData();
            float f = 0.0f;
            n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                float f2 = fArray[n5] - (float)(byArray[n5][0] & 0xFF);
                f += f2 * f2;
                ++n5;
            }
            int n6 = 1;
            while (n6 < n3) {
                float f3 = 0.0f;
                int n7 = 0;
                while (n7 < n2) {
                    float f4 = fArray[n7] - (float)(byArray[n7][n6] & 0xFF);
                    f3 += f4 * f4;
                    ++n7;
                }
                if (f3 < f) {
                    f = f3;
                    n4 = n6;
                }
                ++n6;
            }
        } else if (n == 2) {
            short[][] sArray = this.getShortData();
            float f = 0.0f;
            n4 = 0;
            int n8 = 0;
            while (n8 < n2) {
                float f5 = fArray[n8] - (float)sArray[n8][0];
                f += f5 * f5;
                ++n8;
            }
            int n9 = 1;
            while (n9 < n3) {
                float f6 = 0.0f;
                int n10 = 0;
                while (n10 < n2) {
                    float f7 = fArray[n10] - (float)sArray[n10][n9];
                    f6 += f7 * f7;
                    ++n10;
                }
                if (f6 < f) {
                    f = f6;
                    n4 = n9;
                }
                ++n9;
            }
        } else if (n == 1) {
            short[][] sArray = this.getShortData();
            float f = 0.0f;
            n4 = 0;
            int n11 = 0;
            while (n11 < n2) {
                float f8 = fArray[n11] - (float)(sArray[n11][0] & 0xFFFF);
                f += f8 * f8;
                ++n11;
            }
            int n12 = 1;
            while (n12 < n3) {
                float f9 = 0.0f;
                int n13 = 0;
                while (n13 < n2) {
                    float f10 = fArray[n13] - (float)(sArray[n13][n12] & 0xFFFF);
                    f9 += f10 * f10;
                    ++n13;
                }
                if (f9 < f) {
                    f = f9;
                    n4 = n12;
                }
                ++n12;
            }
        } else if (n == 3) {
            int[][] nArray = this.getIntData();
            float f = 0.0f;
            n4 = 0;
            int n14 = 0;
            while (n14 < n2) {
                float f11 = fArray[n14] - (float)nArray[n14][0];
                f += f11 * f11;
                ++n14;
            }
            int n15 = 1;
            while (n15 < n3) {
                float f12 = 0.0f;
                int n16 = 0;
                while (n16 < n2) {
                    float f13 = fArray[n16] - (float)nArray[n16][n15];
                    f12 += f13 * f13;
                    ++n16;
                }
                if (f12 < f) {
                    f = f12;
                    n4 = n15;
                }
                ++n15;
            }
        } else if (n == 4) {
            float[][] fArray2 = this.getFloatData();
            float f = 0.0f;
            n4 = 0;
            int n17 = 0;
            while (n17 < n2) {
                float f14 = fArray[n17] - fArray2[n17][0];
                f += f14 * f14;
                ++n17;
            }
            int n18 = 1;
            while (n18 < n3) {
                float f15 = 0.0f;
                int n19 = 0;
                while (n19 < n2) {
                    float f16 = fArray[n19] - fArray2[n19][n18];
                    f15 += f16 * f16;
                    ++n19;
                }
                if (f15 < f) {
                    f = f15;
                    n4 = n18;
                }
                ++n18;
            }
        } else if (n == 5) {
            double[][] dArray = this.getDoubleData();
            double d = 0.0;
            n4 = 0;
            int n20 = 0;
            while (n20 < n2) {
                double d2 = (double)fArray[n20] - dArray[n20][0];
                d += d2 * d2;
                ++n20;
            }
            int n21 = 1;
            while (n21 < n3) {
                double d3 = 0.0;
                int n22 = 0;
                while (n22 < n2) {
                    double d4 = (double)fArray[n22] - dArray[n22][n21];
                    d3 += d4 * d4;
                    ++n22;
                }
                if (d3 < d) {
                    d = d3;
                    n4 = n21;
                }
                ++n21;
            }
        } else {
            throw new RuntimeException(JaiI18N.getString("LookupTableJAI0"));
        }
        return n4 == -1 ? n4 : n4 + this.getOffset();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(SerializerFactory.getState(this.data));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        SerializableState serializableState = (SerializableState)object;
        this.data = (DataBuffer)serializableState.getObject();
    }

    private void initOffsets(int n, int n2) {
        this.tableOffsets = new int[n];
        int n3 = 0;
        while (n3 < n) {
            this.tableOffsets[n3] = n2;
            ++n3;
        }
    }

    private void initOffsets(int n, int[] nArray) {
        this.tableOffsets = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.tableOffsets[n2] = nArray[n2];
            ++n2;
        }
    }
}

