/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;

public abstract class GeometricOpImage
extends OpImage {
    protected Interpolation interp;
    protected BorderExtender extender = null;
    protected Rectangle computableBounds;

    public GeometricOpImage(Vector vector, ImageLayout imageLayout, Map map, boolean bl, BorderExtender borderExtender, Interpolation interpolation) {
        super(vector, imageLayout, map, bl);
        this.extender = borderExtender;
        this.interp = interpolation != null ? interpolation : new InterpolationNearest();
        this.computableBounds = this.getBounds();
    }

    public Interpolation getInterpolation() {
        return this.interp;
    }

    public BorderExtender getBorderExtender() {
        return this.extender;
    }

    protected abstract Rectangle forwardMapRect(Rectangle var1, int var2);

    protected abstract Rectangle backwardMapRect(Rectangle var1, int var2);

    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n2 = this.interp.getLeftPadding();
        int n3 = this.interp.getTopPadding();
        Rectangle rectangle2 = (Rectangle)rectangle.clone();
        rectangle2.x += n2;
        rectangle2.y += n3;
        rectangle2.width -= n2 + this.interp.getRightPadding();
        rectangle2.height -= n3 + this.interp.getBottomPadding();
        Rectangle rectangle3 = this.forwardMapRect(rectangle2, n);
        return rectangle3 == null ? this.getBounds() : rectangle3;
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        Rectangle rectangle2 = this.backwardMapRect(rectangle, n);
        if (rectangle2 == null) {
            return this.getSource(n).getBounds();
        }
        int n2 = this.interp.getLeftPadding();
        int n3 = this.interp.getTopPadding();
        return new Rectangle(rectangle2.x - n2, rectangle2.y - n3, rectangle2.width + n2 + this.interp.getRightPadding(), rectangle2.height + n3 + this.interp.getBottomPadding());
    }

    public Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = RasterFactory.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = this.getTileRect(n, n2).intersection(this.getBounds());
        if (rectangle.isEmpty()) {
            return writableRaster;
        }
        int n3 = this.getNumSources();
        if (this.cobbleSources) {
            Raster[] rasterArray = new Raster[n3];
            int n4 = 0;
            while (n4 < n3) {
                PlanarImage planarImage = this.getSource(n4);
                Rectangle rectangle2 = this.mapDestRect(rectangle, n4);
                if (rectangle2 == null) {
                    rectangle2 = planarImage.getBounds();
                } else if (!rectangle2.intersects(planarImage.getBounds())) {
                    return writableRaster;
                }
                rasterArray[n4] = this.extender != null ? planarImage.getExtendedData(rectangle2, this.extender) : planarImage.getData(rectangle2);
                ++n4;
            }
            this.computeRect(rasterArray, writableRaster, rectangle);
        } else {
            PlanarImage[] planarImageArray = new PlanarImage[n3];
            int n5 = 0;
            while (n5 < n3) {
                planarImageArray[n5] = this.getSource(n5);
                ++n5;
            }
            this.computeRect(planarImageArray, writableRaster, rectangle);
        }
        return writableRaster;
    }
}

