/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;

public final class BorderExtenderConstant
extends BorderExtender {
    private double[] constants;

    public BorderExtenderConstant(double[] dArray) {
        this.constants = dArray;
    }

    private int clamp(int n, int n2, int n3) {
        double d;
        int n4 = this.constants.length;
        if (n4 == 1) {
            d = this.constants[0];
        } else if (n < n4) {
            d = this.constants[n];
        } else {
            throw new UnsupportedOperationException(JaiI18N.getString("BorderExtenderConstant0"));
        }
        return d > (double)n2 ? (d > (double)n3 ? n3 : (int)d) : n2;
    }

    public final void extend(WritableRaster writableRaster, PlanarImage planarImage) {
        if (writableRaster == null || planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getNumBands();
        int n4 = writableRaster.getMinX();
        int n5 = n4 + n;
        int n6 = writableRaster.getMinY();
        int n7 = n6 + n2;
        int n8 = Math.max(planarImage.getMinX(), n4);
        int n9 = Math.min(planarImage.getMaxX(), n5);
        int n10 = Math.max(planarImage.getMinY(), n6);
        int n11 = Math.min(planarImage.getMaxY(), n7);
        int n12 = writableRaster.getSampleModel().getDataType();
        if (n12 == 4) {
            float[] fArray = new float[n3];
            int n13 = 0;
            while (n13 < n3) {
                fArray[n13] = n13 < this.constants.length ? (float)this.constants[n13] : 0.0f;
                ++n13;
            }
            float[] fArray2 = new float[n * n3];
            int n14 = 0;
            int n15 = 0;
            while (n15 < n) {
                int n16 = 0;
                while (n16 < n3) {
                    fArray2[n14++] = fArray[n16];
                    ++n16;
                }
                ++n15;
            }
            if (n8 > n9 || n10 > n11) {
                int n17 = n6;
                while (n17 < n7) {
                    writableRaster.setPixels(n4, n17, n, 1, fArray2);
                    ++n17;
                }
            } else {
                int n18 = n6;
                while (n18 < n10) {
                    writableRaster.setPixels(n4, n18, n, 1, fArray2);
                    ++n18;
                }
                n18 = n10;
                while (n18 < n11) {
                    if (n4 < n8) {
                        writableRaster.setPixels(n4, n18, n8 - n4, 1, fArray2);
                    }
                    if (n9 < n5) {
                        writableRaster.setPixels(n9, n18, n5 - n9, 1, fArray2);
                    }
                    ++n18;
                }
                n18 = n11;
                while (n18 < n7) {
                    writableRaster.setPixels(n4, n18, n, 1, fArray2);
                    ++n18;
                }
            }
        } else if (n12 == 5) {
            double[] dArray = new double[n3];
            int n19 = 0;
            while (n19 < n3) {
                dArray[n19] = n19 < this.constants.length ? this.constants[n19] : 0.0;
                ++n19;
            }
            double[] dArray2 = new double[n * n3];
            int n20 = 0;
            int n21 = 0;
            while (n21 < n) {
                int n22 = 0;
                while (n22 < n3) {
                    dArray2[n20++] = dArray[n22];
                    ++n22;
                }
                ++n21;
            }
            if (n8 > n9 || n10 > n11) {
                int n23 = n6;
                while (n23 < n7) {
                    writableRaster.setPixels(n4, n23, n, 1, dArray2);
                    ++n23;
                }
            } else {
                int n24 = n6;
                while (n24 < n10) {
                    writableRaster.setPixels(n4, n24, n, 1, dArray2);
                    ++n24;
                }
                n24 = n10;
                while (n24 < n11) {
                    if (n4 < n8) {
                        writableRaster.setPixels(n4, n24, n8 - n4, 1, dArray2);
                    }
                    if (n9 < n5) {
                        writableRaster.setPixels(n9, n24, n5 - n9, 1, dArray2);
                    }
                    ++n24;
                }
                n24 = n11;
                while (n24 < n7) {
                    writableRaster.setPixels(n4, n24, n, 1, dArray2);
                    ++n24;
                }
            }
        } else {
            int[] nArray = new int[n3];
            switch (n12) {
                case 0: {
                    int n25 = 0;
                    while (n25 < n3) {
                        nArray[n25] = this.clamp(n25, 0, 255);
                        ++n25;
                    }
                    break;
                }
                case 2: {
                    int n26 = 0;
                    while (n26 < n3) {
                        nArray[n26] = this.clamp(n26, Short.MIN_VALUE, Short.MAX_VALUE);
                        ++n26;
                    }
                    break;
                }
                case 1: {
                    int n27 = 0;
                    while (n27 < n3) {
                        nArray[n27] = this.clamp(n27, 0, 65535);
                        ++n27;
                    }
                    break;
                }
                case 3: {
                    int n28 = 0;
                    while (n28 < n3) {
                        nArray[n28] = this.clamp(n28, Integer.MIN_VALUE, Integer.MAX_VALUE);
                        ++n28;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JaiI18N.getString("Generic3"));
                }
            }
            int[] nArray2 = new int[n * n3];
            int n29 = 0;
            int n30 = 0;
            while (n30 < n) {
                int n31 = 0;
                while (n31 < n3) {
                    nArray2[n29++] = nArray[n31];
                    ++n31;
                }
                ++n30;
            }
            if (n8 > n9 || n10 > n11) {
                int n32 = n6;
                while (n32 < n7) {
                    writableRaster.setPixels(n4, n32, n, 1, nArray2);
                    ++n32;
                }
            } else {
                int n33 = n6;
                while (n33 < n10) {
                    writableRaster.setPixels(n4, n33, n, 1, nArray2);
                    ++n33;
                }
                n33 = n10;
                while (n33 < n11) {
                    if (n4 < n8) {
                        writableRaster.setPixels(n4, n33, n8 - n4, 1, nArray2);
                    }
                    if (n9 < n5) {
                        writableRaster.setPixels(n9, n33, n5 - n9, 1, nArray2);
                    }
                    ++n33;
                }
                n33 = n11;
                while (n33 < n7) {
                    writableRaster.setPixels(n4, n33, n, 1, nArray2);
                    ++n33;
                }
            }
        }
    }
}

