/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.ImageServer;
import com.sun.media.jai.rmi.JAIRMIImageServer;
import com.sun.media.jai.rmi.JAIRMIUtil;
import com.sun.media.jai.rmi.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.OperationNode;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertyChangeEventJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.RenderingChangeEvent;
import javax.media.jai.remote.NegotiableCapability;
import javax.media.jai.remote.NegotiableCapabilitySet;
import javax.media.jai.remote.PlanarImageServerProxy;
import javax.media.jai.remote.RemoteImagingException;
import javax.media.jai.remote.RemoteRenderedOp;
import javax.media.jai.remote.SerializableRenderedImage;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;
import javax.media.jai.tilecodec.TileCodecDescriptor;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileDecoderFactory;

public class RMIServerProxy
extends PlanarImageServerProxy {
    private ImageServer remoteImage = null;
    private Long id;
    private Long renderingID = null;
    private boolean preferencesSet;
    private NegotiableCapabilitySet negPref;
    private static final Class NULL_PROPERTY_CLASS = JAIRMIImageServer.NULL_PROPERTY.getClass();
    static /* synthetic */ Class class$javax$media$jai$tilecodec$TileDecoderFactory;

    public RMIServerProxy(String string, String string2, RenderingHints renderingHints) {
        super(string, "jairmi", string2, null, renderingHints);
        boolean bl;
        int n = string.indexOf("::");
        boolean bl2 = bl = n != -1;
        if (!bl) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteImage1"));
        }
        if (bl) {
            this.id = Long.valueOf(string.substring(n + 2));
            this.serverName = string = string.substring(0, n);
        }
        this.remoteImage = this.getImageServer(string);
        if (this.preferencesSet) {
            super.setNegotiationPreferences(this.negPref);
        }
        try {
            this.remoteImage.incrementRefCount(this.id);
        }
        catch (RemoteException remoteException) {
            System.err.println(JaiI18N.getString("RMIServerProxy2"));
        }
    }

    public RMIServerProxy(String string, ParameterBlock parameterBlock, String string2, RenderingHints renderingHints) {
        super(string, "jairmi", string2, parameterBlock, renderingHints);
        boolean bl;
        int n = string.indexOf("::");
        boolean bl2 = bl = n != -1;
        if (!bl) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteImage1"));
        }
        if (bl) {
            this.id = Long.valueOf(string.substring(n + 2));
            this.serverName = string = string.substring(0, n);
        }
        this.remoteImage = this.getImageServer(string);
        if (this.preferencesSet) {
            super.setNegotiationPreferences(this.negPref);
        }
        try {
            this.remoteImage.incrementRefCount(this.id);
        }
        catch (RemoteException remoteException) {
            System.err.println(JaiI18N.getString("RMIServerProxy2"));
        }
    }

    public RMIServerProxy(String string, String string2, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        super(string, "jairmi", string2, parameterBlock, renderingHints);
        Object object;
        this.remoteImage = this.getImageServer(string);
        this.getRMIID();
        if (this.preferencesSet) {
            super.setNegotiationPreferences(this.negPref);
        }
        ParameterBlock parameterBlock2 = (ParameterBlock)parameterBlock.clone();
        parameterBlock2.removeSources();
        JAIRMIUtil.checkClientParameters(parameterBlock2, string);
        try {
            object = SerializerFactory.getState(renderingHints, null);
            this.remoteImage.createRenderedOp(this.id, string2, parameterBlock2, (SerializableState)object);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
        int n = this.getNumSources();
        int n2 = 0;
        while (n2 < n) {
            PlanarImage planarImage;
            object = this.getSource(n2);
            if (object instanceof RMIServerProxy) {
                try {
                    planarImage = (RMIServerProxy)object;
                    if (((PlanarImageServerProxy)planarImage).serverName.equalsIgnoreCase(this.serverName)) {
                        this.remoteImage.setRenderedSource(this.id, ((RMIServerProxy)planarImage).getRMIID(), n2);
                    }
                    this.remoteImage.setRenderedSource(this.id, ((RMIServerProxy)planarImage).getRMIID(), ((PlanarImageServerProxy)planarImage).serverName, ((PlanarImageServerProxy)planarImage).operationName, n2);
                }
                catch (RemoteException remoteException) {
                    throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
                }
            } else {
                if (object instanceof RenderedOp) {
                    planarImage = (RenderedOp)object;
                    RenderedImage renderedImage = ((RenderedOp)planarImage).getRendering();
                    if (!(renderedImage instanceof Serializable)) {
                        renderedImage = new SerializableRenderedImage(renderedImage);
                    }
                    try {
                        this.remoteImage.setRenderedSource(this.id, renderedImage, n2);
                    }
                    catch (RemoteException remoteException) {
                        throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
                    }
                }
                if (object instanceof RenderedImage) {
                    try {
                        if (object instanceof Serializable) {
                            this.remoteImage.setRenderedSource(this.id, (RenderedImage)object, n2);
                        } else {
                            this.remoteImage.setRenderedSource(this.id, new SerializableRenderedImage((RenderedImage)object), n2);
                        }
                    }
                    catch (RemoteException remoteException) {
                        throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
                    }
                }
            }
            ++n2;
        }
        try {
            this.remoteImage.incrementRefCount(this.id);
        }
        catch (RemoteException remoteException) {
            System.err.println(JaiI18N.getString("RMIServerProxy2"));
        }
    }

    public RMIServerProxy(PlanarImageServerProxy planarImageServerProxy, OperationNode operationNode, String string) {
        this(string, operationNode.getOperationName(), operationNode.getParameterBlock(), operationNode.getRenderingHints());
    }

    public RMIServerProxy(PlanarImageServerProxy planarImageServerProxy, OperationNode operationNode, PropertyChangeEventJAI propertyChangeEventJAI) {
        super(((RemoteRenderedOp)operationNode).getServerName(), "jairmi", operationNode.getOperationName(), operationNode.getParameterBlock(), operationNode.getRenderingHints());
        this.remoteImage = this.getImageServer(this.serverName);
        RMIServerProxy rMIServerProxy = null;
        if (planarImageServerProxy instanceof RMIServerProxy) {
            rMIServerProxy = (RMIServerProxy)planarImageServerProxy;
        } else {
            System.err.println(JaiI18N.getString("RMIServerProxy3"));
        }
        Long l = rMIServerProxy.getRMIID();
        String string = propertyChangeEventJAI.getPropertyName();
        if (propertyChangeEventJAI instanceof RenderingChangeEvent) {
            Object object;
            RenderingChangeEvent renderingChangeEvent = (RenderingChangeEvent)propertyChangeEventJAI;
            int n = ((RenderedOp)operationNode).getSources().indexOf(renderingChangeEvent.getSource());
            PlanarImage planarImage = (PlanarImage)propertyChangeEventJAI.getOldValue();
            Object object2 = null;
            String string2 = null;
            if (planarImage instanceof RMIServerProxy) {
                object = (RMIServerProxy)planarImage;
                string2 = !((PlanarImageServerProxy)object).getServerName().equalsIgnoreCase(this.serverName) ? ((PlanarImageServerProxy)object).getServerName() + "::" + ((RMIServerProxy)object).getRMIID() : ((RMIServerProxy)object).getRMIID().toString();
                object2 = string2;
            } else {
                object2 = planarImage instanceof Serializable ? planarImage : new SerializableRenderedImage(planarImage);
            }
            object = renderingChangeEvent.getInvalidRegion();
            SerializableState serializableState = SerializerFactory.getState((Shape)object, null);
            Long l2 = null;
            try {
                l2 = this.remoteImage.handleEvent(l, n, serializableState, object2);
            }
            catch (RemoteException remoteException) {
                throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
            }
            rMIServerProxy.id = l2;
            this.id = l;
        } else {
            Cloneable cloneable;
            Object object;
            Object object3 = null;
            Object object4 = null;
            if (string.equals("operationname")) {
                object3 = propertyChangeEventJAI.getOldValue();
                object4 = propertyChangeEventJAI.getNewValue();
            } else if (string.equals("parameterblock")) {
                object = (ParameterBlock)propertyChangeEventJAI.getOldValue();
                cloneable = ((ParameterBlock)object).getSources();
                ((ParameterBlock)object).removeSources();
                ParameterBlock parameterBlock = (ParameterBlock)propertyChangeEventJAI.getNewValue();
                Vector<Object> vector = parameterBlock.getSources();
                parameterBlock.removeSources();
                JAIRMIUtil.checkClientParameters((ParameterBlock)object, this.serverName);
                JAIRMIUtil.checkClientParameters(parameterBlock, this.serverName);
                ((ParameterBlock)object).setSources(JAIRMIUtil.replaceSourcesWithId(cloneable, this.serverName));
                parameterBlock.setSources(JAIRMIUtil.replaceSourcesWithId(vector, this.serverName));
                object3 = object;
                object4 = parameterBlock;
            } else if (string.equals("sources")) {
                object = (Vector)propertyChangeEventJAI.getOldValue();
                cloneable = (Vector)propertyChangeEventJAI.getNewValue();
                object3 = JAIRMIUtil.replaceSourcesWithId((Vector)object, this.serverName);
                object4 = JAIRMIUtil.replaceSourcesWithId(cloneable, this.serverName);
            } else if (string.equals("parameters")) {
                object = (Vector)propertyChangeEventJAI.getOldValue();
                cloneable = (Vector)propertyChangeEventJAI.getNewValue();
                JAIRMIUtil.checkClientParameters((Vector)object, this.serverName);
                JAIRMIUtil.checkClientParameters(cloneable, this.serverName);
                object3 = object;
                object4 = cloneable;
            } else if (string.equals("renderinghints")) {
                object = (RenderingHints)propertyChangeEventJAI.getOldValue();
                cloneable = (RenderingHints)propertyChangeEventJAI.getNewValue();
                object3 = SerializerFactory.getState(object, null);
                object4 = SerializerFactory.getState(cloneable, null);
            } else {
                throw new RemoteImagingException(JaiI18N.getString("RMIServerProxy4"));
            }
            object = null;
            try {
                object = this.remoteImage.handleEvent(l, string, object3, object4);
                this.remoteImage.incrementRefCount((Long)object);
            }
            catch (RemoteException remoteException) {
                throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
            }
            rMIServerProxy.id = object;
            this.id = l;
        }
        if (this.preferencesSet) {
            super.setNegotiationPreferences(this.negPref);
        }
    }

    public RMIServerProxy(String string, String string2, ParameterBlock parameterBlock, RenderingHints renderingHints, Long l) {
        super(string, "jairmi", string2, parameterBlock, renderingHints);
        this.remoteImage = this.getImageServer(string);
        this.id = l;
    }

    public RMIServerProxy(String string, String string2, ParameterBlock parameterBlock, RenderContext renderContext, boolean bl) {
        super(string, "jairmi", string2, parameterBlock, null);
        this.remoteImage = this.getImageServer(string);
        this.getRMIID();
        if (this.preferencesSet) {
            super.setNegotiationPreferences(this.negPref);
        }
        ParameterBlock parameterBlock2 = (ParameterBlock)parameterBlock.clone();
        parameterBlock2.removeSources();
        try {
            this.remoteImage.createRenderableOp(this.id, string2, parameterBlock2);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
        int n = this.getNumSources();
        int n2 = 0;
        while (n2 < n) {
            Vector<Object> vector = parameterBlock.getSources();
            Object object = vector.elementAt(n2);
            if (object instanceof RMIServerProxy) {
                try {
                    RMIServerProxy rMIServerProxy = (RMIServerProxy)object;
                    if (rMIServerProxy.serverName.equals(this.serverName)) {
                        this.remoteImage.setRenderableSource(this.id, rMIServerProxy.getRMIID(), n2);
                    }
                    this.remoteImage.setRenderableSource(this.id, rMIServerProxy.getRMIID(), rMIServerProxy.serverName, rMIServerProxy.operationName, n2);
                }
                catch (RemoteException remoteException) {
                    throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
                }
            } else {
                if (object instanceof RenderableOp) {
                    try {
                        this.remoteImage.setRenderableSource(this.id, (RenderableOp)object, n2);
                    }
                    catch (RemoteException remoteException) {
                        throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
                    }
                }
                if (object instanceof RenderedImage) {
                    try {
                        this.remoteImage.setRenderableSource(this.id, new SerializableRenderedImage((RenderedImage)object), n2);
                    }
                    catch (RemoteException remoteException) {
                        throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
                    }
                }
            }
            ++n2;
        }
        try {
            this.remoteImage.incrementRefCount(this.id);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
        if (bl) {
            try {
                this.renderingID = this.remoteImage.getRendering(this.id, SerializerFactory.getState(renderContext, null));
                this.remoteImage.incrementRefCount(this.renderingID);
            }
            catch (RemoteException remoteException) {
                throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
            }
        }
    }

    protected synchronized ImageServer getImageServer(String string) {
        if (this.remoteImage == null) {
            if (string == null) {
                try {
                    string = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Exception exception) {
                    throw new RemoteImagingException(ImageUtil.getStackTraceString(exception));
                }
            }
            String string2 = new String("rmi://" + string + "/" + "JAIRMIRemoteServer1.1");
            this.remoteImage = null;
            try {
                this.remoteImage = (ImageServer)Naming.lookup(string2);
            }
            catch (Exception exception) {
                throw new RemoteImagingException(ImageUtil.getStackTraceString(exception));
            }
        }
        return this.remoteImage;
    }

    public synchronized Long getRMIID() {
        if (this.id != null) {
            return this.id;
        }
        try {
            this.id = this.remoteImage.getRemoteID();
            return this.id;
        }
        catch (Exception exception) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(exception));
        }
    }

    public Long getRenderingID() {
        return this.renderingID;
    }

    public boolean canBeRendered() {
        boolean bl;
        this.getImageServer(this.serverName);
        try {
            bl = this.remoteImage.getRendering(this.getRMIID());
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
        return bl;
    }

    protected void finalize() {
        try {
            this.remoteImage.dispose(this.id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dispose();
    }

    public ImageLayout getImageLayout() throws RemoteImagingException {
        ImageLayout imageLayout = new ImageLayout();
        try {
            imageLayout.setMinX(this.remoteImage.getMinX(this.id));
            imageLayout.setMinY(this.remoteImage.getMinY(this.id));
            imageLayout.setWidth(this.remoteImage.getWidth(this.id));
            imageLayout.setHeight(this.remoteImage.getHeight(this.id));
            imageLayout.setTileWidth(this.remoteImage.getTileWidth(this.id));
            imageLayout.setTileHeight(this.remoteImage.getTileHeight(this.id));
            imageLayout.setTileGridXOffset(this.remoteImage.getTileGridXOffset(this.id));
            imageLayout.setTileGridYOffset(this.remoteImage.getTileGridYOffset(this.id));
            SerializableState serializableState = this.remoteImage.getSampleModel(this.id);
            imageLayout.setSampleModel((SampleModel)serializableState.getObject());
            SerializableState serializableState2 = this.remoteImage.getColorModel(this.id);
            imageLayout.setColorModel((ColorModel)serializableState2.getObject());
            return imageLayout;
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
    }

    public Raster computeTile(int n, int n2) throws RemoteImagingException {
        Object object;
        Object object2;
        Object object3;
        if (n < this.getMinTileX() || n > this.getMaxTileX() || n2 < this.getMinTileY() || n2 > this.getMaxTileY()) {
            return null;
        }
        NegotiableCapability negotiableCapability = this.getNegotiatedValue("tileCodec");
        TileDecoderFactory tileDecoderFactory = null;
        TileCodecParameterList tileCodecParameterList = null;
        if (negotiableCapability != null) {
            String[] stringArray;
            object3 = negotiableCapability.getCategory();
            object2 = negotiableCapability.getCapabilityName();
            object = negotiableCapability.getGenerators();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Class clazz = (Class)iterator.next();
                if (tileDecoderFactory != null || !(class$javax$media$jai$tilecodec$TileDecoderFactory == null ? RMIServerProxy.class$("javax.media.jai.tilecodec.TileDecoderFactory") : class$javax$media$jai$tilecodec$TileDecoderFactory).isAssignableFrom(clazz)) continue;
                try {
                    tileDecoderFactory = (TileDecoderFactory)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new RemoteImagingException(ImageUtil.getStackTraceString(instantiationException));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RemoteImagingException(ImageUtil.getStackTraceString(illegalAccessException));
                }
            }
            if (tileDecoderFactory == null) {
                throw new RemoteImagingException(JaiI18N.getString("RMIServerProxy0"));
            }
            TileCodecDescriptor tileCodecDescriptor = (TileCodecDescriptor)this.registry.getDescriptor("tileDecoder", (String)object2);
            if (!tileCodecDescriptor.includesSampleModelInfo() || !tileCodecDescriptor.includesLocationInfo()) {
                throw new RemoteImagingException(JaiI18N.getString("RMIServerProxy1"));
            }
            ParameterListDescriptor parameterListDescriptor = tileCodecDescriptor.getParameterListDescriptor("tileDecoder");
            tileCodecParameterList = new TileCodecParameterList((String)object2, new String[]{"tileDecoder"}, parameterListDescriptor);
            if (parameterListDescriptor != null && (stringArray = parameterListDescriptor.getParamNames()) != null) {
                int n3 = 0;
                while (n3 < stringArray.length) {
                    block17: {
                        Object object4;
                        String string = stringArray[n3];
                        try {
                            object4 = negotiableCapability.getNegotiatedValue(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            break block17;
                        }
                        tileCodecParameterList.setParameter(string, object4);
                    }
                    ++n3;
                }
            }
        }
        try {
            if (negotiableCapability != null) {
                object3 = this.remoteImage.getCompressedTile(this.id, n, n2);
                object2 = new ByteArrayInputStream((byte[])object3);
                object = tileDecoderFactory.createDecoder((InputStream)object2, tileCodecParameterList);
                try {
                    return object.decode();
                }
                catch (IOException iOException) {
                    throw new RemoteImagingException(ImageUtil.getStackTraceString(iOException));
                }
            }
            object3 = this.remoteImage.getTile(this.id, n, n2);
            return (Raster)object3.getObject();
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
    }

    public Object getRemoteProperty(String string) throws RemoteImagingException {
        try {
            Object object = this.remoteImage.getProperty(this.id, string);
            if (NULL_PROPERTY_CLASS.isInstance(object)) {
                object = Image.UndefinedProperty;
            }
            return object;
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
    }

    public String[] getRemotePropertyNames() throws RemoteImagingException {
        try {
            return this.remoteImage.getPropertyNames(this.id);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n) throws RemoteImagingException {
        Rectangle rectangle2 = null;
        try {
            rectangle2 = this.remoteImage.mapSourceRect(this.id, rectangle, n);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
        return rectangle2;
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n) throws RemoteImagingException {
        Rectangle rectangle2 = null;
        try {
            rectangle2 = this.remoteImage.mapDestRect(this.id, rectangle, n);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
        return rectangle2;
    }

    public void setNegotiationPreferences(NegotiableCapabilitySet negotiableCapabilitySet) {
        if (this.remoteImage == null) {
            this.negPref = negotiableCapabilitySet;
            this.preferencesSet = true;
        } else {
            super.setNegotiationPreferences(negotiableCapabilitySet);
        }
    }

    public synchronized void setServerNegotiatedValues(NegotiableCapabilitySet negotiableCapabilitySet) throws RemoteImagingException {
        try {
            this.remoteImage.setServerNegotiatedValues(this.id, negotiableCapabilitySet);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

