/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.Warp;
import javax.media.jai.WarpOpImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

final class WarpGeneralOpImage
extends WarpOpImage {
    private byte[][] ctable = null;

    public WarpGeneralOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, Warp warp, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, false, borderExtender, interpolation, warp);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            this.ctable = new byte[3][indexColorModel.getMapSize()];
            indexColorModel.getReds(this.ctable[0]);
            indexColorModel.getGreens(this.ctable[1]);
            indexColorModel.getBlues(this.ctable[2]);
        }
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(planarImageArray[0], rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(planarImageArray[0], rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(planarImageArray[0], rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(planarImageArray[0], rasterAccessor);
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.interp != null) {
            n8 = this.interp.getLeftPadding();
            n7 = this.interp.getRightPadding();
            n6 = this.interp.getTopPadding();
            n5 = this.interp.getBottomPadding();
        } else {
            n5 = 0;
            n6 = 0;
            n7 = 0;
            n8 = 0;
        }
        if (this.extender != null) {
            n4 = planarImage.getMinX();
            n3 = planarImage.getMaxX();
            n2 = planarImage.getMinY();
            n = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n8, planarImage.getMinY() - n6, planarImage.getWidth() + n8 + n7, planarImage.getHeight() + n6 + n5);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n4 = planarImage.getMinX() + n8;
            n3 = planarImage.getMaxX() - n7;
            n2 = planarImage.getMinY() + n6;
            n = planarImage.getMaxY() - n5;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n9 = this.interp.getWidth();
        int n10 = this.interp.getHeight();
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n16 = 1 << this.interp.getSubsampleBitsH();
        int n17 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n11];
        int[][] nArray2 = new int[n10][n9];
        int n18 = 0;
        if (this.ctable == null) {
            int n19 = 0;
            while (n19 < n12) {
                int n20 = n18;
                n18 += n14;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n19, n11, 1, fArray);
                int n21 = 0;
                int n22 = 0;
                while (n22 < n11) {
                    float f = fArray[n21++];
                    float f2 = fArray[n21++];
                    int n23 = WarpGeneralOpImage.floor(f);
                    int n24 = WarpGeneralOpImage.floor(f2);
                    int n25 = (int)((f - (float)n23) * (float)n16);
                    int n26 = (int)((f2 - (float)n24) * (float)n17);
                    if (n23 >= n4 && n23 < n3 && n24 >= n2 && n24 < n) {
                        n23 -= n8;
                        n24 -= n6;
                        int n27 = 0;
                        while (n27 < n13) {
                            int n28 = 0;
                            while (n28 < n10) {
                                int n29 = 0;
                                while (n29 < n9) {
                                    nArray2[n28][n29] = randomIter.getSample(n23 + n29, n24 + n28, n27) & 0xFF;
                                    ++n29;
                                }
                                ++n28;
                            }
                            byArray[n27][n20 + nArray[n27]] = ImageUtil.clampByte(this.interp.interpolate(nArray2, n25, n26));
                            ++n27;
                        }
                    }
                    n20 += n15;
                    ++n22;
                }
                ++n19;
            }
        } else {
            int n30 = 0;
            while (n30 < n12) {
                int n31 = n18;
                n18 += n14;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n30, n11, 1, fArray);
                int n32 = 0;
                int n33 = 0;
                while (n33 < n11) {
                    float f = fArray[n32++];
                    float f3 = fArray[n32++];
                    int n34 = WarpGeneralOpImage.floor(f);
                    int n35 = WarpGeneralOpImage.floor(f3);
                    int n36 = (int)((f - (float)n34) * (float)n16);
                    int n37 = (int)((f3 - (float)n35) * (float)n17);
                    if (n34 >= n4 && n34 < n3 && n35 >= n2 && n35 < n) {
                        n34 -= n8;
                        n35 -= n6;
                        int n38 = 0;
                        while (n38 < n13) {
                            byte[] byArray2 = this.ctable[n38];
                            int n39 = 0;
                            while (n39 < n10) {
                                int n40 = 0;
                                while (n40 < n9) {
                                    nArray2[n39][n40] = byArray2[randomIter.getSample(n34 + n40, n35 + n39, 0) & 0xFF] & 0xFF;
                                    ++n40;
                                }
                                ++n39;
                            }
                            byArray[n38][n31 + nArray[n38]] = ImageUtil.clampByte(this.interp.interpolate(nArray2, n36, n37));
                            ++n38;
                        }
                    }
                    n31 += n15;
                    ++n33;
                }
                ++n30;
            }
        }
    }

    private void computeRectUShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.interp != null) {
            n8 = this.interp.getLeftPadding();
            n7 = this.interp.getRightPadding();
            n6 = this.interp.getTopPadding();
            n5 = this.interp.getBottomPadding();
        } else {
            n5 = 0;
            n6 = 0;
            n7 = 0;
            n8 = 0;
        }
        if (this.extender != null) {
            n4 = planarImage.getMinX();
            n3 = planarImage.getMaxX();
            n2 = planarImage.getMinY();
            n = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n8, planarImage.getMinY() - n6, planarImage.getWidth() + n8 + n7, planarImage.getHeight() + n6 + n5);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n4 = planarImage.getMinX() + n8;
            n3 = planarImage.getMaxX() - n7;
            n2 = planarImage.getMinY() + n6;
            n = planarImage.getMaxY() - n5;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n9 = this.interp.getWidth();
        int n10 = this.interp.getHeight();
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n16 = 1 << this.interp.getSubsampleBitsH();
        int n17 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n11];
        int[][] nArray2 = new int[n10][n9];
        int n18 = 0;
        int n19 = 0;
        while (n19 < n12) {
            int n20 = n18;
            n18 += n14;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n19, n11, 1, fArray);
            int n21 = 0;
            int n22 = 0;
            while (n22 < n11) {
                float f = fArray[n21++];
                float f2 = fArray[n21++];
                int n23 = WarpGeneralOpImage.floor(f);
                int n24 = WarpGeneralOpImage.floor(f2);
                int n25 = (int)((f - (float)n23) * (float)n16);
                int n26 = (int)((f2 - (float)n24) * (float)n17);
                if (n23 >= n4 && n23 < n3 && n24 >= n2 && n24 < n) {
                    n23 -= n8;
                    n24 -= n6;
                    int n27 = 0;
                    while (n27 < n13) {
                        int n28 = 0;
                        while (n28 < n10) {
                            int n29 = 0;
                            while (n29 < n9) {
                                nArray2[n28][n29] = randomIter.getSample(n23 + n29, n24 + n28, n27) & 0xFFFF;
                                ++n29;
                            }
                            ++n28;
                        }
                        sArray[n27][n20 + nArray[n27]] = ImageUtil.clampUShort(this.interp.interpolate(nArray2, n25, n26));
                        ++n27;
                    }
                }
                n20 += n15;
                ++n22;
            }
            ++n19;
        }
    }

    private void computeRectShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.interp != null) {
            n8 = this.interp.getLeftPadding();
            n7 = this.interp.getRightPadding();
            n6 = this.interp.getTopPadding();
            n5 = this.interp.getBottomPadding();
        } else {
            n5 = 0;
            n6 = 0;
            n7 = 0;
            n8 = 0;
        }
        if (this.extender != null) {
            n4 = planarImage.getMinX();
            n3 = planarImage.getMaxX();
            n2 = planarImage.getMinY();
            n = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n8, planarImage.getMinY() - n6, planarImage.getWidth() + n8 + n7, planarImage.getHeight() + n6 + n5);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n4 = planarImage.getMinX() + n8;
            n3 = planarImage.getMaxX() - n7;
            n2 = planarImage.getMinY() + n6;
            n = planarImage.getMaxY() - n5;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n9 = this.interp.getWidth();
        int n10 = this.interp.getHeight();
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n16 = 1 << this.interp.getSubsampleBitsH();
        int n17 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n11];
        int[][] nArray2 = new int[n10][n9];
        int n18 = 0;
        int n19 = 0;
        while (n19 < n12) {
            int n20 = n18;
            n18 += n14;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n19, n11, 1, fArray);
            int n21 = 0;
            int n22 = 0;
            while (n22 < n11) {
                float f = fArray[n21++];
                float f2 = fArray[n21++];
                int n23 = WarpGeneralOpImage.floor(f);
                int n24 = WarpGeneralOpImage.floor(f2);
                int n25 = (int)((f - (float)n23) * (float)n16);
                int n26 = (int)((f2 - (float)n24) * (float)n17);
                if (n23 >= n4 && n23 < n3 && n24 >= n2 && n24 < n) {
                    n23 -= n8;
                    n24 -= n6;
                    int n27 = 0;
                    while (n27 < n13) {
                        int n28 = 0;
                        while (n28 < n10) {
                            int n29 = 0;
                            while (n29 < n9) {
                                nArray2[n28][n29] = randomIter.getSample(n23 + n29, n24 + n28, n27);
                                ++n29;
                            }
                            ++n28;
                        }
                        sArray[n27][n20 + nArray[n27]] = ImageUtil.clampShort(this.interp.interpolate(nArray2, n25, n26));
                        ++n27;
                    }
                }
                n20 += n15;
                ++n22;
            }
            ++n19;
        }
    }

    private void computeRectInt(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.interp != null) {
            n8 = this.interp.getLeftPadding();
            n7 = this.interp.getRightPadding();
            n6 = this.interp.getTopPadding();
            n5 = this.interp.getBottomPadding();
        } else {
            n5 = 0;
            n6 = 0;
            n7 = 0;
            n8 = 0;
        }
        if (this.extender != null) {
            n4 = planarImage.getMinX();
            n3 = planarImage.getMaxX();
            n2 = planarImage.getMinY();
            n = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n8, planarImage.getMinY() - n6, planarImage.getWidth() + n8 + n7, planarImage.getHeight() + n6 + n5);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n4 = planarImage.getMinX() + n8;
            n3 = planarImage.getMaxX() - n7;
            n2 = planarImage.getMinY() + n6;
            n = planarImage.getMaxY() - n5;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n9 = this.interp.getWidth();
        int n10 = this.interp.getHeight();
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n16 = 1 << this.interp.getSubsampleBitsH();
        int n17 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n11];
        int[][] nArray3 = new int[n10][n9];
        int n18 = 0;
        int n19 = 0;
        while (n19 < n12) {
            int n20 = n18;
            n18 += n14;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n19, n11, 1, fArray);
            int n21 = 0;
            int n22 = 0;
            while (n22 < n11) {
                float f = fArray[n21++];
                float f2 = fArray[n21++];
                int n23 = WarpGeneralOpImage.floor(f);
                int n24 = WarpGeneralOpImage.floor(f2);
                int n25 = (int)((f - (float)n23) * (float)n16);
                int n26 = (int)((f2 - (float)n24) * (float)n17);
                if (n23 >= n4 && n23 < n3 && n24 >= n2 && n24 < n) {
                    n23 -= n8;
                    n24 -= n6;
                    int n27 = 0;
                    while (n27 < n13) {
                        int n28 = 0;
                        while (n28 < n10) {
                            int n29 = 0;
                            while (n29 < n9) {
                                nArray3[n28][n29] = randomIter.getSample(n23 + n29, n24 + n28, n27);
                                ++n29;
                            }
                            ++n28;
                        }
                        nArray2[n27][n20 + nArray[n27]] = this.interp.interpolate(nArray3, n25, n26);
                        ++n27;
                    }
                }
                n20 += n15;
                ++n22;
            }
            ++n19;
        }
    }

    private void computeRectFloat(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.interp != null) {
            n8 = this.interp.getLeftPadding();
            n7 = this.interp.getRightPadding();
            n6 = this.interp.getTopPadding();
            n5 = this.interp.getBottomPadding();
        } else {
            n5 = 0;
            n6 = 0;
            n7 = 0;
            n8 = 0;
        }
        if (this.extender != null) {
            n4 = planarImage.getMinX();
            n3 = planarImage.getMaxX();
            n2 = planarImage.getMinY();
            n = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n8, planarImage.getMinY() - n6, planarImage.getWidth() + n8 + n7, planarImage.getHeight() + n6 + n5);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n4 = planarImage.getMinX() + n8;
            n3 = planarImage.getMaxX() - n7;
            n2 = planarImage.getMinY() + n6;
            n = planarImage.getMaxY() - n5;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n9 = this.interp.getWidth();
        int n10 = this.interp.getHeight();
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        float[] fArray2 = new float[2 * n11];
        float[][] fArray3 = new float[n10][n9];
        int n16 = 0;
        int n17 = 0;
        while (n17 < n12) {
            int n18 = n16;
            n16 += n14;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n17, n11, 1, fArray2);
            int n19 = 0;
            int n20 = 0;
            while (n20 < n11) {
                float f = fArray2[n19++];
                float f2 = fArray2[n19++];
                int n21 = WarpGeneralOpImage.floor(f);
                int n22 = WarpGeneralOpImage.floor(f2);
                float f3 = f - (float)n21;
                float f4 = f2 - (float)n22;
                if (n21 >= n4 && n21 < n3 && n22 >= n2 && n22 < n) {
                    n21 -= n8;
                    n22 -= n6;
                    int n23 = 0;
                    while (n23 < n13) {
                        int n24 = 0;
                        while (n24 < n10) {
                            int n25 = 0;
                            while (n25 < n9) {
                                fArray3[n24][n25] = randomIter.getSampleFloat(n21 + n25, n22 + n24, n23);
                                ++n25;
                            }
                            ++n24;
                        }
                        fArray[n23][n18 + nArray[n23]] = this.interp.interpolate(fArray3, f3, f4);
                        ++n23;
                    }
                }
                n18 += n15;
                ++n20;
            }
            ++n17;
        }
    }

    private void computeRectDouble(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.interp != null) {
            n8 = this.interp.getLeftPadding();
            n7 = this.interp.getRightPadding();
            n6 = this.interp.getTopPadding();
            n5 = this.interp.getBottomPadding();
        } else {
            n5 = 0;
            n6 = 0;
            n7 = 0;
            n8 = 0;
        }
        if (this.extender != null) {
            n4 = planarImage.getMinX();
            n3 = planarImage.getMaxX();
            n2 = planarImage.getMinY();
            n = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n8, planarImage.getMinY() - n6, planarImage.getWidth() + n8 + n7, planarImage.getHeight() + n6 + n5);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n4 = planarImage.getMinX() + n8;
            n3 = planarImage.getMaxX() - n7;
            n2 = planarImage.getMinY() + n6;
            n = planarImage.getMaxY() - n5;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n9 = this.interp.getWidth();
        int n10 = this.interp.getHeight();
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        float[] fArray = new float[2 * n11];
        double[][] dArray2 = new double[n10][n9];
        int n16 = 0;
        int n17 = 0;
        while (n17 < n12) {
            int n18 = n16;
            n16 += n14;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n17, n11, 1, fArray);
            int n19 = 0;
            int n20 = 0;
            while (n20 < n11) {
                float f = fArray[n19++];
                float f2 = fArray[n19++];
                int n21 = WarpGeneralOpImage.floor(f);
                int n22 = WarpGeneralOpImage.floor(f2);
                float f3 = f - (float)n21;
                float f4 = f2 - (float)n22;
                if (n21 >= n4 && n21 < n3 && n22 >= n2 && n22 < n) {
                    n21 -= n8;
                    n22 -= n6;
                    int n23 = 0;
                    while (n23 < n13) {
                        int n24 = 0;
                        while (n24 < n10) {
                            int n25 = 0;
                            while (n25 < n9) {
                                dArray2[n24][n25] = randomIter.getSampleDouble(n21 + n25, n22 + n24, n23);
                                ++n25;
                            }
                            ++n24;
                        }
                        dArray[n23][n18 + nArray[n23]] = this.interp.interpolate(dArray2, f3, f4);
                        ++n23;
                    }
                }
                n18 += n15;
                ++n20;
            }
            ++n17;
        }
    }

    private static final int floor(float f) {
        return f >= 0.0f ? (int)f : (int)f - 1;
    }
}

