/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.OpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class FilteredSubsampleOpImage
extends GeometricOpImage {
    protected int scaleX;
    protected int scaleY;
    protected int hParity;
    protected int vParity;
    protected float[] hKernel;
    protected float[] vKernel;

    private static float[] convolveFullKernels(float[] fArray, float[] fArray2) {
        int n = fArray.length;
        int n2 = fArray2.length;
        float[] fArray3 = new float[n + n2 - 1];
        int n3 = 0;
        while (n3 < fArray3.length) {
            int n4 = Math.max(0, n3 - n2 + 1);
            while (n4 <= Math.min(n3, n - 1)) {
                int n5 = n3;
                fArray3[n5] = fArray3[n5] + fArray[n4] * fArray2[n3 - n4];
                ++n4;
            }
            ++n3;
        }
        return fArray3;
    }

    private static float[] convolveSymmetricKernels(int n, int n2, float[] fArray, float[] fArray2) {
        int n3 = fArray.length;
        int n4 = fArray2.length;
        int n5 = 2 * n3 - n;
        int n6 = 2 * n4 - n2;
        int n7 = n5 + n6 - 1;
        float[] fArray3 = new float[n5];
        float[] fArray4 = new float[n6];
        float[] fArray5 = new float[(n7 + 1) / 2];
        int n8 = 0;
        while (n8 < n5) {
            fArray3[n8] = fArray[Math.abs(n8 - n3 + (n - 1) * (n8 / n3) + 1)];
            ++n8;
        }
        int n9 = 0;
        while (n9 < n6) {
            fArray4[n9] = fArray2[Math.abs(n9 - n4 + (n2 - 1) * (n9 / n4) + 1)];
            ++n9;
        }
        float[] fArray6 = FilteredSubsampleOpImage.convolveFullKernels(fArray3, fArray4);
        int n10 = fArray6.length % 2;
        int n11 = 0;
        while (n11 < fArray5.length) {
            fArray5[n11] = fArray6[n7 - fArray5.length - n11 - 1 + n10];
            ++n11;
        }
        return fArray5;
    }

    private static float[] combineFilters(int n, int n2, float[] fArray) {
        if (n % 2 == 1) {
            return (float[])fArray.clone();
        }
        int n3 = 1;
        int n4 = 0;
        switch (n2) {
            case 0: {
                return (float[])fArray.clone();
            }
            case 1: {
                float[] fArray2 = new float[]{0.5f};
                return FilteredSubsampleOpImage.convolveSymmetricKernels(n3, n4, fArray, fArray2);
            }
            case 2: {
                float[] fArray3 = new float[]{0.5625f, -0.0625f};
                return FilteredSubsampleOpImage.convolveSymmetricKernels(n3, n4, fArray, fArray3);
            }
            case 3: {
                float[] fArray4 = new float[]{0.625f, -0.125f};
                return FilteredSubsampleOpImage.convolveSymmetricKernels(n3, n4, fArray, fArray4);
            }
        }
        throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample0"));
    }

    private static int filterParity(int n, int n2) {
        if (n % 2 == 1 || n2 == 0) {
            return 1;
        }
        return 0;
    }

    private static final ImageLayout layoutHelper(RenderedImage renderedImage, Interpolation interpolation, int n, int n2, int n3, ImageLayout imageLayout) {
        ImageLayout imageLayout2;
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample1"));
        }
        if (n3 < 1) {
            throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample2"));
        }
        Rectangle rectangle = FilteredSubsampleOpImage.forwardMapRect(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight(), n, n2);
        ImageLayout imageLayout3 = imageLayout2 = imageLayout == null ? new ImageLayout(rectangle.x, rectangle.y, rectangle.width, rectangle.height) : (ImageLayout)imageLayout.clone();
        if (imageLayout != null) {
            imageLayout2.setWidth(rectangle.width);
            imageLayout2.setHeight(rectangle.height);
            imageLayout2.setMinX(rectangle.x);
            imageLayout2.setMinY(rectangle.y);
        }
        return imageLayout2;
    }

    public FilteredSubsampleOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, int n, int n2, float[] fArray, Interpolation interpolation) {
        super(OpImage.vectorize(renderedImage), FilteredSubsampleOpImage.layoutHelper(renderedImage, interpolation, n, n2, fArray.length, imageLayout), map, true, borderExtender, interpolation);
        int n3;
        if (interpolation instanceof InterpolationNearest) {
            n3 = 0;
        } else if (interpolation instanceof InterpolationBilinear) {
            n3 = 1;
        } else if (interpolation instanceof InterpolationBicubic) {
            n3 = 2;
        } else if (interpolation instanceof InterpolationBicubic2) {
            n3 = 3;
        } else {
            throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample3"));
        }
        this.hParity = FilteredSubsampleOpImage.filterParity(n, n3);
        this.vParity = FilteredSubsampleOpImage.filterParity(n2, n3);
        this.hKernel = FilteredSubsampleOpImage.combineFilters(n, n3, fArray);
        this.vKernel = FilteredSubsampleOpImage.combineFilters(n2, n3, fArray);
        this.scaleX = n;
        this.scaleY = n2;
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample4"));
        }
        int n2 = rectangle.x + this.hKernel.length - this.hParity - this.scaleX / 2;
        int n3 = rectangle.y + this.vKernel.length - this.vParity - this.scaleY / 2;
        int n4 = rectangle.width - 2 * this.hKernel.length + this.hParity + 1;
        int n5 = rectangle.height - 2 * this.vKernel.length + this.vParity + 1;
        return FilteredSubsampleOpImage.forwardMapRect(n2, n3, n4, n5, this.scaleX, this.scaleY);
    }

    private static final Rectangle forwardMapRect(int n, int n2, int n3, int n4, int n5, int n6) {
        float f = 1.0f / (float)n5;
        float f2 = 1.0f / (float)n6;
        n = Math.round((float)n * f);
        n2 = Math.round((float)n2 * f2);
        return new Rectangle(n, n2, Math.round((float)(n + n3) * f) - n, Math.round((float)(n2 + n4) * f2) - n2);
    }

    protected final Rectangle forwardMapRect(Rectangle rectangle, int n) {
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        float f = 1.0f / (float)this.scaleX;
        float f2 = 1.0f / (float)this.scaleY;
        n2 = Math.round((float)n2 * f);
        n3 = Math.round((float)n3 * f2);
        return new Rectangle(n2, n3, Math.round((float)(n2 + n4) * f) - n2, Math.round((float)(n3 + n5) * f2) - n3);
    }

    protected final Rectangle backwardMapRect(Rectangle rectangle, int n) {
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        return new Rectangle(n2 * this.scaleX, n3 * this.scaleY, (n2 + n4) * this.scaleX - n2, (n3 + n5) * this.scaleY - n3);
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample4"));
        }
        int n2 = rectangle.x * this.scaleX - this.hKernel.length + this.hParity + this.scaleX / 2;
        int n3 = rectangle.y * this.scaleY - this.vKernel.length + this.vParity + this.scaleY / 2;
        int n4 = rectangle.width * this.scaleX + 2 * this.hKernel.length - this.hParity - 1;
        int n5 = rectangle.height * this.scaleY + 2 * this.vKernel.length - this.vParity - 1;
        return new Rectangle(n2, n3, n4, n5);
    }

    public void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[0], this.mapDestRect(rectangle, 0), rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor2, rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor2, rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor2, rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor2, rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor2, rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor2, rasterAccessor);
                break;
            }
            default: {
                throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample5"));
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    protected void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 2 * this.hKernel.length - this.hParity;
        int n9 = 2 * this.vKernel.length - this.vParity;
        int n10 = (n9 - 1) * n7;
        int n11 = (n8 - 1) * n6;
        float f = this.vKernel[0];
        float f2 = this.hKernel[0];
        int n12 = 0;
        while (n12 < n3) {
            byte[] byArray3 = byArray[n12];
            byte[] byArray4 = byArray2[n12];
            int n13 = nArray2[n12];
            int n14 = nArray[n12];
            int n15 = 0;
            while (n15 < this.scaleY * n2) {
                int n16 = n14;
                int n17 = 0;
                while (n17 < this.scaleX * n) {
                    int n18;
                    float f3;
                    int n19 = n17 * n6 + n15 * n7 + n13;
                    int n20 = n19 + n11;
                    int n21 = n19 + n10;
                    int n22 = n20 + n10;
                    float f4 = 0.0f;
                    int n23 = this.vKernel.length - 1;
                    while (n23 > this.vParity - 1) {
                        int n24 = n19;
                        int n25 = n20;
                        int n26 = n21;
                        int n27 = n22;
                        int n28 = this.hKernel.length - 1;
                        while (n28 > this.hParity - 1) {
                            f3 = this.hKernel[n28] * this.vKernel[n23];
                            f4 += f3 * (float)((byArray4[n24] & 0xFF) + (byArray4[n25] & 0xFF) + (byArray4[n26] & 0xFF) + (byArray4[n27] & 0xFF));
                            n24 += n6;
                            n25 -= n6;
                            n26 += n6;
                            n27 -= n6;
                            --n28;
                        }
                        n19 += n7;
                        n20 += n7;
                        n21 -= n7;
                        n22 -= n7;
                        --n23;
                    }
                    if (this.hParity == 1) {
                        int n29 = (n17 + this.hKernel.length - 1) * n6 + n15 * n7 + n13;
                        int n30 = n29 + n10;
                        n18 = this.vKernel.length - 1;
                        while (n29 < n30) {
                            f3 = f2 * this.vKernel[n18--];
                            f4 += f3 * (float)((byArray4[n29] & 0xFF) + (byArray4[n30] & 0xFF));
                            n29 += n7;
                            n30 -= n7;
                        }
                    }
                    if (this.vParity == 1) {
                        int n31 = n17 * n6 + (n15 + this.vKernel.length - 1) * n7 + n13;
                        int n32 = n31 + n11;
                        n18 = this.hKernel.length - 1;
                        while (n31 < n32) {
                            f3 = f * this.hKernel[n18--];
                            f4 += f3 * (float)((byArray4[n31] & 0xFF) + (byArray4[n32] & 0xFF));
                            n31 += n6;
                            n32 -= n6;
                        }
                        if (this.hParity == 1) {
                            f4 += f * f2 * (float)(byArray4[n31] & 0xFF);
                        }
                    }
                    if ((double)f4 < 0.0) {
                        f4 = 0.0f;
                    }
                    if ((double)f4 > 255.0) {
                        f4 = 255.0f;
                    }
                    byArray3[n16] = (byte)((double)f4 + 0.5);
                    n16 += n4;
                    n17 += this.scaleX;
                }
                n14 += n5;
                n15 += this.scaleY;
            }
            ++n12;
        }
    }

    protected void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 2 * this.hKernel.length - this.hParity;
        int n9 = 2 * this.vKernel.length - this.vParity;
        int n10 = (n9 - 1) * n7;
        int n11 = (n8 - 1) * n6;
        float f = this.vKernel[0];
        float f2 = this.hKernel[0];
        int n12 = 0;
        while (n12 < n3) {
            short[] sArray3 = sArray[n12];
            short[] sArray4 = sArray2[n12];
            int n13 = nArray2[n12];
            int n14 = nArray[n12];
            int n15 = 0;
            while (n15 < this.scaleY * n2) {
                int n16 = n14;
                int n17 = 0;
                while (n17 < this.scaleX * n) {
                    int n18;
                    float f3;
                    int n19;
                    int n20 = n17 * n6 + n15 * n7 + n13;
                    int n21 = n20 + n11;
                    int n22 = n20 + n10;
                    int n23 = n21 + n10;
                    float f4 = 0.0f;
                    int n24 = this.vKernel.length - 1;
                    while (n24 > this.vParity - 1) {
                        int n25 = n20;
                        int n26 = n21;
                        int n27 = n22;
                        int n28 = n23;
                        n19 = this.hKernel.length - 1;
                        while (n19 > this.hParity - 1) {
                            f3 = this.hKernel[n19] * this.vKernel[n24];
                            f4 += f3 * (float)((sArray4[n25] & 0xFFFF) + (sArray4[n26] & 0xFFFF) + (sArray4[n27] & 0xFFFF) + (sArray4[n28] & 0xFFFF));
                            n25 += n6;
                            n26 -= n6;
                            n27 += n6;
                            n28 -= n6;
                            --n19;
                        }
                        n20 += n7;
                        n21 += n7;
                        n22 -= n7;
                        n23 -= n7;
                        --n24;
                    }
                    if (this.hParity == 1) {
                        int n29 = (n17 + this.hKernel.length - 1) * n6 + n15 * n7 + n13;
                        int n30 = n29 + n10;
                        n18 = this.vKernel.length - 1;
                        while (n29 < n30) {
                            f3 = f2 * this.vKernel[n18--];
                            f4 += f3 * (float)((sArray4[n29] & 0xFFFF) + (sArray4[n30] & 0xFFFF));
                            n29 += n7;
                            n30 -= n7;
                        }
                    }
                    if (this.vParity == 1) {
                        int n31 = n17 * n6 + (n15 + this.vKernel.length - 1) * n7 + n13;
                        int n32 = n31 + n11;
                        n18 = this.hKernel.length - 1;
                        while (n31 < n32) {
                            f3 = f * this.hKernel[n18--];
                            f4 += f3 * (float)((sArray4[n31] & 0xFFFF) + (sArray4[n32] & 0xFFFF));
                            n31 += n6;
                            n32 -= n6;
                        }
                        if (this.hParity == 1) {
                            f4 += f * f2 * (float)(sArray4[n31] & 0xFFFF);
                        }
                    }
                    sArray3[n16] = (short)((n19 = (int)((double)f4 + 0.5)) > 65535 ? -1 : (short)(n19 < 0 ? 0 : (short)n19));
                    n16 += n4;
                    n17 += this.scaleX;
                }
                n14 += n5;
                n15 += this.scaleY;
            }
            ++n12;
        }
    }

    protected void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 2 * this.hKernel.length - this.hParity;
        int n9 = 2 * this.vKernel.length - this.vParity;
        int n10 = (n9 - 1) * n7;
        int n11 = (n8 - 1) * n6;
        float f = this.vKernel[0];
        float f2 = this.hKernel[0];
        int n12 = 0;
        while (n12 < n3) {
            short[] sArray3 = sArray[n12];
            short[] sArray4 = sArray2[n12];
            int n13 = nArray2[n12];
            int n14 = nArray[n12];
            int n15 = 0;
            while (n15 < this.scaleY * n2) {
                int n16 = n14;
                int n17 = 0;
                while (n17 < this.scaleX * n) {
                    int n18;
                    float f3;
                    int n19 = n17 * n6 + n15 * n7 + n13;
                    int n20 = n19 + n11;
                    int n21 = n19 + n10;
                    int n22 = n20 + n10;
                    float f4 = 0.0f;
                    int n23 = this.vKernel.length - 1;
                    while (n23 > this.vParity - 1) {
                        int n24 = n19;
                        int n25 = n20;
                        int n26 = n21;
                        int n27 = n22;
                        int n28 = this.hKernel.length - 1;
                        while (n28 > this.hParity - 1) {
                            f3 = this.hKernel[n28] * this.vKernel[n23];
                            f4 += f3 * (float)(sArray4[n24] + sArray4[n25] + sArray4[n26] + sArray4[n27]);
                            n24 += n6;
                            n25 -= n6;
                            n26 += n6;
                            n27 -= n6;
                            --n28;
                        }
                        n19 += n7;
                        n20 += n7;
                        n21 -= n7;
                        n22 -= n7;
                        --n23;
                    }
                    if (this.hParity == 1) {
                        int n29 = (n17 + this.hKernel.length - 1) * n6 + n15 * n7 + n13;
                        int n30 = n29 + n10;
                        n18 = this.vKernel.length - 1;
                        while (n29 < n30) {
                            f3 = f2 * this.vKernel[n18--];
                            f4 += f3 * (float)(sArray4[n29] + sArray4[n30]);
                            n29 += n7;
                            n30 -= n7;
                        }
                    }
                    if (this.vParity == 1) {
                        int n31 = n17 * n6 + (n15 + this.vKernel.length - 1) * n7 + n13;
                        int n32 = n31 + n11;
                        n18 = this.hKernel.length - 1;
                        while (n31 < n32) {
                            f3 = f * this.hKernel[n18--];
                            f4 += f3 * (float)(sArray4[n31] + sArray4[n32]);
                            n31 += n6;
                            n32 -= n6;
                        }
                        if (this.hParity == 1) {
                            f4 += f * f2 * (float)sArray4[n31];
                        }
                    }
                    sArray3[n16] = ImageUtil.clampShort((int)((double)f4 + 0.5));
                    n16 += n4;
                    n17 += this.scaleX;
                }
                n14 += n5;
                n15 += this.scaleY;
            }
            ++n12;
        }
    }

    protected void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 2 * this.hKernel.length - this.hParity;
        int n9 = 2 * this.vKernel.length - this.vParity;
        int n10 = (n9 - 1) * n7;
        int n11 = (n8 - 1) * n6;
        double d = this.vKernel[0];
        double d2 = this.hKernel[0];
        int n12 = 0;
        while (n12 < n3) {
            int[] nArray5 = nArray[n12];
            int[] nArray6 = nArray3[n12];
            int n13 = nArray4[n12];
            int n14 = nArray2[n12];
            int n15 = 0;
            while (n15 < this.scaleY * n2) {
                int n16 = n14;
                int n17 = 0;
                while (n17 < this.scaleX * n) {
                    int n18;
                    double d3;
                    int n19 = n17 * n6 + n15 * n7 + n13;
                    int n20 = n19 + n11;
                    int n21 = n19 + n10;
                    int n22 = n20 + n10;
                    double d4 = 0.0;
                    int n23 = this.vKernel.length - 1;
                    while (n23 > this.vParity - 1) {
                        int n24 = n19;
                        int n25 = n20;
                        int n26 = n21;
                        int n27 = n22;
                        int n28 = this.hKernel.length - 1;
                        while (n28 > this.hParity - 1) {
                            d3 = this.hKernel[n28] * this.vKernel[n23];
                            d4 += d3 * (double)((long)nArray6[n24] + (long)nArray6[n25] + (long)nArray6[n26] + (long)nArray6[n27]);
                            n24 += n6;
                            n25 -= n6;
                            n26 += n6;
                            n27 -= n6;
                            --n28;
                        }
                        n19 += n7;
                        n20 += n7;
                        n21 -= n7;
                        n22 -= n7;
                        --n23;
                    }
                    if (this.hParity == 1) {
                        int n29 = (n17 + this.hKernel.length - 1) * n6 + n15 * n7 + n13;
                        int n30 = n29 + n10;
                        n18 = this.vKernel.length - 1;
                        while (n29 < n30) {
                            d3 = d2 * (double)this.vKernel[n18--];
                            d4 += d3 * (double)((long)nArray6[n29] + (long)nArray6[n30]);
                            n29 += n7;
                            n30 -= n7;
                        }
                    }
                    if (this.vParity == 1) {
                        int n31 = n17 * n6 + (n15 + this.vKernel.length - 1) * n7 + n13;
                        int n32 = n31 + n11;
                        n18 = this.hKernel.length - 1;
                        while (n31 < n32) {
                            d3 = d * (double)this.hKernel[n18--];
                            d4 += d3 * (double)((long)nArray6[n31] + (long)nArray6[n32]);
                            n31 += n6;
                            n32 -= n6;
                        }
                        if (this.hParity == 1) {
                            d4 += d * d2 * (double)nArray6[n31];
                        }
                    }
                    nArray5[n16] = ImageUtil.clampInt((int)(d4 + 0.5));
                    n16 += n4;
                    n17 += this.scaleX;
                }
                n14 += n5;
                n15 += this.scaleY;
            }
            ++n12;
        }
    }

    protected void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 2 * this.hKernel.length - this.hParity;
        int n9 = 2 * this.vKernel.length - this.vParity;
        int n10 = (n9 - 1) * n7;
        int n11 = (n8 - 1) * n6;
        double d = this.vKernel[0];
        double d2 = this.hKernel[0];
        int n12 = 0;
        while (n12 < n3) {
            float[] fArray3 = fArray[n12];
            float[] fArray4 = fArray2[n12];
            int n13 = nArray2[n12];
            int n14 = nArray[n12];
            int n15 = 0;
            while (n15 < this.scaleY * n2) {
                int n16 = n14;
                int n17 = 0;
                while (n17 < this.scaleX * n) {
                    int n18;
                    double d3;
                    int n19 = n17 * n6 + n15 * n7 + n13;
                    int n20 = n19 + n11;
                    int n21 = n19 + n10;
                    int n22 = n20 + n10;
                    double d4 = 0.0;
                    int n23 = this.vKernel.length - 1;
                    while (n23 > this.vParity - 1) {
                        int n24 = n19;
                        int n25 = n20;
                        int n26 = n21;
                        int n27 = n22;
                        int n28 = this.hKernel.length - 1;
                        while (n28 > this.hParity - 1) {
                            d3 = this.hKernel[n28] * this.vKernel[n23];
                            d4 += d3 * ((double)fArray4[n24] + (double)fArray4[n25] + (double)fArray4[n26] + (double)fArray4[n27]);
                            n24 += n6;
                            n25 -= n6;
                            n26 += n6;
                            n27 -= n6;
                            --n28;
                        }
                        n19 += n7;
                        n20 += n7;
                        n21 -= n7;
                        n22 -= n7;
                        --n23;
                    }
                    if (this.hParity == 1) {
                        int n29 = (n17 + this.hKernel.length - 1) * n6 + n15 * n7 + n13;
                        int n30 = n29 + n10;
                        n18 = this.vKernel.length - 1;
                        while (n29 < n30) {
                            d3 = d2 * (double)this.vKernel[n18--];
                            d4 += d3 * ((double)fArray4[n29] + (double)fArray4[n30]);
                            n29 += n7;
                            n30 -= n7;
                        }
                    }
                    if (this.vParity == 1) {
                        int n31 = n17 * n6 + (n15 + this.vKernel.length - 1) * n7 + n13;
                        int n32 = n31 + n11;
                        n18 = this.hKernel.length - 1;
                        while (n31 < n32) {
                            d3 = d * (double)this.hKernel[n18--];
                            d4 += d3 * ((double)fArray4[n31] + (double)fArray4[n32]);
                            n31 += n6;
                            n32 -= n6;
                        }
                        if (this.hParity == 1) {
                            d4 += d * d2 * (double)fArray4[n31];
                        }
                    }
                    fArray3[n16] = ImageUtil.clampFloat(d4);
                    n16 += n4;
                    n17 += this.scaleX;
                }
                n14 += n5;
                n15 += this.scaleY;
            }
            ++n12;
        }
    }

    protected void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 2 * this.hKernel.length - this.hParity;
        int n9 = 2 * this.vKernel.length - this.vParity;
        int n10 = (n9 - 1) * n7;
        int n11 = (n8 - 1) * n6;
        double d = this.vKernel[0];
        double d2 = this.hKernel[0];
        int n12 = 0;
        while (n12 < n3) {
            double[] dArray3 = dArray[n12];
            double[] dArray4 = dArray2[n12];
            int n13 = nArray2[n12];
            int n14 = nArray[n12];
            int n15 = 0;
            while (n15 < this.scaleY * n2) {
                int n16 = n14;
                int n17 = 0;
                while (n17 < this.scaleX * n) {
                    int n18;
                    double d3;
                    int n19 = n17 * n6 + n15 * n7 + n13;
                    int n20 = n19 + n11;
                    int n21 = n19 + n10;
                    int n22 = n20 + n10;
                    double d4 = 0.0;
                    int n23 = this.vKernel.length - 1;
                    while (n23 > this.vParity - 1) {
                        int n24 = n19;
                        int n25 = n20;
                        int n26 = n21;
                        int n27 = n22;
                        int n28 = this.hKernel.length - 1;
                        while (n28 > this.hParity - 1) {
                            d3 = this.hKernel[n28] * this.vKernel[n23];
                            d4 += d3 * (dArray4[n24] + dArray4[n25] + dArray4[n26] + dArray4[n27]);
                            n24 += n6;
                            n25 -= n6;
                            n26 += n6;
                            n27 -= n6;
                            --n28;
                        }
                        n19 += n7;
                        n20 += n7;
                        n21 -= n7;
                        n22 -= n7;
                        --n23;
                    }
                    if (this.hParity == 1) {
                        int n29 = (n17 + this.hKernel.length - 1) * n6 + n15 * n7 + n13;
                        int n30 = n29 + n10;
                        n18 = this.vKernel.length - 1;
                        while (n29 < n30) {
                            d3 = d2 * (double)this.vKernel[n18--];
                            d4 += d3 * (dArray4[n29] + dArray4[n30]);
                            n29 += n7;
                            n30 -= n7;
                        }
                    }
                    if (this.vParity == 1) {
                        int n31 = n17 * n6 + (n15 + this.vKernel.length - 1) * n7 + n13;
                        int n32 = n31 + n11;
                        n18 = this.hKernel.length - 1;
                        while (n31 < n32) {
                            d3 = d * (double)this.hKernel[n18--];
                            d4 += d3 * (dArray4[n31] + dArray4[n32]);
                            n31 += n6;
                            n32 -= n6;
                        }
                        if (this.hParity == 1) {
                            d4 += d * d2 * dArray4[n31];
                        }
                    }
                    dArray3[n16] = d4;
                    n16 += n4;
                    n17 += this.scaleX;
                }
                n14 += n5;
                n15 += this.scaleY;
            }
            ++n12;
        }
    }
}

