/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.SeekableOutputStream;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.registry.RIFRegistry;

public class FileStoreRIF
implements RenderedImageFactory {
    private static String DEFAULT_FORMAT = "tiff";

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        String string = (String)parameterBlock.getObjectParameter(0);
        String string2 = (String)parameterBlock.getObjectParameter(1);
        if (string2 == null) {
            string2 = DEFAULT_FORMAT;
        }
        ImageEncodeParam imageEncodeParam = null;
        if (parameterBlock.getNumParameters() > 2) {
            imageEncodeParam = (ImageEncodeParam)parameterBlock.getObjectParameter(2);
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = imageEncodeParam == null ? new BufferedOutputStream(new FileOutputStream(string)) : new SeekableOutputStream(new RandomAccessFile(string, "rw"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return null;
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return null;
        }
        ParameterBlock parameterBlock2 = new ParameterBlock();
        parameterBlock2.addSource(parameterBlock.getSource(0));
        parameterBlock2.add(bufferedOutputStream).add(string2).add(imageEncodeParam);
        OperationRegistry operationRegistry = renderingHints == null ? null : (OperationRegistry)renderingHints.get(JAI.KEY_OPERATION_REGISTRY);
        FileStoreImage fileStoreImage = new FileStoreImage(RIFRegistry.create(operationRegistry, "encode", parameterBlock2, renderingHints), bufferedOutputStream);
        return fileStoreImage;
    }

    private class FileStoreImage
    extends RenderedImageAdapter {
        private OutputStream stream;

        public FileStoreImage(RenderedImage renderedImage, OutputStream outputStream) {
            super(renderedImage);
            this.stream = outputStream;
        }

        protected void finalize() throws Throwable {
            this.stream.close();
            super.finalize();
        }
    }
}

