/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibAffineBicubicOpImage;
import com.sun.media.jai.mlib.MlibAffineBilinearOpImage;
import com.sun.media.jai.mlib.MlibAffineNearestOpImage;
import com.sun.media.jai.mlib.MlibAffineTableOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.InterpolationTable;
import javax.media.jai.operator.ShearDescriptor;

public class MlibShearRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(4);
        boolean bl = !(interpolation instanceof InterpolationTable) || interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2;
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout, bl) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout) || renderedImage.getTileWidth() >= 32768 || renderedImage.getTileHeight() >= 32768) {
            return null;
        }
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        float f = parameterBlock.getFloatParameter(0);
        EnumeratedParameter enumeratedParameter = (EnumeratedParameter)parameterBlock.getObjectParameter(1);
        float f2 = parameterBlock.getFloatParameter(2);
        float f3 = parameterBlock.getFloatParameter(3);
        AffineTransform affineTransform = new AffineTransform();
        if (enumeratedParameter.equals(ShearDescriptor.SHEAR_HORIZONTAL)) {
            affineTransform.setTransform(1.0, 0.0, f, 1.0, f2, 0.0);
        } else {
            affineTransform.setTransform(1.0, f, 0.0, 1.0, 0.0, f3);
        }
        if (interpolation instanceof InterpolationNearest) {
            return new MlibAffineNearestOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationBilinear) {
            return new MlibAffineBilinearOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2) {
            return new MlibAffineBicubicOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationTable) {
            return new MlibAffineTableOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
        }
        return null;
    }
}

