/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.OpImage;

class MlibAffineOpImage
extends GeometricOpImage {
    protected double[] f_transform;
    protected double[] m_transform;
    protected double[] medialib_tr;
    protected AffineTransform i_transform;
    protected Interpolation interp;
    private Rectangle srcimg;
    private Rectangle padimg;
    protected BorderExtender extender;
    private Rectangle theDest;
    public int lpad;
    public int rpad;
    public int tpad;
    public int bpad;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, AffineTransform affineTransform) {
        ImageLayout imageLayout2 = imageLayout != null ? (ImageLayout)imageLayout.clone() : new ImageLayout();
        float f = renderedImage.getMinX();
        float f2 = renderedImage.getMinY();
        float f3 = renderedImage.getWidth();
        float f4 = renderedImage.getHeight();
        Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f, f2), new Point2D.Float(f + f3, f2), new Point2D.Float(f + f3, f2 + f4), new Point2D.Float(f, f2 + f4)};
        affineTransform.transform(point2DArray, 0, point2DArray, 0, 4);
        float f5 = Float.MAX_VALUE;
        float f6 = Float.MAX_VALUE;
        float f7 = -3.4028235E38f;
        float f8 = -3.4028235E38f;
        int n = 0;
        while (n < 4) {
            float f9 = (float)point2DArray[n].getX();
            float f10 = (float)point2DArray[n].getY();
            f5 = Math.min(f5, f9);
            f6 = Math.min(f6, f10);
            f7 = Math.max(f7, f9);
            f8 = Math.max(f8, f10);
            ++n;
        }
        int n2 = (int)(f7 - f5);
        int n3 = (int)(f8 - f6);
        int n4 = (int)Math.floor(f5);
        int n5 = (double)Math.abs(f5 - (float)n4) <= 0.5 ? n4 : (int)Math.ceil(f5);
        int n6 = (int)Math.floor(f6);
        int n7 = (double)Math.abs(f6 - (float)n6) <= 0.5 ? n6 : (int)Math.ceil(f6);
        imageLayout2.setMinX(n5);
        imageLayout2.setMinY(n7);
        imageLayout2.setWidth(n2);
        imageLayout2.setHeight(n3);
        return imageLayout2;
    }

    public MlibAffineOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, BorderExtender borderExtender, AffineTransform affineTransform, Interpolation interpolation) {
        super(OpImage.vectorize(renderedImage), MlibAffineOpImage.layoutHelper(imageLayout, renderedImage, affineTransform), map, true, borderExtender, interpolation);
        this.interp = interpolation;
        this.extender = borderExtender;
        this.lpad = interpolation.getLeftPadding();
        this.rpad = interpolation.getRightPadding();
        this.tpad = interpolation.getTopPadding();
        this.bpad = interpolation.getBottomPadding();
        this.srcimg = new Rectangle(this.getSourceImage(0).getMinX(), this.getSourceImage(0).getMinY(), this.getSourceImage(0).getWidth(), this.getSourceImage(0).getHeight());
        this.padimg = new Rectangle(this.srcimg.x - this.lpad, this.srcimg.y - this.tpad, this.srcimg.width + this.lpad + this.rpad, this.srcimg.height + this.tpad + this.bpad);
        if (borderExtender == null) {
            float f = this.srcimg.x;
            float f2 = this.srcimg.y;
            float f3 = this.srcimg.width;
            float f4 = this.srcimg.height;
            float f5 = this.lpad;
            float f6 = this.rpad;
            float f7 = this.tpad;
            float f8 = this.bpad;
            if (interpolation instanceof InterpolationBilinear || interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2) {
                f5 = (float)((double)f5 + 0.5);
                f7 = (float)((double)f7 + 0.5);
                f6 = (float)((double)f6 + 0.5);
                f8 = (float)((double)f8 + 0.5);
            }
            Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f += f5, f2 += f7), new Point2D.Float(f + (f3 -= f5 + f6), f2), new Point2D.Float(f + f3, f2 + (f4 -= f7 + f8)), new Point2D.Float(f, f2 + f4)};
            affineTransform.transform(point2DArray, 0, point2DArray, 0, 4);
            float f9 = Float.MAX_VALUE;
            float f10 = Float.MAX_VALUE;
            float f11 = -3.4028235E38f;
            float f12 = -3.4028235E38f;
            int n = 0;
            while (n < 4) {
                float f13 = (float)point2DArray[n].getX();
                float f14 = (float)point2DArray[n].getY();
                f9 = Math.min(f9, f13);
                f10 = Math.min(f10, f14);
                f11 = Math.max(f11, f13);
                f12 = Math.max(f12, f14);
                ++n;
            }
            int n2 = (int)Math.ceil(f9);
            int n3 = (int)Math.ceil(f10);
            int n4 = (int)Math.floor(f11);
            int n5 = (int)Math.floor(f12);
            this.theDest = new Rectangle(n2, n3, n4 - n2, n5 - n3);
        } else {
            this.theDest = this.getBounds();
        }
        try {
            this.i_transform = affineTransform.createInverse();
        }
        catch (Exception exception) {
            throw new RuntimeException(JaiI18N.getString("MlibAffineOpImage0"));
        }
        this.f_transform = new double[6];
        affineTransform.getMatrix(this.f_transform);
        this.medialib_tr = new double[6];
        this.medialib_tr[0] = this.f_transform[0];
        this.medialib_tr[1] = this.f_transform[2];
        this.medialib_tr[2] = this.f_transform[4];
        this.medialib_tr[3] = this.f_transform[1];
        this.medialib_tr[4] = this.f_transform[3];
        this.medialib_tr[5] = this.f_transform[5];
        this.m_transform = new double[6];
        this.m_transform[0] = this.f_transform[0];
        this.m_transform[1] = this.f_transform[2];
        this.m_transform[2] = this.f_transform[4];
        this.m_transform[3] = this.f_transform[1];
        this.m_transform[4] = this.f_transform[3];
        this.m_transform[5] = this.f_transform[5];
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int n) {
        return this.getBounds();
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n) {
        float f = rectangle.x;
        float f2 = rectangle.y;
        float f3 = rectangle.width;
        float f4 = rectangle.height;
        Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f, f2), new Point2D.Float(f + f3, f2), new Point2D.Float(f + f3, f2 + f4), new Point2D.Float(f, f2 + f4)};
        this.i_transform.transform(point2DArray, 0, point2DArray, 0, 4);
        float f5 = Float.MAX_VALUE;
        float f6 = Float.MAX_VALUE;
        float f7 = -3.4028235E38f;
        float f8 = -3.4028235E38f;
        int n2 = 0;
        while (n2 < 4) {
            float f9 = (float)point2DArray[n2].getX();
            float f10 = (float)point2DArray[n2].getY();
            f5 = Math.min(f5, f9);
            f6 = Math.min(f6, f10);
            f7 = Math.max(f7, f9);
            f8 = Math.max(f8, f10);
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (this.interp instanceof InterpolationNearest) {
            n3 = (int)Math.floor(f5);
            n4 = (int)Math.floor(f6);
            n5 = (int)Math.ceil(f7);
            n6 = (int)Math.ceil(f8);
        } else {
            n3 = (int)Math.floor((double)f5 - 0.5);
            n4 = (int)Math.floor((double)f6 - 0.5);
            n5 = (int)Math.ceil(f7);
            n6 = (int)Math.ceil(f8);
        }
        return new Rectangle(n3, n4, n5 - n3, n6 - n4);
    }

    public Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = Raster.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.tileWidth, this.tileHeight);
        Rectangle rectangle2 = rectangle.intersection(this.theDest);
        if (rectangle2.width <= 0 || rectangle2.height <= 0) {
            return writableRaster;
        }
        Rectangle rectangle3 = this.mapDestRect(rectangle2, 0);
        rectangle3 = this.extender == null ? rectangle3.intersection(this.srcimg) : rectangle3.intersection(this.padimg);
        if (rectangle3.width <= 0 || rectangle3.height <= 0) {
            return writableRaster;
        }
        Raster[] rasterArray = new Raster[]{this.extender == null ? this.getSourceImage(0).getData(rectangle3) : this.getSourceImage(0).getExtendedData(rectangle3, this.extender)};
        this.computeRect(rasterArray, writableRaster, rectangle2);
        return writableRaster;
    }
}

