/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.sedml;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.jlibsedml.ArchiveComponents;
import org.jlibsedml.DataGenerator;
import org.jlibsedml.Output;
import org.jlibsedml.SedML;
import org.jlibsedml.Simulation;
import org.jlibsedml.Task;
import org.jlibsedml.UniformTimeCourse;
import org.jlibsedml.Variable;
import org.jlibsedml.VariableSymbol;
import org.jlibsedml.execution.AbstractSedmlExecutor;
import org.jlibsedml.execution.ArchiveModelResolver;
import org.jlibsedml.execution.ExecutionStatusElement;
import org.jlibsedml.execution.IModelResolver;
import org.jlibsedml.execution.IProcessedSedMLSimulationResults;
import org.jlibsedml.execution.IRawSedmlSimulationResults;
import org.jlibsedml.execution.SedMLResultsProcesser2;
import org.jlibsedml.modelsupport.BioModelsModelsRetriever;
import org.jlibsedml.modelsupport.KisaoOntology;
import org.jlibsedml.modelsupport.KisaoTerm;
import org.jlibsedml.modelsupport.URLResourceRetriever;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.xml.stax.SBMLReader;
import org.simulator.math.odes.AbstractDESSolver;
import org.simulator.math.odes.DormandPrince54Solver;
import org.simulator.math.odes.EulerMethod;
import org.simulator.math.odes.MultiTable;
import org.simulator.math.odes.RosenbrockSolver;
import org.simulator.sbml.SBMLinterpreter;
import org.simulator.sedml.MultTableSEDMLWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SedMLSBMLSimulatorExecutor
extends AbstractSedmlExecutor {
    static final String[] SupportedIDs = new String[]{"KISAO:0000033", "KISAO:0000030", "KISAO:0000087", "KISAO:0000088"};

    public SedMLSBMLSimulatorExecutor(SedML sedml, Output output) {
        super(sedml, output);
        this.addModelResolver((IModelResolver)new BioModelsModelsRetriever());
        this.addModelResolver((IModelResolver)new URLResourceRetriever());
    }

    public void setIsArchive(ArchiveComponents ac) {
        this.addModelResolver((IModelResolver)new ArchiveModelResolver(ac));
    }

    protected boolean canExecuteSimulation(Simulation sim) {
        String kisaoID = sim.getAlgorithm().getKisaoID();
        KisaoTerm wanted = KisaoOntology.getInstance().getTermById(kisaoID);
        String[] stringArray = SupportedIDs;
        int n = SupportedIDs.length;
        int n2 = 0;
        while (n2 < n) {
            KisaoTerm offered;
            String supported = stringArray[n2];
            if (wanted != null & (offered = KisaoOntology.getInstance().getTermById(supported)) != null && offered.is_a(wanted)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected IRawSedmlSimulationResults executeSimulation(String modelStr, UniformTimeCourse sim) {
        AbstractDESSolver solver = this.getSolverForKisaoID(sim.getAlgorithm().getKisaoID());
        File tmp = null;
        try {
            tmp = File.createTempFile("Sim", "sbml");
            FileUtils.writeStringToFile((File)tmp, (String)modelStr, (String)"UTF-8");
            Model model = new SBMLReader().readSBML(tmp).getModel();
            SBMLinterpreter interpreter = new SBMLinterpreter(model);
            solver.setIncludeIntermediates(false);
            solver.setStepSize((sim.getOutputEndTime() - sim.getOutputStartTime()) / (double)sim.getNumberOfPoints());
            MultiTable mts = solver.solve(interpreter, interpreter.getInitialValues(), sim.getOutputStartTime(), sim.getOutputEndTime());
            return new MultTableSEDMLWrapper(mts);
        }
        catch (Exception e) {
            this.addStatus(new ExecutionStatusElement(e, "Simulation failed", ExecutionStatusElement.ExecutionStatusType.ERROR));
            return null;
        }
    }

    protected boolean supportsLanguage(String language) {
        return language.contains("sbml") || language.contains("SBML");
    }

    AbstractDESSolver getSolverForKisaoID(String id) {
        if (SupportedIDs[0].equals(id)) {
            return new RosenbrockSolver();
        }
        if (SupportedIDs[1].equals(id)) {
            return new EulerMethod();
        }
        if (SupportedIDs[2].equals(id)) {
            return new DormandPrince54Solver();
        }
        return new RosenbrockSolver();
    }

    public MultiTable processSimulationResults(Output wanted, Map<Task, IRawSedmlSimulationResults> res) {
        SedMLResultsProcesser2 pcsr2 = new SedMLResultsProcesser2(this.sedml, wanted);
        pcsr2.process(res);
        IProcessedSedMLSimulationResults prRes = pcsr2.getProcessedResult();
        MultiTable mt = this.createMultiTableFromProcessedResults(wanted, prRes);
        return mt;
    }

    public MultiTable createMultiTableFromProcessedResults(Output wanted, IProcessedSedMLSimulationResults prRes) {
        String timeColName = this.findTimeColumn(prRes, wanted, this.sedml);
        double[] time = this.getTimeData(prRes, timeColName);
        double[][] data = this.getNonTimeData(prRes, timeColName);
        String[] hdrs = this.getNonTimeHeaders(prRes, timeColName);
        MultiTable mt = new MultiTable(time, data, hdrs);
        return mt;
    }

    private String[] getNonTimeHeaders(IProcessedSedMLSimulationResults prRes, String timeColName) {
        String[] rc = new String[prRes.getNumColumns() - 1];
        int rcIndx = 0;
        String[] stringArray = prRes.getColumnHeaders();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String col = stringArray[n2];
            if (!col.equals(timeColName)) {
                rc[rcIndx++] = col;
            }
            ++n2;
        }
        return rc;
    }

    private double[][] getNonTimeData(IProcessedSedMLSimulationResults prRes, String timeColName) {
        double[][] data = prRes.getData();
        int indx = prRes.getIndexByColumnID(timeColName);
        double[][] rc = new double[prRes.getNumDataRows()][prRes.getNumColumns() - 1];
        int r = 0;
        while (r < data.length) {
            int colIndx = 0;
            int c = 0;
            while (c < data[r].length) {
                if (c != indx) {
                    rc[r][colIndx++] = data[r][c];
                }
                ++c;
            }
            ++r;
        }
        return rc;
    }

    private double[] getTimeData(IProcessedSedMLSimulationResults prRes, String timeColName) {
        Double[] tim = prRes.getDataByColumnId(timeColName);
        double[] rc = new double[tim.length];
        int indx = 0;
        Double[] doubleArray = tim;
        int n = tim.length;
        int n2 = 0;
        while (n2 < n) {
            Double d = doubleArray[n2];
            rc[indx++] = d;
            ++n2;
        }
        return rc;
    }

    private String findTimeColumn(IProcessedSedMLSimulationResults prRes, Output wanted, SedML sedml2) {
        List dgIds = wanted.getAllDataGeneratorReferences();
        for (String dgID : dgIds) {
            DataGenerator dg = this.sedml.getDataGeneratorWithId(dgID);
            if (dg == null) continue;
            List vars = dg.getListOfVariables();
            for (Variable v : vars) {
                if (!v.isSymbol() || !VariableSymbol.TIME.equals((Object)v.getSymbol())) continue;
                return dgID;
            }
        }
        return null;
    }
}

