/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.sedml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.jdom.Element;
import org.jlibsedml.Algorithm;
import org.jlibsedml.Curve;
import org.jlibsedml.DataGenerator;
import org.jlibsedml.Libsedml;
import org.jlibsedml.Model;
import org.jlibsedml.Notes;
import org.jlibsedml.Output;
import org.jlibsedml.Plot2D;
import org.jlibsedml.SEDMLDocument;
import org.jlibsedml.SedML;
import org.jlibsedml.Simulation;
import org.jlibsedml.Task;
import org.jlibsedml.UniformTimeCourse;
import org.jlibsedml.Variable;
import org.jlibsedml.VariableSymbol;
import org.jlibsedml.modelsupport.SBMLSupport;
import org.jlibsedml.modelsupport.SUPPORTED_LANGUAGE;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Species;
import org.simulator.math.odes.AbstractDESSolver;
import org.simulator.math.odes.AdamsBashforthSolver;
import org.simulator.math.odes.AdamsMoultonSolver;
import org.simulator.math.odes.DormandPrince54Solver;
import org.simulator.math.odes.DormandPrince853Solver;
import org.simulator.math.odes.EulerMethod;
import org.simulator.math.odes.RosenbrockSolver;
import org.simulator.math.odes.RungeKutta_EventSolver;

public class SEDMLWriter {
    private String comment;

    public void setComment(String comment) {
        this.comment = comment;
    }

    private void addNote(String text, SedML sedml) {
        Element el = new Element("p");
        el.setText(text);
        Notes n = new Notes(el);
        sedml.addNote(n);
    }

    public void saveExperimentToSEDML(double start, double end, double stepsize, AbstractDESSolver solver, org.sbml.jsbml.Model model, URI modelURI, OutputStream os) throws IOException {
        SEDMLDocument doc = Libsedml.createDocument();
        SedML sedml = doc.getSedMLModel();
        String modelName = this.extractModelName(model);
        if (this.comment != null && this.comment.length() != 0) {
            this.addNote(this.comment, sedml);
        }
        Model m = new Model(modelName, modelName, SUPPORTED_LANGUAGE.SBML_GENERIC.getURN(), modelURI.toString());
        UniformTimeCourse utc = new UniformTimeCourse("sim1", "utc", 0.0, start, end, (int)((end - start) / stepsize), new Algorithm(this.getKisaoIDForSolver(solver)));
        Task t1 = new Task("t1", "TASK", m.getId(), utc.getId());
        sedml.addModel(m);
        sedml.addSimulation((Simulation)utc);
        sedml.addTask(t1);
        ListOf los = model.getListOfSpecies();
        for (Species s : los) {
            DataGenerator dg = new DataGenerator(String.valueOf(s.getId()) + "dg", s.getId(), Libsedml.parseFormulaString((String)s.getId()));
            SBMLSupport support = new SBMLSupport();
            Variable v = new Variable(s.getId(), s.getId(), t1.getId(), support.getXPathForSpecies(s.getId()));
            dg.addVariable(v);
            sedml.addDataGenerator(dg);
        }
        DataGenerator time = new DataGenerator("timedg", "Time", Libsedml.parseFormulaString((String)"Time"));
        Variable timeVar = new Variable("Time", "Time", t1.getId(), VariableSymbol.TIME);
        time.addVariable(timeVar);
        sedml.addDataGenerator(time);
        Plot2D plot2d = new Plot2D("plot", "Basic plot");
        sedml.addOutput((Output)plot2d);
        int indx = 0;
        for (DataGenerator dg : sedml.getDataGenerators()) {
            if (dg.equals((Object)time)) continue;
            Curve curve = new Curve("curve" + indx++, null, false, false, time.getId(), dg.getId());
            plot2d.addCurve(curve);
        }
        os.write(doc.writeDocumentToString().getBytes());
    }

    String extractModelName(org.sbml.jsbml.Model model) {
        String modelName = model.getName();
        if (modelName == null || modelName.length() == 0) {
            modelName = model.getId();
        }
        if (modelName == null || modelName.length() == 0) {
            modelName = "model1";
        }
        return modelName;
    }

    public void executeSedML(InputStream SedML2) {
    }

    String getKisaoIDForSolver(AbstractDESSolver solver) {
        if (solver instanceof EulerMethod) {
            return "KISAO_0000261";
        }
        if (solver instanceof RungeKutta_EventSolver) {
            return "KISAO_0000064";
        }
        if (solver instanceof RosenbrockSolver) {
            return "KISAO_0000033";
        }
        if (solver instanceof AdamsBashforthSolver) {
            return "KISAO_0000279";
        }
        if (solver instanceof AdamsMoultonSolver) {
            return "KISAO_0000280";
        }
        if (solver instanceof DormandPrince54Solver || solver instanceof DormandPrince853Solver) {
            return "KISAO_0000087";
        }
        return "KISAO_0000033";
    }
}

