/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.sedml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.jlibsedml.Libsedml;
import org.jlibsedml.Output;
import org.jlibsedml.SEDMLDocument;
import org.jlibsedml.SedML;
import org.jlibsedml.XMLException;
import org.simulator.math.odes.MultiTable;
import org.simulator.sedml.ExecutionException;
import org.simulator.sedml.SedMLSBMLSimulatorExecutor;

public class SEDMLExecutor {
    public MultiTable execute(String outputID, InputStream is) throws ExecutionException, IOException {
        SEDMLDocument doc;
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        try {
            doc = Libsedml.readDocumentFromString((String)sb.toString());
        }
        catch (XMLException e) {
            e.printStackTrace();
            throw new ExecutionException("Error reading SED-ML: " + e.getMessage());
        }
        SedML sed = doc.getSedMLModel();
        Output out = sed.getOutputWithId(outputID);
        if (out == null) {
            throw new ExecutionException("No output with id [" + outputID + "]");
        }
        SedMLSBMLSimulatorExecutor exe = new SedMLSBMLSimulatorExecutor(sed, out);
        Map res = exe.runSimulations();
        return exe.processSimulationResults(out, res);
    }
}

