/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.sedml;

import org.jlibsedml.execution.IModel2DataMappings;
import org.jlibsedml.execution.IRawSedmlSimulationResults;
import org.simulator.math.odes.MultiTable;

public class MultTableSEDMLWrapper
implements IRawSedmlSimulationResults {
    private MultiTable mTable;

    public MultTableSEDMLWrapper(MultiTable mTable) {
        this.mTable = mTable;
    }

    public MultiTable getMultiTable() {
        return this.mTable;
    }

    public String[] getColumnHeaders() {
        String[] hdrs = new String[this.mTable.getColumnCount()];
        int i = 0;
        while (i < hdrs.length) {
            hdrs[i] = this.mTable.getColumnIdentifier(i);
            ++i;
        }
        return hdrs;
    }

    public double[][] getData() {
        double[][] data = new double[this.mTable.getRowCount()][this.mTable.getColumnCount()];
        int i = 0;
        while (i < this.mTable.getRowCount()) {
            int j = 0;
            while (j < this.mTable.getColumnCount()) {
                data[i][j] = this.mTable.getValueAt(i, j);
                ++j;
            }
            ++i;
        }
        return data;
    }

    public Double[] getDataByColumnId(String id) {
        Double[] rc = new Double[this.mTable.getRowCount()];
        MultiTable.Block.Column col = this.mTable.getColumn(id);
        int i = 0;
        while (i < this.mTable.getRowCount()) {
            rc[i] = col.getValue(i);
            ++i;
        }
        return rc;
    }

    public Double[] getDataByColumnIndex(int indx) {
        Double[] rc = new Double[this.mTable.getRowCount()];
        MultiTable.Block.Column col = this.mTable.getColumn(indx);
        int i = 0;
        while (i < this.mTable.getRowCount()) {
            rc[i] = col.getValue(i);
            ++i;
        }
        return rc;
    }

    public int getIndexByColumnID(String colID) {
        return this.mTable.getColumnIndex(colID);
    }

    public int getNumColumns() {
        return this.mTable.getColumnCount();
    }

    public int getNumDataRows() {
        return this.mTable.getRowCount();
    }

    public IModel2DataMappings getMappings() {
        return new IModel2DataMappings(){

            public boolean hasMappingFor(String id) {
                return MultTableSEDMLWrapper.this.mTable.getColumn(id) != null;
            }

            public String getColumnTitleFor(String modelID) {
                return modelID;
            }

            public int getColumnIndexFor(String colID) {
                return MultTableSEDMLWrapper.this.mTable.getColumnIndex(colID);
            }
        };
    }
}

