/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.sbml.astnode;

import java.util.Map;
import java.util.Set;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.SpeciesReference;
import org.simulator.sbml.SBMLValueHolder;
import org.simulator.sbml.astnode.ASTNodeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoichiometryValue {
    private double stoichiometry;
    private double time;
    private int speciesIndex;
    private int speciesRefIndex;
    private boolean constantStoichiometry;
    private boolean constantQuantity;
    private boolean boundaryCondition;
    private boolean isSetStoichiometryMath;
    private int compartmentIndex;
    protected SBMLValueHolder valueHolder;
    private String id;
    private SpeciesReference sr;
    private Map<String, Double> stoichiometricCoefHash;
    private double[] Y;
    private ASTNodeValue stoichiometryMathValue;
    private int reactionIndex;
    private boolean isReactant;
    private boolean inConcentration;
    private boolean stoichiometrySet;

    public StoichiometryValue(SpeciesReference sr, int speciesIndex, int speciesRefIndex, int compartmentIndex, Map<String, Double> stoichiometricCoefHash, SBMLValueHolder valueHolder, double[] Y, ASTNodeValue stoichiometryMathValue, int reactionIndex, Set<String> inConcentrationSet, boolean isReactant) {
        this.isSetStoichiometryMath = sr.isSetStoichiometryMath();
        this.valueHolder = valueHolder;
        this.compartmentIndex = compartmentIndex;
        this.sr = sr;
        this.reactionIndex = reactionIndex;
        this.id = sr.getId();
        this.speciesIndex = speciesIndex;
        this.speciesRefIndex = speciesRefIndex;
        this.constantStoichiometry = false;
        if (sr.isSetConstant()) {
            this.constantStoichiometry = sr.getConstant();
        } else if (!sr.isSetId() && !this.isSetStoichiometryMath) {
            this.constantStoichiometry = true;
        }
        this.boundaryCondition = false;
        this.constantQuantity = false;
        this.inConcentration = false;
        Species s = sr.getSpeciesInstance();
        if (s != null) {
            if (s.getBoundaryCondition()) {
                this.boundaryCondition = true;
            }
            if (s.getConstant()) {
                this.constantQuantity = true;
            }
            if (inConcentrationSet.contains(s.getId())) {
                this.inConcentration = true;
            }
        }
        this.stoichiometricCoefHash = stoichiometricCoefHash;
        this.Y = Y;
        this.stoichiometryMathValue = stoichiometryMathValue;
        this.time = Double.NaN;
        this.isReactant = isReactant;
        this.computeStoichiometricValue();
    }

    public void computeChange(double currentTime, double[] changeRate, double[] v) {
        if (!this.constantStoichiometry || !this.stoichiometrySet) {
            this.compileDouble(currentTime);
        }
        double value = this.constantQuantity || this.boundaryCondition ? 0.0 : (this.isReactant ? -1.0 * this.stoichiometry * v[this.reactionIndex] : this.stoichiometry * v[this.reactionIndex]);
        if (this.inConcentration) {
            value /= this.valueHolder.getCurrentValueOf(this.compartmentIndex);
        }
        int n = this.speciesIndex;
        changeRate[n] = changeRate[n] + value;
    }

    private double compileDouble(double time) {
        if (this.time != time) {
            this.time = time;
            if (!this.constantStoichiometry || time <= 0.0 || !this.stoichiometrySet) {
                this.computeStoichiometricValue();
            }
        }
        return this.stoichiometry;
    }

    private void computeStoichiometricValue() {
        if (this.speciesRefIndex >= 0) {
            this.stoichiometry = this.Y[this.speciesRefIndex];
            this.stoichiometricCoefHash.put(this.id, this.stoichiometry);
            this.stoichiometrySet = true;
        } else if (this.stoichiometricCoefHash != null && this.stoichiometricCoefHash.containsKey(this.id)) {
            this.stoichiometry = this.stoichiometricCoefHash.get(this.id);
            this.stoichiometrySet = true;
        } else if (this.isSetStoichiometryMath) {
            this.stoichiometry = this.stoichiometryMathValue.compileDouble(this.time);
            this.stoichiometrySet = true;
        } else if (!this.sr.isSetStoichiometry() && this.sr.getLevel() >= 3) {
            this.stoichiometry = 1.0;
            this.stoichiometrySet = false;
        } else {
            this.stoichiometry = this.sr.getCalculatedStoichiometry();
            this.stoichiometrySet = this.id.equals("");
        }
    }

    public void refresh() {
        this.computeStoichiometricValue();
    }
}

