/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.sbml.astnode;

import org.sbml.jsbml.Species;
import org.simulator.sbml.SBMLValueHolder;
import org.simulator.sbml.astnode.ASTNodeValue;

public class RuleValue {
    protected ASTNodeValue nodeObject;
    protected double value;
    protected boolean isSpecies;
    protected SBMLValueHolder valueHolder;
    protected int compartmentIndex;
    protected boolean hasOnlySubstanceUnits;
    protected boolean isSetInitialAmount;
    protected boolean isSetInitialConcentration;
    protected boolean hasZeroSpatialDimensions;
    protected int index;

    public RuleValue(ASTNodeValue nodeObject, int index) {
        this.nodeObject = nodeObject;
        this.index = index;
        this.isSpecies = false;
    }

    public RuleValue(ASTNodeValue nodeObject, int index, Species sp, int compartmentIndex, boolean hasZeroSpatialDimensions, SBMLValueHolder valueHolder) {
        this.nodeObject = nodeObject;
        this.index = index;
        this.isSpecies = true;
        this.compartmentIndex = compartmentIndex;
        this.hasOnlySubstanceUnits = sp.getHasOnlySubstanceUnits();
        this.isSetInitialAmount = sp.isSetInitialAmount();
        this.isSetInitialConcentration = sp.isSetInitialConcentration();
        this.hasZeroSpatialDimensions = hasZeroSpatialDimensions;
        this.valueHolder = valueHolder;
    }

    protected double processAssignmentVariable(double time) {
        this.value = this.nodeObject.compileDouble(time);
        if (this.isSpecies && !this.hasZeroSpatialDimensions) {
            double compartmentValue = this.valueHolder.getCurrentValueOf(this.compartmentIndex);
            if (this.isSetInitialAmount && !this.hasOnlySubstanceUnits) {
                this.value *= compartmentValue;
            } else if (this.isSetInitialConcentration && this.hasOnlySubstanceUnits) {
                this.value /= compartmentValue;
            }
        }
        return this.value;
    }

    public double getValue() {
        return this.value;
    }

    public int getIndex() {
        return this.index;
    }
}

