/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.sbml.astnode;

import java.util.List;
import org.sbml.jsbml.Species;
import org.simulator.sbml.SBMLValueHolder;
import org.simulator.sbml.astnode.ASTNodeValue;
import org.simulator.sbml.astnode.RuleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateRuleValue
extends RuleValue {
    private boolean isCompartment;
    private List<Integer> speciesIndices;

    public RateRuleValue(ASTNodeValue nodeObject, int index) {
        super(nodeObject, index);
    }

    public RateRuleValue(ASTNodeValue nodeObject, int index, Species sp, int compartmentIndex, boolean hasZeroSpatialDimensions, SBMLValueHolder valueHolder) {
        super(nodeObject, index, sp, compartmentIndex, hasZeroSpatialDimensions, valueHolder);
    }

    public RateRuleValue(ASTNodeValue nodeObject, int index, List<Integer> speciesIndices, SBMLValueHolder valueHolder) {
        super(nodeObject, index);
        this.isCompartment = true;
        this.speciesIndices = speciesIndices;
    }

    public void processRule(double[] changeRate, double[] Y, double time) {
        changeRate[this.index] = this.processAssignmentVariable(time);
        if (this.isCompartment && this.speciesIndices != null) {
            for (int speciesIndex : this.speciesIndices) {
                changeRate[speciesIndex] = -changeRate[this.index] * Y[speciesIndex] / Y[this.index];
            }
        }
    }
}

