/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.sbml.astnode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.CallableSBase;
import org.sbml.jsbml.FunctionDefinition;
import org.sbml.jsbml.SBMLException;
import org.simulator.sbml.astnode.ASTNodeInterpreter;
import org.simulator.sbml.astnode.ASTNodeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionValue
extends ASTNodeValue {
    protected ASTNodeValue evaluationBlock;
    protected List<String> variables;
    protected double[] argumentValues;
    protected Map<String, Integer> indexMap;
    protected ASTNode math;

    /*
     * Enabled aggressive block sorting
     */
    public FunctionValue(ASTNodeInterpreter interpreter, ASTNode node, List<ASTNode> variableNodes) {
        super(interpreter, node);
        CallableSBase variable = node.getVariable();
        if (variable == null) {
            logger.warning("ASTNode of type FUNCTION but the variable is null !! (" + node.getName() + ", " + node.getParentSBMLObject() + "). " + "Check that your object is linked to a Model.");
            return;
        }
        if (!(variable instanceof FunctionDefinition)) {
            logger.warning("ASTNode of type FUNCTION but the variable is not a FunctionDefinition !! (" + node.getName() + ", " + node.getParentSBMLObject() + ")");
            throw new SBMLException("ASTNode of type FUNCTION but the variable is not a FunctionDefinition !! (" + node.getName() + ", " + node.getParentSBMLObject() + ")");
        }
        this.variables = new ArrayList<String>(variableNodes.size());
        this.indexMap = new HashMap<String, Integer>();
        int index = 0;
        for (ASTNode argument : variableNodes) {
            String argumentName = interpreter.compileString(argument);
            this.variables.add(argumentName);
            this.indexMap.put(argumentName, index);
            ++index;
        }
        this.argumentValues = new double[this.variables.size()];
    }

    @Override
    protected void computeDoubleValue() {
        this.doubleValue = this.math != null ? this.interpreter.functionDouble(this.evaluationBlock, this.variables, this.children, this.numChildren, this.argumentValues, this.time) : Double.NaN;
    }

    @Override
    protected void computeBooleanValue() {
        this.booleanValue = this.math != null ? this.interpreter.functionBoolean(this.evaluationBlock, this.variables, this.children, this.argumentValues, this.time) : false;
    }

    public void setMath(ASTNode math) {
        this.math = math;
        this.evaluationBlock = (ASTNodeValue)math.getRightChild().getUserObject((Object)"SBML_SIMULATION_TEMP_VALUE");
    }

    public double[] getArgumentValues() {
        return this.argumentValues;
    }

    public int getIndex(String argumentName) {
        return this.indexMap.get(argumentName);
    }
}

