/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.sbml.astnode;

import java.util.Map;
import org.sbml.jsbml.Species;
import org.simulator.sbml.SBMLValueHolder;
import org.simulator.sbml.astnode.ASTNodeValue;
import org.simulator.sbml.astnode.RuleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignmentRuleValue
extends RuleValue {
    private String speciesReferenceID;
    private Map<String, Double> stoichiometricCoefHash;

    public AssignmentRuleValue(ASTNodeValue nodeObject, int index) {
        super(nodeObject, index);
    }

    public AssignmentRuleValue(ASTNodeValue nodeObject, String speciesReferenceID, Map<String, Double> stoichiometricCoefHash) {
        super(nodeObject, -1);
        this.speciesReferenceID = speciesReferenceID;
        this.stoichiometricCoefHash = stoichiometricCoefHash;
    }

    public AssignmentRuleValue(ASTNodeValue nodeObject, int index, Species sp, int compartmentIndex, boolean hasZeroSpatialDimensions, SBMLValueHolder valueHolder) {
        super(nodeObject, index, sp, compartmentIndex, hasZeroSpatialDimensions, valueHolder);
    }

    public boolean processRule(double[] Y, double time, boolean changeY) {
        this.processAssignmentVariable(time);
        if (this.index >= 0) {
            double oldValue = Y[this.index];
            if (changeY) {
                Y[this.index] = this.value;
            }
            if (oldValue != this.value) {
                return true;
            }
        } else if (this.speciesReferenceID != null) {
            Double v = this.stoichiometricCoefHash.get(this.speciesReferenceID);
            this.stoichiometricCoefHash.put(this.speciesReferenceID, this.value);
            if (v != null && v != this.value) {
                return true;
            }
        }
        return false;
    }

    public String getSpeciesReferenceID() {
        return this.speciesReferenceID;
    }
}

