/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.sbml.astnode;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.CallableSBase;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.util.Maths;
import org.simulator.sbml.astnode.ASTNodeInterpreter;

public class ASTNodeValue {
    protected double time;
    protected boolean isConstant;
    protected boolean isInfinite;
    protected boolean booleanValue;
    protected double doubleValue;
    protected boolean isDouble;
    protected ASTNode node;
    protected ASTNode.Type nodeType;
    protected List<ASTNodeValue> children;
    protected ASTNodeValue leftChild;
    protected ASTNodeValue rightChild;
    protected String name;
    protected int numChildren;
    protected boolean alreadyProcessed;
    protected ASTNodeInterpreter interpreter;
    protected double real;
    protected double mantissa;
    protected int exponent;
    protected int numerator;
    protected int denominator;
    protected String units;
    public static final Logger logger = Logger.getLogger(ASTNodeValue.class.getName());

    public void reset() {
        this.alreadyProcessed = false;
    }

    public ASTNodeValue(ASTNodeInterpreter interpreter, ASTNode node) {
        this.interpreter = interpreter;
        this.node = node;
        this.nodeType = node.getType();
        this.isConstant = false;
        this.alreadyProcessed = false;
        if (this.nodeType == ASTNode.Type.REAL) {
            this.real = node.getReal();
            this.isInfinite = Double.isInfinite(this.real);
        } else {
            this.real = this.nodeType == ASTNode.Type.INTEGER ? (double)node.getInteger() : Double.NaN;
        }
        if (node.isSetUnits()) {
            this.units = node.getUnits();
        }
        if (this.nodeType == ASTNode.Type.REAL || this.nodeType == ASTNode.Type.REAL_E) {
            this.mantissa = node.getMantissa();
            this.exponent = node.getExponent();
        }
        if (this.nodeType == ASTNode.Type.RATIONAL) {
            this.numerator = node.getNumerator();
            this.denominator = node.getDenominator();
        }
        if (node.isName()) {
            this.name = node.getName();
        }
        this.time = 0.0;
        this.children = new ArrayList<ASTNodeValue>();
        if (node != null) {
            for (ASTNode childNode : node.getChildren()) {
                Object userObject = childNode.getUserObject((Object)"SBML_SIMULATION_TEMP_VALUE");
                if (userObject == null) continue;
                this.children.add((ASTNodeValue)userObject);
            }
        }
        this.numChildren = this.children.size();
        if (this.numChildren > 0) {
            this.leftChild = this.children.get(0);
            this.rightChild = this.children.get(this.numChildren - 1);
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public boolean getConstant() {
        return this.isConstant;
    }

    public Object getValue(double time) {
        if (this.isDouble) {
            return this.compileDouble(time);
        }
        return this.compileBoolean(time);
    }

    public double compileDouble(double time) {
        if (this.time == time || this.isConstant && this.alreadyProcessed) {
            return this.doubleValue;
        }
        this.isDouble = true;
        this.alreadyProcessed = true;
        this.time = time;
        this.computeDoubleValue();
        return this.doubleValue;
    }

    public boolean compileBoolean(double time) {
        if (this.time == time || this.isConstant && this.alreadyProcessed) {
            return this.booleanValue;
        }
        this.isDouble = false;
        this.alreadyProcessed = true;
        this.time = time;
        this.computeBooleanValue();
        return this.booleanValue;
    }

    protected void computeDoubleValue() {
        switch (this.nodeType) {
            case REAL: {
                if (this.isInfinite) {
                    this.doubleValue = this.real > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                    break;
                }
                this.doubleValue = this.interpreter.compile(this.real, this.units);
                break;
            }
            case INTEGER: {
                this.doubleValue = this.interpreter.compile(this.real, this.units);
                break;
            }
            case POWER: {
                this.doubleValue = this.interpreter.pow(this.leftChild, this.rightChild, this.time);
                break;
            }
            case PLUS: {
                this.doubleValue = this.interpreter.plus(this.children, this.numChildren, this.time);
                break;
            }
            case MINUS: {
                if (this.numChildren == 1) {
                    this.doubleValue = this.interpreter.uMinus(this.leftChild, this.time);
                    break;
                }
                this.doubleValue = this.interpreter.minus(this.children, this.numChildren, this.time);
                break;
            }
            case TIMES: {
                this.doubleValue = this.interpreter.times(this.children, this.numChildren, this.time);
                break;
            }
            case DIVIDE: {
                if (this.numChildren != 2) {
                    throw new SBMLException(MessageFormat.format("Fractions must have one numerator and one denominator, here {0,number,integer} elements are given.", this.node.getChildCount()));
                }
                this.doubleValue = this.interpreter.frac(this.leftChild, this.rightChild, this.time);
                break;
            }
            case RATIONAL: {
                this.doubleValue = this.interpreter.frac(this.numerator, this.denominator);
                break;
            }
            case NAME_TIME: {
                this.doubleValue = this.interpreter.symbolTime(this.name);
                break;
            }
            case FUNCTION_DELAY: {
                this.doubleValue = this.interpreter.delay(this.name, this.leftChild, this.rightChild, this.units, this.time);
                break;
            }
            case CONSTANT_PI: {
                this.doubleValue = Math.PI;
                break;
            }
            case CONSTANT_E: {
                this.doubleValue = Math.E;
                break;
            }
            case NAME_AVOGADRO: {
                this.doubleValue = Maths.AVOGADRO_L3V1;
                break;
            }
            case REAL_E: {
                this.doubleValue = this.interpreter.compile(this.mantissa, this.exponent, this.units);
                break;
            }
            case FUNCTION_LOG: {
                if (this.numChildren == 2) {
                    this.doubleValue = this.interpreter.log(this.leftChild, this.rightChild, this.time);
                    break;
                }
                this.doubleValue = this.interpreter.log(this.rightChild, this.time);
                break;
            }
            case FUNCTION_ABS: {
                this.doubleValue = this.interpreter.abs(this.rightChild, this.time);
                break;
            }
            case FUNCTION_ARCCOS: {
                this.doubleValue = this.interpreter.arccos(this.leftChild, this.time);
                break;
            }
            case FUNCTION_ARCCOSH: {
                this.doubleValue = this.interpreter.arccosh(this.leftChild, this.time);
                break;
            }
            case FUNCTION_ARCCOT: {
                this.doubleValue = this.interpreter.arccot(this.leftChild, this.time);
                break;
            }
            case FUNCTION_ARCCOTH: {
                this.doubleValue = this.interpreter.arccoth(this.leftChild, this.time);
                break;
            }
            case FUNCTION_ARCCSC: {
                this.doubleValue = this.interpreter.arccsc(this.leftChild, this.time);
                break;
            }
            case FUNCTION_ARCCSCH: {
                this.doubleValue = this.interpreter.arccsch(this.leftChild, this.time);
                break;
            }
            case FUNCTION_ARCSEC: {
                this.doubleValue = this.interpreter.arcsec(this.leftChild, this.time);
                break;
            }
            case FUNCTION_ARCSECH: {
                this.doubleValue = this.interpreter.arcsech(this.leftChild, this.time);
                break;
            }
            case FUNCTION_ARCSIN: {
                this.doubleValue = this.interpreter.arcsin(this.leftChild, this.time);
                break;
            }
            case FUNCTION_ARCSINH: {
                this.doubleValue = this.interpreter.arcsinh(this.leftChild, this.time);
                break;
            }
            case FUNCTION_ARCTAN: {
                this.doubleValue = this.interpreter.arctan(this.leftChild, this.time);
                break;
            }
            case FUNCTION_ARCTANH: {
                this.doubleValue = this.interpreter.arctanh(this.leftChild, this.time);
                break;
            }
            case FUNCTION_CEILING: {
                this.doubleValue = this.interpreter.ceiling(this.leftChild, this.time);
                break;
            }
            case FUNCTION_COS: {
                this.doubleValue = this.interpreter.cos(this.leftChild, this.time);
                break;
            }
            case FUNCTION_COSH: {
                this.doubleValue = this.interpreter.cosh(this.leftChild, this.time);
                break;
            }
            case FUNCTION_COT: {
                this.doubleValue = this.interpreter.cot(this.leftChild, this.time);
                break;
            }
            case FUNCTION_COTH: {
                this.doubleValue = this.interpreter.coth(this.leftChild, this.time);
                break;
            }
            case FUNCTION_CSC: {
                this.doubleValue = this.interpreter.csc(this.leftChild, this.time);
                break;
            }
            case FUNCTION_CSCH: {
                this.doubleValue = this.interpreter.csch(this.leftChild, this.time);
                break;
            }
            case FUNCTION_EXP: {
                this.doubleValue = this.interpreter.exp(this.leftChild, this.time);
                break;
            }
            case FUNCTION_FACTORIAL: {
                this.doubleValue = this.interpreter.factorial(this.leftChild, this.time);
                break;
            }
            case FUNCTION_FLOOR: {
                this.doubleValue = this.interpreter.floor(this.leftChild, this.time);
                break;
            }
            case FUNCTION_LN: {
                this.doubleValue = this.interpreter.ln(this.leftChild, this.time);
                break;
            }
            case FUNCTION_POWER: {
                this.doubleValue = this.interpreter.pow(this.leftChild, this.rightChild, this.time);
                break;
            }
            case FUNCTION_SEC: {
                this.doubleValue = this.interpreter.sec(this.leftChild, this.time);
                break;
            }
            case FUNCTION_SECH: {
                this.doubleValue = this.interpreter.sech(this.leftChild, this.time);
                break;
            }
            case FUNCTION_SIN: {
                this.doubleValue = this.interpreter.sin(this.leftChild, this.time);
                break;
            }
            case FUNCTION_SINH: {
                this.doubleValue = this.interpreter.sinh(this.leftChild, this.time);
                break;
            }
            case FUNCTION_TAN: {
                this.doubleValue = this.interpreter.tan(this.leftChild, this.time);
                break;
            }
            case FUNCTION_TANH: {
                this.doubleValue = this.interpreter.tanh(this.leftChild, this.time);
                break;
            }
            case FUNCTION_PIECEWISE: {
                this.doubleValue = this.interpreter.piecewise(this.children, this.time);
                break;
            }
            case LAMBDA: {
                this.doubleValue = this.interpreter.lambdaDouble(this.children, this.time);
                break;
            }
            default: {
                this.doubleValue = Double.NaN;
            }
        }
    }

    protected void computeBooleanValue() {
        switch (this.nodeType) {
            case LOGICAL_AND: {
                this.booleanValue = this.interpreter.and(this.children, this.numChildren, this.time);
                break;
            }
            case LOGICAL_XOR: {
                this.booleanValue = this.interpreter.xor(this.children, this.time);
                break;
            }
            case LOGICAL_OR: {
                this.booleanValue = this.interpreter.or(this.children, this.time);
                break;
            }
            case LOGICAL_NOT: {
                this.booleanValue = this.interpreter.not(this.leftChild, this.time);
                break;
            }
            case RELATIONAL_EQ: {
                this.booleanValue = this.interpreter.eq(this.leftChild, this.rightChild, this.time);
                break;
            }
            case RELATIONAL_GEQ: {
                this.booleanValue = this.interpreter.geq(this.leftChild, this.rightChild, this.time);
                break;
            }
            case RELATIONAL_GT: {
                this.booleanValue = this.interpreter.gt(this.leftChild, this.rightChild, this.time);
                break;
            }
            case RELATIONAL_NEQ: {
                this.booleanValue = this.interpreter.neq(this.leftChild, this.rightChild, this.time);
                break;
            }
            case RELATIONAL_LEQ: {
                this.booleanValue = this.interpreter.leq(this.leftChild, this.rightChild, this.time);
                break;
            }
            case RELATIONAL_LT: {
                this.booleanValue = this.interpreter.lt(this.leftChild, this.rightChild, this.time);
                break;
            }
            case CONSTANT_TRUE: {
                this.booleanValue = true;
                break;
            }
            case CONSTANT_FALSE: {
                this.booleanValue = false;
                break;
            }
            case NAME: {
                CallableSBase variable = this.node.getVariable();
                if (variable == null) break;
                this.booleanValue = this.interpreter.compileBoolean(variable, this.time);
                break;
            }
            case LAMBDA: {
                this.booleanValue = this.interpreter.lambdaBoolean(this.children, this.time);
                break;
            }
            default: {
                this.booleanValue = false;
            }
        }
    }

    public boolean isName() {
        if (this.node != null) {
            return this.node.isName();
        }
        return false;
    }

    public String getName() {
        if (this.node != null) {
            return this.node.getName();
        }
        return null;
    }
}

