/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.sbml.astnode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.CallableSBase;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.FunctionDefinition;
import org.sbml.jsbml.LocalParameter;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.util.Maths;
import org.simulator.sbml.SBMLValueHolder;
import org.simulator.sbml.SBMLinterpreter;
import org.simulator.sbml.astnode.ASTNodeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTNodeInterpreter {
    public static final Logger logger = Logger.getLogger(SBMLinterpreter.class.getName());
    private Map<String, Double> funcArgs;
    private SBMLValueHolder valueHolder;

    public ASTNodeInterpreter(SBMLValueHolder valueHolder) {
        this.valueHolder = valueHolder;
        this.funcArgs = new HashMap<String, Double>();
    }

    public final String toString(ASTNode value) {
        return value.toString();
    }

    public double compileDouble(String name, double time) {
        Double funcArg = (double)this.funcArgs.get(name);
        double value = funcArg != null ? funcArg : (!Double.isNaN(this.valueHolder.getCurrentValueOf(name)) ? this.valueHolder.getCurrentValueOf(name) : Double.NaN);
        return value;
    }

    public double compileDouble(CallableSBase nsb, double time) {
        Reaction r;
        if (nsb instanceof Species) {
            Species s = (Species)nsb;
            String id = s.getId();
            double compartmentValue = this.valueHolder.getCurrentCompartmentValueOf(id);
            if (compartmentValue == 0.0) {
                return this.valueHolder.getCurrentSpeciesValue(id);
            }
            if (s.isSetInitialAmount() && !s.getHasOnlySubstanceUnits()) {
                return this.valueHolder.getCurrentSpeciesValue(id) / compartmentValue;
            }
            if (s.isSetInitialConcentration() && s.getHasOnlySubstanceUnits()) {
                return this.valueHolder.getCurrentSpeciesValue(id) * compartmentValue;
            }
            return this.valueHolder.getCurrentSpeciesValue(id);
        }
        if (nsb instanceof Compartment || nsb instanceof Parameter) {
            String id = nsb.getId();
            return this.valueHolder.getCurrentValueOf(id);
        }
        if (nsb instanceof LocalParameter) {
            LocalParameter p = (LocalParameter)nsb;
            return p.getValue();
        }
        if (nsb instanceof Reaction && (r = (Reaction)nsb).isSetKineticLaw()) {
            ((ASTNodeValue)r.getKineticLaw().getMath().getUserObject((Object)"SBML_SIMULATION_TEMP_VALUE")).compileDouble(time);
        }
        return Double.NaN;
    }

    public boolean compileBoolean(CallableSBase nsb, double time) {
        if (nsb instanceof FunctionDefinition) {
            ASTNode math = ((FunctionDefinition)nsb).getMath();
            ASTNodeValue rightChild = (ASTNodeValue)math.getRightChild().getUserObject((Object)"SBML_SIMULATION_TEMP_VALUE");
            ArrayList<String> variables = new ArrayList<String>(math.getChildCount());
            for (ASTNode child : math.getChildren()) {
                variables.add(this.compileString(child));
            }
            return this.functionBoolean(rightChild, variables, new LinkedList<ASTNodeValue>(), new double[math.getChildCount()], time);
        }
        return false;
    }

    public double functionDouble(ASTNodeValue rightChild, List<String> variables, List<ASTNodeValue> arguments, int nArguments, double[] values, double time) {
        int i = 0;
        while (i < nArguments) {
            values[i] = arguments.get(i).compileDouble(time);
            ++i;
        }
        double value = rightChild.compileDouble(time);
        return value;
    }

    public String compileString(ASTNodeValue child) {
        if (child.isName()) {
            return child.getName();
        }
        return child.toString();
    }

    public String compileString(ASTNode child) {
        if (child.isName()) {
            return child.getName();
        }
        return child.toString();
    }

    public double lambdaDouble(List<ASTNodeValue> nodes, double time) {
        double[] d = new double[Math.max(0, nodes.size() - 1)];
        int i = 0;
        while (i < nodes.size() - 1) {
            d[i++] = nodes.get(i).compileDouble(time);
            ++i;
        }
        return nodes.get(nodes.size() - 1).compileDouble(time);
    }

    public boolean lambdaBoolean(List<ASTNodeValue> nodes, double time) {
        double[] d = new double[Math.max(0, nodes.size() - 1)];
        int i = 0;
        while (i < nodes.size() - 1) {
            d[i++] = nodes.get(i).compileDouble(time);
            ++i;
        }
        return nodes.get(nodes.size() - 1).compileBoolean(time);
    }

    public double piecewise(List<ASTNodeValue> nodes, double time) {
        int i = 1;
        while (i < nodes.size() - 1) {
            if (nodes.get(i).compileBoolean(time)) {
                return nodes.get(i - 1).compileDouble(time);
            }
            i += 2;
        }
        return nodes.get(i - 1).compileDouble(time);
    }

    public double log(ASTNodeValue userObject, double time) {
        return Math.log10(userObject.compileDouble(time));
    }

    public double log(ASTNodeValue left, ASTNodeValue right, double time) {
        return Maths.log((double)right.compileDouble(time), (double)left.compileDouble(time));
    }

    public double functionDouble(String functionDefinitionName, List<ASTNodeValue> args, double time) {
        return Double.NaN;
    }

    public double tanh(ASTNodeValue userObject, double time) {
        return Math.tanh(userObject.compileDouble(time));
    }

    public double tan(ASTNodeValue userObject, double time) {
        return Math.tan(userObject.compileDouble(time));
    }

    public double sinh(ASTNodeValue userObject, double time) {
        return Math.sinh(userObject.compileDouble(time));
    }

    public double sin(ASTNodeValue userObject, double time) {
        return Math.sin(userObject.compileDouble(time));
    }

    public double sech(ASTNodeValue userObject, double time) {
        return Maths.sech((double)userObject.compileDouble(time));
    }

    public double sec(ASTNodeValue userObject, double time) {
        double argument = userObject.compileDouble(time);
        return Maths.sec((double)argument);
    }

    public double root(ASTNodeValue rootExponent, ASTNodeValue radiant, double time) {
        return this.root(rootExponent.compileDouble(time), radiant, time);
    }

    public double root(double rootExponent, ASTNodeValue userObject, double time) {
        return Maths.root((double)userObject.compileDouble(time), (double)rootExponent);
    }

    public double ln(ASTNodeValue userObject, double time) {
        return Maths.ln((double)userObject.compileDouble(time));
    }

    public double floor(ASTNodeValue userObject, double time) {
        return Math.floor(userObject.compileDouble(time));
    }

    public double factorial(ASTNodeValue userObject, double time) {
        return Maths.factorial((int)((int)Math.round(userObject.compileDouble(time))));
    }

    public double exp(ASTNodeValue userObject, double time) {
        return Math.exp(userObject.compileDouble(time));
    }

    public double csch(ASTNodeValue userObject, double time) {
        return Maths.csch((double)userObject.compileDouble(time));
    }

    public double csc(ASTNodeValue userObject, double time) {
        return Maths.csc((double)userObject.compileDouble(time));
    }

    public double coth(ASTNodeValue userObject, double time) {
        return Maths.coth((double)userObject.compileDouble(time));
    }

    public double cot(ASTNodeValue userObject, double time) {
        return Maths.cot((double)userObject.compileDouble(time));
    }

    public double cosh(ASTNodeValue userObject, double time) {
        return Math.cosh(userObject.compileDouble(time));
    }

    public double cos(ASTNodeValue userObject, double time) {
        return Math.cos(userObject.compileDouble(time));
    }

    public double ceiling(ASTNodeValue userObject, double time) {
        return Math.ceil(userObject.compileDouble(time));
    }

    public double arctanh(ASTNodeValue userObject, double time) {
        return Maths.arctanh((double)userObject.compileDouble(time));
    }

    public boolean functionBoolean(String name, List<ASTNodeValue> children) {
        return false;
    }

    public boolean functionBoolean(ASTNodeValue rightChild, List<String> variables, List<ASTNodeValue> arguments, double[] values, double time) {
        int i = 0;
        while (i < arguments.size()) {
            values[i] = arguments.get(i).compileDouble(time);
            ++i;
        }
        boolean value = rightChild.compileBoolean(time);
        return value;
    }

    public boolean lt(ASTNodeValue left, ASTNodeValue right, double time) {
        return left.compileDouble(time) < right.compileDouble(time);
    }

    public boolean leq(ASTNodeValue left, ASTNodeValue right, double time) {
        return left.compileDouble(time) <= right.compileDouble(time);
    }

    public boolean neq(ASTNodeValue left, ASTNodeValue right, double time) {
        return left.compileDouble(time) != right.compileDouble(time);
    }

    public boolean gt(ASTNodeValue left, ASTNodeValue right, double time) {
        return left.compileDouble(time) > right.compileDouble(time);
    }

    public boolean geq(ASTNodeValue left, ASTNodeValue right, double time) {
        return left.compileDouble(time) >= right.compileDouble(time);
    }

    public boolean eq(ASTNodeValue left, ASTNodeValue right, double time) {
        return left.compileDouble(time) == right.compileDouble(time);
    }

    public boolean not(ASTNodeValue node, double time) {
        return !node.compileBoolean(time);
    }

    public boolean or(List<ASTNodeValue> nodes, double time) {
        int i = 0;
        while (i < nodes.size()) {
            if (nodes.get(i).compileBoolean(time)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean xor(List<ASTNodeValue> nodes, double time) {
        boolean value = false;
        int size = nodes.size();
        int i = 0;
        while (i < size) {
            if (nodes.get(i).compileBoolean(time)) {
                if (value) {
                    return false;
                }
                value = true;
            }
            ++i;
        }
        return value;
    }

    public boolean and(List<ASTNodeValue> nodes, int size, double time) {
        int i = 0;
        while (i < size) {
            if (!nodes.get(i).compileBoolean(time)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public double arctan(ASTNodeValue userObject, double time) {
        return Math.atan(userObject.compileDouble(time));
    }

    public double arcsinh(ASTNodeValue userObject, double time) {
        return Maths.arcsinh((double)userObject.compileDouble(time));
    }

    public double arcsin(ASTNodeValue userObject, double time) {
        return Math.asin(userObject.compileDouble(time));
    }

    public double arcsech(ASTNodeValue userObject, double time) {
        return Maths.arcsech((double)userObject.compileDouble(time));
    }

    public double arcsec(ASTNodeValue userObject, double time) {
        return Maths.arcsec((double)userObject.compileDouble(time));
    }

    public double arccsch(ASTNodeValue userObject, double time) {
        return Maths.arccsch((double)userObject.compileDouble(time));
    }

    public double arccsc(ASTNodeValue userObject, double time) {
        return Maths.arccsc((double)userObject.compileDouble(time));
    }

    public double arccoth(ASTNodeValue userObject, double time) {
        return Maths.arccoth((double)userObject.compileDouble(time));
    }

    public double arccot(ASTNodeValue userObject, double time) {
        double argument = userObject.compileDouble(time);
        return Maths.arccot((double)argument);
    }

    public double arccosh(ASTNodeValue userObject, double time) {
        return Maths.arccosh((double)userObject.compileDouble(time));
    }

    public double arccos(ASTNodeValue userObject, double time) {
        return Math.acos(userObject.compileDouble(time));
    }

    public double abs(ASTNodeValue userObject, double time) {
        return Math.abs(userObject.compileDouble(time));
    }

    public double compile(double mantissa, int exponent, String units) {
        return mantissa * Math.pow(10.0, exponent);
    }

    public final double delay(String delayName, ASTNodeValue x, ASTNodeValue delay, String timeUnits, double time) {
        double delayTime = delay.compileDouble(time);
        if (delayTime == 0.0) {
            return x.compileDouble(time);
        }
        double valueTime = this.symbolTime(delayName) - delayTime;
        return this.valueHolder.computeDelayedValue(valueTime, this.compileString(x));
    }

    public double symbolTime(String name) {
        return this.valueHolder.getCurrentTime();
    }

    public double frac(int numerator, int denominator) {
        return (double)numerator / (double)denominator;
    }

    public double frac(ASTNodeValue left, ASTNodeValue right, double time) {
        return left.compileDouble(time) / right.compileDouble(time);
    }

    public double times(List<ASTNodeValue> nodes, int size, double time) {
        if (size == 0) {
            return 0.0;
        }
        double value = 1.0;
        int i = 0;
        while (i != size) {
            value *= nodes.get(i).compileDouble(time);
            ++i;
        }
        return value;
    }

    public double minus(List<ASTNodeValue> nodes, int size, double time) {
        double value = 0.0;
        if (size > 0) {
            value = nodes.get(0).compileDouble(time);
        }
        int i = 1;
        while (i < size) {
            value -= nodes.get(i).compileDouble(time);
            ++i;
        }
        return value;
    }

    public double plus(List<ASTNodeValue> nodes, int size, double time) {
        double value = 0.0;
        int i = 0;
        while (i != size) {
            value += nodes.get(i).compileDouble(time);
            ++i;
        }
        return value;
    }

    public double pow(ASTNodeValue left, ASTNodeValue right, double time) {
        double l = left.compileDouble(time);
        double r = right.compileDouble(time);
        double result = Math.pow(Math.abs(l), r);
        if (l < 0.0) {
            double sign = Math.pow(-1.0, r);
            if (Double.isNaN(sign)) {
                sign = -1.0;
                logger.warning("Power with negative base and non-integer exponent encountered.");
            }
            result *= sign;
        }
        return result;
    }

    public double compile(double value, String units) {
        return value;
    }

    public double sqrt(ASTNodeValue userObject, double time) {
        return Math.sqrt(userObject.compileDouble(time));
    }

    public double uMinus(ASTNodeValue userObject, double time) {
        return -userObject.compileDouble(time);
    }
}

