/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.sbml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math.ode.DerivativeException;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.AssignmentRule;
import org.sbml.jsbml.CallableSBase;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.Constraint;
import org.sbml.jsbml.Event;
import org.sbml.jsbml.EventAssignment;
import org.sbml.jsbml.FunctionDefinition;
import org.sbml.jsbml.InitialAssignment;
import org.sbml.jsbml.KineticLaw;
import org.sbml.jsbml.LocalParameter;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.RateRule;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.Rule;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.SpeciesReference;
import org.sbml.jsbml.Symbol;
import org.sbml.jsbml.util.StringTools;
import org.sbml.jsbml.validator.ModelOverdeterminedException;
import org.sbml.jsbml.validator.OverdeterminationValidator;
import org.simulator.math.RNG;
import org.simulator.math.odes.DelayValueHolder;
import org.simulator.math.odes.DelayedDESystem;
import org.simulator.math.odes.EventDESystem;
import org.simulator.math.odes.EventInProgress;
import org.simulator.math.odes.FastProcessDESystem;
import org.simulator.math.odes.RichDESystem;
import org.simulator.sbml.AlgebraicRuleConverter;
import org.simulator.sbml.SBMLEventInProgress;
import org.simulator.sbml.SBMLEventInProgressWithDelay;
import org.simulator.sbml.SBMLValueHolder;
import org.simulator.sbml.astnode.ASTNodeInterpreter;
import org.simulator.sbml.astnode.ASTNodeValue;
import org.simulator.sbml.astnode.AssignmentRuleValue;
import org.simulator.sbml.astnode.CompartmentOrParameterValue;
import org.simulator.sbml.astnode.FunctionValue;
import org.simulator.sbml.astnode.LocalParameterValue;
import org.simulator.sbml.astnode.NamedValue;
import org.simulator.sbml.astnode.RateRuleValue;
import org.simulator.sbml.astnode.ReactionValue;
import org.simulator.sbml.astnode.RootFunctionValue;
import org.simulator.sbml.astnode.SpeciesReferenceValue;
import org.simulator.sbml.astnode.SpeciesValue;
import org.simulator.sbml.astnode.StoichiometryValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBMLinterpreter
implements DelayedDESystem,
EventDESystem,
FastProcessDESystem,
RichDESystem,
SBMLValueHolder {
    private static final transient Logger logger = Logger.getLogger(SBMLinterpreter.class.getName());
    public static final String TEMP_VALUE = "SBML_SIMULATION_TEMP_VALUE";
    private static final long serialVersionUID = 3453063382705340995L;
    private List<AssignmentRule> algebraicRules;
    private Map<String, Integer> compartmentHash;
    protected Reaction currentReaction;
    private double currentTime;
    private SBMLEventInProgress[] events;
    private HashSet<Double> priorities;
    protected double[] initialValues;
    protected List<Double>[] listOfContraintsViolations;
    protected Model model;
    private Map<String, Integer> symbolHash;
    private String[] symbolIdentifiers;
    protected double[] v;
    protected Map<String, Double> stoichiometricCoefHash;
    protected double[] Y;
    private boolean isProcessingFastReactions = false;
    private boolean hasFastReactions = false;
    private List<Integer> runningEvents;
    private List<Integer> delayedEvents;
    private Map<String, Species> speciesMap;
    private Set<String> inConcentration;
    private List<ASTNodeValue> kineticLawRoots;
    private List<ASTNodeValue> constraintRoots;
    private List<ASTNode> nodes;
    private ASTNodeInterpreter nodeInterpreter;
    private List<StoichiometryValue> stoichiometries;
    private int stoichiometriesSize;
    private boolean[] reactionFast;
    private boolean[] reactionReversible;
    private List<AssignmentRuleValue> assignmentRulesRoots;
    private List<RateRuleValue> rateRulesRoots;
    private double astNodeTime;
    private DelayValueHolder delayValueHolder;
    private List<Integer> highOrderEvents;
    private double[] conversionFactors;
    private boolean modelHasEvents;
    private int nRateRules;
    private int nAssignmentRules;
    private int nConstraints;
    private List<AssignmentRuleValue> initialAssignmentRoots;
    private boolean noDerivatives;

    public SBMLinterpreter(Model model) throws ModelOverdeterminedException, SBMLException {
        this.model = model;
        this.v = new double[this.model.getListOfReactions().size()];
        this.nConstraints = this.model.getConstraintCount();
        this.symbolHash = new HashMap<String, Integer>();
        this.compartmentHash = new HashMap<String, Integer>();
        this.stoichiometricCoefHash = new HashMap<String, Double>();
        this.nodeInterpreter = new ASTNodeInterpreter(this);
        this.astNodeTime = 0.0;
        this.priorities = new HashSet();
        this.highOrderEvents = new LinkedList<Integer>();
        HashMap<String, Integer> speciesReferenceToRateRule = new HashMap<String, Integer>();
        int speciesReferencesInRateRules = 0;
        int k = 0;
        while (k < model.getRuleCount()) {
            RateRule rr;
            SpeciesReference sr;
            Rule rule = model.getRule(k);
            if (rule.isRate() && (sr = model.findSpeciesReference((rr = (RateRule)rule).getVariable())) != null && !sr.isConstant()) {
                ++speciesReferencesInRateRules;
                speciesReferenceToRateRule.put(sr.getId(), k);
            }
            ++k;
        }
        this.Y = new double[model.getCompartmentCount() + model.getSpeciesCount() + model.getParameterCount() + speciesReferencesInRateRules];
        this.conversionFactors = new double[this.Y.length];
        Arrays.fill(this.conversionFactors, 1.0);
        this.symbolIdentifiers = new String[this.Y.length];
        this.speciesMap = new HashMap<String, Species>();
        this.inConcentration = new HashSet<String>();
        this.reactionFast = new boolean[model.getReactionCount()];
        this.reactionReversible = new boolean[model.getReactionCount()];
        this.initialValues = new double[this.Y.length];
        this.nodes = new LinkedList<ASTNode>();
        this.kineticLawRoots = new ArrayList<ASTNodeValue>();
        this.stoichiometries = new ArrayList<StoichiometryValue>();
        this.init();
    }

    @Override
    public boolean containsFastProcesses() {
        return this.hasFastReactions;
    }

    private Species determineMajorSpeciesAttributes() {
        Species majority = new Species(2, 4);
        int concentration = 0;
        int amount = 0;
        int substanceUnits = 0;
        for (Species species : this.model.getListOfSpecies()) {
            if (species.isSetInitialAmount()) {
                ++amount;
            } else if (species.isSetInitialConcentration()) {
                ++concentration;
            }
            if (!species.hasOnlySubstanceUnits()) continue;
            ++substanceUnits;
        }
        if (amount >= concentration) {
            majority.setInitialAmount(0.0);
        } else {
            majority.setInitialConcentration(0.0);
        }
        if (substanceUnits > this.model.getSpeciesCount() - substanceUnits) {
            majority.setHasOnlySubstanceUnits(true);
        } else {
            majority.setHasOnlySubstanceUnits(false);
        }
        return majority;
    }

    private void evaluateAlgebraicRules() throws ModelOverdeterminedException {
        OverdeterminationValidator odv = new OverdeterminationValidator(this.model);
        if (odv.isOverdetermined()) {
            throw new ModelOverdeterminedException();
        }
        AlgebraicRuleConverter arc = new AlgebraicRuleConverter(odv.getMatching(), this.model);
        this.algebraicRules = arc.getAssignmentRules();
    }

    @Override
    public String[] getAdditionalValueIds() {
        String[] ids = new String[this.v.length];
        int i = 0;
        for (Reaction r : this.model.getListOfReactions()) {
            ids[i++] = r.getId();
        }
        return ids;
    }

    @Override
    public double[] getAdditionalValues(double t, double[] Y) throws DerivativeException {
        if (t - this.currentTime > 1.0E-15 || Y != this.Y && !Arrays.equals(Y, this.Y)) {
            this.computeDerivatives(t, Y);
        }
        return this.v;
    }

    @Override
    public double getCurrentCompartmentValueOf(String speciesId) {
        double value;
        Integer compartmentIndex = this.compartmentHash.get(speciesId);
        if (compartmentIndex != null && (value = this.Y[compartmentIndex]) != 0.0) {
            return value;
        }
        return 1.0;
    }

    @Override
    public double getCurrentCompartmentSize(String id) {
        return this.Y[this.symbolHash.get(id)];
    }

    @Override
    public double getCurrentParameterValue(String id) {
        return this.Y[this.symbolHash.get(id)];
    }

    @Override
    public double getCurrentSpeciesValue(String id) {
        return this.Y[this.symbolHash.get(id)];
    }

    @Override
    public double getCurrentStoichiometry(String id) {
        Integer pos = this.symbolHash.get(id);
        if (pos != null) {
            return this.Y[pos];
        }
        Double value = this.stoichiometricCoefHash.get(id);
        if (value != null) {
            return value;
        }
        SpeciesReference sr = this.model.findSpeciesReference(id);
        if (sr != null && sr.isSetStoichiometryMath()) {
            try {
                return ((ASTNodeValue)sr.getStoichiometryMath().getMath().getUserObject((Object)TEMP_VALUE)).compileDouble(this.astNodeTime);
            }
            catch (SBMLException exc) {
                logger.log(Level.WARNING, String.format("Could not compile stoichiometry math of species reference %s.", id), exc);
            }
        } else if (sr != null) {
            return sr.getStoichiometry();
        }
        return 1.0;
    }

    public int getDimension() {
        return this.initialValues.length;
    }

    @Override
    public EventInProgress getNextEventAssignments(double t, double previousTime, double[] Y) throws DerivativeException {
        if (!this.modelHasEvents) {
            return null;
        }
        System.arraycopy(Y, 0, this.Y, 0, Y.length);
        this.currentTime = t;
        Double execTime = 0.0;
        this.astNodeTime += 0.01;
        int i = 0;
        boolean hasNewDelayedEvents = false;
        try {
            Double priority;
            Boolean persistent;
            int index;
            this.priorities.clear();
            while (i < this.runningEvents.size()) {
                ASTNodeValue priorityObject;
                index = this.runningEvents.get(i);
                if (!this.events[index].hasMoreAssignments(this.currentTime)) {
                    this.runningEvents.remove(i);
                    continue;
                }
                persistent = this.events[index].getPersistent();
                if (!persistent.booleanValue()) {
                    if (!this.events[index].getTriggerObject().compileBoolean(this.astNodeTime)) {
                        this.runningEvents.remove(i);
                        this.events[index].aborted(this.currentTime);
                        --i;
                    } else {
                        priorityObject = this.events[index].getPriorityObject();
                        if (priorityObject != null) {
                            this.events[index].changePriority(priorityObject.compileDouble(this.astNodeTime));
                            this.priorities.add(this.events[index].getPriority());
                        }
                    }
                } else {
                    priorityObject = this.events[index].getPriorityObject();
                    if (priorityObject != null) {
                        this.events[index].changePriority(priorityObject.compileDouble(this.astNodeTime));
                        this.priorities.add(this.events[index].getPriority());
                    }
                }
                ++i;
            }
            i = 0;
            while (i < this.delayedEvents.size()) {
                index = this.delayedEvents.get(i);
                Event ev = this.model.getEvent(index);
                Boolean aborted = false;
                if (this.events[index].getLastTimeFired() > this.currentTime) {
                    this.delayedEvents.remove(i);
                    this.events[index].refresh(this.currentTime);
                    --i;
                    aborted = true;
                } else if (this.events[index].getLastTimeFired() <= this.currentTime && this.events[index].getLastTimeExecuted() > previousTime && this.events[index].getLastTimeExecuted() != this.currentTime) {
                    this.events[index].refresh(previousTime);
                }
                persistent = ev.getTrigger().getPersistent();
                if (!(persistent.booleanValue() || aborted.booleanValue() || this.events[index].getTriggerObject().compileBoolean(this.astNodeTime))) {
                    this.events[index].aborted(this.currentTime);
                    aborted = true;
                }
                if (this.events[index].hasExecutionTime() && this.events[index].getTime() <= this.currentTime && !aborted.booleanValue()) {
                    if (ev.getPriority() != null) {
                        priority = this.events[index].getPriorityObject().compileDouble(this.astNodeTime);
                        if (!this.priorities.contains(priority)) {
                            this.priorities.add(priority);
                        }
                        this.events[index].changePriority(priority);
                    }
                    this.runningEvents.add(index);
                }
                ++i;
            }
            i = 0;
            while (i < this.events.length) {
                if (this.events[i].getTriggerObject().compileBoolean(this.astNodeTime)) {
                    if (!this.events[i].getFireStatus(this.currentTime)) {
                        execTime = this.currentTime;
                        ASTNodeValue delayObject = this.events[i].getDelayObject();
                        if (delayObject != null) {
                            execTime = execTime + delayObject.compileDouble(this.astNodeTime);
                            if (!this.delayedEvents.contains(i)) {
                                this.delayedEvents.add(i);
                            }
                            hasNewDelayedEvents = true;
                        } else {
                            ASTNodeValue priorityObject = this.events[i].getPriorityObject();
                            if (priorityObject != null) {
                                priority = this.events[i].getPriorityObject().compileDouble(this.astNodeTime);
                                this.priorities.add(priority);
                                this.events[i].changePriority(priority);
                            }
                            this.runningEvents.add(i);
                        }
                        Double[] triggerTimeValues = null;
                        if (this.events[i].getUseValuesFromTriggerTime()) {
                            List<AssignmentRuleValue> ruleObjects = this.events[i].getRuleObjects();
                            triggerTimeValues = new Double[ruleObjects.size()];
                            if (ruleObjects != null) {
                                int j = 0;
                                for (AssignmentRuleValue obj : ruleObjects) {
                                    obj.processRule(Y, this.astNodeTime, false);
                                    triggerTimeValues[j] = obj.getValue();
                                    ++j;
                                }
                            }
                        }
                        this.events[i].addValues(triggerTimeValues, execTime);
                        this.events[i].fired(this.currentTime);
                    }
                } else if (this.events[i].getFireStatus(this.currentTime)) {
                    this.events[i].recovered(this.currentTime);
                }
                ++i;
            }
            if (this.runningEvents.size() > 0) {
                return this.processNextEvent(this.priorities, this.Y);
            }
            if (hasNewDelayedEvents) {
                this.events[0].clearAssignments();
                return this.events[0];
            }
            return null;
        }
        catch (SBMLException exc) {
            throw new DerivativeException((Throwable)exc);
        }
    }

    @Override
    public String[] getIdentifiers() {
        return this.symbolIdentifiers;
    }

    public double[] getInitialValues() {
        return this.initialValues;
    }

    public Model getModel() {
        return this.model;
    }

    @Override
    public int getNumAdditionalValues() {
        return this.v.length;
    }

    @Override
    public int getEventCount() {
        return this.model.getEventCount();
    }

    public int getParameterCount() {
        int p = this.model.getParameterCount();
        int i = 0;
        while (i < this.model.getReactionCount()) {
            KineticLaw k = this.model.getReaction(i).getKineticLaw();
            if (k != null) {
                p += k.getLocalParameterCount();
            }
            ++i;
        }
        return p;
    }

    @Override
    public int getRuleCount() {
        return this.model.getRuleCount();
    }

    public int getPositionOfParameters() {
        return this.Y.length - this.model.getParameterCount();
    }

    @Override
    public double getCurrentTime() {
        return this.currentTime;
    }

    private double[] computeDerivatives(double time, double[] Y) throws DerivativeException {
        double[] changeRate = new double[Y.length];
        this.computeDerivatives(time, Y, changeRate);
        return changeRate;
    }

    public void computeDerivatives(double time, double[] Y, double[] changeRate) throws DerivativeException {
        this.currentTime = time;
        if (Double.isNaN(time)) {
            throw new DerivativeException("Time should not be NaN!", new Object[0]);
        }
        Arrays.fill(changeRate, 0.0);
        if (this.noDerivatives) {
            return;
        }
        System.arraycopy(Y, 0, this.Y, 0, Y.length);
        if (this.modelHasEvents) {
            this.runningEvents.clear();
        }
        try {
            this.astNodeTime += 0.01;
            this.processRules(this.astNodeTime, changeRate, this.Y, false);
            this.processVelocities(changeRate, this.astNodeTime);
            int i = 0;
            while (i < this.nConstraints) {
                if (this.constraintRoots.get(i).compileBoolean(time)) {
                    this.listOfContraintsViolations[i].add(time);
                }
                ++i;
            }
        }
        catch (SBMLException exc) {
            throw new DerivativeException((Throwable)exc);
        }
    }

    @Override
    public double getCurrentValueOf(String id) {
        Integer symbolIndex = this.symbolHash.get(id);
        if (symbolIndex != null) {
            return this.Y[symbolIndex];
        }
        return Double.NaN;
    }

    public void init() throws ModelOverdeterminedException, SBMLException {
        this.init(true, 0.0, 1.0, 1.0);
    }

    public void init(boolean refreshTree) throws ModelOverdeterminedException, SBMLException {
        this.init(refreshTree, 0.0, 1.0, 1.0);
    }

    public void init(boolean renewTree, double defaultSpeciesValue, double defaultParameterValue, double defaultCompartmentValue) throws ModelOverdeterminedException, SBMLException {
        this.symbolHash.clear();
        this.compartmentHash.clear();
        Integer yIndex = 0;
        this.currentTime = 0.0;
        this.astNodeTime = 0.0;
        this.noDerivatives = false;
        if (this.model.getReactionCount() == 0 && this.model.getConstraintCount() == 0) {
            this.noDerivatives = true;
            int k = 0;
            while (k < this.model.getRuleCount()) {
                Rule rule = this.model.getRule(k);
                if (rule.isRate()) {
                    this.noDerivatives = false;
                }
                ++k;
            }
        }
        HashMap<String, Integer> speciesReferenceToRateRule = new HashMap<String, Integer>();
        int speciesReferencesInRateRules = 0;
        int k = 0;
        while (k < this.model.getRuleCount()) {
            RateRule rr;
            SpeciesReference sr;
            Rule rule = this.model.getRule(k);
            if (rule.isRate() && (sr = this.model.findSpeciesReference((rr = (RateRule)rule).getVariable())) != null && sr.isConstant()) {
                ++speciesReferencesInRateRules;
                speciesReferenceToRateRule.put(sr.getId(), k);
            }
            ++k;
        }
        int sizeY = this.model.getCompartmentCount() + this.model.getSpeciesCount() + this.model.getParameterCount() + speciesReferencesInRateRules;
        if (sizeY != this.Y.length) {
            this.Y = new double[sizeY];
            this.symbolIdentifiers = new String[this.Y.length];
            this.conversionFactors = new double[this.Y.length];
            Arrays.fill(this.conversionFactors, 1.0);
        }
        int i = 0;
        while (i < this.model.getCompartmentCount()) {
            Compartment c = this.model.getCompartment(i);
            this.Y[yIndex.intValue()] = !c.isSetValue() ? defaultCompartmentValue : c.getSize();
            this.symbolHash.put(c.getId(), yIndex);
            this.symbolIdentifiers[yIndex.intValue()] = c.getId();
            yIndex = yIndex + 1;
            ++i;
        }
        Species majority = this.determineMajorSpeciesAttributes();
        this.speciesMap.clear();
        i = 0;
        while (i < this.model.getSpeciesCount()) {
            Species s = this.model.getSpecies(i);
            if (!s.getBoundaryCondition() && !s.isConstant()) {
                this.speciesMap.put(s.getId(), s);
                Parameter convParameter = s.getConversionFactorInstance();
                if (convParameter == null) {
                    convParameter = this.model.getConversionFactorInstance();
                }
                if (convParameter != null) {
                    this.conversionFactors[yIndex.intValue()] = convParameter.getValue();
                }
            }
            Integer compartmentIndex = this.symbolHash.get(s.getCompartment());
            if (!s.isSetInitialAmount() && !s.isSetInitialConcentration()) {
                if (majority.isSetInitialAmount()) {
                    s.setInitialAmount(0.0);
                } else {
                    s.setInitialConcentration(0.0);
                }
                s.setHasOnlySubstanceUnits(majority.getHasOnlySubstanceUnits());
            }
            this.Y[yIndex.intValue()] = !s.isSetValue() ? defaultSpeciesValue : (s.isSetInitialAmount() ? s.getInitialAmount() : s.getInitialConcentration());
            this.symbolHash.put(s.getId(), yIndex);
            this.compartmentHash.put(s.getId(), compartmentIndex);
            this.symbolIdentifiers[yIndex.intValue()] = s.getId();
            yIndex = yIndex + 1;
            ++i;
        }
        for (String id : speciesReferenceToRateRule.keySet()) {
            SpeciesReference sr = this.model.findSpeciesReference(id);
            this.Y[yIndex.intValue()] = sr.getStoichiometry();
            this.symbolHash.put(id, yIndex);
            this.symbolIdentifiers[yIndex.intValue()] = id;
            yIndex = yIndex + 1;
        }
        i = 0;
        while (i < this.model.getParameterCount()) {
            Parameter p = this.model.getParameter(i);
            this.Y[yIndex.intValue()] = !p.isSetValue() ? defaultParameterValue : p.getValue();
            this.symbolHash.put(p.getId(), yIndex);
            this.symbolIdentifiers[yIndex.intValue()] = p.getId();
            yIndex = yIndex + 1;
            ++i;
        }
        this.inConcentration.clear();
        if (this.reactionFast.length != this.model.getReactionCount()) {
            this.reactionFast = new boolean[this.model.getReactionCount()];
        }
        int reactionIndex = 0;
        for (Reaction r : this.model.getListOfReactions()) {
            Species species;
            String speciesID;
            this.reactionFast[reactionIndex] = r.isFast();
            this.reactionReversible[reactionIndex] = r.isReversible();
            if (r.isFast() && !this.hasFastReactions) {
                this.hasFastReactions = true;
            }
            if (r.getKineticLaw() != null && r.getKineticLaw().getListOfLocalParameters().size() > 0) {
                r.getKineticLaw().getMath().updateVariables();
            }
            for (SpeciesReference speciesRef : r.getListOfReactants()) {
                speciesID = speciesRef.getSpecies();
                species = this.speciesMap.get(speciesID);
                if (species == null || !species.isSetInitialConcentration() || species.hasOnlySubstanceUnits()) continue;
                this.inConcentration.add(speciesID);
            }
            for (SpeciesReference speciesRef : r.getListOfProducts()) {
                speciesID = speciesRef.getSpecies();
                species = this.speciesMap.get(speciesID);
                if (species == null || !species.isSetInitialConcentration() || species.hasOnlySubstanceUnits()) continue;
                this.inConcentration.add(speciesID);
            }
            ++reactionIndex;
        }
        boolean containsAlgebraicRules = false;
        i = 0;
        while (i < this.model.getRuleCount()) {
            if (this.model.getRule(i).isAlgebraic()) {
                containsAlgebraicRules = true;
                break;
            }
            ++i;
        }
        if (containsAlgebraicRules) {
            this.evaluateAlgebraicRules();
        }
        if (this.model.getEventCount() > 0) {
            if (this.events == null) {
                this.events = new SBMLEventInProgress[this.model.getEventCount()];
            }
            this.runningEvents = new LinkedList<Integer>();
            this.delayedEvents = new LinkedList<Integer>();
            this.initEvents();
            this.modelHasEvents = true;
        } else {
            this.modelHasEvents = false;
        }
        if (renewTree) {
            this.createSimplifiedSyntaxTree();
        } else {
            this.refreshSyntaxTree();
        }
        if (this.initialValues.length != this.Y.length) {
            this.initialValues = new double[this.Y.length];
        }
        System.arraycopy(this.Y, 0, this.initialValues, 0, this.initialValues.length);
        this.astNodeTime += 0.01;
        this.processInitialAssignments(this.astNodeTime, this.Y);
        if (this.model.getConstraintCount() > 0) {
            this.listOfContraintsViolations = new LinkedList[this.model.getConstraintCount()];
            i = 0;
            while (i < this.model.getConstraintCount()) {
                if (this.listOfContraintsViolations[i] == null) {
                    this.listOfContraintsViolations[i] = new LinkedList<Double>();
                }
                if (this.constraintRoots.get(i).compileBoolean(this.astNodeTime)) {
                    this.listOfContraintsViolations[i].add(0.0);
                }
                ++i;
            }
        }
        this.astNodeTime += 0.01;
        this.processRules(this.astNodeTime, null, this.Y, true);
        this.astNodeTime += 0.01;
        this.processInitialAssignments(this.astNodeTime, this.Y);
        this.astNodeTime += 0.01;
        this.processRules(this.astNodeTime, null, this.Y, true);
        System.arraycopy(this.Y, 0, this.initialValues, 0, this.initialValues.length);
    }

    private void refreshSyntaxTree() {
        for (ASTNode node : this.nodes) {
            ((ASTNodeValue)node.getUserObject((Object)TEMP_VALUE)).reset();
        }
        for (StoichiometryValue s : this.stoichiometries) {
            s.refresh();
        }
    }

    private void createSimplifiedSyntaxTree() {
        this.nodes.clear();
        this.kineticLawRoots.clear();
        this.stoichiometries.clear();
        this.initializeKineticLaws();
        this.initializeConstraints();
        this.initializeRules();
        this.initializeEvents();
    }

    private void initializeConstraints() {
        this.constraintRoots = new ArrayList<ASTNodeValue>();
        for (Constraint c : this.model.getListOfConstraints()) {
            ASTNodeValue currentConstraint = (ASTNodeValue)this.copyAST(c.getMath(), true, null, null).getUserObject((Object)TEMP_VALUE);
            this.constraintRoots.add(currentConstraint);
            c.getMath().putUserObject((Object)TEMP_VALUE, (Object)currentConstraint);
        }
    }

    private void initializeEvents() {
        if (this.events != null) {
            int i = 0;
            while (i != this.events.length) {
                Event e = this.model.getEvent(i);
                this.events[i].setUseValuesFromTriggerTime(e.getUseValuesFromTriggerTime());
                this.events[i].setPersistent(e.getTrigger().getPersistent());
                this.events[i].setTriggerObject((ASTNodeValue)this.copyAST(e.getTrigger().getMath(), true, null, null).getUserObject((Object)TEMP_VALUE));
                if (e.getPriority() != null) {
                    this.events[i].setPriorityObject((ASTNodeValue)this.copyAST(e.getPriority().getMath(), true, null, null).getUserObject((Object)TEMP_VALUE));
                }
                if (e.getDelay() != null) {
                    this.events[i].setDelayObject((ASTNodeValue)this.copyAST(e.getDelay().getMath(), true, null, null).getUserObject((Object)TEMP_VALUE));
                }
                this.events[i].clearRuleObjects();
                for (EventAssignment as : e.getListOfEventAssignments()) {
                    SpeciesReference sr;
                    Integer symbolIndex = this.symbolHash.get(as.getVariable());
                    if (symbolIndex != null) {
                        Species sp = this.model.getSpecies(as.getVariable());
                        if (sp != null) {
                            Compartment c = sp.getCompartmentInstance();
                            boolean hasZeroSpatialDimensions = true;
                            if (c != null && c.getSpatialDimensions() > 0.0) {
                                hasZeroSpatialDimensions = false;
                            }
                            this.events[i].addRuleObject(new AssignmentRuleValue((ASTNodeValue)this.copyAST(as.getMath(), true, null, null).getUserObject((Object)TEMP_VALUE), symbolIndex, sp, this.compartmentHash.get(sp.getId()), hasZeroSpatialDimensions, this));
                            continue;
                        }
                        this.events[i].addRuleObject(new AssignmentRuleValue((ASTNodeValue)this.copyAST(as.getMath(), true, null, null).getUserObject((Object)TEMP_VALUE), symbolIndex));
                        continue;
                    }
                    if (this.model.findSpeciesReference(as.getVariable()) == null || (sr = this.model.findSpeciesReference(as.getVariable())).isConstant()) continue;
                    this.events[i].addRuleObject(new AssignmentRuleValue((ASTNodeValue)this.copyAST(as.getMath(), true, null, null).getUserObject((Object)TEMP_VALUE), sr.getId(), this.stoichiometricCoefHash));
                }
                this.events[i].setUseValuesFromTriggerTime(e.getUseValuesFromTriggerTime());
                ++i;
            }
        }
    }

    private void initializeKineticLaws() {
        int reactionIndex = 0;
        for (Reaction r : this.model.getListOfReactions()) {
            KineticLaw kl = r.getKineticLaw();
            if (kl != null) {
                ASTNode currentMath;
                ASTNodeValue currentMathValue;
                String id;
                int srIndex;
                Species sp;
                int compartmentIndex;
                int speciesIndex;
                String speciesID;
                ASTNodeValue currentLaw = (ASTNodeValue)this.copyAST(kl.getMath(), true, null, null).getUserObject((Object)TEMP_VALUE);
                this.kineticLawRoots.add(currentLaw);
                kl.getMath().putUserObject((Object)TEMP_VALUE, (Object)currentLaw);
                for (SpeciesReference speciesRef : r.getListOfReactants()) {
                    String compartmentID;
                    speciesID = speciesRef.getSpecies();
                    speciesIndex = this.symbolHash.get(speciesID);
                    compartmentIndex = -1;
                    sp = speciesRef.getSpeciesInstance();
                    if (sp != null && this.symbolHash.containsKey(compartmentID = sp.getCompartment())) {
                        compartmentIndex = this.symbolHash.get(compartmentID);
                    }
                    srIndex = -1;
                    if (this.model.getLevel() >= 3 && (id = speciesRef.getId()) != null && this.symbolHash.containsKey(id)) {
                        srIndex = this.symbolHash.get(id);
                    }
                    currentMathValue = null;
                    if (speciesRef.isSetStoichiometryMath()) {
                        currentMath = speciesRef.getStoichiometryMath().getMath();
                        currentMathValue = (ASTNodeValue)this.copyAST(currentMath, true, null, null).getUserObject((Object)TEMP_VALUE);
                        currentMath.putUserObject((Object)TEMP_VALUE, (Object)currentMathValue);
                    }
                    this.stoichiometries.add(new StoichiometryValue(speciesRef, speciesIndex, srIndex, compartmentIndex, this.stoichiometricCoefHash, this, this.Y, currentMathValue, reactionIndex, this.inConcentration, true));
                }
                for (SpeciesReference speciesRef : r.getListOfProducts()) {
                    String compartmentID;
                    speciesID = speciesRef.getSpecies();
                    speciesIndex = this.symbolHash.get(speciesID);
                    compartmentIndex = -1;
                    sp = speciesRef.getSpeciesInstance();
                    if (sp != null && this.symbolHash.containsKey(compartmentID = sp.getCompartment())) {
                        compartmentIndex = this.symbolHash.get(compartmentID);
                    }
                    srIndex = -1;
                    if (this.model.getLevel() >= 3 && (id = speciesRef.getId()) != null && this.symbolHash.containsKey(id)) {
                        srIndex = this.symbolHash.get(id);
                    }
                    currentMathValue = null;
                    if (speciesRef.isSetStoichiometryMath()) {
                        currentMath = speciesRef.getStoichiometryMath().getMath();
                        currentMathValue = (ASTNodeValue)this.copyAST(currentMath, true, null, null).getUserObject((Object)TEMP_VALUE);
                        currentMath.putUserObject((Object)TEMP_VALUE, (Object)currentMathValue);
                    }
                    this.stoichiometries.add(new StoichiometryValue(speciesRef, speciesIndex, srIndex, compartmentIndex, this.stoichiometricCoefHash, this, this.Y, currentMathValue, reactionIndex, this.inConcentration, false));
                }
            } else {
                this.kineticLawRoots.add(new ASTNodeValue(this.nodeInterpreter, new ASTNode(0.0)));
            }
            ++reactionIndex;
        }
        this.stoichiometriesSize = this.stoichiometries.size();
    }

    private void initializeRules() {
        SpeciesReference sr;
        Compartment c;
        Species sp;
        Integer symbolIndex;
        this.assignmentRulesRoots = new ArrayList<AssignmentRuleValue>();
        this.initialAssignmentRoots = new ArrayList<AssignmentRuleValue>();
        this.rateRulesRoots = new ArrayList<RateRuleValue>();
        int i = 0;
        while (i < this.model.getRuleCount()) {
            RateRule rr;
            Compartment c2;
            Species sp2;
            Rule rule = this.model.getRule(i);
            if (rule.isAssignment()) {
                SpeciesReference sr2;
                AssignmentRule as = (AssignmentRule)rule;
                symbolIndex = this.symbolHash.get(as.getVariable());
                if (symbolIndex != null) {
                    sp2 = this.model.getSpecies(as.getVariable());
                    if (sp2 != null) {
                        c2 = sp2.getCompartmentInstance();
                        boolean hasZeroSpatialDimensions = true;
                        if (c2 != null && c2.getSpatialDimensions() > 0.0) {
                            hasZeroSpatialDimensions = false;
                        }
                        this.assignmentRulesRoots.add(new AssignmentRuleValue((ASTNodeValue)this.copyAST(as.getMath(), true, null, null).getUserObject((Object)TEMP_VALUE), symbolIndex, sp2, this.compartmentHash.get(sp2.getId()), hasZeroSpatialDimensions, this));
                    } else {
                        this.assignmentRulesRoots.add(new AssignmentRuleValue((ASTNodeValue)this.copyAST(as.getMath(), true, null, null).getUserObject((Object)TEMP_VALUE), symbolIndex));
                    }
                } else if (this.model.findSpeciesReference(as.getVariable()) != null && !(sr2 = this.model.findSpeciesReference(as.getVariable())).isConstant()) {
                    this.assignmentRulesRoots.add(new AssignmentRuleValue((ASTNodeValue)this.copyAST(as.getMath(), true, null, null).getUserObject((Object)TEMP_VALUE), sr2.getId(), this.stoichiometricCoefHash));
                }
            } else if (rule.isRate() && (symbolIndex = this.symbolHash.get((rr = (RateRule)rule).getVariable())) != null) {
                sp2 = this.model.getSpecies(rr.getVariable());
                if (sp2 != null) {
                    c2 = sp2.getCompartmentInstance();
                    boolean hasZeroSpatialDimensions = true;
                    if (c2 != null && c2.getSpatialDimensions() > 0.0) {
                        hasZeroSpatialDimensions = false;
                    }
                    this.rateRulesRoots.add(new RateRuleValue((ASTNodeValue)this.copyAST(rr.getMath(), true, null, null).getUserObject((Object)TEMP_VALUE), symbolIndex, sp2, this.compartmentHash.get(sp2.getId()), hasZeroSpatialDimensions, this));
                } else if (this.compartmentHash.containsValue(symbolIndex)) {
                    LinkedList<Integer> speciesIndices = new LinkedList<Integer>();
                    for (Map.Entry<String, Integer> entry : this.compartmentHash.entrySet()) {
                        Species s;
                        if (entry.getValue() != symbolIndex || !(s = this.model.getSpecies(entry.getKey())).isSetInitialConcentration()) continue;
                        int speciesIndex = this.symbolHash.get(entry.getKey());
                        speciesIndices.add(speciesIndex);
                    }
                    this.rateRulesRoots.add(new RateRuleValue((ASTNodeValue)this.copyAST(rr.getMath(), true, null, null).getUserObject((Object)TEMP_VALUE), symbolIndex, speciesIndices, this));
                } else {
                    this.rateRulesRoots.add(new RateRuleValue((ASTNodeValue)this.copyAST(rr.getMath(), true, null, null).getUserObject((Object)TEMP_VALUE), symbolIndex));
                }
            }
            ++i;
        }
        if (this.algebraicRules != null) {
            for (AssignmentRule as : this.algebraicRules) {
                symbolIndex = this.symbolHash.get(as.getVariable());
                if (symbolIndex != null) {
                    sp = this.model.getSpecies(as.getVariable());
                    if (sp != null) {
                        c = sp.getCompartmentInstance();
                        boolean hasZeroSpatialDimensions = true;
                        if (c != null && c.getSpatialDimensions() > 0.0) {
                            hasZeroSpatialDimensions = false;
                        }
                        this.assignmentRulesRoots.add(new AssignmentRuleValue((ASTNodeValue)this.copyAST(as.getMath(), true, null, null).getUserObject((Object)TEMP_VALUE), symbolIndex, sp, this.compartmentHash.get(sp.getId()), hasZeroSpatialDimensions, this));
                        continue;
                    }
                    this.assignmentRulesRoots.add(new AssignmentRuleValue((ASTNodeValue)this.copyAST(as.getMath(), true, null, null).getUserObject((Object)TEMP_VALUE), symbolIndex));
                    continue;
                }
                if (this.model.findSpeciesReference(as.getVariable()) == null || (sr = this.model.findSpeciesReference(as.getVariable())).isConstant()) continue;
                this.assignmentRulesRoots.add(new AssignmentRuleValue((ASTNodeValue)this.copyAST(as.getMath(), true, null, null).getUserObject((Object)TEMP_VALUE), sr.getId(), this.stoichiometricCoefHash));
            }
        }
        i = 0;
        while (i < this.model.getInitialAssignmentCount()) {
            InitialAssignment iA = this.model.getInitialAssignment(i);
            symbolIndex = this.symbolHash.get(iA.getVariable());
            if (symbolIndex != null) {
                sp = this.model.getSpecies(iA.getVariable());
                if (sp != null) {
                    c = sp.getCompartmentInstance();
                    boolean hasZeroSpatialDimensions = true;
                    if (c != null && c.getSpatialDimensions() > 0.0) {
                        hasZeroSpatialDimensions = false;
                    }
                    this.initialAssignmentRoots.add(new AssignmentRuleValue((ASTNodeValue)this.copyAST(iA.getMath(), true, null, null).getUserObject((Object)TEMP_VALUE), symbolIndex, sp, this.compartmentHash.get(sp.getId()), hasZeroSpatialDimensions, this));
                } else {
                    this.initialAssignmentRoots.add(new AssignmentRuleValue((ASTNodeValue)this.copyAST(iA.getMath(), true, null, null).getUserObject((Object)TEMP_VALUE), symbolIndex));
                }
            } else if (this.model.findSpeciesReference(iA.getVariable()) != null) {
                sr = this.model.findSpeciesReference(iA.getVariable());
                this.initialAssignmentRoots.add(new AssignmentRuleValue((ASTNodeValue)this.copyAST(iA.getMath(), true, null, null).getUserObject((Object)TEMP_VALUE), sr.getId(), this.stoichiometricCoefHash));
            }
            ++i;
        }
        this.nRateRules = this.rateRulesRoots.size();
        this.nAssignmentRules = this.assignmentRulesRoots.size();
    }

    private ASTNode copyAST(ASTNode node, boolean mergingPossible, FunctionValue function, List<ASTNode> inFunctionNodes) {
        String nodeString = node.toString();
        ASTNode copiedAST = null;
        if (!(!mergingPossible || node.isName() && node.getType() != ASTNode.Type.NAME_TIME && node.getType() != ASTNode.Type.NAME_AVOGADRO && node.getVariable() != null && node.getVariable() instanceof LocalParameter)) {
            List<ASTNode> nodesToLookAt = null;
            nodesToLookAt = function != null ? inFunctionNodes : this.nodes;
            for (ASTNode current : nodesToLookAt) {
                if (current.isName() && current.getType() != ASTNode.Type.NAME_TIME && current.getType() != ASTNode.Type.NAME_AVOGADRO && (!current.isName() || current.getVariable() instanceof LocalParameter) || !current.toString().equals(nodeString) || this.containUnequalLocalParameters(current, node)) continue;
                copiedAST = current;
                break;
            }
        }
        if (copiedAST == null) {
            copiedAST = new ASTNode(node.getType());
            for (ASTNode child : node.getChildren()) {
                if (function != null) {
                    copiedAST.addChild(this.copyAST(child, true, function, inFunctionNodes));
                    continue;
                }
                copiedAST.addChild(this.copyAST(child, mergingPossible, function, inFunctionNodes));
            }
            if (function != null) {
                inFunctionNodes.add(copiedAST);
            } else {
                this.nodes.add(copiedAST);
            }
            if (node.isSetUnits()) {
                copiedAST.setUnits(node.getUnits());
            }
            switch (node.getType()) {
                case REAL: {
                    copiedAST.setValue(node.getReal());
                    copiedAST.putUserObject((Object)TEMP_VALUE, (Object)new ASTNodeValue(this.nodeInterpreter, copiedAST));
                    break;
                }
                case INTEGER: {
                    copiedAST.setValue(node.getInteger());
                    copiedAST.putUserObject((Object)TEMP_VALUE, (Object)new ASTNodeValue(this.nodeInterpreter, copiedAST));
                    break;
                }
                case RATIONAL: {
                    copiedAST.setValue(node.getNumerator(), node.getDenominator());
                    copiedAST.putUserObject((Object)TEMP_VALUE, (Object)new ASTNodeValue(this.nodeInterpreter, copiedAST));
                    break;
                }
                case NAME_TIME: {
                    copiedAST.setName(node.getName());
                    copiedAST.putUserObject((Object)TEMP_VALUE, (Object)new ASTNodeValue(this.nodeInterpreter, copiedAST));
                    break;
                }
                case FUNCTION_DELAY: {
                    copiedAST.setName(node.getName());
                    copiedAST.putUserObject((Object)TEMP_VALUE, (Object)new ASTNodeValue(this.nodeInterpreter, copiedAST));
                    break;
                }
                case NAME: {
                    ASTNode lambda;
                    LinkedList<ASTNode> arguments;
                    copiedAST.setName(node.getName());
                    CallableSBase variable = node.getVariable();
                    if (variable == null && function == null) {
                        variable = this.model.findCallableSBase(node.getName());
                    }
                    if (variable != null) {
                        copiedAST.setVariable(variable);
                        if (variable instanceof FunctionDefinition) {
                            arguments = new LinkedList();
                            lambda = ((FunctionDefinition)variable).getMath();
                            int i = 0;
                            while (i != lambda.getChildren().size() - 1) {
                                arguments.add(lambda.getChild(i));
                                ++i;
                            }
                            FunctionValue functionValue = new FunctionValue(this.nodeInterpreter, copiedAST, arguments);
                            copiedAST.putUserObject((Object)TEMP_VALUE, (Object)functionValue);
                            ASTNode mathAST = this.copyAST(lambda, false, functionValue, new LinkedList<ASTNode>());
                            functionValue.setMath(mathAST);
                            break;
                        }
                        if (variable instanceof Species) {
                            boolean hasZeroSpatialDimensions = true;
                            Species sp = (Species)variable;
                            Compartment c = sp.getCompartmentInstance();
                            if (c != null && c.getSpatialDimensions() > 0.0) {
                                hasZeroSpatialDimensions = false;
                            }
                            copiedAST.putUserObject((Object)TEMP_VALUE, (Object)new SpeciesValue(this.nodeInterpreter, copiedAST, sp, this, this.symbolHash.get(variable.getId()), this.compartmentHash.get(variable.getId()), hasZeroSpatialDimensions));
                            break;
                        }
                        if (variable instanceof Compartment || variable instanceof Parameter) {
                            copiedAST.putUserObject((Object)TEMP_VALUE, (Object)new CompartmentOrParameterValue(this.nodeInterpreter, copiedAST, (Symbol)variable, this, this.symbolHash.get(variable.getId())));
                            break;
                        }
                        if (variable instanceof LocalParameter) {
                            copiedAST.putUserObject((Object)TEMP_VALUE, (Object)new LocalParameterValue(this.nodeInterpreter, copiedAST, (LocalParameter)variable));
                            break;
                        }
                        if (variable instanceof SpeciesReference) {
                            copiedAST.putUserObject((Object)TEMP_VALUE, (Object)new SpeciesReferenceValue(this.nodeInterpreter, copiedAST, (SpeciesReference)variable, this));
                            break;
                        }
                        if (!(variable instanceof Reaction)) break;
                        copiedAST.putUserObject((Object)TEMP_VALUE, (Object)new ReactionValue(this.nodeInterpreter, copiedAST, (Reaction)variable));
                        break;
                    }
                    copiedAST.putUserObject((Object)TEMP_VALUE, (Object)new NamedValue(this.nodeInterpreter, copiedAST, function));
                    break;
                }
                case NAME_AVOGADRO: {
                    copiedAST.putUserObject((Object)TEMP_VALUE, (Object)new ASTNodeValue(this.nodeInterpreter, copiedAST));
                    copiedAST.setName(node.getName());
                    break;
                }
                case REAL_E: {
                    copiedAST.setValue(node.getMantissa(), node.getExponent());
                    copiedAST.putUserObject((Object)TEMP_VALUE, (Object)new ASTNodeValue(this.nodeInterpreter, copiedAST));
                    break;
                }
                case FUNCTION: {
                    copiedAST.setName(node.getName());
                    CallableSBase variable = node.getVariable();
                    if (variable == null) break;
                    copiedAST.setVariable(variable);
                    if (!(variable instanceof FunctionDefinition)) break;
                    LinkedList<ASTNode> arguments = new LinkedList<ASTNode>();
                    ASTNode lambda = ((FunctionDefinition)variable).getMath();
                    int i = 0;
                    while (i != lambda.getChildren().size() - 1) {
                        arguments.add(lambda.getChild(i));
                        ++i;
                    }
                    FunctionValue functionValue = new FunctionValue(this.nodeInterpreter, copiedAST, arguments);
                    copiedAST.putUserObject((Object)TEMP_VALUE, (Object)functionValue);
                    ASTNode mathAST = this.copyAST(lambda, false, functionValue, new LinkedList<ASTNode>());
                    functionValue.setMath(mathAST);
                    break;
                }
                case FUNCTION_PIECEWISE: {
                    copiedAST.putUserObject((Object)TEMP_VALUE, (Object)new ASTNodeValue(this.nodeInterpreter, copiedAST));
                    break;
                }
                case FUNCTION_ROOT: {
                    copiedAST.putUserObject((Object)TEMP_VALUE, (Object)new RootFunctionValue(this.nodeInterpreter, copiedAST));
                    break;
                }
                case LAMBDA: {
                    copiedAST.putUserObject((Object)TEMP_VALUE, (Object)new ASTNodeValue(this.nodeInterpreter, copiedAST));
                    break;
                }
                default: {
                    copiedAST.putUserObject((Object)TEMP_VALUE, (Object)new ASTNodeValue(this.nodeInterpreter, copiedAST));
                }
            }
        }
        return copiedAST;
    }

    private boolean containUnequalLocalParameters(ASTNode node1, ASTNode node2) {
        if (node1.getChildCount() != node2.getChildCount()) {
            return true;
        }
        if (node1.getType() == ASTNode.Type.NAME && node2.getType() == ASTNode.Type.NAME && node1.getVariable() instanceof LocalParameter && node2.getVariable() instanceof LocalParameter) {
            LocalParameter lp1 = (LocalParameter)node1.getVariable();
            LocalParameter lp2 = (LocalParameter)node2.getVariable();
            return lp1.getId().equals(lp2.getId()) && !lp1.equals((Object)lp2);
        }
        if (node1.getType() == ASTNode.Type.NAME && node2.getType() == ASTNode.Type.NAME && (node1.getVariable() instanceof LocalParameter && !(node2.getVariable() instanceof LocalParameter) || !(node1.getVariable() instanceof LocalParameter) && node2.getVariable() instanceof LocalParameter)) {
            return true;
        }
        boolean result = false;
        int i = 0;
        while (i != node1.getChildCount()) {
            result = result || this.containUnequalLocalParameters(node1.getChild(i), node2.getChild(i));
            ++i;
        }
        return result;
    }

    private void initEvents() throws SBMLException {
        int i = 0;
        while (i < this.model.getEventCount()) {
            if (this.model.getEvent(i).getDelay() == null) {
                if (this.events[i] != null) {
                    this.events[i].refresh(this.model.getEvent(i).getTrigger().getInitialValue());
                } else {
                    this.events[i] = new SBMLEventInProgress(this.model.getEvent(i).getTrigger().getInitialValue());
                }
            } else if (this.events[i] != null) {
                this.events[i].refresh(this.model.getEvent(i).getTrigger().getInitialValue());
            } else {
                this.events[i] = new SBMLEventInProgressWithDelay(this.model.getEvent(i).getTrigger().getInitialValue());
            }
            ++i;
        }
    }

    private void pickRandomEvent(List<Integer> highOrderEvents) {
        int length = highOrderEvents.size();
        int random = RNG.randomInt(0, length - 1);
        Integer winner = highOrderEvents.get(random);
        highOrderEvents.clear();
        highOrderEvents.add(winner);
    }

    @Override
    public boolean processAssignmentRules(double t, double[] Y) throws DerivativeException {
        this.currentTime = t;
        this.astNodeTime += 0.01;
        return this.processRules(t, null, Y, false);
    }

    private SBMLEventInProgress processNextEvent(HashSet<Double> priorities, double[] Y) throws DerivativeException {
        int index;
        double highestPriority = -1.0;
        this.highOrderEvents.clear();
        if (!priorities.isEmpty()) {
            boolean first = true;
            Iterator<Object> iterator = priorities.iterator();
            while (iterator.hasNext()) {
                double priority = iterator.next();
                if (first) {
                    first = false;
                    highestPriority = priority;
                    continue;
                }
                highestPriority = Math.max(highestPriority, priority);
            }
            int i = 0;
            while (i < this.runningEvents.size()) {
                if (this.events[this.runningEvents.get(i)].getPriority() == highestPriority) {
                    this.highOrderEvents.add(this.runningEvents.get(i));
                }
                ++i;
            }
            if (this.highOrderEvents.size() > 1) {
                this.pickRandomEvent(this.highOrderEvents);
            }
        } else {
            int i = 0;
            while (i < this.runningEvents.size()) {
                this.highOrderEvents.add(this.runningEvents.get(i));
                ++i;
            }
            if (this.highOrderEvents.size() > 1) {
                this.pickRandomEvent(this.highOrderEvents);
            }
        }
        this.runningEvents.remove(this.highOrderEvents.get(0));
        try {
            index = this.highOrderEvents.get(0);
            this.events[index].clearAssignments();
            if (!this.events[index].getUseValuesFromTriggerTime()) {
                for (AssignmentRuleValue obj : this.events[index].getRuleObjects()) {
                    obj.processRule(Y, this.astNodeTime, false);
                    double newVal = obj.getValue();
                    Integer symbolIndex = obj.getIndex();
                    if (symbolIndex >= 0 && this.compartmentHash.containsValue(symbolIndex)) {
                        this.updateSpeciesConcentration(symbolIndex, Y, Y[symbolIndex], newVal, false);
                    }
                    if (symbolIndex < 0) continue;
                    this.events[index].addAssignment(symbolIndex, newVal);
                }
            } else {
                Double[] triggerTimeValues = this.events[index].getValues();
                int j = 0;
                for (AssignmentRuleValue obj : this.events[index].getRuleObjects()) {
                    double newVal = triggerTimeValues[j];
                    Integer symbolIndex = obj.getIndex();
                    if (symbolIndex >= 0) {
                        if (this.compartmentHash.containsValue(symbolIndex)) {
                            this.updateSpeciesConcentration(symbolIndex, Y, Y[symbolIndex], newVal, false);
                        }
                        this.events[index].addAssignment(symbolIndex, newVal);
                    } else {
                        String id = obj.getSpeciesReferenceID();
                        if (id != null) {
                            this.stoichiometricCoefHash.put(id, newVal);
                        }
                    }
                    ++j;
                }
            }
            this.events[index].executed(this.currentTime);
        }
        catch (SBMLException exc) {
            throw new DerivativeException((Throwable)exc);
        }
        return this.events[index];
    }

    public void processInitialAssignments(double time, double[] Y) throws SBMLException {
        if (Y != null) {
            int i = 0;
            while (i != this.initialAssignmentRoots.size()) {
                this.initialAssignmentRoots.get(i).processRule(Y, time, true);
                ++i;
            }
        }
    }

    public boolean processRules(double time, double[] changeRate, double[] Y, boolean initialCalculations) throws SBMLException {
        boolean changeByAssignmentRules = false;
        double intermediateASTNodeTime = -this.astNodeTime;
        if (Y != null) {
            int n = 0;
            while (n != this.nAssignmentRules) {
                intermediateASTNodeTime = -intermediateASTNodeTime;
                int i = 0;
                while (i != this.nAssignmentRules) {
                    AssignmentRuleValue currentRuleObject = this.assignmentRulesRoots.get(i);
                    double oldValue = Double.NaN;
                    double newValue = Double.NaN;
                    int index = currentRuleObject.getIndex();
                    if (index >= 0) {
                        oldValue = Y[index];
                    }
                    boolean currentChange = currentRuleObject.processRule(Y, intermediateASTNodeTime, true);
                    if (index >= 0) {
                        newValue = Y[index];
                    }
                    if (currentChange && !initialCalculations && index >= 0 && this.compartmentHash.containsValue(index)) {
                        this.updateSpeciesConcentration(index, Y, oldValue, newValue, false);
                    }
                    changeByAssignmentRules = changeByAssignmentRules || currentChange;
                    ++i;
                }
                ++n;
            }
        }
        if (changeRate != null) {
            int i = 0;
            while (i != this.nRateRules) {
                this.rateRulesRoots.get(i).processRule(changeRate, this.Y, this.astNodeTime);
                ++i;
            }
        }
        return changeByAssignmentRules;
    }

    protected void processVelocities(double[] changeRate, double time) throws SBMLException {
        int reactionIndex = 0;
        while (reactionIndex != this.v.length) {
            this.v[reactionIndex] = this.hasFastReactions ? (this.isProcessingFastReactions == this.reactionFast[reactionIndex] ? this.kineticLawRoots.get(reactionIndex).compileDouble(time) : 0.0) : this.kineticLawRoots.get(reactionIndex).compileDouble(time);
            if (this.v[reactionIndex] < 0.0 && !this.reactionReversible[reactionIndex]) {
                this.v[reactionIndex] = 0.0;
            }
            ++reactionIndex;
        }
        int i = 0;
        while (i != this.stoichiometriesSize) {
            this.stoichiometries.get(i).computeChange(this.astNodeTime, changeRate, this.v);
            ++i;
        }
        i = 0;
        while (i != changeRate.length) {
            int n = i;
            changeRate[n] = changeRate[n] * this.conversionFactors[i];
            ++i;
        }
    }

    @Override
    public void setFastProcessComputation(boolean isProcessing) {
        this.isProcessingFastReactions = isProcessing;
    }

    public void setParameters(double[] params) {
        int paramNum = 0;
        while (paramNum < this.model.getParameterCount()) {
            this.model.getParameter(paramNum).setValue(params[paramNum]);
            ++paramNum;
        }
        int reactionNum = 0;
        while (reactionNum < this.model.getReactionCount()) {
            KineticLaw law = this.model.getReaction(reactionNum).getKineticLaw();
            int localPnum = 0;
            while (localPnum < law.getLocalParameterCount()) {
                law.getLocalParameter(localPnum).setValue(params[paramNum++]);
                ++localPnum;
            }
            ++reactionNum;
        }
        if (this.model.getInitialAssignmentCount() > 0 || this.model.getEventCount() > 0) {
            try {
                this.init();
            }
            catch (Exception exc) {
                logger.log(Level.WARNING, "Could not re-initialize the model with the new parameter values.", exc);
            }
        }
    }

    private void updateSpeciesConcentration(int compartmentIndex, double[] changeRate, double oldCompartmentValue, double newCompartmentValue, boolean causedByRateRule) {
        for (Map.Entry<String, Integer> entry : this.compartmentHash.entrySet()) {
            Species s;
            if (entry.getValue() != compartmentIndex || !(s = this.model.getSpecies(entry.getKey())).isSetInitialConcentration()) continue;
            int speciesIndex = this.symbolHash.get(entry.getKey());
            changeRate[speciesIndex] = causedByRateRule ? -changeRate[compartmentIndex] * this.Y[speciesIndex] / this.Y[compartmentIndex] : changeRate[speciesIndex] * oldCompartmentValue / newCompartmentValue;
        }
    }

    @Override
    public boolean containsEventsOrRules() {
        return this.model.getRuleCount() != 0 || this.model.getEventCount() != 0;
    }

    @Override
    public double getCurrentValueOf(int position) {
        return this.Y[position];
    }

    @Override
    public int getPositiveValueCount() {
        return 0;
    }

    @Override
    public void registerDelayValueHolder(DelayValueHolder dvh) {
        this.delayValueHolder = dvh;
    }

    @Override
    public double computeDelayedValue(double time, String id) {
        if (time < 0.0 || time >= 0.0 && this.delayValueHolder == null) {
            int index = this.symbolHash.get(id);
            double oldTime = this.currentTime;
            this.currentTime = time;
            double value = Double.NaN;
            for (AssignmentRuleValue r : this.assignmentRulesRoots) {
                if (r.getIndex() != index) continue;
                r.processRule(this.Y, -this.astNodeTime - 0.01, false);
                value = r.getValue();
                break;
            }
            if (Double.isNaN(value)) {
                for (AssignmentRuleValue i : this.initialAssignmentRoots) {
                    if (i.getIndex() != index) continue;
                    i.processRule(this.Y, -this.astNodeTime - 0.01, false);
                    value = i.getValue();
                    break;
                }
            }
            if (Double.isNaN(value)) {
                value = this.initialValues[index];
            }
            this.currentTime = oldTime;
            return value;
        }
        if (this.delayValueHolder == null) {
            logger.warning(String.format("Cannot access delayed value at time %s for %s.", StringTools.toString((double)time), id));
            return Double.NaN;
        }
        return this.delayValueHolder.computeDelayedValue(time, id);
    }

    @Override
    public boolean getNoDerivatives() {
        return this.noDerivatives;
    }

    public double compileReaction(int reactionIndex) {
        this.astNodeTime += 0.01;
        double value = this.kineticLawRoots.get(reactionIndex).compileDouble(this.astNodeTime);
        return value;
    }
}

