/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.sbml;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.AlgebraicRule;
import org.sbml.jsbml.AssignmentRule;
import org.sbml.jsbml.CallableSBase;
import org.sbml.jsbml.FunctionDefinition;
import org.sbml.jsbml.MathContainer;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Rule;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgebraicRuleConverter {
    private Map<SBase, SBase> matching;
    private Model model;
    private ASTNode variableNodeParent;
    private ASTNode variableNode;
    private boolean additive = true;
    private boolean remainOnSide = true;
    private int nestingDepth;
    private ArrayList<ArrayList<EquationObject>> equationObjects;
    private MathContainer pso;

    public AlgebraicRuleConverter(Map<SBase, SBase> map, Model model) {
        this.matching = map;
        this.model = model;
    }

    private ASTNode buildEquation() {
        ArrayList<EquationObject> addition = this.equationObjects.get(0);
        ArrayList<EquationObject> multiplication = this.equationObjects.get(1);
        ASTNode add = new ASTNode(ASTNode.Type.PLUS, this.pso);
        ASTNode multiply = new ASTNode(ASTNode.Type.TIMES, this.pso);
        ASTNode divide = new ASTNode(ASTNode.Type.DIVIDE, this.pso);
        ASTNode node = null;
        if (this.additive) {
            if (!this.remainOnSide) {
                int i = 0;
                while (i < addition.size()) {
                    EquationObject eo = addition.get(i);
                    if (eo.isNegative()) {
                        ASTNode minus = new ASTNode(ASTNode.Type.MINUS, this.pso);
                        minus.addChild(eo.getNode());
                        add.addChild(minus);
                    } else {
                        add.addChild(eo.getNode());
                    }
                    ++i;
                }
                node = add;
                if (multiplication.size() > 0) {
                    i = 0;
                    while (i < multiplication.size()) {
                        multiply.addChild(multiplication.get(i).getNode());
                        ++i;
                    }
                    multiply.addChild(add);
                    node = multiply;
                }
            } else {
                int i = 0;
                while (i < addition.size()) {
                    EquationObject eo = addition.get(i);
                    if (eo.isNegative()) {
                        add.addChild(eo.getNode());
                    } else {
                        ASTNode minus = new ASTNode(ASTNode.Type.MINUS, this.pso);
                        minus.addChild(eo.getNode());
                        add.addChild(minus);
                    }
                    ++i;
                }
                node = add;
                if (multiplication.size() > 0) {
                    if (multiplication.size() == 1) {
                        i = 0;
                        while (i < multiplication.size()) {
                            multiply.addChild(multiplication.get(i).getNode());
                            ++i;
                        }
                        divide.addChild(add);
                        divide.addChild(multiply);
                    } else {
                        divide.addChild(add);
                        divide.addChild(multiplication.get(0).getNode());
                    }
                    node = divide;
                }
            }
        } else if (!this.remainOnSide) {
            int i = 0;
            while (i < addition.size()) {
                EquationObject eo = addition.get(i);
                if (eo.isNegative()) {
                    ASTNode minus = new ASTNode(ASTNode.Type.MINUS, this.pso);
                    minus.addChild(eo.getNode());
                    add.addChild(minus);
                } else {
                    add.addChild(eo.getNode());
                }
                ++i;
            }
            node = add;
            if (multiplication.size() > 0) {
                if (multiplication.size() == 1) {
                    divide.addChild(multiplication.get(0).getNode());
                    divide.addChild(add);
                } else {
                    i = 0;
                    while (i < multiplication.size()) {
                        multiply.addChild(multiplication.get(i).getNode());
                        ++i;
                    }
                    divide.addChild(multiply);
                    divide.addChild(add);
                }
                node = divide;
            }
        } else {
            int i = 0;
            while (i < addition.size()) {
                EquationObject eo = addition.get(i);
                if (eo.isNegative()) {
                    add.addChild(eo.getNode());
                } else {
                    ASTNode minus = new ASTNode(ASTNode.Type.MINUS, this.pso);
                    minus.addChild(eo.getNode());
                    add.addChild(minus);
                }
                ++i;
            }
            node = add;
            if (multiplication.size() > 0) {
                if (multiplication.size() == 1) {
                    divide.addChild(add);
                    divide.addChild(multiplication.get(0).getNode());
                } else {
                    i = 0;
                    while (i < multiplication.size()) {
                        multiply.addChild(multiplication.get(i).getNode());
                        ++i;
                    }
                    divide.addChild(add);
                    divide.addChild(multiply);
                }
                node = divide;
            }
        }
        return node;
    }

    private AssignmentRule createAssignmentRule(ASTNode node, Rule rule) {
        AssignmentRule as = null;
        Variable variable = (Variable)this.matching.get(rule);
        if (variable != null) {
            this.variableNodeParent = null;
            this.variableNode = null;
            as = new AssignmentRule();
            as.setVariable(variable);
            this.setNodeWithVariable(node, variable);
            this.nestingDepth = 0;
            this.evaluateEquation(this.variableNodeParent);
            this.equationObjects = new ArrayList();
            this.equationObjects.add(new ArrayList());
            this.equationObjects.add(new ArrayList());
            this.deleteVariable();
            this.sortEquationObjects(node, false, false, false, this.nestingDepth);
            as.setMath(this.buildEquation());
        }
        return as;
    }

    private void deleteVariable() {
        if (this.variableNodeParent.getChildCount() == 2 && this.variableNodeParent.getType() == ASTNode.Type.TIMES) {
            if (this.variableNodeParent.getLeftChild().isMinusOne() || this.variableNodeParent.getLeftChild().isUMinus() && this.variableNodeParent.getLeftChild().getLeftChild().isOne() || this.variableNodeParent.getRightChild().isMinusOne() || this.variableNodeParent.getRightChild().isUMinus() && this.variableNodeParent.getRightChild().getLeftChild().isOne()) {
                int index = this.variableNodeParent.getParent().getIndex((TreeNode)this.variableNodeParent);
                this.variableNodeParent.getParent().removeChild(index);
            } else {
                int index = this.variableNodeParent.getIndex((TreeNode)this.variableNode);
                this.variableNodeParent.removeChild(index);
            }
        } else {
            int index = this.variableNodeParent.getIndex((TreeNode)this.variableNode);
            this.variableNodeParent.removeChild(index);
        }
    }

    private void evaluateEquation(ASTNode node) {
        if (node != null) {
            if (node.getType() == ASTNode.Type.TIMES) {
                if (node.getChildCount() == 2) {
                    if (node.getLeftChild().isMinusOne() || node.getLeftChild().isUMinus() && node.getLeftChild().getLeftChild().isOne() || node.getRightChild().isMinusOne() || node.getRightChild().isUMinus() && node.getRightChild().getLeftChild().isOne()) {
                        this.remainOnSide = false;
                    } else {
                        this.additive = false;
                        ++this.nestingDepth;
                    }
                } else {
                    this.additive = false;
                    ++this.nestingDepth;
                }
            } else if (node.getType() == ASTNode.Type.DIVIDE) {
                this.additive = false;
                this.remainOnSide = false;
                ++this.nestingDepth;
            }
            this.evaluateEquation(node.getParent());
        }
    }

    public List<AssignmentRule> getAssignmentRules() {
        ArrayList<AssignmentRule> assignmentRules = new ArrayList<AssignmentRule>();
        if (this.matching == null) {
            System.out.println("no matching found");
        }
        int i = 0;
        while (i < this.model.getRuleCount()) {
            Rule r = this.model.getRule(i);
            if (r instanceof AlgebraicRule) {
                AlgebraicRule ar = (AlgebraicRule)r;
                ASTNode node = ar.getMath().clone();
                if (this.model.getFunctionDefinitionCount() > 0) {
                    node = this.substituteFunctions(node, 0);
                }
                this.pso = node.getParentSBMLObject();
                AssignmentRule as = this.createAssignmentRule(node, (Rule)ar);
                if (as != null) {
                    assignmentRules.add(as);
                    Object var2_3 = null;
                }
            }
            ++i;
        }
        return assignmentRules;
    }

    private void replaceNames(ASTNode node, Map<String, String> varibales, Map<String, Double> numberHash, Map<String, ASTNode> nodeHash) {
        if (node.isString()) {
            if (varibales.get(node.getName()) != null) {
                node.setName(varibales.get(node.getName()));
            } else if (numberHash.get(node.getName()) != null) {
                node.setValue(numberHash.get(node.getName()).doubleValue());
            } else if (nodeHash.get(node.getName()) != null && !node.isRoot()) {
                ASTNode parent = node.getParent();
                parent.replaceChild(parent.getIndex((TreeNode)node), nodeHash.get(node.getName()));
            }
        }
        int i = 0;
        while (i < node.getChildCount()) {
            this.replaceNames(node.getChild(i), varibales, numberHash, nodeHash);
            ++i;
        }
    }

    private void setNodeWithVariable(ASTNode node, Variable variable) {
        Enumeration nodes = node.children();
        while (nodes.hasMoreElements()) {
            ASTNode subnode = (ASTNode)nodes.nextElement();
            if (subnode.isString()) {
                if (subnode.getName() != variable.getId()) continue;
                this.variableNodeParent = node;
                this.variableNode = subnode;
                continue;
            }
            this.setNodeWithVariable(subnode, variable);
        }
    }

    private void sortEquationObjects(ASTNode node, boolean plus, boolean times, boolean divide, int depth) {
        if (depth >= 0 && node.isOperator()) {
            if (node.getType() == ASTNode.Type.PLUS) {
                int i = 0;
                while (i < node.getChildCount()) {
                    this.sortEquationObjects(node.getChild(i), true, false, false, depth - 1);
                    ++i;
                }
            } else if (node.getType() == ASTNode.Type.MINUS) {
                int i = 0;
                while (i < node.getChildCount()) {
                    this.sortEquationObjects(node.getChild(i), true, true, false, depth - 1);
                    ++i;
                }
            } else if (node.getType() == ASTNode.Type.TIMES) {
                if (node.getChildCount() == 2) {
                    if ((node.getLeftChild().isMinusOne() || node.getLeftChild().isUMinus() && node.getLeftChild().getLeftChild().isOne()) && !node.getRightChild().isMinusOne() && (!node.getRightChild().isUMinus() || !node.getRightChild().getLeftChild().isOne())) {
                        this.sortEquationObjects(node.getRightChild(), true, true, false, depth - 1);
                    } else if (!node.getLeftChild().isMinusOne() && (!node.getLeftChild().isUMinus() || !node.getLeftChild().getLeftChild().isOne()) && (node.getRightChild().isMinusOne() || node.getRightChild().isUMinus() && node.getRightChild().getLeftChild().isOne())) {
                        this.sortEquationObjects(node.getLeftChild(), true, true, false, depth - 1);
                    } else {
                        this.equationObjects.get(1).add(new EquationObject(node.clone(), false));
                    }
                } else {
                    this.equationObjects.get(1).add(new EquationObject(node.clone(), false));
                }
            }
        } else if (plus && times) {
            this.equationObjects.get(0).add(new EquationObject(node.clone(), true));
        } else if (plus) {
            this.equationObjects.get(0).add(new EquationObject(node.clone(), false));
        }
    }

    private ASTNode substituteFunctions(ASTNode node, int indexParent) {
        FunctionDefinition fd;
        if (node.isString() && (fd = this.model.getFunctionDefinition(node.getName())) != null) {
            ASTNode function = fd.getMath();
            HashMap<String, String> nameHash = new HashMap<String, String>();
            HashMap<String, Double> numberHash = new HashMap<String, Double>();
            HashMap<String, ASTNode> nodeHash = new HashMap<String, ASTNode>();
            int i = 0;
            while (i < node.getChildCount()) {
                CallableSBase variable = null;
                if (node.getChild(i).isString() && (variable = node.getChild(i).getVariable()) == null) {
                    variable = this.model.findNamedSBaseWithDerivedUnit(node.getName());
                }
                if (variable instanceof FunctionDefinition) {
                    nodeHash.put(function.getChild(i).getName(), node.getChild(i).clone());
                } else if (node.getChild(i).isOperator()) {
                    nodeHash.put(function.getChild(i).getName(), node.getChild(i).clone());
                } else if (node.getChild(i).isString()) {
                    nameHash.put(function.getChild(i).getName(), node.getChild(i).getName());
                } else if (node.getChild(i).isNumber()) {
                    if (node.getChild(i).isInteger()) {
                        numberHash.put(function.getChild(i).getName(), Double.valueOf(node.getChild(i).getInteger()));
                    } else {
                        numberHash.put(function.getChild(i).getName(), node.getChild(i).getReal());
                    }
                }
                ++i;
            }
            ASTNode parent = node.getParent();
            if (parent != null) {
                parent.replaceChild(indexParent, function.getRightChild().clone());
                this.replaceNames(parent.getChild(indexParent), nameHash, numberHash, nodeHash);
                node = parent;
            } else {
                node = function.getRightChild().clone();
                this.replaceNames(node, nameHash, numberHash, nodeHash);
            }
        }
        int i = 0;
        while (i < node.getChildCount()) {
            this.substituteFunctions(node.getChild(i), i);
            ++i;
        }
        return node;
    }

    private class EquationObject {
        private ASTNode node;
        private boolean isNegative;

        public EquationObject(ASTNode node, boolean isNegative) {
            this.node = node;
            this.isNegative = isNegative;
        }

        public ASTNode getNode() {
            return this.node;
        }

        public boolean isNegative() {
            return this.isNegative;
        }
    }
}

