/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.math.odes;

import org.apache.commons.math.ode.DerivativeException;
import org.simulator.math.Mathematics;
import org.simulator.math.odes.AbstractDESSolver;
import org.simulator.math.odes.DESystem;

public class RungeKutta_EventSolver
extends AbstractDESSolver {
    private static final long serialVersionUID = -2034495479346567501L;
    protected transient double[][] kVals = null;
    protected transient double[] kHelp;

    public RungeKutta_EventSolver() {
    }

    public RungeKutta_EventSolver(double stepSize) {
        super(stepSize);
    }

    public RungeKutta_EventSolver(double stepSize, boolean nonnegative) {
        super(stepSize, nonnegative);
    }

    public RungeKutta_EventSolver(RungeKutta_EventSolver rkEventSolver) {
        super(rkEventSolver);
    }

    public double[] computeChange(DESystem DES, double[] yTemp, double t, double h, double[] change, boolean steadyState) throws DerivativeException {
        int dim = DES.getDimension();
        if (this.kVals == null || this.kVals.length != 4 || this.kVals[0].length != dim) {
            this.kVals = new double[4][dim];
            this.kHelp = new double[dim];
        }
        DES.computeDerivatives(t, yTemp, this.kVals[0]);
        Mathematics.svMult(h, this.kVals[0], this.kVals[0]);
        Mathematics.svvAddScaled(0.5, this.kVals[0], yTemp, this.kHelp);
        DES.computeDerivatives(t + h / 2.0, this.kHelp, this.kVals[1]);
        Mathematics.svMult(h, this.kVals[1], this.kVals[1]);
        Mathematics.svvAddScaled(0.5, this.kVals[1], yTemp, this.kHelp);
        DES.computeDerivatives(t + h / 2.0, this.kHelp, this.kVals[2]);
        Mathematics.svMult(h, this.kVals[2], this.kVals[2]);
        Mathematics.vvAdd(yTemp, this.kVals[2], this.kHelp);
        DES.computeDerivatives(t + h, this.kHelp, this.kVals[3]);
        Mathematics.svMult(h, this.kVals[3], this.kVals[3]);
        Mathematics.svvAddScaled(2.0, this.kVals[2], this.kVals[3], this.kVals[3]);
        Mathematics.svvAddScaled(2.0, this.kVals[1], this.kVals[3], this.kVals[2]);
        Mathematics.svvAddAndScale(0.16666666666666666, this.kVals[0], this.kVals[2], change);
        return change;
    }

    public String getName() {
        return "4th order Runge-Kutta event solver";
    }

    public RungeKutta_EventSolver clone() {
        return new RungeKutta_EventSolver(this);
    }

    protected boolean hasSolverEventProcessing() {
        return false;
    }
}

