/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.math.odes;

import java.math.BigDecimal;
import org.apache.commons.math.ode.DerivativeException;
import org.simulator.math.Mathematics;
import org.simulator.math.MatrixOperations;
import org.simulator.math.odes.AbstractDESSolver;
import org.simulator.math.odes.AdaptiveStepsizeIntegrator;
import org.simulator.math.odes.DESystem;
import org.simulator.math.odes.EventDESystem;

public class RosenbrockSolver
extends AdaptiveStepsizeIntegrator {
    private static final long serialVersionUID = -3446213991016212781L;
    public static final double SAFETY = 0.9;
    public static final double fac1 = 0.16666666666666666;
    public static final double fac2 = 5.0;
    public static final double PWR = 0.25;
    public static final double c2 = 0.386;
    public static final double c3 = 0.21;
    public static final double c4 = 0.63;
    public static final double a21 = 1.544;
    public static final double a31 = 0.9466785280815826;
    public static final double a32 = 0.2557011698983284;
    public static final double a41 = 3.314825187068521;
    public static final double a42 = 2.896124015972201;
    public static final double a43 = 0.9986419139977817;
    public static final double a51 = 1.221224509226641;
    public static final double a52 = 6.019134481288629;
    public static final double a53 = 12.53708332932087;
    public static final double a54 = -0.687886036105895;
    public static final double gam = 0.25;
    public static final double c21 = -5.6688;
    public static final double c31 = -2.430093356833875;
    public static final double c32 = -0.2063599157091915;
    public static final double c41 = -0.1073529058151375;
    public static final double c42 = -9.594562251023355;
    public static final double c43 = -20.47028614809616;
    public static final double c51 = 7.496443313967647;
    public static final double c52 = -10.24680431464352;
    public static final double c53 = -33.99990352819905;
    public static final double c54 = 11.7089089320616;
    public static final double c61 = 8.083246795921522;
    public static final double c62 = -7.981132988064893;
    public static final double c63 = -31.52159432874371;
    public static final double c64 = 16.31930543123136;
    public static final double c65 = -6.058818238834054;
    public static final double d1 = 0.25;
    public static final double d2 = 0.1043;
    public static final double d3 = 0.1035;
    public static final double d4 = -0.0362;
    public static final double RELMIN = 1.0E-12;
    private double hMax;
    private double hMin;
    private double t;
    private double h;
    double sk;
    double hAdap;
    int numEqn;
    private double[] y;
    private double[] oldY;
    private double[] f1;
    private double[] f2;
    private double[] f3;
    private double[] f4;
    private double[] f5;
    private double[] f6;
    private double[] k1;
    private double[] k2;
    private double[] k3;
    private double[] k4;
    private double[] k5;
    double[] yNew;
    private double[] yerr;
    double[] yTemp;
    double[] ya;
    double[] yb;
    double[] g0;
    double[] g1;
    double[] g2;
    double[] g1x;
    double[] g2x;
    double[] DFDX;
    int[] indx;
    double[][] JAC;
    double[][] FAC;
    double[][] I;
    boolean stop;
    private double[] timePoints;
    private boolean[] ignoreNaN;
    private static final double precisionEventsAndRules = 1.0E-7;

    public RosenbrockSolver() {
    }

    public RosenbrockSolver(int size, double stepsize) {
        super(stepsize);
        this.init(size, stepsize, 2);
    }

    public RosenbrockSolver(RosenbrockSolver solver) {
        super(solver);
        this.init(solver.getNumEquations(), solver.getStepSize(), 2);
    }

    private void init(int size, double stepsize, int nTimepoints) {
        this.numEqn = size;
        this.hMin = 1.0E-14;
        this.setStepSize(stepsize);
        this.hMax = Math.min(stepsize, 0.1);
        this.stop = false;
        this.timePoints = new double[nTimepoints];
        this.y = new double[this.numEqn];
        this.f1 = new double[this.numEqn];
        this.f2 = new double[this.numEqn];
        this.f3 = new double[this.numEqn];
        this.f4 = new double[this.numEqn];
        this.f5 = new double[this.numEqn];
        this.f6 = new double[this.numEqn];
        this.k1 = new double[this.numEqn];
        this.k2 = new double[this.numEqn];
        this.k3 = new double[this.numEqn];
        this.k4 = new double[this.numEqn];
        this.k5 = new double[this.numEqn];
        this.yNew = new double[this.numEqn];
        this.yerr = new double[this.numEqn];
        this.yTemp = new double[this.numEqn];
        this.oldY = new double[this.numEqn];
        this.ya = new double[this.numEqn];
        this.yb = new double[this.numEqn];
        this.g0 = new double[this.numEqn];
        this.g1 = new double[this.numEqn];
        this.g2 = new double[this.numEqn];
        this.g1x = new double[this.numEqn];
        this.g2x = new double[this.numEqn];
        this.DFDX = new double[this.numEqn];
        this.indx = new int[this.numEqn];
        this.JAC = new double[this.numEqn][this.numEqn];
        this.FAC = new double[this.numEqn][this.numEqn];
        this.I = new double[this.numEqn][this.numEqn];
        this.ignoreNaN = new boolean[this.numEqn];
    }

    public AbstractDESSolver clone() {
        return new RosenbrockSolver(this.getNumEquations(), this.getStepSize());
    }

    public double step(DESystem DES) throws DerivativeException {
        int j;
        double largestError = 0.0;
        DES.computeDerivatives(this.t, this.y, this.g0);
        int j2 = 0;
        while (j2 < this.numEqn) {
            System.arraycopy(this.y, 0, this.ya, 0, this.numEqn);
            int n = j2;
            this.ya[n] = this.ya[n] + this.h;
            System.arraycopy(this.y, 0, this.yb, 0, this.numEqn);
            int n2 = j2;
            this.yb[n2] = this.yb[n2] + 2.0 * this.h;
            DES.computeDerivatives(this.t, this.ya, this.g1);
            DES.computeDerivatives(this.t, this.yb, this.g2);
            int q = 0;
            while (q < this.numEqn) {
                this.JAC[q][j2] = (-3.0 * this.g0[q] + 4.0 * this.g1[q] - this.g2[q]) / (2.0 * this.h);
                ++q;
            }
            ++j2;
        }
        int i = 0;
        while (i < this.numEqn) {
            j = 0;
            while (j < this.numEqn) {
                this.I[i][j] = i == j ? 1.0 : 0.0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.numEqn) {
            j = 0;
            while (j < this.numEqn) {
                this.FAC[i][j] = this.I[i][j] / (0.25 * this.h) - this.JAC[i][j];
                ++j;
            }
            ++i;
        }
        DES.computeDerivatives(this.t + this.h, this.y, this.g1x);
        DES.computeDerivatives(this.t + 2.0 * this.h, this.y, this.g2x);
        i = 0;
        while (i < this.numEqn) {
            this.DFDX[i] = this.g0[i] * -3.0 / (2.0 * this.h) + this.g1x[i] * 2.0 / this.h + this.g2x[i] * -1.0 / (2.0 * this.h);
            ++i;
        }
        DES.computeDerivatives(this.t, this.yTemp, this.f1);
        i = 0;
        while (i < this.numEqn) {
            this.k1[i] = this.f1[i] + this.DFDX[i] * this.h * 0.25;
            ++i;
        }
        try {
            MatrixOperations.ludcmp(this.FAC, this.indx);
        }
        catch (MatrixOperations.MatrixException e) {
            throw new DerivativeException("Rosenbrock solver returns an error due to singular matrix.", new Object[0]);
        }
        MatrixOperations.lubksb(this.FAC, this.indx, this.k1);
        i = 0;
        while (i < this.numEqn) {
            this.yTemp[i] = this.y[i] + this.k1[i] * 1.544;
            ++i;
        }
        DES.computeDerivatives(this.t + 0.386 * this.h, this.yTemp, this.f2);
        i = 0;
        while (i < this.numEqn) {
            this.k2[i] = this.f2[i] + this.DFDX[i] * this.h * 0.1043 + this.k1[i] * -5.6688 / this.h;
            ++i;
        }
        MatrixOperations.lubksb(this.FAC, this.indx, this.k2);
        i = 0;
        while (i < this.numEqn) {
            this.yTemp[i] = this.y[i] + this.k1[i] * 0.9466785280815826 + this.k2[i] * 0.2557011698983284;
            ++i;
        }
        DES.computeDerivatives(this.t + 0.21 * this.h, this.yTemp, this.f3);
        i = 0;
        while (i < this.numEqn) {
            this.k3[i] = this.f3[i] + this.DFDX[i] * this.h * 0.1035 + this.k1[i] * -2.430093356833875 / this.h + this.k2[i] * -0.2063599157091915 / this.h;
            ++i;
        }
        MatrixOperations.lubksb(this.FAC, this.indx, this.k3);
        i = 0;
        while (i < this.numEqn) {
            this.yTemp[i] = this.y[i] + this.k1[i] * 3.314825187068521 + this.k2[i] * 2.896124015972201 + this.k3[i] * 0.9986419139977817;
            ++i;
        }
        DES.computeDerivatives(this.t + 0.63 * this.h, this.yTemp, this.f4);
        i = 0;
        while (i < this.numEqn) {
            this.k4[i] = this.f4[i] + this.DFDX[i] * this.h * -0.0362 + this.k1[i] * -0.1073529058151375 / this.h + this.k2[i] * -9.594562251023355 / this.h + this.k3[i] * -20.47028614809616 / this.h;
            ++i;
        }
        MatrixOperations.lubksb(this.FAC, this.indx, this.k4);
        i = 0;
        while (i < this.numEqn) {
            this.yTemp[i] = this.y[i] + this.k1[i] * 1.221224509226641 + this.k2[i] * 6.019134481288629 + this.k3[i] * 12.53708332932087 + this.k4[i] * -0.687886036105895;
            ++i;
        }
        DES.computeDerivatives(this.t + this.h, this.yTemp, this.f5);
        i = 0;
        while (i < this.numEqn) {
            this.k5[i] = this.f5[i] + this.k1[i] * 7.496443313967647 / this.h + this.k2[i] * -10.24680431464352 / this.h + this.k3[i] * -33.99990352819905 / this.h + this.k4[i] * 11.7089089320616 / this.h;
            ++i;
        }
        MatrixOperations.lubksb(this.FAC, this.indx, this.k5);
        i = 0;
        while (i < this.numEqn) {
            int n = i;
            this.yTemp[n] = this.yTemp[n] + this.k5[i];
            ++i;
        }
        DES.computeDerivatives(this.t + this.h, this.yTemp, this.f6);
        i = 0;
        while (i < this.numEqn) {
            this.yerr[i] = this.f6[i] + this.k1[i] * 8.083246795921522 / this.h + this.k2[i] * -7.981132988064893 / this.h + this.k3[i] * -31.52159432874371 / this.h + this.k4[i] * 16.31930543123136 / this.h + this.k5[i] * -6.058818238834054 / this.h;
            ++i;
        }
        MatrixOperations.lubksb(this.FAC, this.indx, this.yerr);
        i = 0;
        while (i < this.numEqn) {
            this.yNew[i] = this.yTemp[i] + this.yerr[i];
            ++i;
        }
        i = 0;
        while (i < this.numEqn) {
            if (!this.ignoreNaN[i]) {
                this.sk = this.absTol + this.relTol * Math.max(Math.abs(this.y[i]), Math.abs(this.yNew[i]));
                largestError += Math.pow(this.yerr[i] / this.sk, 2.0);
                if (Double.isInfinite(this.yTemp[i]) || Double.isNaN(this.yTemp[i])) {
                    return -1.0;
                }
            }
            ++i;
        }
        largestError = Math.pow(largestError / (double)this.numEqn, 0.5);
        return largestError;
    }

    public double unitRoundoff() {
        double u = 1.0;
        double one_plus_u = 1.0 + u;
        while (one_plus_u != 1.0) {
            one_plus_u = 1.0 + (u /= 2.0);
        }
        return u *= 2.0;
    }

    public String getName() {
        return "Rosenbrock solver";
    }

    public int getNumEquations() {
        return this.numEqn;
    }

    public double[] computeChange(DESystem DES, double[] y2, double time, double currentStepSize, double[] change, boolean steadyState) throws DerivativeException {
        EventDESystem EDES;
        if (this.y == null || this.y.length == 0 || this.y.length != y2.length) {
            this.init(DES.getDimension(), this.getStepSize(), 2);
        }
        this.hMax = currentStepSize;
        boolean hasDerivatives = true;
        if (DES instanceof EventDESystem && (EDES = (EventDESystem)DES).getNoDerivatives()) {
            hasDerivatives = false;
        }
        double timeEnd = BigDecimal.valueOf(time).add(BigDecimal.valueOf(currentStepSize)).doubleValue();
        try {
            double localError = 0.0;
            int solutionIndex = 0;
            boolean lastStepSuccessful = false;
            double eps = this.unitRoundoff();
            double relMin = 2.0 * eps + 1.0E-12;
            if (this.relTol < relMin) {
                this.relTol = relMin;
            }
            this.timePoints[0] = this.t = time;
            if (this.y.length != y2.length) {
                this.y = (double[])y2.clone();
                this.ignoreNaN = new boolean[this.y.length];
            } else {
                System.arraycopy(y2, 0, this.y, 0, this.y.length);
            }
            int i = 0;
            while (i != this.y.length) {
                this.ignoreNaN[i] = Double.isInfinite(this.y[i]) || Double.isNaN(this.y[i]);
                ++i;
            }
            this.h = this.hMax;
            this.stop = false;
            while (!this.stop) {
                if (lastStepSuccessful && Math.abs(this.timePoints[solutionIndex] - this.t) >= Math.abs(currentStepSize)) {
                    this.timePoints[++solutionIndex] = this.t;
                }
                if (this.t >= timeEnd) {
                    if (DES instanceof EventDESystem) {
                        EventDESystem EDES2 = (EventDESystem)DES;
                        if (EDES2.getEventCount() > 0 && !steadyState || EDES2.getRuleCount() > 0) {
                            this.processEventsAndRules(true, EDES2, timeEnd, this.t - this.h, this.yTemp);
                        }
                        System.arraycopy(this.yTemp, 0, this.y, 0, this.numEqn);
                    }
                    Mathematics.vvSub(this.y, y2, change);
                    break;
                }
                System.arraycopy(this.y, 0, this.yTemp, 0, this.numEqn);
                try {
                    localError = hasDerivatives ? this.step(DES) : 0.0;
                }
                catch (Exception ex) {
                    this.stop = true;
                }
                if (!Double.isNaN(localError) && localError != -1.0 && localError <= 1.0 && !this.stop) {
                    EventDESystem EDES3;
                    this.setUnstableFlag(false);
                    System.arraycopy(this.y, 0, this.oldY, 0, this.numEqn);
                    System.arraycopy(this.yTemp, 0, this.y, 0, this.numEqn);
                    boolean changed = false;
                    double newTime = BigDecimal.valueOf(this.t).add(BigDecimal.valueOf(this.h)).doubleValue();
                    if (DES instanceof EventDESystem && !steadyState && ((EDES3 = (EventDESystem)DES).getEventCount() > 0 || EDES3.getRuleCount() > 0)) {
                        changed = this.processEventsAndRules(true, EDES3, Math.min(newTime, timeEnd), this.t, this.yTemp);
                    }
                    if (changed) {
                        if (this.h > 1.0E-7) {
                            this.h = Math.max(this.h / 10.0, 1.0E-7);
                            if (this.h - 1.0E-7 < 1.0E-7) {
                                this.h = 1.0E-7;
                            }
                            System.arraycopy(this.oldY, 0, this.y, 0, this.numEqn);
                        } else {
                            System.arraycopy(this.yTemp, 0, this.y, 0, this.numEqn);
                            this.t = Math.min(newTime, timeEnd);
                            if (timeEnd - this.t - this.h < this.hMin) {
                                this.h = timeEnd - this.t;
                            }
                            lastStepSuccessful = true;
                        }
                    } else {
                        this.t = Math.min(newTime, timeEnd);
                        this.hAdap = Math.max(0.16666666666666666, Math.min(5.0, Math.pow(localError, 0.25) / 0.9));
                        this.h /= this.hAdap;
                        if (timeEnd - this.t - this.h < this.hMin) {
                            this.h = timeEnd - this.t;
                        }
                        lastStepSuccessful = true;
                    }
                } else {
                    double tNew;
                    if (Math.abs(this.h) <= Math.abs(this.hMin)) {
                        throw new DerivativeException("Requested tolerance could not be achieved, even at the minumum stepsize.  Please increase the tolerance or decrease the minimum stepsize.", new Object[0]);
                    }
                    this.hAdap = Double.isNaN(localError) || localError == -1.0 || this.stop ? 2.0 : Math.max(0.16666666666666666, Math.min(5.0, Math.pow(localError, 0.25) / 0.9));
                    this.h /= this.hAdap;
                    if (timeEnd - this.t - this.h < this.hMin) {
                        this.h = timeEnd - this.t;
                    }
                    if ((tNew = this.t + this.h) == this.t) {
                        throw new DerivativeException("Stepsize underflow in Rosenbrock solver", new Object[0]);
                    }
                    lastStepSuccessful = false;
                }
                if (Math.abs(this.h) < this.hMin) {
                    this.h = this.hMin;
                } else if (Math.abs(this.h) > this.hMax) {
                    this.h = this.hMax;
                }
                this.stop = false;
            }
        }
        catch (OutOfMemoryError e) {
            throw new DerivativeException("Out of memory : try reducing solve span or increasing step size.", new Object[0]);
        }
        return change;
    }

    protected boolean hasSolverEventProcessing() {
        return true;
    }
}

