/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.math.odes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTable
extends AbstractTableModel
implements Iterable<Iterable<Double>> {
    private static final String ONLY_DOUBLE_VALUES_ACCEPTED = "only double values are accepted as arguments";
    private static final long serialVersionUID = 1853070398348919488L;
    private static final String UNEQUAL_COLUMNS_AND_IDENTIFIERS = "unequal number of %d columns and %d identifiers in the data matrix";
    private static final String UNEQUAL_DATA_AND_TIME_POINTS = "unequal number of %d data rows and %d time points";
    private List<Block> listOfBlocks = new LinkedList<Block>();
    private String name;
    private String timeName = "Time";
    private double[] timePoints;

    public static long getSerialversionuid() {
        return 1853070398348919488L;
    }

    public MultiTable() {
    }

    public MultiTable(double[] timePoints, double[][] data, String[] identifiers) {
        this(timePoints, data, identifiers, null);
    }

    public MultiTable(double[] timePoints, double[][] data, String[] columnIdentifiers, String[] columnNames) {
        this();
        String[] ids;
        this.setTimePoints(timePoints);
        if (columnIdentifiers.length == data[0].length + 1) {
            this.setTimeName(columnIdentifiers[0]);
            ids = new String[columnIdentifiers.length - 1];
            System.arraycopy(columnIdentifiers, 1, ids, 0, ids.length);
        } else {
            ids = columnIdentifiers;
        }
        String[] names = columnNames;
        if (columnNames != null && columnNames.length == data[0].length + 1) {
            this.setTimeName(columnNames[0]);
            names = new String[columnNames.length - 1];
            System.arraycopy(columnNames, 1, names, 0, names.length);
        }
        this.listOfBlocks.add(new Block(data, ids, names, this));
    }

    public void addBlock(String[] identifiers) {
        Block block = new Block(this);
        block.setIdentifiers(identifiers);
        if (this.isSetTimePoints()) {
            block.setData(new double[this.timePoints.length][identifiers.length]);
        }
        this.listOfBlocks.add(block);
    }

    public MultiTable filter(double[] timepoints) {
        ArrayList<Integer> rowIndices = new ArrayList<Integer>();
        int i = 0;
        Object object = timepoints;
        int n = timepoints.length;
        int n2 = 0;
        while (n2 < n) {
            double time = object[n2];
            while (i < this.getTimePoints().length && this.getTimePoints()[i] <= time) {
                if (this.getTimePoints()[i] == time) {
                    rowIndices.add(i);
                }
                ++i;
            }
            ++n2;
        }
        MultiTable filtered = new MultiTable();
        int block = 0;
        while (block != this.getBlockCount()) {
            filtered.addBlock(this.getBlock(block).getIdentifiers());
            filtered.getBlock(block).setData(new double[rowIndices.size()][this.getBlock(block).getIdentifiers().length]);
            int rowCounter = 0;
            object = rowIndices.iterator();
            while (object.hasNext()) {
                int rowIndex = (Integer)object.next();
                filtered.getBlock(block).setRowData(rowCounter, this.getBlock(block).getRow(rowIndex));
                ++rowCounter;
            }
            ++block;
        }
        return filtered;
    }

    public Block getBlock(int index) {
        return this.listOfBlocks.get(index);
    }

    public int getBlockCount() {
        return this.getNumBlocks();
    }

    public Block.Column getColumn(int column) {
        if (column > this.getColumnCount()) {
            throw new IndexOutOfBoundsException(Integer.toString(column));
        }
        if (column == 0) {
            throw new IllegalArgumentException("no column 0: use getTimePoints()");
        }
        int index = column - 1;
        int bidx = 0;
        Block b = this.listOfBlocks.get(bidx);
        while (index >= b.getColumnCount()) {
            index -= b.getColumnCount();
            b = this.listOfBlocks.get(++bidx);
        }
        return b.getColumn(index);
    }

    public Block.Column getColumn(String identifier) {
        int index = this.getColumnIndex(identifier);
        return index > -1 ? this.getColumn(index) : null;
    }

    public int getColumnIndex(String identifier) {
        int i = 1;
        while (i < this.getColumnCount()) {
            String id = this.getColumnIdentifier(i);
            if (id.equals(identifier)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Class<Double> getColumnClass(int columnIndex) {
        return Double.class;
    }

    @Override
    public int getColumnCount() {
        int count = 0;
        if (this.isSetTimePoints()) {
            ++count;
        }
        for (Block b : this.listOfBlocks) {
            count += b.getColumnCount();
        }
        return count;
    }

    public String getColumnIdentifier(int column) {
        if (column > this.getColumnCount()) {
            throw new IndexOutOfBoundsException(Integer.toString(column));
        }
        if (column == 0) {
            return this.getTimeName();
        }
        return this.getColumn(column).getId();
    }

    @Override
    public String getColumnName(int column) {
        if (column > this.getColumnCount()) {
            throw new IndexOutOfBoundsException(Integer.toString(column));
        }
        if (column == 0) {
            return this.getTimeName();
        }
        return this.getColumn(column).getColumnName();
    }

    public String getName() {
        return this.name;
    }

    public int getNumBlocks() {
        return this.listOfBlocks.size();
    }

    @Override
    public int getRowCount() {
        return this.isSetTimePoints() ? this.timePoints.length : 0;
    }

    public String getTimeName() {
        return this.timeName;
    }

    public double getTimePoint(int rowIndex) {
        return this.timePoints[rowIndex];
    }

    public double[] getTimePoints() {
        return this.timePoints;
    }

    @Override
    public Double getValueAt(int rowIndex, int columnIndex) {
        return columnIndex == 0 ? this.timePoints[rowIndex] : this.getColumn(columnIndex).getValue(rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public boolean isSetTimePoints() {
        return this.timePoints != null;
    }

    @Override
    public Iterator<Iterable<Double>> iterator() {
        return new Iterator<Iterable<Double>>(){
            private int currCol = 0;

            @Override
            public boolean hasNext() {
                return this.currCol < MultiTable.this.getColumnCount() - 1;
            }

            @Override
            public Iterable<Double> next() {
                return MultiTable.this.getColumn(this.currCol++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("this iterator does not remove anything.");
            }
        };
    }

    public void removeBlock(int index) {
        this.listOfBlocks.remove(index);
    }

    public void setName(String name) {
        this.name = new String(name);
    }

    public void setTimeName(String timeName) {
        this.timeName = timeName;
    }

    public void setTimePoints(double[] timePoints) {
        if (this.listOfBlocks.size() > 0 && this.listOfBlocks.get(0).getRowCount() != timePoints.length) {
            throw new IllegalArgumentException(String.format(UNEQUAL_DATA_AND_TIME_POINTS, this.listOfBlocks.get(0).getRowCount(), timePoints.length));
        }
        this.timePoints = timePoints;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!(aValue instanceof Double)) {
            throw new IllegalArgumentException(ONLY_DOUBLE_VALUES_ACCEPTED);
        }
        if (columnIndex == 0) {
            this.timePoints[rowIndex] = (Double)aValue;
        } else {
            this.getColumn(columnIndex).setValue((Double)aValue, rowIndex);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.getTimeName());
        sb.append("] [");
        int i = 0;
        while (i < this.timePoints.length) {
            sb.append(this.timePoints[i]);
            if (i < this.timePoints.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(']');
        for (Block b : this.listOfBlocks) {
            sb.append(", ");
            sb.append(b.toString());
        }
        return sb.toString();
    }

    public class Block
    extends AbstractTableModel {
        private static final long serialVersionUID = -6797479340761921075L;
        private String blockName;
        private String[] columnNames;
        private double[][] data;
        private String[] identifiers;
        private Hashtable<String, Integer> idHash;
        private MultiTable parent;

        private Block(double[][] data, String[] identifiers, MultiTable parent) {
            this(data, identifiers, null, parent);
        }

        private Block(double[][] data, String[] identifiers, String[] names, MultiTable parent) {
            this(parent);
            this.setData(data);
            this.setIdentifiers(identifiers);
            this.setColumnNames(names);
        }

        private Block(MultiTable parent) {
            this.parent = parent;
            this.idHash = new Hashtable();
        }

        public boolean containsColumn(String id) {
            return this.idHash.containsKey(id);
        }

        public Column getColumn(int columnIndex) {
            return new Column(columnIndex);
        }

        public Column getColumn(String identfier) {
            return new Column(this.idHash.get(identfier));
        }

        public int getColumnCount() {
            return this.identifiers.length;
        }

        public String getColumnIdentifier(int column) {
            return this.identifiers[column];
        }

        public String getColumnName(int column) {
            return this.columnNames == null || this.columnNames[column] == null ? this.getColumnIdentifier(column) : this.columnNames[column];
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public double[][] getData() {
            return this.data;
        }

        public String[] getIdentifiers() {
            return this.identifiers;
        }

        public String getName() {
            return this.blockName;
        }

        public double[] getRow(int rowIndex) {
            return this.data[rowIndex];
        }

        public int getRowCount() {
            return MultiTable.this.isSetTimePoints() ? MultiTable.this.timePoints.length : 0;
        }

        public double[] getTimePoints() {
            return this.parent.getTimePoints();
        }

        public Double getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return MultiTable.this.getTimePoint(rowIndex);
            }
            return this.data[rowIndex][columnIndex - 1];
        }

        public boolean isSetData() {
            return this.data != null;
        }

        public void setColumnNames(String[] columnNames) {
            this.columnNames = columnNames;
        }

        public void setData(double[][] data) {
            if (MultiTable.this.isSetTimePoints() && data.length != this.getRowCount()) {
                throw new IllegalArgumentException(String.format(MultiTable.UNEQUAL_DATA_AND_TIME_POINTS, data.length, MultiTable.this.timePoints.length));
            }
            this.data = data;
        }

        public void setIdentifiers(String[] identifiers) {
            if (this.isSetData() && identifiers.length != this.data[0].length) {
                throw new IllegalArgumentException(String.format(MultiTable.UNEQUAL_COLUMNS_AND_IDENTIFIERS, this.data[0].length, identifiers.length));
            }
            this.identifiers = identifiers;
            this.idHash.clear();
            int i = 0;
            while (i < this.identifiers.length) {
                this.idHash.put(this.identifiers[i], i);
                ++i;
            }
        }

        public void setName(String name) {
            this.blockName = name;
        }

        public void setRowData(int rowIndex, double[] array) {
            if (array.length != this.getColumnCount()) {
                throw new IllegalArgumentException(String.format(MultiTable.UNEQUAL_COLUMNS_AND_IDENTIFIERS, array.length, this.identifiers.length));
            }
            this.data[rowIndex] = array;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (!(aValue instanceof Double)) {
                throw new IllegalArgumentException(MultiTable.ONLY_DOUBLE_VALUES_ACCEPTED);
            }
            if (columnIndex == 0) {
                ((MultiTable)MultiTable.this).timePoints[rowIndex] = (Double)aValue;
            } else {
                this.data[rowIndex][columnIndex - 1] = (Double)aValue;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(Arrays.toString(this.getIdentifiers()));
            if (this.isSetData()) {
                sb.append(", ");
                int i = 0;
                while (i < this.getRowCount()) {
                    sb.append(Arrays.toString(this.getRow(i)));
                    if (i < this.getRowCount() - 1) {
                        sb.append(", ");
                    }
                    ++i;
                }
            } else {
                sb.append("[]");
            }
            sb.append(']');
            return sb.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Column
        implements Iterable<Double> {
            private int columnIndex;

            private Column(int columnIndex) {
                if (columnIndex < 0 || Block.this.getColumnCount() <= columnIndex) {
                    throw new IndexOutOfBoundsException(Integer.toString(columnIndex));
                }
                this.columnIndex = columnIndex;
            }

            public String getColumnName() {
                return Block.this.columnNames != null && Block.this.columnNames[this.columnIndex] != null ? Block.this.columnNames[this.columnIndex] : this.getId();
            }

            public String getId() {
                return Block.this.identifiers[this.columnIndex];
            }

            public String getName() {
                return Block.this.columnNames[this.columnIndex];
            }

            public int getRowCount() {
                return Block.this.data.length;
            }

            public double getValue(int rowIndex) {
                return Block.this.data[rowIndex][this.columnIndex];
            }

            @Override
            public Iterator<Double> iterator() {
                return new Iterator<Double>(){
                    private int currRow = 0;

                    @Override
                    public boolean hasNext() {
                        return this.currRow < Column.this.getRowCount();
                    }

                    @Override
                    public Double next() {
                        return Column.this.getValue(this.currRow++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("cannot remove anything from the underlying object");
                    }
                };
            }

            public void setValue(double doubleValue, int rowIndex) {
                ((Block)Block.this).data[rowIndex][this.columnIndex] = doubleValue;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append('[');
                int i = 0;
                while (i < this.getRowCount()) {
                    sb.append(this.getValue(i));
                    if (i < this.getRowCount() - 1) {
                        sb.append(", ");
                    }
                    ++i;
                }
                sb.append(']');
                return sb.toString();
            }
        }
    }
}

