/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.math.odes;

import org.apache.commons.math.ode.nonstiff.HighamHall54Integrator;
import org.simulator.math.odes.FirstOrderSolver;

public class HighamHall54Solver
extends FirstOrderSolver {
    private static final long serialVersionUID = -2601862472447650296L;

    public HighamHall54Solver() {
        this.absTol = 0.5;
        this.relTol = 0.01;
    }

    public HighamHall54Solver(double stepSize) {
        super(stepSize);
        this.absTol = 0.5;
        this.relTol = 0.01;
    }

    public HighamHall54Solver(double stepSize, boolean nonnegative) {
        super(stepSize, nonnegative);
        this.absTol = 0.5;
        this.relTol = 0.01;
    }

    public HighamHall54Solver(HighamHall54Solver solver) {
        super(solver);
        this.integrator = solver.getIntegrator();
    }

    public HighamHall54Solver clone() {
        return new HighamHall54Solver(this);
    }

    protected void createIntegrator() {
        this.integrator = new HighamHall54Integrator(Math.min(1.0E-8, Math.min(1.0, this.getStepSize())), Math.min(1.0, this.getStepSize()), this.getAbsTol(), this.getRelTol());
    }

    public String getName() {
        return "Higham-Hall 54 solver";
    }
}

