/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.math.odes;

import java.util.logging.Logger;
import org.apache.commons.math.ode.AbstractIntegrator;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math.ode.events.EventHandler;
import org.apache.commons.math.util.FastMath;
import org.simulator.math.Mathematics;
import org.simulator.math.odes.AdaptiveStepsizeIntegrator;
import org.simulator.math.odes.DESystem;

public abstract class FirstOrderSolver
extends AdaptiveStepsizeIntegrator {
    private static final long serialVersionUID = -2671266540106066022L;
    private static final Logger logger = Logger.getLogger(FirstOrderSolver.class.getName());
    private double[] integrationResult;
    protected AbstractIntegrator integrator;

    public void setStepSize(double stepSize) {
        super.setStepSize(stepSize);
        this.createIntegrator();
    }

    public FirstOrderSolver() {
        this.createIntegrator();
        this.addHandler();
    }

    public FirstOrderSolver(double stepSize) {
        super(stepSize);
        this.createIntegrator();
        this.addHandler();
    }

    public FirstOrderSolver(double stepSize, boolean nonnegative) {
        super(stepSize, nonnegative);
        this.createIntegrator();
        this.addHandler();
    }

    public FirstOrderSolver(FirstOrderSolver firstOrderSolver) {
        super(firstOrderSolver);
        this.createIntegrator();
        this.addHandler();
    }

    private void addHandler() {
        this.integrator.addEventHandler((EventHandler)this, 1.0, 1.0, 1);
    }

    public abstract FirstOrderSolver clone();

    public double[] computeChange(DESystem DES, double[] y, double t, double stepSize, double[] change, boolean steadyState) throws DerivativeException {
        double tend;
        double tstart;
        if (this.integrationResult == null || this.integrationResult.length != y.length) {
            this.integrationResult = new double[y.length];
        }
        if (FastMath.abs((double)((tstart = t) - (tend = t + stepSize))) <= 1.0E-12 * FastMath.max((double)FastMath.abs((double)tstart), (double)FastMath.abs((double)tend))) {
            int i = 0;
            while (i != change.length) {
                change[i] = 0.0;
                ++i;
            }
        } else {
            try {
                this.integrator.integrate((FirstOrderDifferentialEquations)DES, tstart, y, tend, this.integrationResult);
                Mathematics.vvSub(this.integrationResult, y, change);
            }
            catch (Exception e) {
                this.setUnstableFlag(true);
                logger.fine(e.getLocalizedMessage());
            }
        }
        return change;
    }

    protected abstract void createIntegrator();

    public AbstractIntegrator getIntegrator() {
        return this.integrator;
    }

    protected boolean hasSolverEventProcessing() {
        return false;
    }
}

