/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.math.odes;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventInProgress {
    protected boolean fired;
    protected double lastTimeFired;
    protected double lastTimeRecovered;
    protected double lastTimeExecuted;
    protected LinkedList<Double> execTimes;
    protected LinkedList<Double[]> values;
    protected Map<Integer, Double> assignments;

    public EventInProgress(boolean fired) {
        this.fired = fired;
        this.execTimes = new LinkedList();
        this.values = new LinkedList();
        this.lastTimeFired = -1.0;
        this.lastTimeRecovered = -1.0;
        this.lastTimeExecuted = -1.0;
        this.assignments = new HashMap<Integer, Double>();
    }

    public void refresh(boolean fired) {
        this.fired = fired;
        this.execTimes = new LinkedList();
        this.values = new LinkedList();
        this.lastTimeFired = -1.0;
        this.lastTimeRecovered = -1.0;
        this.lastTimeExecuted = -1.0;
        this.assignments = new HashMap<Integer, Double>();
    }

    public void aborted(double time) {
        this.executed(time);
    }

    public void addValues(Double[] values, double time) {
        this.execTimes.add(time);
        this.values.add(values);
    }

    public void executed(double time) {
        this.execTimes.poll();
        this.values.poll();
        this.lastTimeExecuted = time;
    }

    public void fired(double time) {
        this.fired = true;
        this.lastTimeFired = time;
    }

    public boolean getFireStatus(double time) {
        if (this.lastTimeFired <= time && this.lastTimeRecovered <= time) {
            return this.fired;
        }
        if (this.lastTimeFired <= time && this.lastTimeRecovered > time) {
            this.lastTimeRecovered = -1.0;
            this.fired = true;
            return true;
        }
        if (this.lastTimeFired > time && this.lastTimeRecovered <= time) {
            this.lastTimeFired = -1.0;
            this.fired = false;
            return false;
        }
        this.lastTimeRecovered = -1.0;
        this.lastTimeFired = -1.0;
        return this.fired;
    }

    public double getTime() {
        return this.execTimes.peek();
    }

    public boolean hasExecutionTime() {
        return this.execTimes.peek() != null;
    }

    public Double[] getValues() {
        return this.values.peek();
    }

    public void recovered(double time) {
        this.fired = false;
        this.lastTimeRecovered = time;
    }

    public boolean hasMoreAssignments(double time) {
        if (this.execTimes.isEmpty()) {
            return false;
        }
        return this.execTimes.peek() <= time;
    }

    public double getLastTimeFired() {
        return this.lastTimeFired;
    }

    public double getLastTimeExecuted() {
        return this.lastTimeExecuted;
    }

    public void refresh(double currentTime) {
    }

    public void clearAssignments() {
        this.assignments.clear();
    }

    public void addAssignment(int index, double value) {
        this.assignments.put(index, value);
    }

    public Map<Integer, Double> getAssignments() {
        return this.assignments;
    }
}

