/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.math.odes;

import org.apache.commons.math.ode.DerivativeException;
import org.simulator.math.Mathematics;
import org.simulator.math.odes.AbstractDESSolver;
import org.simulator.math.odes.DESystem;

public class EulerMethod
extends AbstractDESSolver {
    private static final long serialVersionUID = 9094797527506196715L;

    public EulerMethod() {
    }

    public EulerMethod(double stepSize) {
        super(stepSize);
    }

    public EulerMethod(double stepSize, boolean nonnegative) {
        super(stepSize, nonnegative);
    }

    public EulerMethod(EulerMethod eulerMethod) {
        super(eulerMethod);
    }

    public String getName() {
        return "Euler's method";
    }

    public double[] computeChange(DESystem DES, double[] yPrev, double t, double stepSize, double[] change, boolean steadyState) throws DerivativeException {
        DES.computeDerivatives(t, yPrev, change);
        Mathematics.scale(stepSize, change);
        return change;
    }

    public EulerMethod clone() {
        return new EulerMethod(this);
    }

    protected boolean hasSolverEventProcessing() {
        return false;
    }
}

