/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.math.odes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.events.EventException;
import org.apache.commons.math.ode.events.EventHandler;
import org.simulator.math.Mathematics;
import org.simulator.math.odes.DESSolver;
import org.simulator.math.odes.DESystem;
import org.simulator.math.odes.DelayValueHolder;
import org.simulator.math.odes.DelayedDESystem;
import org.simulator.math.odes.EventDESystem;
import org.simulator.math.odes.EventInProgress;
import org.simulator.math.odes.FastProcessDESystem;
import org.simulator.math.odes.MultiTable;
import org.simulator.math.odes.RichDESystem;

public abstract class AbstractDESSolver
implements DelayValueHolder,
DESSolver,
EventHandler {
    private static final transient Logger logger = Logger.getLogger(AbstractDESSolver.class.getName());
    private static final long serialVersionUID = 1859418461410763939L;
    private boolean includeIntermediates = true;
    private double intervalFactor = 0.0;
    List<PropertyChangeListener> listenerList = new LinkedList<PropertyChangeListener>();
    private boolean nonnegative = false;
    private double stepSize = 0.01;
    private boolean unstableFlag = false;
    private MultiTable data;

    public static long getSerialversionuid() {
        return 1859418461410763939L;
    }

    public AbstractDESSolver() {
    }

    public void reset() {
        this.stepSize = 0.01;
        this.nonnegative = false;
        this.unstableFlag = false;
        this.includeIntermediates = true;
        this.intervalFactor = 0.0;
        this.listenerList = new LinkedList<PropertyChangeListener>();
    }

    public AbstractDESSolver(AbstractDESSolver solver) {
        this(solver.getStepSize(), solver.isNonnegative());
        this.setIncludeIntermediates(solver.isIncludeIntermediates());
        this.unstableFlag = solver.isUnstable();
    }

    public AbstractDESSolver(double stepSize) {
        this();
        this.setStepSize(stepSize);
    }

    public AbstractDESSolver(double stepSize, boolean nonnegative) {
        this(stepSize);
        this.setNonnegative(nonnegative);
    }

    protected void additionalResults(DESystem DES, double t, double[] yTemp, MultiTable data, int rowIndex) throws DerivativeException {
        if (this.includeIntermediates && DES instanceof RichDESystem) {
            MultiTable.Block block = data.getBlock(1);
            double[] v = ((RichDESystem)DES).getAdditionalValues(t, yTemp);
            block.setRowData(rowIndex, (double[])v.clone());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    private void checkNonNegativity(double[] yTemp) {
        if (this.nonnegative) {
            int k = 0;
            while (k < yTemp.length) {
                if (yTemp[k] < 0.0) {
                    yTemp[k] = 0.0;
                }
                ++k;
            }
        }
    }

    boolean checkSolution(double[] currentState) {
        int k = 0;
        while (k < currentState.length) {
            if (Double.isNaN(currentState[k])) {
                this.unstableFlag = true;
                currentState[k] = 0.0;
            }
            ++k;
        }
        return !this.unstableFlag;
    }

    boolean checkSolution(double[] currentChange, double[] yPrev) {
        int k = 0;
        while (k < currentChange.length) {
            if (Double.isNaN(currentChange[k])) {
                if (!Double.isNaN(yPrev[k]) && !Double.isInfinite(yPrev[k])) {
                    this.unstableFlag = true;
                } else if (Double.isInfinite(yPrev[k])) {
                    currentChange[k] = 0.0;
                }
            }
            ++k;
        }
        return !this.unstableFlag;
    }

    public abstract AbstractDESSolver clone();

    public abstract double[] computeChange(DESystem var1, double[] var2, double var3, double var5, double[] var7, boolean var8) throws DerivativeException;

    public double computeDelayedValue(double time, String id) {
        double[] timepoints = this.data.getTimePoints();
        int leftIndex = -1;
        int rightIndex = -1;
        int i = 0;
        while (i != timepoints.length) {
            if (timepoints[i] >= time) {
                rightIndex = i;
                if (i <= 0 || !(timepoints[i] > time)) break;
                leftIndex = i - 1;
                break;
            }
            ++i;
        }
        if (leftIndex == -1 && rightIndex == -1) {
            leftIndex = timepoints.length - 1;
        }
        double leftValue = Double.NaN;
        double rightValue = Double.NaN;
        MultiTable.Block.Column c = this.data.getColumn(id);
        if (leftIndex != -1) {
            leftValue = c.getValue(leftIndex);
        }
        if (rightIndex != -1) {
            rightValue = c.getValue(rightIndex);
        }
        if (leftIndex == -1) {
            return rightValue;
        }
        if (rightIndex == -1) {
            return leftValue;
        }
        return leftValue + (rightValue - leftValue) * ((time - timepoints[leftIndex]) / (timepoints[rightIndex] - timepoints[leftIndex]));
    }

    double computeNextState(DESystem DES, double t, double stepSize, double[] yPrev, double[] change, double[] yTemp, boolean increase, boolean steadyState) throws DerivativeException {
        double previousTime = t;
        this.computeChange(DES, yPrev, t, stepSize, change, steadyState);
        this.checkSolution(change, yPrev);
        Mathematics.vvAdd(yPrev, change, yTemp);
        this.checkNonNegativity(yTemp);
        if (increase) {
            t = BigDecimal.valueOf(stepSize).add(BigDecimal.valueOf(t)).doubleValue();
        }
        this.processEventsAndRules(false, DES, t, previousTime, yTemp);
        return t;
    }

    private double[] computeSteadyState(FastProcessDESystem DES, double[] result, double timeBegin) throws DerivativeException {
        double[] oldValues = new double[result.length];
        double[] newValues = new double[result.length];
        double[] change = new double[result.length];
        System.arraycopy(result, 0, newValues, 0, result.length);
        double ft = timeBegin;
        DES.setFastProcessComputation(true);
        while (!this.noChange(oldValues, newValues)) {
            System.arraycopy(newValues, 0, oldValues, 0, newValues.length);
            ft = this.computeNextState(DES, ft, this.stepSize, oldValues, change, newValues, true, true);
        }
        DES.setFastProcessComputation(false);
        return oldValues;
    }

    public int eventOccurred(double t, double[] y, boolean increasing) throws EventException {
        return 0;
    }

    public void firePropertyChange(double oldValue, double newValue) {
        if (!this.listenerList.isEmpty()) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, "progress", oldValue, newValue);
            for (PropertyChangeListener listener : this.listenerList) {
                listener.propertyChange(evt);
            }
        }
    }

    public double g(double t, double[] y) throws EventException {
        if (Double.isNaN(t)) {
            return -1.0;
        }
        return this.checkSolution(y) ? 1.0 : -1.0;
    }

    public abstract String getName();

    public double getStepSize() {
        return this.stepSize;
    }

    protected abstract boolean hasSolverEventProcessing();

    public int inBetweenSteps(double lastTime, double nextTime, double stepSize) {
        return (int)Math.floor((nextTime - lastTime) / stepSize);
    }

    protected MultiTable initResultMatrix(DESystem DES, double[] initialValues, double timeBegin, double timeEnd) {
        return this.initResultMatrix(DES, initialValues, timeBegin, this.numSteps(timeBegin, timeEnd));
    }

    protected MultiTable initResultMatrix(DESystem DES, double[] initialValues, double timeBegin, int numSteps) {
        int dim = DES.getDimension();
        if (dim != initialValues.length) {
            throw new IllegalArgumentException("The number of initial values must equal the dimension of the DE system.");
        }
        double[] timePoints = new double[numSteps];
        int i = 0;
        while (i < timePoints.length) {
            timePoints[i] = BigDecimal.valueOf(timeBegin).add(BigDecimal.valueOf(i).multiply(BigDecimal.valueOf(this.stepSize))).doubleValue();
            ++i;
        }
        return this.initResultMatrix(DES, initialValues, timePoints);
    }

    protected MultiTable initResultMatrix(DESystem DES, double[] initialValues, double[] timePoints) {
        double[][] result = new double[timePoints.length][initialValues.length];
        System.arraycopy(initialValues, 0, result[0], 0, initialValues.length);
        this.data = new MultiTable(timePoints, result, DES.getIdentifiers());
        this.data.getBlock(0).setName("Values");
        if (this.includeIntermediates && DES instanceof RichDESystem) {
            this.data.addBlock(((RichDESystem)DES).getAdditionalValueIds());
            this.data.getBlock(this.data.getBlockCount() - 1).setName("Additional values");
        }
        this.unstableFlag = false;
        return this.data;
    }

    public boolean isIncludeIntermediates() {
        return this.includeIntermediates;
    }

    public boolean isNonnegative() {
        return this.nonnegative;
    }

    public boolean isUnstable() {
        return this.unstableFlag;
    }

    private boolean noChange(double[] newValues, double[] oldValues) {
        int i = 0;
        while (i < newValues.length) {
            double distance = Math.abs(newValues[i] - oldValues[i]);
            if (distance > 1.0E-12) {
                return false;
            }
            ++i;
        }
        return true;
    }

    int numSteps(double timeBegin, double timeEnd) {
        if (timeBegin > timeEnd) {
            throw new IllegalArgumentException("End time point must be greater than start time point.");
        }
        return (int)Math.round((timeEnd - timeBegin) / this.stepSize + 1.0);
    }

    public boolean processEvents(EventDESystem EDES, double time, double previousTime, double[] yTemp) throws DerivativeException {
        boolean hasNewEvents = false;
        EventInProgress event = EDES.getNextEventAssignments(time, previousTime, yTemp);
        if (event != null) {
            hasNewEvents = true;
        }
        while (event != null && (event.getLastTimeExecuted() == time || event.getFireStatus(time))) {
            for (int index : event.getAssignments().keySet()) {
                yTemp[index] = event.getAssignments().get(index);
            }
            event = EDES.getNextEventAssignments(time, previousTime, yTemp);
        }
        return hasNewEvents;
    }

    public boolean processEventsAndRules(boolean forceProcessing, DESystem DES, double t, double previousTime, double[] yTemp) throws DerivativeException {
        boolean change = false;
        if (DES instanceof EventDESystem) {
            EventDESystem EDES = (EventDESystem)DES;
            if (EDES.getRuleCount() > 0) {
                this.processRules(EDES, t, yTemp);
            }
            if ((forceProcessing || !this.hasSolverEventProcessing()) && EDES.getEventCount() > 0) {
                change = this.processEvents(EDES, t, previousTime, yTemp);
            }
            if (EDES.getRuleCount() > 0) {
                this.processRules(EDES, t, yTemp);
            }
        }
        return change;
    }

    public boolean processRules(EventDESystem EDES, double time, double[] Ytemp) throws DerivativeException {
        return EDES.processAssignmentRules(time, Ytemp);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listenerList.contains(listener)) {
            this.listenerList.remove(listener);
        }
    }

    public void resetState(double t, double[] y) throws EventException {
    }

    public void setIncludeIntermediates(boolean includeIntermediates) {
        this.includeIntermediates = includeIntermediates;
    }

    public void setNonnegative(boolean nonnegative) {
        this.nonnegative = nonnegative;
    }

    public void setStepSize(double stepSize) {
        if (stepSize < Double.MIN_VALUE) {
            throw new IllegalArgumentException("The integration step size must be a positive, non-zero value.");
        }
        this.stepSize = stepSize;
    }

    public void setUnstableFlag(boolean unstableFlag) {
        this.unstableFlag = unstableFlag;
    }

    public MultiTable solve(DESystem DES, double[] initialValues, double timeBegin, double timeEnd) throws DerivativeException {
        if (DES instanceof DelayedDESystem) {
            ((DelayedDESystem)DES).registerDelayValueHolder(this);
        }
        this.intervalFactor = 100.0 / (timeEnd - timeBegin);
        MultiTable data = this.initResultMatrix(DES, initialValues, timeBegin, timeEnd);
        double[][] result = data.getBlock(0).getData();
        double[] change = new double[initialValues.length];
        double[] yTemp = new double[initialValues.length];
        double[] yPrev = new double[initialValues.length];
        double t = timeBegin;
        this.additionalResults(DES, t, result[0], data, 0);
        boolean fastFlag = false;
        if (DES instanceof FastProcessDESystem) {
            fastFlag = ((FastProcessDESystem)DES).containsFastProcesses();
        }
        if (fastFlag) {
            result[0] = this.computeSteadyState((FastProcessDESystem)DES, result[0], timeBegin);
        }
        this.processEvents((EventDESystem)DES, 0.0, 0.0, result[0]);
        System.arraycopy(result[0], 0, yTemp, 0, yTemp.length);
        int i = 1;
        while (i < result.length && !Thread.currentThread().isInterrupted()) {
            double oldT = t;
            System.arraycopy(yTemp, 0, yPrev, 0, yTemp.length);
            t = this.computeNextState(DES, t, this.stepSize, yPrev, change, yTemp, true, false);
            System.arraycopy(yTemp, 0, result[i], 0, yTemp.length);
            if (i == 1) {
                System.arraycopy(yPrev, 0, result[0], 0, yPrev.length);
            }
            this.firePropertyChange(oldT * this.intervalFactor, t * this.intervalFactor);
            if (fastFlag) {
                yTemp = this.computeSteadyState((FastProcessDESystem)DES, result[i], timeBegin);
                System.arraycopy(yTemp, 0, result[i], 0, yTemp.length);
            }
            this.additionalResults(DES, t - this.stepSize, result[i - 1], data, i);
            ++i;
        }
        return data;
    }

    public MultiTable solve(DESystem DES, double[] initialValues, double x, double h, int steps) throws DerivativeException {
        double[] timeVector = new double[steps];
        int i = 0;
        while (i < steps) {
            timeVector[i] = x + (double)i * h;
            ++i;
        }
        return this.solve(DES, initialValues, timeVector);
    }

    public MultiTable solve(DESystem DES, double[] initialValues, double[] timePoints) throws DerivativeException {
        if (DES instanceof DelayedDESystem) {
            ((DelayedDESystem)DES).registerDelayValueHolder(this);
        }
        MultiTable data = this.initResultMatrix(DES, initialValues, timePoints);
        double[][] result = data.getBlock(0).getData();
        double[] change = new double[initialValues.length];
        double[] yPrev = new double[initialValues.length];
        double[] yTemp = new double[initialValues.length];
        double[] steady = new double[initialValues.length];
        double t = timePoints[0];
        double h = this.stepSize;
        boolean fastFlag = false;
        this.additionalResults(DES, t, result[0], data, 0);
        if (DES instanceof FastProcessDESystem) {
            fastFlag = ((FastProcessDESystem)DES).containsFastProcesses();
        }
        if (fastFlag) {
            result[0] = this.computeSteadyState((FastProcessDESystem)DES, result[0], timePoints[0]);
        }
        this.processEvents((EventDESystem)DES, 0.0, 0.0, result[0]);
        System.arraycopy(result[0], 0, yTemp, 0, result[0].length);
        int i = 1;
        while (i < timePoints.length && !Thread.currentThread().isInterrupted()) {
            this.firePropertyChange(timePoints[i - 1] * this.intervalFactor, timePoints[i] * this.intervalFactor);
            h = this.stepSize;
            int steps = this.inBetweenSteps(timePoints[i - 1], timePoints[i], h);
            int j = 1;
            while (j <= steps) {
                System.arraycopy(yTemp, 0, yPrev, 0, yTemp.length);
                t = this.computeNextState(DES, t, h, yPrev, change, yTemp, true, false);
                if (i == 1 && j == 1) {
                    System.arraycopy(yPrev, 0, result[0], 0, yPrev.length);
                }
                ++j;
            }
            h = BigDecimal.valueOf(timePoints[i]).subtract(BigDecimal.valueOf(t)).doubleValue();
            if (h > 1.0E-14) {
                System.arraycopy(yTemp, 0, yPrev, 0, yTemp.length);
                t = this.computeNextState(DES, t, h, yTemp, change, yTemp, true, false);
            }
            System.arraycopy(yTemp, 0, result[i], 0, yTemp.length);
            if (fastFlag) {
                steady = this.computeSteadyState((FastProcessDESystem)DES, result[i], timePoints[0]);
                System.arraycopy(steady, 0, result[i], 0, yTemp.length);
                System.arraycopy(steady, 0, yTemp, 0, yTemp.length);
            }
            this.additionalResults(DES, t, yTemp, data, i);
            t = timePoints[i];
            ++i;
        }
        return data;
    }

    public MultiTable solve(DESystem DES, MultiTable.Block initConditions, double[] initialValues) throws DerivativeException {
        if (DES instanceof DelayedDESystem) {
            ((DelayedDESystem)DES).registerDelayValueHolder(this);
        }
        double[] timePoints = initConditions.getTimePoints();
        HashMap<String, Integer> idIndex = new HashMap<String, Integer>();
        HashSet<String> missingIds = new HashSet<String>();
        String[] ids = DES.getIdentifiers();
        int i = 0;
        while (i < ids.length) {
            if (!initConditions.containsColumn(ids[i])) {
                missingIds.add(ids[i]);
            }
            idIndex.put(ids[i], i);
            ++i;
        }
        int col = 0;
        while (col < initConditions.getColumnCount()) {
            Integer index;
            String columnName = initConditions.getColumnIdentifier(col);
            if (columnName != null && (index = (Integer)idIndex.get(initConditions.getColumnIdentifier(col))) != null) {
                initialValues[index.intValue()] = initConditions.getValueAt(0, col + 1);
            }
            ++col;
        }
        MultiTable data = this.initResultMatrix(DES, initialValues, timePoints);
        double[][] result = data.getBlock(0).getData();
        double[] yTemp = new double[DES.getDimension()];
        double[] change = new double[DES.getDimension()];
        double t = timePoints[0];
        this.additionalResults(DES, t, result[0], data, 0);
        i = 1;
        while (i < timePoints.length && !Thread.currentThread().isInterrupted()) {
            this.firePropertyChange(timePoints[i - 1] * this.intervalFactor, timePoints[i] * this.intervalFactor);
            double h = this.stepSize;
            if (!missingIds.isEmpty()) {
                int k = 0;
                while (k < initConditions.getColumnCount()) {
                    yTemp[((Integer)idIndex.get((Object)initConditions.getColumnIdentifier((int)k))).intValue()] = initConditions.getValueAt(i - 1, k + 1);
                    ++k;
                }
                for (String key : missingIds) {
                    k = (Integer)idIndex.get(key);
                    yTemp[k] = result[i - 1][k];
                }
            } else {
                System.arraycopy(initConditions.getRow(i - 1), 0, yTemp, 0, yTemp.length);
            }
            int j = 0;
            while (j < this.inBetweenSteps(timePoints[i - 1], timePoints[i], h)) {
                this.computeChange(DES, yTemp, t, h, change, false);
                this.checkSolution(change, yTemp);
                Mathematics.vvAdd(yTemp, change, yTemp);
                t = BigDecimal.valueOf(h).add(BigDecimal.valueOf(t)).doubleValue();
                ++j;
            }
            h = BigDecimal.valueOf(timePoints[i]).subtract(BigDecimal.valueOf(t)).doubleValue();
            if (h > 1.0E-14) {
                this.computeChange(DES, yTemp, t, h, change, false);
                this.checkSolution(change);
                Mathematics.vvAdd(yTemp, change, yTemp);
            }
            this.checkNonNegativity(yTemp);
            System.arraycopy(yTemp, 0, result[i], 0, yTemp.length);
            this.additionalResults(DES, t, yTemp, data, i);
            t = timePoints[i];
            ++i;
        }
        return data;
    }
}

