/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.math;

import java.util.Random;
import java.util.logging.Logger;

public class RNG {
    private static Random RANDOM;
    private static long RANDOM_SEED;
    private static final Logger logger;

    static {
        logger = Logger.getLogger(RNG.class.getName());
        RANDOM_SEED = System.currentTimeMillis();
        RANDOM = new Random(RANDOM_SEED);
    }

    public static int randomInt(int low, int high) {
        if (high < low) {
            logger.fine("Invalid boundary values! Returning -1.");
            return -1;
        }
        int result = Math.abs(RANDOM.nextInt()) % (high - low + 1) + low;
        if (result < low || result > high) {
            logger.fine(String.format("Error, invalid value %d in RNG.randomInt! boundaries were low = %d\thigh = %d", result, low, high));
            result = Math.abs(RANDOM.nextInt() % (high - low + 1)) + low;
        }
        return result;
    }
}

