/*
 * Decompiled with CFR 0.152.
 */
package org.simulator.math;

public class MatrixOperations {
    public static final double ALF = 1.0E-4;
    public static final double EPS = 1.0E-8;
    public static final double STPMX = 100.0;
    public static final double TINY = 1.0E-20;
    public static final double TOLF = 1.0E-4;
    public static final double TOLMIN = 1.0E-6;
    public static final double TOLX = 1.0E-7;
    private static double[] vv;

    public static double ludcmp(double[][] a, int[] indx) throws MatrixException {
        double big;
        int n = a.length;
        int i = 0;
        int imax = 0;
        int j = 0;
        int k = 0;
        double d = 1.0;
        if (vv == null || vv.length != n) {
            vv = new double[n];
        }
        i = 0;
        while (i < n) {
            big = 0.0;
            j = 0;
            while (j < n) {
                double temp = a[i][j];
                if (temp < 0.0) {
                    temp *= -1.0;
                }
                if (temp > big) {
                    big = temp;
                }
                ++j;
            }
            if (big == 0.0) {
                throw new MatrixException("Error: Singular linearized system. Computation cannot proceed.");
            }
            MatrixOperations.vv[i] = 1.0 / big;
            ++i;
        }
        j = 0;
        while (j < n) {
            double dum;
            double sum;
            i = 0;
            while (i < j) {
                sum = a[i][j];
                k = 0;
                while (k < i) {
                    sum -= a[i][k] * a[k][j];
                    ++k;
                }
                a[i][j] = sum;
                ++i;
            }
            big = 0.0;
            i = j;
            while (i < n) {
                sum = a[i][j];
                k = 0;
                while (k < j) {
                    sum -= a[i][k] * a[k][j];
                    ++k;
                }
                a[i][j] = sum;
                dum = vv[i] * sum;
                if (sum < 0.0) {
                    dum *= -1.0;
                }
                if (dum >= big) {
                    big = dum;
                    imax = i;
                }
                ++i;
            }
            if (j != imax) {
                k = 0;
                while (k < n) {
                    dum = a[imax][k];
                    a[imax][k] = a[j][k];
                    a[j][k] = dum;
                    ++k;
                }
                d = -d;
                MatrixOperations.vv[imax] = vv[j];
            }
            indx[j] = imax;
            if (a[j][j] == 0.0) {
                a[j][j] = 1.0E-20;
            }
            if (j != n) {
                dum = 1.0 / a[j][j];
                i = j + 1;
                while (i < n) {
                    double[] dArray = a[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] * dum;
                    ++i;
                }
            }
            ++j;
        }
        return d;
    }

    public static void lubksb(double[][] a, int[] indx, double[] b) {
        int j;
        int ii = 0;
        int ip = 0;
        double sum = 0.0;
        int n = a.length;
        int i = 1;
        while (i <= n) {
            ip = indx[i - 1] + 1;
            sum = b[ip - 1];
            b[ip - 1] = b[i - 1];
            if (ii != 0) {
                j = ii;
                while (j <= i - 1) {
                    sum -= a[i - 1][j - 1] * b[j - 1];
                    ++j;
                }
            } else if (sum != 0.0) {
                ii = i;
            }
            b[i - 1] = sum;
            ++i;
        }
        i = n;
        while (i >= 1) {
            sum = b[i - 1];
            j = i + 1;
            while (j <= n) {
                sum -= a[i - 1][j - 1] * b[j - 1];
                ++j;
            }
            b[i - 1] = sum / a[i - 1][i - 1];
            --i;
        }
    }

    public static void balance(double[][] a) {
        int RADIX = 2;
        boolean last = false;
        int n = a.length;
        double s = 0.0;
        double r = 0.0;
        double g = 0.0;
        double f = 0.0;
        double c = 0.0;
        double sqrdx = 4.0;
        while (!last) {
            last = true;
            int i = 1;
            while (i <= n) {
                r = 0.0;
                c = 0.0;
                int j = 1;
                while (j <= n) {
                    if (j != i) {
                        c += Math.abs(a[j - 1][i - 1]);
                        r += Math.abs(a[i - 1][j - 1]);
                    }
                    ++j;
                }
                if (c != 0.0 && r != 0.0) {
                    g = r / 2.0;
                    f = 1.0;
                    s = c + r;
                    while (c < g) {
                        f *= 2.0;
                        c *= sqrdx;
                    }
                    g = r * 2.0;
                    while (c > g) {
                        f /= 2.0;
                        c /= sqrdx;
                    }
                    if ((c + r) / f < 0.95 * s) {
                        last = false;
                        g = 1.0 / f;
                        j = 1;
                        while (j <= n) {
                            double[] dArray = a[i - 1];
                            int n2 = j - 1;
                            dArray[n2] = dArray[n2] * g;
                            ++j;
                        }
                        j = 1;
                        while (j <= n) {
                            double[] dArray = a[j - 1];
                            int n3 = i - 1;
                            dArray[n3] = dArray[n3] * f;
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    public static void elmhes(double[][] a) {
        int n = a.length;
        int m = 2;
        while (m < n) {
            double x = 0.0;
            int i = m;
            int j = m;
            while (j <= n) {
                if (Math.abs(a[j - 1][m - 2]) > Math.abs(x)) {
                    x = a[j - 1][m - 2];
                    i = j;
                }
                ++j;
            }
            if (i != m) {
                double temp;
                j = m - 1;
                while (j <= n) {
                    temp = a[i - 1][j - 1];
                    a[i - 1][j - 1] = a[m - 1][j - 1];
                    a[m - 1][j - 1] = temp;
                    ++j;
                }
                j = 1;
                while (j <= n) {
                    temp = a[j - 1][i - 1];
                    a[j - 1][i - 1] = a[j - 1][m - 1];
                    a[j - 1][m - 1] = temp;
                    ++j;
                }
            }
            if (x != 0.0) {
                i = m + 1;
                while (i <= n) {
                    double y = a[i - 1][m - 2];
                    if (y != 0.0) {
                        a[i - 1][m - 2] = y /= x;
                        j = m;
                        while (j <= n) {
                            double[] dArray = a[i - 1];
                            int n2 = j - 1;
                            dArray[n2] = dArray[n2] - y * a[m - 1][j - 1];
                            ++j;
                        }
                        j = 1;
                        while (j <= n) {
                            double[] dArray = a[j - 1];
                            int n3 = m - 1;
                            dArray[n3] = dArray[n3] + y * a[j - 1][i - 1];
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            ++m;
        }
    }

    public static double sign(double a, double b) {
        if (b > 0.0) {
            return Math.abs(a);
        }
        return -1.0 * Math.abs(a);
    }

    public static int hqr(double[][] a, double[] wr, double[] wi) throws MatrixException {
        int nn = 0;
        int m = 0;
        int l = 0;
        int k = 0;
        int j = 0;
        int its = 0;
        int i = 0;
        int mmin = 0;
        int n = a.length;
        double z = 0.0;
        double y = 0.0;
        double x = 0.0;
        double w = 0.0;
        double v = 0.0;
        double u = 0.0;
        double t = 0.0;
        double s = 0.0;
        double r = 0.0;
        double q = 0.0;
        double p = 0.0;
        double anorm = 0.0;
        anorm = Math.abs(a[0][0]);
        i = 2;
        while (i <= n) {
            j = i - 1;
            while (j <= n) {
                anorm += Math.abs(a[i - 1][j - 1]);
                ++j;
            }
            ++i;
        }
        nn = n;
        t = 0.0;
        while (nn >= 1) {
            its = 0;
            do {
                l = nn;
                while (l >= 2) {
                    s = Math.abs(a[l - 2][l - 2]) + Math.abs(a[l - 1][l - 1]);
                    if (s == 0.0) {
                        s = anorm;
                    }
                    if (Math.abs(a[l - 1][l - 2]) + s == s) {
                        a[l - 1][l - 2] = 0.0;
                        break;
                    }
                    --l;
                }
                x = a[nn - 1][nn - 1];
                if (l == nn) {
                    wr[nn - 1] = x + t;
                    wi[nn - 1] = 0.0;
                    --nn;
                    continue;
                }
                y = a[nn - 2][nn - 2];
                w = a[nn - 1][nn - 2] * a[nn - 2][nn - 1];
                if (l == nn - 1) {
                    p = 0.5 * (y - x);
                    q = p * p + w;
                    z = Math.sqrt(Math.abs(q));
                    x += t;
                    if (q >= 0.0) {
                        z = p + MatrixOperations.sign(z, p);
                        double d = x + z;
                        wr[nn - 1] = d;
                        wr[nn - 2] = d;
                        if (z != 0.0) {
                            wr[nn - 1] = x - w / z;
                        }
                        wi[nn - 1] = 0.0;
                        wi[nn - 2] = 0.0;
                    } else {
                        double d = x + p;
                        wr[nn - 1] = d;
                        wr[nn - 2] = d;
                        double d2 = z;
                        wi[nn - 1] = d2;
                        wi[nn - 2] = -d2;
                    }
                    nn -= 2;
                    continue;
                }
                if (its == 30) {
                    throw new MatrixException("Error: Could not find acceptable equilibrium point in " + its + " iterations. Please try another initial guess.");
                }
                if (its == 10 || its == 20) {
                    t += x;
                    i = 1;
                    while (i <= nn) {
                        double[] dArray = a[i - 1];
                        int n2 = i - 1;
                        dArray[n2] = dArray[n2] - x;
                        ++i;
                    }
                    s = Math.abs(a[nn - 1][nn - 2]) + Math.abs(a[nn - 2][nn - 3]);
                    y = x = 0.75 * s;
                    w = -0.4375 * s * s;
                }
                ++its;
                m = nn - 2;
                while (m >= l) {
                    z = a[m - 1][m - 1];
                    r = x - z;
                    s = y - z;
                    p = (r * s - w) / a[m][m - 1] + a[m - 1][m];
                    q = a[m][m] - z - r - s;
                    r = a[m + 1][m];
                    s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (m == l || (u = Math.abs(a[m - 1][m - 2]) * (Math.abs(q /= s) + Math.abs(r /= s))) + (v = Math.abs(p /= s) * (Math.abs(a[m - 2][m - 2]) + Math.abs(z) + Math.abs(a[m][m]))) == v) break;
                    --m;
                }
                i = m + 2;
                while (i <= nn) {
                    a[i - 1][i - 3] = 0.0;
                    if (i != m + 2) {
                        a[i - 1][i - 4] = 0.0;
                    }
                    ++i;
                }
                k = m;
                while (k <= nn - 1) {
                    if (k != m) {
                        p = a[k - 1][k - 2];
                        q = a[k][k - 2];
                        r = 0.0;
                        if (k != nn - 1) {
                            r = a[k + 1][k - 2];
                        }
                        if ((x = Math.abs(p) + Math.abs(q) + Math.abs(r)) != 0.0) {
                            p /= x;
                            q /= x;
                            r /= x;
                        }
                    }
                    if ((s = MatrixOperations.sign(Math.sqrt(p * p + q * q + r * r), p)) != 0.0) {
                        if (k == m) {
                            if (l != m) {
                                a[k - 1][k - 2] = -a[k - 1][k - 2];
                            }
                        } else {
                            a[k - 1][k - 2] = -s * x;
                        }
                        x = (p += s) / s;
                        y = q / s;
                        z = r / s;
                        q /= p;
                        r /= p;
                        j = k;
                        while (j <= nn) {
                            p = a[k - 1][j - 1] + q * a[k][j - 1];
                            if (k != nn - 1) {
                                double[] dArray = a[k + 1];
                                int n3 = j - 1;
                                dArray[n3] = dArray[n3] - (p += r * a[k + 1][j - 1]) * z;
                            }
                            double[] dArray = a[k];
                            int n4 = j - 1;
                            dArray[n4] = dArray[n4] - p * y;
                            double[] dArray2 = a[k - 1];
                            int n5 = j - 1;
                            dArray2[n5] = dArray2[n5] - p * x;
                            ++j;
                        }
                        mmin = nn < k + 3 ? nn : k + 3;
                        i = l;
                        while (i <= mmin) {
                            p = x * a[i - 1][k - 1] + y * a[i - 1][k];
                            if (k != nn - 1) {
                                double[] dArray = a[i - 1];
                                int n6 = k + 1;
                                dArray[n6] = dArray[n6] - (p += z * a[i - 1][k + 1]) * r;
                            }
                            double[] dArray = a[i - 1];
                            int n7 = k;
                            dArray[n7] = dArray[n7] - p * q;
                            double[] dArray3 = a[i - 1];
                            int n8 = k - 1;
                            dArray3[n8] = dArray3[n8] - p;
                            ++i;
                        }
                    }
                    ++k;
                }
            } while (l < nn - 1);
        }
        return 0;
    }

    public static class MatrixException
    extends Exception {
        public MatrixException() {
        }

        public MatrixException(String message) {
            super(message);
        }
    }
}

