/*
 * Decompiled with CFR 0.152.
 */
package org.simulator;

import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.math.ode.DerivativeException;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.validator.ModelOverdeterminedException;
import org.sbml.jsbml.xml.stax.SBMLReader;
import org.simulator.math.odes.AbstractDESSolver;
import org.simulator.math.odes.EulerMethod;
import org.simulator.math.odes.MultiTable;
import org.simulator.sbml.SBMLinterpreter;

public class SimulatorTest {
    public static void main(String[] args) throws XMLStreamException, IOException, ModelOverdeterminedException, SBMLException, DerivativeException {
        String fileName = args[0];
        double stepSize = Double.parseDouble(args[1]);
        double timeEnd = Double.parseDouble(args[2]);
        Model model = new SBMLReader().readSBML(fileName).getModel();
        EulerMethod solver = new EulerMethod();
        solver.setStepSize(stepSize);
        SBMLinterpreter interpreter = new SBMLinterpreter(model);
        solver.setStepSize(stepSize);
        if (solver instanceof AbstractDESSolver) {
            solver.setIncludeIntermediates(false);
        }
        MultiTable solution = solver.solve(interpreter, interpreter.getInitialValues(), 0.0, timeEnd);
        JScrollPane resultDisplay = new JScrollPane(new JTable(solution));
        resultDisplay.setPreferredSize(new Dimension(400, 400));
        JOptionPane.showMessageDialog(null, resultDisplay, "The solution of model " + model.getId(), 1);
    }
}

