/*
 * Decompiled with CFR 0.152.
 */
package plugin.newsample.NotifySelected;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.sbi.celldesigner.plugin.CellDesignerPlugin;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;

public class MessageDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private CellDesignerPlugin plugin;
    private JPanel jMainPane = null;
    private JLabel jMsgLabel = null;
    private JScrollPane jMsgScrollPane = null;
    private JButton jClearButton = null;
    private JButton jCloseButton = null;
    private Vector<String> lstMsg = new Vector();
    private JList jMsgList = new JList<String>(this.lstMsg);
    private static int cnt = 0;

    public MessageDialog(CellDesignerPlugin plugin) {
        this.plugin = plugin;
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(640, 480));
        this.setLocation(40, 30);
        this.setPreferredSize(this.getSize());
        this.setTitle("Selected Info.");
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.setContentPane(this.getJMainPane());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MessageDialog.this.disposePluginSampleDialog();
            }
        });
    }

    private JPanel getJMainPane() {
        if (this.jMainPane == null) {
            this.jMsgLabel = new JLabel();
            this.jMsgLabel.setBounds(new Rectangle(5, 5, 620, 25));
            this.jMsgLabel.setPreferredSize(this.jMsgLabel.getSize());
            this.jMsgLabel.setText("Selected-Infomation from DrawArea");
            this.jMainPane = new JPanel();
            this.jMainPane.setLayout(null);
            this.jMainPane.add((Component)this.jMsgLabel, null);
            this.jMainPane.add((Component)this.getJMsgScrollPane(), null);
            this.jMainPane.add((Component)this.getJClearButton(), null);
            this.jMainPane.add((Component)this.getJCloseButton(), null);
        }
        return this.jMainPane;
    }

    private JScrollPane getJMsgScrollPane() {
        if (this.jMsgScrollPane == null) {
            this.jMsgScrollPane = new JScrollPane(this.jMsgList);
            this.jMsgScrollPane.setBounds(new Rectangle(5, 35, 620, 370));
            this.jMsgScrollPane.setPreferredSize(this.jMsgScrollPane.getSize());
            this.jMsgScrollPane.setVerticalScrollBarPolicy(20);
            this.jMsgScrollPane.setHorizontalScrollBarPolicy(31);
        }
        return this.jMsgScrollPane;
    }

    private JButton getJClearButton() {
        if (this.jClearButton == null) {
            this.jClearButton = new JButton();
            this.jClearButton.setBounds(new Rectangle(300, 410, 80, 30));
            this.jClearButton.setPreferredSize(this.jClearButton.getSize());
            this.jClearButton.setText("Clear");
            this.jClearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    cnt = 0;
                    MessageDialog.this.lstMsg.clear();
                    MessageDialog.this.jMsgList.setListData(MessageDialog.this.lstMsg);
                }
            });
        }
        return this.jClearButton;
    }

    private JButton getJCloseButton() {
        if (this.jCloseButton == null) {
            this.jCloseButton = new JButton();
            this.jCloseButton.setBounds(new Rectangle(500, 410, 80, 30));
            this.jCloseButton.setPreferredSize(this.jCloseButton.getSize());
            this.jCloseButton.setText("Close");
            this.jCloseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MessageDialog.this.disposePluginSampleDialog();
                }
            });
        }
        return this.jCloseButton;
    }

    public void disposePluginSampleDialog() {
        this.plugin.setStarted(false);
        this.setVisible(false);
        this.dispose();
    }

    public void outputSelectedMsg() {
        int index = 0;
        String strPrefix = "  ";
        this.lstMsg.add(index++, "No. " + ++cnt);
        PluginListOf lstSelectedSpecies = this.plugin.getSelectedSpeciesNode();
        int i = 0;
        while (i < lstSelectedSpecies.size()) {
            PluginSpeciesAlias pAlias = (PluginSpeciesAlias)lstSelectedSpecies.get(i);
            String sAliasID = pAlias.getAliasID();
            String sExtensionID = pAlias.getExtensionId();
            String sName = pAlias.getName();
            String msg = String.valueOf(strPrefix) + "AliasID[" + sAliasID + "] , " + "ExtensionID[" + sExtensionID + "] , " + "Name[" + sName + "]";
            this.lstMsg.add(index++, msg);
            ++i;
        }
        PluginListOf lstSelectedReaction = this.plugin.getSelectedReactionNode();
        int i2 = 0;
        while (i2 < lstSelectedReaction.size()) {
            PluginReaction pReaction = (PluginReaction)lstSelectedReaction.get(i2);
            String sID = pReaction.getId();
            String msg = String.valueOf(strPrefix) + "ReactionID[" + sID + "]";
            this.lstMsg.add(index++, msg);
            ++i2;
        }
        this.lstMsg.add(index++, " ");
        this.jMsgList.setListData(this.lstMsg);
        this.pack();
    }
}

