/*
 * Decompiled with CFR 0.152.
 */
package plugin.annotationsample;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

class Debug {
    private static boolean isToConsole = false;
    private static boolean isToFile = false;
    private static boolean isToRedirectErr = false;
    public static PrintStream fileout = null;
    public static PrintStream err = null;

    Debug() {
    }

    public static void close() {
        if (fileout != null) {
            fileout.close();
            fileout = null;
        }
        if (err != null) {
            err.close();
            err = null;
        }
    }

    public static void println(String string) {
        if (isToConsole) {
            System.out.println(string);
        }
        if (isToFile & fileout != null) {
            fileout.println(string);
        }
    }

    public static boolean setMode(String string) {
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == 'c' & (isToConsole ^ true)) {
                isToConsole = true;
            }
            if (c == 'f' & (isToFile ^ true)) {
                try {
                    fileout = new PrintStream(new FileOutputStream("debug.txt"));
                    isToFile = true;
                }
                catch (Exception exception) {
                    System.err.println("[Debug] failed to open debug.txt");
                    return false;
                }
            }
            if (c == 'r' & (isToRedirectErr ^ true)) {
                try {
                    err = new PrintStream(new FileOutputStream("error.txt"));
                    System.setErr(err);
                    isToRedirectErr = true;
                }
                catch (Exception exception) {
                    System.err.println("[Debug] failed to open error.txt");
                    err = System.out;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean outputDebugMessage(String dev, String msg, int nest) {
        if (msg == null) {
            return false;
        }
        String device = "c";
        device = dev != null && (dev.toLowerCase().equals("c") || dev.toLowerCase().equals("f") || dev.toLowerCase().equals("r")) ? dev.toLowerCase() : "c";
        if (device.equals("f") && fileout == null && !Debug.setMode(dev)) {
            return false;
        }
        int nst = 0;
        if (nest > 0 && nest <= 100) {
            nst = nest;
        }
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss SSS");
        String prefix = String.valueOf(System.currentTimeMillis()) + "(" + format.format(now) + "):";
        prefix = "";
        String strNest = "";
        int i = 0;
        while (i < nst) {
            strNest = String.valueOf(strNest) + "\t";
            ++i;
        }
        prefix = String.valueOf(prefix) + strNest;
        Debug.println(String.valueOf(prefix) + msg);
        return true;
    }
}

