/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbw;

import edu.caltech.sbw.ModuleImpl;
import edu.caltech.sbw.SBW;
import edu.caltech.sbw.SBWBrokerStartException;
import edu.caltech.sbw.SBWCommunicationException;
import edu.caltech.sbw.SBWException;
import edu.caltech.sbw.SBWIncorrectCategorySyntaxException;
import edu.caltech.sbw.SBWModuleDefinitionException;
import edu.caltech.sbw.Service;
import edu.caltech.sbw.ServiceDescriptor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.sbml.SpecInfo;
import jp.sbi.sbml.debug.DebugPrinter;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbw.Analysis;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.libsbml;

public class SBWUtil {
    private static ModuleImpl sbwModuleObject = null;
    private static JFrame ownerFrame = null;
    private static SBMLDocument currentDocument = null;
    private static SBModel sbmodel = null;
    private static ServiceDescriptor[] descriptors;

    public static void connect() throws SBWCommunicationException, SBWBrokerStartException {
        SBW.connect();
    }

    public static void registerToSBW() throws SBWModuleDefinitionException, SBWBrokerStartException, SBWCommunicationException {
        if (sbwModuleObject == null) {
            return;
        }
        sbwModuleObject.registerModule();
    }

    public static void setSBWModuleObject(ModuleImpl obj) {
        sbwModuleObject = obj;
    }

    public static ModuleImpl getSBWModuleObject() {
        return sbwModuleObject;
    }

    public static void registerJMenu(JMenu menuSBW) throws SBWCommunicationException, SBWIncorrectCategorySyntaxException {
        descriptors = SBW.findServices((String)"Analysis", (boolean)true);
        JMenuItem[] menuItems = new JMenuItem[descriptors.length];
        int i = 0;
        while (i < descriptors.length) {
            String displayName = descriptors[i].getDisplayName();
            if (!displayName.equals("CellDesigner")) {
                menuItems[i] = new JMenuItem(displayName);
                menuSBW.add(menuItems[i]);
                menuItems[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        SBWUtil.startSimulation(evt);
                    }
                });
            }
            ++i;
        }
    }

    public static void disconnect() {
        SBW.disconnect();
    }

    public static void setCurrentDocument(SBMLDocument currentDocument) {
        SBWUtil.currentDocument = currentDocument;
    }

    public static void setSBModel(SBModel sbm) {
        sbmodel = sbm;
    }

    private static void startSimulation(ActionEvent evt) {
        SpecInfo currentSpec = new SpecInfo(currentDocument.getLevel(), currentDocument.getVersion());
        try {
            sbmodel.prepareSave();
            SBMLDocument targetDoc = LibSBMLUtil.updateNotesAndAnnotation(currentDocument, sbmodel);
            Model model = targetDoc.getModel();
            if (model == null) {
                LibSBMLUtil.checkSBMLFatalErrorAndShowErrorMessage(targetDoc, ownerFrame, new String[]{"SBW"});
                throw new Exception("canceled");
            }
            String xmlString = libsbml.writeSBMLToString((SBMLDocument)targetDoc);
            LibSBMLUtil.setParameterAnnotation((ListOf)sbmodel.getModel().getListOfReactions());
            targetDoc.getModel().unsetAnnotation();
            int i = 0;
            while ((long)i < targetDoc.getModel().getNumSpecies()) {
                targetDoc.getModel().getSpecies((long)i).unsetAnnotation();
                targetDoc.getModel().getSpecies((long)i).unsetNotes();
                ++i;
            }
            i = 0;
            while ((long)i < targetDoc.getModel().getNumReactions()) {
                targetDoc.getModel().getReaction((long)i).unsetAnnotation();
                targetDoc.getModel().getReaction((long)i).unsetNotes();
                ++i;
            }
            i = 0;
            while ((long)i < targetDoc.getModel().getNumCompartments()) {
                targetDoc.getModel().getCompartment((long)i).unsetAnnotation();
                targetDoc.getModel().getCompartment((long)i).unsetNotes();
                ++i;
            }
            targetDoc.delete();
            targetDoc = null;
            System.gc();
            String simulationName = evt.getActionCommand();
            int i2 = 0;
            while (i2 < descriptors.length) {
                if (simulationName.equals(descriptors[i2].getDisplayName())) {
                    Service service = descriptors[i2].getServiceInModuleInstance();
                    Analysis analysis = (Analysis)service.getServiceObject(Analysis.class);
                    analysis.doAnalysis(xmlString);
                    break;
                }
                ++i2;
            }
        }
        catch (SBWException e) {
            DebugPrinter.println(0, e.toString());
            e.handleWithDialog();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void postRegisterJMenuProcess() {
        String nom = "Save to Network Object Model Clipboard";
        try {
            int i = 0;
            while (i < descriptors.length) {
                if ("Save to Network Object Model Clipboard".equals(descriptors[i].getDisplayName())) {
                    Service obj = descriptors[i].getServiceInModuleInstance();
                    break;
                }
                ++i;
            }
        }
        catch (SBWException e) {
            DebugPrinter.println(0, e.toString());
        }
    }

    public void setOwnerFrame(JFrame myFrame) {
        ownerFrame = myFrame;
    }
}

