/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.StringBufferInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    private XMLUtil() {
    }

    public static Document readDocument(File filepath) throws Exception {
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        doc = builder.parse(new FileInputStream(filepath));
        return doc;
    }

    public static Document readDocument(String str) throws Exception {
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        doc = builder.parse(new StringBufferInputStream(str));
        return doc;
    }

    public static String getValue(Node node) {
        return node.getFirstChild().getNodeValue();
    }

    public static Node getLowerNode(Node node, String name) {
        Node rtn = null;
        NodeList childs = node.getChildNodes();
        if (childs.getLength() == 0) {
            return rtn;
        }
        int i = 0;
        while (i < childs.getLength()) {
            Node child = childs.item(i);
            if (child.getNodeName().equals(name)) {
                rtn = child;
                break;
            }
            rtn = XMLUtil.getLowerNode(child, name);
            if (rtn != null) break;
            ++i;
        }
        return rtn;
    }

    public static Node getChildNode(Node node, String name) {
        NodeList childs = node.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node child = childs.item(i);
            if (child.getNodeName().equals(name)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public static Node getChildNodeNS(Node node, String name) {
        String URI2 = node.getNamespaceURI();
        NodeList childs = node.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node child = childs.item(i);
            if (child.getNodeName().equals(name)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public static String getChildNodeValue(Node node, String name) {
        String str = "";
        NodeList childs = node.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node child = childs.item(i);
            if (child.getNodeName().equals(name)) {
                Node value = child.getFirstChild();
                str = value.getNodeValue();
            }
            ++i;
        }
        return str;
    }

    public static String getAttributeValue(Node node, String name) {
        String str = "";
        NamedNodeMap map = node.getAttributes();
        Node attrNode = map.getNamedItem(name);
        if (attrNode == null) {
            return "";
        }
        return attrNode.getNodeValue();
    }

    public static String getAttributeValueNS(Element element, String name) {
        String URI2 = element.getNamespaceURI();
        return element.getAttributeNS(URI2, name);
    }

    public static NodeList getChildNodes(Node node) {
        return node.getChildNodes();
    }

    public static void removeChildNode(Node node, String name) {
        NodeList child = node.getChildNodes();
        int childsize = child.getLength();
        int i = 0;
        while (i < childsize) {
            Node n = child.item(i);
            String nodename = n.getNodeName();
            if (nodename.equals(name)) {
                node.removeChild(n);
                return;
            }
            ++i;
        }
    }
}

