/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.ListDialog;
import jp.sbi.sbml.util.SBaseDialog;
import jp.sbi.sbml.util.UnitDefinitionDialog;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Unit;
import org.sbml.libsbml.libsbml;

public class UnitDialog
extends SBaseDialog {
    private JTextField kindTextField;
    private JTextField exponentTextField;
    private JTextField scaleTextField;
    private JTextField multiplierTextField;
    private JTextField offsetTextField;
    private JComboBox kindCombo;
    public static final String strErrMessage = "Unit cannot be changed.";

    public UnitDialog() {
    }

    public UnitDialog(Dialog owner) {
        super(owner);
    }

    public UnitDialog(Frame owner) {
        super(owner);
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        this.LABEL_WIDTH = 70;
        this.TEXT_WIDTH = 300;
        this.setLayoutConstants();
        int yline = this.VERTICAL_MARGIN;
        JLabel kindLabel = new JLabel("kind");
        kindLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)kindLabel, null);
        this.kindCombo = new JComboBox();
        this.kindCombo.setEditable(false);
        this.kindCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemevent) {
                UnitDialog.this.changeExponentForDefaultUnits();
                UnitDialog.this.okButton.setEnabled(true);
                UnitDialog.this.cancelButton.setEnabled(true);
            }
        });
        this.kindCombo.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)this.kindCombo, null);
        JLabel exponentLabel = new JLabel("exponent");
        exponentLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)exponentLabel, null);
        this.exponentTextField = new JTextField();
        this.exponentTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.exponentTextField.setEditable(true);
        this.exponentTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.exponentTextField, null);
        JLabel scaleLabel = new JLabel("scale");
        scaleLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)scaleLabel, null);
        this.scaleTextField = new JTextField();
        this.scaleTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.scaleTextField.setEditable(true);
        this.scaleTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.scaleTextField, null);
        JLabel multiplierLabel = new JLabel("multiplier");
        multiplierLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)multiplierLabel, null);
        this.multiplierTextField = new JTextField();
        this.multiplierTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.multiplierTextField.setEditable(true);
        this.multiplierTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.multiplierTextField, null);
        this.offsetTextField = new JTextField();
        this.BUTTON_POSITION_Y = yline += this.BASELINE_SKIP;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new Unit();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        Unit unit = (Unit)sbase;
        String kind = libsbml.UnitKind_toString((int)unit.getKind());
        String strSId = "";
        if (this.getParent() instanceof ListDialog && this.getParent().getParent() instanceof UnitDefinitionDialog) {
            UnitDefinitionDialog unitDefinitionDialog = (UnitDefinitionDialog)this.getParent().getParent();
            if (unitDefinitionDialog.editingSBase != null) {
                strSId = unitDefinitionDialog.editingSBase.getId();
            }
        }
        if (!this.setKindComboForDefaultUnits(strSId, kind)) {
            this.kindCombo.removeAllItems();
            String[] strArg = LibSBMLUtil.strListofSBMLKind;
            int cnt = 0;
            if (strArg != null) {
                while (cnt < strArg.length) {
                    this.kindCombo.addItem(strArg[cnt]);
                    if (strArg[cnt].equals(kind)) {
                        this.kindCombo.setSelectedIndex(cnt);
                    }
                    ++cnt;
                }
            }
            if (this.kindCombo.getSelectedIndex() == -1) {
                this.kindCombo.setSelectedIndex(0);
            }
        }
        int exponent = unit.getExponent();
        String s1 = Integer.toString(exponent);
        this.exponentTextField.setText(s1);
        this.exponentTextField.setCaretPosition(s1.length());
        int scale = unit.getScale();
        String s2 = Integer.toString(scale);
        this.scaleTextField.setText(s2);
        this.scaleTextField.setCaretPosition(s2.length());
        String mult = Double.toString(unit.getMultiplier());
        this.multiplierTextField.setText(mult);
        this.multiplierTextField.setCaretPosition(mult.length());
        String off = Double.toString(unit.getOffset());
        this.offsetTextField.setText(off);
        this.offsetTextField.setCaretPosition(off.length());
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        int i;
        if (sbase == null) {
            return;
        }
        Unit unit = (Unit)sbase;
        this.checkInputedValueInThisDialog();
        this.checkChangeAbled();
        unit.setKind(libsbml.UnitKind_forName((String)((String)this.kindCombo.getSelectedItem())));
        String str = this.exponentTextField.getText();
        if (str.equals("")) {
            unit.setExponent(1);
        } else {
            i = Integer.parseInt(str);
            unit.setExponent(i);
        }
        str = this.scaleTextField.getText();
        if (str.equals("")) {
            unit.setScale(0);
        } else {
            i = Integer.parseInt(str);
            unit.setScale(i);
        }
        str = this.multiplierTextField.getText();
        if (str.equals("")) {
            unit.setMultiplier(1.0);
        } else {
            unit.setMultiplier(Double.parseDouble(str));
        }
        str = this.offsetTextField.getText();
        if (str.equals("")) {
            unit.setOffset(0.0);
        } else {
            unit.setOffset(Double.parseDouble(str));
        }
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.kindCombo.setEnabled(isEnabled);
        this.exponentTextField.setEnabled(isEnabled);
        this.scaleTextField.setEnabled(isEnabled);
        this.multiplierTextField.setEnabled(isEnabled);
        this.offsetTextField.setEditable(isEnabled);
        this.okButton.setEnabled(isEnabled);
        this.cancelButton.setEnabled(isEnabled);
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }

    protected boolean setKindComboForDefaultUnits(String strSId, String strkind) {
        if (strSId == null || strSId.equals("")) {
            return false;
        }
        this.exponentTextField.setEnabled(false);
        if (strSId.equals("substance")) {
            this.kindCombo.removeAllItems();
            this.kindCombo.addItem(libsbml.UnitKind_toString((int)22));
            this.kindCombo.addItem(libsbml.UnitKind_toString((int)11));
            this.kindCombo.addItem(libsbml.UnitKind_toString((int)7));
            this.kindCombo.addItem(libsbml.UnitKind_toString((int)15));
            this.kindCombo.addItem(libsbml.UnitKind_toString((int)5));
            this.kindCombo.setSelectedItem(strkind);
            if (this.kindCombo.getSelectedIndex() == -1) {
                this.kindCombo.setSelectedIndex(0);
            }
            return true;
        }
        if (strSId.equals("volume")) {
            this.kindCombo.removeAllItems();
            this.kindCombo.addItem(libsbml.UnitKind_toString((int)17));
            this.kindCombo.addItem(libsbml.UnitKind_toString((int)21));
            this.kindCombo.addItem(libsbml.UnitKind_toString((int)5));
            this.kindCombo.setSelectedItem(strkind);
            if (this.kindCombo.getSelectedIndex() == -1) {
                this.kindCombo.setSelectedIndex(0);
            }
            return true;
        }
        if (strSId.equals("area")) {
            this.kindCombo.removeAllItems();
            this.kindCombo.addItem(libsbml.UnitKind_toString((int)21));
            this.kindCombo.addItem(libsbml.UnitKind_toString((int)5));
            this.kindCombo.setSelectedItem(strkind);
            if (this.kindCombo.getSelectedIndex() == -1) {
                this.kindCombo.setSelectedIndex(0);
            }
            return true;
        }
        if (strSId.equals("length")) {
            this.kindCombo.removeAllItems();
            this.kindCombo.addItem(libsbml.UnitKind_toString((int)21));
            this.kindCombo.addItem(libsbml.UnitKind_toString((int)5));
            this.kindCombo.setSelectedItem(strkind);
            if (this.kindCombo.getSelectedIndex() == -1) {
                this.kindCombo.setSelectedIndex(0);
            }
            return true;
        }
        if (strSId.equals("time")) {
            this.kindCombo.removeAllItems();
            this.kindCombo.addItem(libsbml.UnitKind_toString((int)27));
            this.kindCombo.addItem(libsbml.UnitKind_toString((int)5));
            this.kindCombo.setSelectedItem(strkind);
            if (this.kindCombo.getSelectedIndex() == -1) {
                this.kindCombo.setSelectedIndex(0);
            }
            return true;
        }
        this.exponentTextField.setEnabled(true);
        return false;
    }

    protected void changeExponentForDefaultUnits() {
        if (this.getParent() instanceof ListDialog && this.getParent().getParent() instanceof UnitDefinitionDialog) {
            String strSId;
            UnitDefinitionDialog unitDefinitionDialog = (UnitDefinitionDialog)this.getParent().getParent();
            if (unitDefinitionDialog.editingSBase != null && (strSId = unitDefinitionDialog.editingSBase.getId()) != null && !strSId.equals("")) {
                if (strSId.equals("substance")) {
                    String selectedValue = (String)this.kindCombo.getSelectedItem();
                    this.setExponentTextFieldEnabledbyDimensionlessForDefaultUnits(selectedValue);
                } else if (strSId.equals("volume")) {
                    String selectedValue = (String)this.kindCombo.getSelectedItem();
                    if (selectedValue != null && selectedValue.equals(libsbml.UnitKind_toString((int)21))) {
                        this.exponentTextField.setText("3");
                    } else {
                        this.exponentTextField.setText("1");
                    }
                    this.setExponentTextFieldEnabledbyDimensionlessForDefaultUnits(selectedValue);
                } else if (strSId.equals("area")) {
                    String selectedValue = (String)this.kindCombo.getSelectedItem();
                    if (selectedValue != null && selectedValue.equals(libsbml.UnitKind_toString((int)21))) {
                        this.exponentTextField.setText("2");
                    } else {
                        this.exponentTextField.setText("1");
                    }
                    this.setExponentTextFieldEnabledbyDimensionlessForDefaultUnits(selectedValue);
                } else if (strSId.equals("length")) {
                    String selectedValue = (String)this.kindCombo.getSelectedItem();
                    this.setExponentTextFieldEnabledbyDimensionlessForDefaultUnits(selectedValue);
                } else if (strSId.equals("time")) {
                    String selectedValue = (String)this.kindCombo.getSelectedItem();
                    this.setExponentTextFieldEnabledbyDimensionlessForDefaultUnits(selectedValue);
                }
            }
        }
    }

    protected void setExponentTextFieldEnabledbyDimensionlessForDefaultUnits(String selectedValue) {
        if (libsbml.UnitKind_toString((int)5).equals(selectedValue)) {
            this.exponentTextField.setEnabled(true);
        } else {
            this.exponentTextField.setEnabled(false);
        }
    }

    public void checkInputedValueInThisDialog() throws Exception {
        String strkind = (String)this.kindCombo.getSelectedItem();
        try {
            if (strkind == null || strkind.equals("")) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new Exception("malformed [units] string");
        }
        String str = this.exponentTextField.getText();
        if (!str.equals("")) {
            try {
                Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                throw new Exception("exponent must be an integer");
            }
        }
        if (!(str = this.scaleTextField.getText()).equals("")) {
            try {
                Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                throw new Exception("scale must be an integer");
            }
        }
        if (!(str = this.multiplierTextField.getText()).equals("")) {
            try {
                Double.parseDouble(str);
            }
            catch (NumberFormatException e) {
                throw new Exception("multiplier must be a double");
            }
        }
        if (!(str = this.offsetTextField.getText()).equals("")) {
            try {
                Double.parseDouble(str);
            }
            catch (NumberFormatException e) {
                throw new Exception("offset must be a double");
            }
        }
    }

    public void checkChangeAbled() throws Exception {
        if (this.editingSBase == null) {
            return;
        }
        Unit unit = (Unit)this.editingSBase;
        int oldKind = unit.getKind();
        int oldExponent = unit.getExponent();
        String strSId = "";
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        if (sbModel == null) {
            return;
        }
        if (this.getParent() instanceof ListDialog && this.getParent().getParent() instanceof UnitDefinitionDialog) {
            UnitDefinitionDialog unitDefinitionDialog = (UnitDefinitionDialog)this.getParent().getParent();
            if (unitDefinitionDialog.editingSBase != null) {
                strSId = unitDefinitionDialog.editingSBase.getId();
            }
            String strExponent = this.exponentTextField.getText();
            String strkind = (String)this.kindCombo.getSelectedItem();
            int newExponent = Integer.parseInt(strExponent);
            if (!(this.isNewObject || oldKind == libsbml.UnitKind_forName((String)strkind) && oldExponent == newExponent || UnitDefinitionDialog.beSureToChangeAllOtherSBasesUsedTheUnits(sbModel, strSId, strkind, newExponent, "update"))) {
                throw new Exception(strErrMessage);
            }
        }
    }
}

