/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.debug.DebugPrinter;
import jp.sbi.sbml.util.AnyInput;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.ListDialog;
import jp.sbi.sbml.util.ListPanel;
import jp.sbi.sbml.util.SBaseDialog;
import jp.sbi.sbml.util.SBaseListDialog;
import jp.sbi.sbml.util.SBaseListDialogListener;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfCompartments;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.ListOfUnitDefinitions;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.UnitDefinition;
import org.sbml.libsbml.libsbml;

public class UnitDefinitionDialog
extends SBaseDialog {
    public static final int LIST_OF_UNITS = 0;
    public static final int SIZE_OF_LISTS = 1;
    private JTextField idTextField;
    private JTextField nameTextField;
    private JButton unitListDlgButton;
    private boolean[] isFirstShowing;
    private boolean useKeyListenerToTextFields = false;
    SBaseListDialog[] listDialog = new SBaseListDialog[1];
    private MyKeyListener myKeyListener;
    private static String[] dialogClassName = new String[]{"UnitDialog"};

    public UnitDefinitionDialog() {
        this.initListDialogs();
        if (this.useKeyListenerToTextFields) {
            this.addListenerToTextFields();
        }
        this.initIsFirstShowing();
    }

    public UnitDefinitionDialog(Dialog owner) {
        super(owner);
        this.initListDialogs();
        if (this.useKeyListenerToTextFields) {
            this.addListenerToTextFields();
        }
        this.initIsFirstShowing();
    }

    public UnitDefinitionDialog(Frame owner) {
        super(owner);
        this.initListDialogs();
        if (this.useKeyListenerToTextFields) {
            this.addListenerToTextFields();
        }
        this.initIsFirstShowing();
    }

    public void setDialogByArg(String id, String name) {
        this.idTextField.setText(id);
        this.nameTextField.setText(name);
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        JLabel idLabel = new JLabel("id");
        idLabel.setBounds(new Rectangle(10, 10, 60, 20));
        this.mainPanel.add((Component)idLabel, null);
        this.idTextField = new JTextField();
        this.idTextField.setBounds(new Rectangle(55, 10, 200, 20));
        this.idTextField.setEditable(true);
        this.idTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.idTextField, null);
        JLabel nameLabel = new JLabel("name");
        nameLabel.setBounds(new Rectangle(10, 34, 60, 20));
        this.mainPanel.add((Component)nameLabel, null);
        this.nameTextField = new JTextField();
        this.nameTextField.setBounds(new Rectangle(55, 34, 200, 20));
        this.nameTextField.setEditable(true);
        this.nameTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.nameTextField, null);
        JLabel listOfUnitsLabel = new JLabel("listOfUnits");
        listOfUnitsLabel.setBounds(new Rectangle(10, 70, 160, 20));
        this.mainPanel.add((Component)listOfUnitsLabel, null);
        this.unitListDlgButton = new JButton("Show list..");
        this.unitListDlgButton.setBounds(new Rectangle(145, 70, 110, 20));
        this.unitListDlgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnitDefinitionDialog.this.listDlgButton_actionPerformed(0);
            }
        });
        this.unitListDlgButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                UnitDefinitionDialog.this.rootPane.setDefaultButton(UnitDefinitionDialog.this.unitListDlgButton);
            }
        });
        this.mainPanel.add((Component)this.unitListDlgButton, null);
        this.LABEL_WIDTH = 40;
        this.TEXT_WIDTH = 200;
        this.setLayoutConstants();
        this.BUTTON_POSITION_Y = 10 + 4 * this.BASELINE_SKIP;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new UnitDefinition();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        UnitDefinition unitDefinition = (UnitDefinition)sbase;
        String id = unitDefinition.getId();
        this.idTextField.setText(id);
        this.idTextField.setCaretPosition(id.length());
        if (id != null && !id.equals("") && (id.equals("substance") || id.equals("volume") || id.equals("area") || id.equals("length") || id.equals("time"))) {
            this.idTextField.setEnabled(false);
        }
        String name = unitDefinition.getName();
        this.nameTextField.setText(name);
        this.nameTextField.setCaretPosition(name.length());
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        UnitDefinition unitDefinition = (UnitDefinition)sbase;
        String str = this.idTextField.getText();
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        String oldID = new String(unitDefinition.getId());
        String newID = new String(str);
        try {
            SId.check(str);
            if (UnitDefinitionDialog.checkSId(sbModel.getModel(), unitDefinition, str)) {
                unitDefinition.setId(str);
            }
        }
        catch (SIdFormatException e) {
            throw new Exception(String.valueOf(str) + " is an invalid SId. Please rename it.");
        }
        str = this.nameTextField.getText();
        unitDefinition.setName(str);
        if (!newID.equals(oldID)) {
            HashMap hashUnitNotes = sbModel.getHashUnitNotes();
            this.changeNotesforIdChange(hashUnitNotes, oldID, newID);
            this.changeToNewUnits(sbModel, oldID, newID);
        }
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.idTextField.setEnabled(isEnabled);
        this.nameTextField.setEnabled(isEnabled);
        this.unitListDlgButton.setEnabled(isEnabled);
        this.changeListDialogsEnablility(isEnabled);
        this.okButton.setEnabled(isEnabled);
        this.cancelButton.setEnabled(isEnabled);
    }

    @Override
    protected void releaseAllMembers() {
        int i = 0;
        while (i < 1) {
            this.listDialog[i].releaseAll();
            this.listDialog[i] = null;
            this.listDialog = null;
            ++i;
        }
        if (this.useKeyListenerToTextFields) {
            this.removeListenerFromTextFields();
        }
    }

    @Override
    protected boolean hasChildListDialog() {
        return true;
    }

    @Override
    protected void setChildDialogMode(int mode) {
        int i = 0;
        while (i < 1) {
            this.listDialog[i].setElementDialogMode(mode);
            if (mode == 1) {
                this.listDialog[i].setModal(true);
            } else {
                this.listDialog[i].setModal(false);
            }
            ++i;
        }
    }

    @Override
    protected void updateChildDialog() {
        int i = 0;
        while (i < 1) {
            SBaseListDialog listDlg = this.listDialog[i];
            if (listDlg != null) {
                listDlg.updateDialog();
            }
            ++i;
        }
    }

    private void initListDialogs() {
        int i = 0;
        while (i < 1) {
            block4: {
                this.listDialog[i] = new ListDialog(this);
                this.listDialog[i].setTitle(LibSBMLUtil.getListTagName("UnitDefinition", i));
                this.listDialog[i].addSBaseListDialogListener(new MyListListener(i));
                SBaseDialog elementDialog = null;
                String dialogName = String.valueOf(this.getClass().getPackage().getName()) + "." + dialogClassName[i];
                SBaseListDialog owner = this.listDialog[i];
                try {
                    Constructor<?> con = Class.forName(dialogName).getConstructor(Class.forName("java.awt.Dialog"));
                    elementDialog = (SBaseDialog)con.newInstance(owner);
                }
                catch (Exception e) {
                    DebugPrinter.println(1, "UnitDefinitionDialog-initListDialogs-cannnot construct:" + dialogClassName[i] + " ,skip");
                    break block4;
                }
                if (elementDialog != null) {
                    elementDialog.setTitle(LibSBMLUtil.getElementClassName("UnitDefinition", i));
                    this.listDialog[i].setElementDialog(elementDialog);
                }
            }
            ++i;
        }
        this.changeListDialogsEnablility(false);
    }

    private void changeListDialogsEnablility(boolean isEnabled) {
        int i = 0;
        while (i < 1) {
            if (!isEnabled) {
                this.listDialog[i].setSBaseList(null);
                this.listDialog[i].disableChildDialog();
            }
            ++i;
        }
    }

    private void setListDialogs(UnitDefinition unitDefinition) {
        this.changeListDialogsEnablility(unitDefinition != null);
        if (unitDefinition == null) {
            return;
        }
        int i = 0;
        while (i < 1) {
            this.listDialog[i].setSBaseList((ListOf)unitDefinition.getListOfUnits());
            ++i;
        }
    }

    private void listDlgButton_actionPerformed(int i) {
        this.showListDialog(i);
    }

    private void addListenerToTextFields() {
        AnyInput annotationInput;
        this.myKeyListener = new MyKeyListener();
        this.idTextField.addKeyListener(this.myKeyListener);
        this.nameTextField.addKeyListener(this.myKeyListener);
        AnyInput notesInput = super.getAnyInput(1001);
        if (notesInput != null) {
            notesInput.getComponent().addKeyListener(this.myKeyListener);
        }
        if ((annotationInput = super.getAnyInput(1002)) != null) {
            annotationInput.getComponent().addKeyListener(this.myKeyListener);
        }
    }

    private void removeListenerFromTextFields() {
        AnyInput annotationInput;
        this.idTextField.removeKeyListener(this.myKeyListener);
        this.nameTextField.removeKeyListener(this.myKeyListener);
        AnyInput notesInput = super.getAnyInput(1001);
        if (notesInput != null) {
            notesInput.getComponent().removeKeyListener(this.myKeyListener);
        }
        if ((annotationInput = super.getAnyInput(1002)) != null) {
            annotationInput.getComponent().removeKeyListener(this.myKeyListener);
        }
        this.myKeyListener = null;
    }

    private void setListDialogPosition(int i) {
        if (this.listDialog[i] != null && this.isFirstShowing[i]) {
            Point p = this.getLocation();
            Dimension mysize = this.getSize();
            Dimension dlgsize = this.listDialog[i].getSize();
            int x = p.x + (mysize.width - dlgsize.width) / 2;
            int y = p.y + (mysize.height - dlgsize.height) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.listDialog[i].setLocation(x, y);
            this.isFirstShowing[i] = false;
        }
    }

    private void initIsFirstShowing() {
        this.isFirstShowing = new boolean[1];
        int i = 0;
        while (i < 1) {
            this.isFirstShowing[i] = true;
            ++i;
        }
    }

    private void showListDialog(int i) {
        this.setListDialogPosition(i);
        this.listDialog[i].show();
    }

    @Override
    public void setObject(SBase sbase) {
        super.setObject(sbase);
        this.setListDialogs((UnitDefinition)sbase);
    }

    @Override
    public void setNewObject() {
        super.setNewObject();
        this.setListDialogs((UnitDefinition)super.getObject());
    }

    public SBaseListDialog getSBaseListDialog(int list_const) {
        if (list_const < 0 || list_const >= 1) {
            return null;
        }
        return this.listDialog[list_const];
    }

    private void changeToNewUnits(SBModel sbModel, String oldUnits, String newUnits) {
        if (oldUnits == null || oldUnits.equals("")) {
            return;
        }
        if (sbModel == null) {
            return;
        }
        Vector<String> vecUnits = new Vector<String>();
        vecUnits.add(oldUnits);
        ListPanel.checkOrupdateOfUnitDefinitionID(sbModel.getModel(), vecUnits, newUnits, true);
    }

    private static final boolean checkSId(Model model, UnitDefinition sbase, String strUnitsSId) throws Exception {
        if (model == null) {
            throw new Exception("[System error] (checkSId) The given Model object is null.");
        }
        if (sbase == null) {
            throw new Exception("[System error] (checkSId) The given UnitDefinition object is null.");
        }
        if (strUnitsSId == null) {
            throw new Exception("[System error] (checkSId) The given string of UnitDefinition's ID is null.");
        }
        if (!strUnitsSId.equals(sbase.getId())) {
            int kind;
            ListOfUnitDefinitions list = model.getListOfUnitDefinitions();
            if (list != null && list.size() > 0L) {
                int i = 0;
                while ((long)i < list.size()) {
                    UnitDefinition ud = (UnitDefinition)list.get((long)i);
                    String strSIdOfModel = ud.getId();
                    if (strUnitsSId.equals(strSIdOfModel)) {
                        throw new Exception(String.valueOf(strUnitsSId) + " is already defined. Please rename it.");
                    }
                    ++i;
                }
            }
            if ((kind = libsbml.UnitKind_forName((String)strUnitsSId)) != 35 && kind != 3 && kind != 16 && kind != 20) {
                throw new Exception(String.valueOf(strUnitsSId) + " is the name of reserved base unit which can't be redefined by an UnitDefinition.");
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean beSureToChangeAllOtherSBasesUsedTheUnits(SBModel sbModel, String strUnitDefinitionId, String newkind, int newExponent, String strRemoveAndUpdate) {
        try {
            int intexponent;
            Object exponent;
            HashMap rule;
            boolean bMsgNotShowed = true;
            String strSpecies = "Species";
            String strCompartment = "Compartment";
            ListOfSpecies listSpecies = sbModel.getModel().getListOfSpecies();
            int cntspeiecs = 0;
            while ((long)cntspeiecs < listSpecies.size()) {
                block23: {
                    Species species = (Species)listSpecies.get((long)cntspeiecs);
                    String sbustance = species.getSubstanceUnits();
                    if (sbustance != null && (sbustance = sbustance.split("/")[0]) != null && sbustance.equals(strUnitDefinitionId) && bMsgNotShowed) {
                        if ("remove".equals(strRemoveAndUpdate)) {
                            UnitDefinitionDialog.showWarningDialogForBeUsing(strSpecies);
                            return false;
                        }
                        if ("update".equals(strRemoveAndUpdate)) {
                            rule = LibSBMLUtil.getSubstanceUnitsOfSpeciesRule();
                            if (rule != null && rule.containsKey(newkind)) {
                                exponent = rule.get(newkind);
                                if (exponent != null && newExponent != (intexponent = Integer.parseInt(exponent.toString()))) {
                                    UnitDefinitionDialog.showWarningDialogForBeUsing(strSpecies);
                                    return false;
                                }
                                break block23;
                            } else {
                                UnitDefinitionDialog.showWarningDialogForBeUsing(strSpecies);
                                return false;
                            }
                        }
                        if ("init".equals(strRemoveAndUpdate)) {
                            return false;
                        }
                    }
                }
                ++cntspeiecs;
            }
            ListOfCompartments listCompartments = sbModel.getModel().getListOfCompartments();
            int cntCompartments = 0;
            while ((long)cntCompartments < listCompartments.size()) {
                block24: {
                    Compartment compartment = (Compartment)listCompartments.get((long)cntCompartments);
                    if (compartment.getUnits() != null && compartment.getUnits().equals(strUnitDefinitionId) && bMsgNotShowed) {
                        if ("remove".equals(strRemoveAndUpdate)) {
                            UnitDefinitionDialog.showWarningDialogForBeUsing(strCompartment);
                            return false;
                        }
                        if ("update".equals(strRemoveAndUpdate)) {
                            rule = null;
                            if (compartment.getSpatialDimensions() == 1L) {
                                rule = LibSBMLUtil.getUnitsOfCompartmentRule1();
                            } else if (compartment.getSpatialDimensions() == 2L) {
                                rule = LibSBMLUtil.getUnitsOfCompartmentRule2();
                            } else if (compartment.getSpatialDimensions() == 3L) {
                                rule = LibSBMLUtil.getUnitsOfCompartmentRule3();
                            }
                            if (rule != null && rule.containsKey(newkind)) {
                                exponent = rule.get(newkind);
                                if (exponent != null && newExponent != (intexponent = Integer.parseInt(exponent.toString()))) {
                                    UnitDefinitionDialog.showWarningDialogForBeUsing(strCompartment);
                                    return false;
                                }
                                break block24;
                            } else {
                                UnitDefinitionDialog.showWarningDialogForBeUsing(strCompartment);
                                return false;
                            }
                        }
                        if ("init".equals(strRemoveAndUpdate)) {
                            return false;
                        }
                    }
                }
                ++cntCompartments;
            }
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private static void showWarningDialogForBeUsing(String strName) {
        if (strName == null || strName.equals("")) {
            return;
        }
        String TITLE = "Warning";
        String message = "It is impossible to Update. \nBecause the new value of [Kind] or(and) [Exponent]\nis not satisfied to the " + strName + " which used\n" + "this UnitDefinition.";
        JOptionPane.showMessageDialog(null, message, TITLE, 2);
    }

    private class MyKeyListener
    extends KeyAdapter {
        private MyKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            try {
                UnitDefinitionDialog.this.updateObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class MyListListener
    implements SBaseListDialogListener {
        String listName = "";
        int listNumber;

        public MyListListener(int i) {
            this.listName = LibSBMLUtil.getListTagName("UnitDefinition", i);
            this.listNumber = i;
        }

        @Override
        public void elementAdded(SBase sbase) {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementAdded()");
            try {
                UnitDefinitionDialog.this.updateObject();
            }
            catch (Exception e) {
                DebugPrinter.println(1, "UnitDefinitionDialog.MyListListener.elementAdded: " + this.listName + " failed.");
            }
        }

        @Override
        public void elementUpdated(SBase sbase, String[] oldValues) {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementUpdated()");
            try {
                UnitDefinitionDialog.this.updateObject();
            }
            catch (Exception e) {
                DebugPrinter.println(1, "UnitDefinitionDialog.MyListListener.elementUpdated: " + this.listName + " failed.");
            }
        }

        @Override
        public void elementsRemoved(SBase[] sbases, int[] index) {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementsRemoved()" + sbases.length);
            try {
                UnitDefinitionDialog.this.updateObject();
            }
            catch (Exception e) {
                DebugPrinter.println(1, "UnitDefinitionDialog.MyListListener.elementsRemoved: " + this.listName + " failed.");
            }
        }

        @Override
        public void elementsSelected(SBase[] sbases) {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementsSelected()" + sbases.length);
        }

        @Override
        public void elementsDeselected() {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementsDeselected()");
        }

        @Override
        public void dialogClosed() {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":dialogClosed()");
            UnitDefinitionDialog.this.listDialog[this.listNumber].setVisible(false);
        }

        @Override
        public void elementMousePressed(SBase sb) {
        }
    }
}

