/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.fric.mathematics.algebra.Fraction;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.MathEditPanel;
import jp.sbi.sbml.util.MathEditor;
import jp.sbi.sbml.util.MessageDialog;
import jp.sbi.sbml.util.ReactionDialog;
import jp.sbi.sbml.util.SBaseDialog;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.ListOfSpeciesReferences;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.SpeciesReference;
import org.sbml.libsbml.StoichiometryMath;
import org.sbml.libsbml.libsbml;

public class SpeciesReferenceDialog
extends SBaseDialog
implements MathEditor {
    private JTextField speciesTextField;
    private JTextField stoichiometryTextField;
    private JTextField mathTextField;
    private MathEditPanel mathPanel;
    private String type;
    private Reaction parentReaction;
    private Dialog parentDialog;

    public void setParentDialog(Dialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    public Reaction getReaction() {
        return this.parentReaction;
    }

    public void setReaction(Reaction parentReaction) {
        this.parentReaction = parentReaction;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SpeciesReferenceDialog() {
    }

    public SpeciesReferenceDialog(Dialog owner) {
        super(owner);
    }

    public SpeciesReferenceDialog(Frame owner) {
        super(owner);
    }

    @Override
    protected JPanel createDialogPanel() {
        this.LABEL_WIDTH = 120;
        this.TEXT_WIDTH = 400;
        this.setLayoutConstants();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        int yline = this.VERTICAL_MARGIN;
        JLabel speciesLabel = new JLabel("species");
        speciesLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)speciesLabel, null);
        this.speciesTextField = new JTextField();
        this.speciesTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.speciesTextField.setEditable(true);
        this.speciesTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.speciesTextField, null);
        JLabel stoichiometryLabel = new JLabel("stoichiometry");
        stoichiometryLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)stoichiometryLabel, null);
        this.stoichiometryTextField = new JTextField();
        this.stoichiometryTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.stoichiometryTextField.setEditable(true);
        this.stoichiometryTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.stoichiometryTextField, null);
        JLabel stoichiometryMathLabel = new JLabel("stoichiometryMath");
        stoichiometryMathLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)stoichiometryMathLabel, null);
        this.mathPanel = new MathEditPanel();
        int mpheight = this.mathPanel.createUI(this.TEXT_WIDTH, this.LINE_HEIGHT, this.BASELINE_SKIP);
        this.mathPanel.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, mpheight));
        this.mathTextField = this.mathPanel.getTextField();
        this.mathTextField.setEditable(true);
        this.mathTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.mathPanel, null);
        this.BUTTON_POSITION_Y = yline += mpheight + this.BASELINE_SKIP - this.LINE_HEIGHT;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new SpeciesReference();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        SpeciesReference speciesReference = (SpeciesReference)sbase;
        String species = speciesReference.getSpecies();
        this.speciesTextField.setText(species);
        this.speciesTextField.setCaretPosition(species.length());
        String mathString = "";
        if (speciesReference.getStoichiometryMath() != null) {
            mathString = libsbml.formulaToString((ASTNode)speciesReference.getStoichiometryMath().getMath());
        }
        if (mathString.equals("")) {
            double stoichiometry = speciesReference.getStoichiometry();
            String s1 = Double.toString(stoichiometry);
            this.stoichiometryTextField.setText(s1);
            this.stoichiometryTextField.setCaretPosition(s1.length());
        } else {
            this.stoichiometryTextField.setText("");
        }
        this.mathTextField.setText(mathString);
        this.mathTextField.setCaretPosition(mathString.length());
        this.mathPanel.clearSelectedItemText();
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        SpeciesReference speciesReference = (SpeciesReference)sbase;
        SBModel sbModel = null;
        try {
            sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            if (sbModel == null || sbModel.getModel() == null) {
                return;
            }
        }
        catch (Exception ex) {
            return;
        }
        try {
            if (!this.speciesTextField.getText().equals("")) {
                SId.check(this.speciesTextField.getText());
            }
            speciesReference.setSpecies(this.speciesTextField.getText());
        }
        catch (SIdFormatException e) {
            throw new Exception("malformed species string");
        }
        String stoDouble = this.stoichiometryTextField.getText();
        String stoMath = this.mathTextField.getText();
        if (!stoDouble.equals("") && !stoMath.equals("")) {
            throw new Exception("Either stoichiometry or stoichiometryMath should be input.");
        }
        if (stoDouble.equals("") && stoMath.equals("")) {
            speciesReference.setStoichiometry(1.0);
            if (this.type.equals("Reactants")) {
                ListOfSpeciesReferences listra = this.parentReaction.getListOfReactants();
                ArrayList<Object> list = new ArrayList<Object>();
                double numReactants = this.parentReaction.getNumReactants();
                int selectedRow = ((ReactionDialog)this.parentDialog).getSelectedRow(this.type);
                int i = 0;
                while ((double)i < numReactants) {
                    if (i == selectedRow) {
                        SpeciesReference newSpecies = new SpeciesReference();
                        newSpecies.setAnnotation(speciesReference.getAnnotation());
                        newSpecies.setNotes(speciesReference.getNotes());
                        newSpecies.setSpecies(speciesReference.getSpecies());
                        newSpecies.setStoichiometry(speciesReference.getStoichiometry());
                        newSpecies.setDenominator(speciesReference.getDenominator());
                        listra.remove(0L);
                        list.add(newSpecies);
                    } else {
                        list.add(listra.remove(0L));
                    }
                    ++i;
                }
                i = 0;
                while (i < list.size()) {
                    listra.appendAndOwn((SBase)((SpeciesReference)list.get(i)));
                    ++i;
                }
            } else if (this.type.equals("Products")) {
                ListOfSpeciesReferences listpd = this.parentReaction.getListOfProducts();
                ArrayList<Object> list = new ArrayList<Object>();
                double numProducts = this.parentReaction.getNumProducts();
                int selectedRow = ((ReactionDialog)this.parentDialog).getSelectedRow(this.type);
                int i = 0;
                while ((double)i < numProducts) {
                    if (i == selectedRow) {
                        SpeciesReference newSpecies = new SpeciesReference();
                        newSpecies.setAnnotation(speciesReference.getAnnotation());
                        newSpecies.setNotes(speciesReference.getNotes());
                        newSpecies.setSpecies(speciesReference.getSpecies());
                        newSpecies.setStoichiometry(speciesReference.getStoichiometry());
                        newSpecies.setDenominator(speciesReference.getDenominator());
                        listpd.remove(0L);
                        list.add(newSpecies);
                    } else {
                        list.add(listpd.remove(0L));
                    }
                    ++i;
                }
                i = 0;
                while (i < list.size()) {
                    listpd.appendAndOwn((SBase)((SpeciesReference)list.get(i)));
                    ++i;
                }
            }
        } else if (!stoDouble.equals("")) {
            double d = Double.parseDouble(stoDouble);
            if (d <= 0.0) {
                throw new Exception("stoichiometry must be a positive number");
            }
            speciesReference.setStoichiometry(d);
            if (this.type.equals("Reactants")) {
                ListOfSpeciesReferences listra = this.parentReaction.getListOfReactants();
                ArrayList<Object> list = new ArrayList<Object>();
                double numReactants = this.parentReaction.getNumReactants();
                int selectedRow = ((ReactionDialog)this.parentDialog).getSelectedRow(this.type);
                int i = 0;
                while ((double)i < numReactants) {
                    if (i == selectedRow) {
                        SpeciesReference newSpecies = new SpeciesReference();
                        newSpecies.setAnnotation(speciesReference.getAnnotation());
                        newSpecies.setNotes(speciesReference.getNotes());
                        newSpecies.setSpecies(speciesReference.getSpecies());
                        newSpecies.setStoichiometry(speciesReference.getStoichiometry());
                        newSpecies.setDenominator(speciesReference.getDenominator());
                        listra.remove(0L);
                        list.add(newSpecies);
                    } else {
                        list.add(listra.remove(0L));
                    }
                    ++i;
                }
                i = 0;
                while (i < list.size()) {
                    listra.appendAndOwn((SBase)((SpeciesReference)list.get(i)));
                    ++i;
                }
            } else if (this.type.equals("Products")) {
                ListOfSpeciesReferences listpd = this.parentReaction.getListOfProducts();
                ArrayList<Object> list = new ArrayList<Object>();
                double numProducts = this.parentReaction.getNumProducts();
                int selectedRow = ((ReactionDialog)this.parentDialog).getSelectedRow(this.type);
                int i = 0;
                while ((double)i < numProducts) {
                    if (i == selectedRow) {
                        SpeciesReference newSpecies = new SpeciesReference();
                        newSpecies.setAnnotation(speciesReference.getAnnotation());
                        newSpecies.setNotes(speciesReference.getNotes());
                        newSpecies.setSpecies(speciesReference.getSpecies());
                        newSpecies.setStoichiometry(speciesReference.getStoichiometry());
                        newSpecies.setDenominator(speciesReference.getDenominator());
                        listpd.remove(0L);
                        list.add(newSpecies);
                    } else {
                        list.add(listpd.remove(0L));
                    }
                    ++i;
                }
                i = 0;
                while (i < list.size()) {
                    listpd.appendAndOwn((SBase)((SpeciesReference)list.get(i)));
                    ++i;
                }
            }
            Fraction f = Fraction.approximate(d, 200);
            if (f == null) {
                MessageDialog.showMessageDialog(this, "Confirmation", "SBML Level 1 compatibility", "The double value of stoichiometry cannot be converted to likely integer or fractional number. Please use its fractional expression in stoichiometryMath, if you know, or exporting to an SBML Level 1 file will fail.");
            }
        } else {
            try {
                if (libsbml.parseFormula((String)stoMath) == null) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new Exception("malformed math string");
            }
            if (LibSBMLUtil.haveConstantValueInMath(libsbml.parseFormula((String)stoMath))) {
                throw new Exception(LibSBMLUtil.getHaveConstantValueInMathErroMessage("stoichiometryMath"));
            }
            LibSBMLUtil.checkTheNumberOfArgumentsForFunctionDefinition(libsbml.parseFormula((String)stoMath), sbModel.getModel(), null);
            speciesReference.setStoichiometryMath(new StoichiometryMath(libsbml.parseFormula((String)stoMath)));
        }
        if (speciesReference.getStoichiometryMath() != null) {
            LibSBMLUtil.changetoAstTimeNode(speciesReference.getStoichiometryMath().getMath());
        }
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.speciesTextField.setEnabled(false);
        this.stoichiometryTextField.setEnabled(isEnabled);
        this.mathTextField.setEnabled(isEnabled);
        this.okButton.setEnabled(isEnabled);
        this.cancelButton.setEnabled(isEnabled);
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }

    @Override
    public MathEditPanel getMathEditPanel() {
        return this.mathPanel;
    }
}

