/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.util.ArrayList;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.sbml.debug.DebugPrinter;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.ListPanel;
import jp.sbi.sbml.util.SBaseListPanel;
import jp.sbi.sbml.util.SpeciesDialog;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class SpeciesListPanel
extends ListPanel {
    private ArrayList displayList = null;

    public SpeciesListPanel() {
    }

    public SpeciesListPanel(boolean isShowDialog) {
        super(isShowDialog);
    }

    @Override
    protected void initTableModel(SBase sbase) {
        if (sbase == null) {
            return;
        }
        String[] columnNames = LibSBMLUtil.fieldShortNames(sbase);
        int[] columnSizes = LibSBMLUtil.fieldColumnSizes(sbase);
        if (sbase instanceof Species) {
            LibSBMLUtil.changePositionOfCompartment(columnNames, columnSizes);
        }
        this.listTableModel = new MyTableModel(columnNames);
        this.table.setModel(this.listTableModel);
        this.table.getTableHeader().addMouseListener(new TableMouseListener());
        try {
            int dialog_witdh = 0;
            int i = 0;
            while (i < columnSizes.length) {
                TableColumn column = this.table.getColumnModel().getColumn(i);
                if (sbase instanceof Species && ("spatialSizeUnits".equals(column.getHeaderValue()) || "charge".equals(column.getHeaderValue()))) {
                    LibSBMLUtil.hideTableColumn(column);
                } else {
                    column.setPreferredWidth(columnSizes[i]);
                    dialog_witdh += columnSizes[i];
                }
                ++i;
            }
            this.setSize(dialog_witdh + 11, this.getSize().height);
            this.validate();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            DebugPrinter.println(1, e.getMessage());
        }
    }

    public ArrayList getDisplayList() {
        if (this.displayList == null) {
            return new ArrayList();
        }
        return this.displayList;
    }

    @Override
    public void updateDialog() {
        if (this.listTableModel == null) {
            return;
        }
        if (this.sbaseList != null) {
            Model model = MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel();
            this.displayList = LibSBMLUtil.getListOfIndependentSpecies((ListOf)model.getListOfSpecies());
        }
        this.listTableModel.fireTableDataChanged();
        this.changeButtonsEnability();
        if (this.isShowing()) {
            this.repaint();
        }
        this.updateChildDialog();
    }

    @Override
    public SBase getLastSelectedElement() {
        if (this.displayList == null) {
            return null;
        }
        int i = this.table.getSelectedRow();
        if (i >= 0 && i < this.displayList.size()) {
            return (SBase)this.displayList.get(i);
        }
        return null;
    }

    @Override
    public SBase[] getSelectedElements() {
        if (this.displayList == null) {
            SBase[] array = new SBase[]{};
            return array;
        }
        int[] cnt = this.table.getSelectedRows();
        SBase[] array = new SBase[cnt.length];
        int i = 0;
        while (i < cnt.length) {
            int index = cnt[i];
            array[i] = (SBase)this.displayList.get(index);
            ++i;
        }
        return array;
    }

    @Override
    public void setSBaseList(ListOf sbaseList) {
        if (sbaseList != null) {
            Model model = MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel();
            this.displayList = LibSBMLUtil.getListOfIndependentSpecies((ListOf)model.getListOfSpecies());
        } else {
            this.displayList = null;
        }
        super.setSBaseList(sbaseList);
    }

    @Override
    public void showElementDialog(SBase sbase) {
        if (this.displayList == null || this.elementDlg == null) {
            return;
        }
        String id = ((Species)sbase).getId();
        int i = 0;
        while (i < this.displayList.size()) {
            Species sb = (Species)this.displayList.get(i);
            if (sb.getId().equals(id)) {
                this.selectElement(new int[]{i});
                break;
            }
            ++i;
        }
        this.isDialogVisiable = true;
        this.elementDlg.setParentListPanel(this);
        this.elementDlg.setObject(sbase);
        this.elementDlg.updateDialog();
        this.showElementDialog();
    }

    @Override
    public void valueSettedToCell(Object settedvalue, int rowIndex, int columnIndex) {
        SBase base = (SBase)this.displayList.get(rowIndex);
        this.elementDlg.setObject(base);
        this.elementDlg.updateDialog();
        String val = (String)settedvalue;
        int initialamountindex = 8;
        String initialamount = (String)this.table.getValueAt(rowIndex, initialamountindex);
        if (columnIndex == initialamountindex) {
            initialamount = val;
        }
        SpeciesDialog dlg = (SpeciesDialog)this.elementDlg;
        dlg.setDialogByArg(initialamount, "", "");
        if (!this.elementDlg.update_actionPerformed()) {
            this.table.setRowSelectionInterval(rowIndex, rowIndex);
            this.tableedited = true;
        }
    }

    protected class MyTableModel
    extends SBaseListPanel.MyTableModel {
        MyTableModel(String[] columnNames) {
            super(columnNames);
        }

        @Override
        public Object getValueAt(int row, int col) {
            return LibSBMLUtil.getListOfValueAt(SpeciesListPanel.this.displayList, row, col);
        }

        @Override
        public int getRowCount() {
            if (SpeciesListPanel.this.displayList == null) {
                return 0;
            }
            return SpeciesListPanel.this.displayList.size();
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            SpeciesListPanel.this.valueSettedToCell(value, rowIndex, columnIndex);
        }
    }

    protected class TableMouseListener
    extends ListPanel.TableMouseListener {
        protected TableMouseListener() {
        }

        @Override
        protected void sort(ListOf originalList, SBModel sbModel, String panelName, String colName, boolean isRestoreSelectedRows) {
            if (!SpeciesListPanel.this.bCanRespond) {
                return;
            }
            try {
                ListOf list = SpeciesListPanel.this.sbaseList;
                ArrayList<SBase> tempRemovedSBaseList = new ArrayList<SBase>();
                String defaultCompartmentValue = "";
                long lsize = list.size();
                int removed_num = 0;
                int i = 0;
                while ((long)i < lsize) {
                    Species sp = (Species)list.get((long)(i - removed_num));
                    if (sp.getCompartment().equals(defaultCompartmentValue)) {
                        tempRemovedSBaseList.add(list.remove((long)(i - removed_num)));
                        ++removed_num;
                    }
                    ++i;
                }
                String[] selectedIds = this.getSelectedIdsBackup(list);
                ListSelectionModel selectedModel = SpeciesListPanel.this.table.getSelectionModel();
                super.sort(list, sbModel, panelName, colName, false);
                SpeciesListPanel.this.displayList.clear();
                lsize = list.size();
                int i2 = 0;
                while ((long)i2 < lsize) {
                    SpeciesListPanel.this.displayList.add((Species)list.get((long)i2));
                    ++i2;
                }
                this.restoreSelectedRows(list, selectedModel, selectedIds);
                i2 = 0;
                while (i2 < tempRemovedSBaseList.size()) {
                    list.appendAndOwn((SBase)tempRemovedSBaseList.get(i2));
                    ++i2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

