/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.sbml.Any;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.util.ColoredTableCellRenderer;
import jp.sbi.sbml.util.InnerTable;
import jp.sbi.sbml.util.KineticLawDialog;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.MathEditPanel;
import jp.sbi.sbml.util.ReactionDialog;
import jp.sbi.sbml.util.SBMLPanelLists;
import jp.sbi.sbml.util.SBaseListPanel;
import jp.sbi.sbml.util.SortedTableModel;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfCompartments;
import org.sbml.libsbml.ListOfEvents;
import org.sbml.libsbml.ListOfFunctionDefinitions;
import org.sbml.libsbml.ListOfParameters;
import org.sbml.libsbml.ListOfReactions;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.ListOfUnitDefinitions;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class SpeciesIDEditDialog
extends JDialog {
    private JButton okButton;
    private JButton resetButton;
    private JButton cancelButton;
    private JButton copyButton;
    private JScrollPane scroll;
    protected InnerTable table;
    protected boolean isSpeciesIdEdit;
    protected static final Color defaultColor = new Color(255, 255, 255);
    protected static final Color disableColor = new Color(236, 233, 216);
    protected static final Color invalidColor = Color.RED;
    public static final Color unchangedColor = new Color(236, 233, 216);
    public static final Color updatedColor = Color.GREEN;
    public static final Color selectedColor = new Color(25, 120, 220);
    protected static final String UpdateTitle = "Replace Caution";
    protected static final String UpdateMessage = "Do you replace ID in green background?";
    protected static final String WarningTitle = "Error";
    protected static final String WarningMessage = "IDs in red background are overlapped in this model.";
    private Vector vctResultColors = new Vector();
    private static final char[] CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '_'};
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public SpeciesIDEditDialog(Frame frame, boolean isSpeciesId) {
        super(frame);
        this.isSpeciesIdEdit = isSpeciesId;
        this.init();
    }

    public SpeciesIDEditDialog(String id) {
    }

    private void init() {
        this.setModal(true);
        if (this.isSpeciesIdEdit) {
            this.setTitle("Species ID Replace");
        } else {
            this.setTitle("Reactions ID Replace");
        }
        this.setLocation(65, 50);
        this.setSize(500, 400);
        this.getContentPane().setLayout(new BorderLayout());
        this.scroll = new JScrollPane();
        this.scroll.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SpeciesIDEditDialog.this.table.clearSelectedStatus(SpeciesIDEditDialog.this.table.isEditing());
            }
        });
        this.createCenterPanel();
        this.createSouthPanel();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SpeciesIDEditDialog.this.table.clearSelectedStatus(SpeciesIDEditDialog.this.table.isEditing());
            }
        });
        this.setVisible(true);
    }

    private void createCenterPanel() {
        this.table = new InnerTable(this, this.getData());
        this.updateCellRenderer();
        this.scroll.getViewport().add(this.table);
        this.table.setAutoResizeMode(2);
        this.getContentPane().add("Center", this.scroll);
    }

    private void updateCellRenderer() {
        String id;
        String originID;
        Vector data;
        SBModel sbModel = null;
        try {
            sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            if (sbModel == null || sbModel.getModel() == null) {
                return;
            }
        }
        catch (Exception myErr) {
            return;
        }
        Vector listOfTableData = this.getSortedData();
        Object[] colors = new Object[listOfTableData.size()];
        Vector<String> vctCurretID = new Vector<String>();
        Vector<String> vctChecked = new Vector<String>();
        Vector<String> vctReChecked = new Vector<String>();
        int i = 0;
        while (i < this.getSortedData().size()) {
            data = (Vector)this.getSortedData().get(i);
            try {
                SId.check((String)data.get(2));
                vctCurretID.add((String)data.get(2));
                colors[i] = updatedColor;
            }
            catch (Exception e) {
                vctCurretID.add((String)data.get(0));
                colors[i] = e.getMessage().equals("SId:malformed string") ? invalidColor : (e.getMessage().equals("SId:void string") ? unchangedColor : defaultColor);
            }
            ++i;
        }
        i = 0;
        while (i < vctCurretID.size()) {
            data = (Vector)listOfTableData.elementAt(i);
            originID = (String)data.get(0);
            id = (String)vctCurretID.get(i);
            if (colors[i] == updatedColor) {
                if (!this.isValidID(id, vctCurretID)) {
                    colors[i] = invalidColor;
                    vctChecked.add(originID);
                } else {
                    if (originID.equals(id)) {
                        colors[i] = unchangedColor;
                    }
                    vctChecked.add(id);
                }
            } else {
                vctChecked.add(id);
            }
            ++i;
        }
        i = 0;
        while (i < vctChecked.size()) {
            data = (Vector)listOfTableData.elementAt(i);
            originID = (String)data.get(0);
            id = (String)vctChecked.get(i);
            if (colors[i] == updatedColor && !this.isValidID(id, vctChecked)) {
                colors[i] = invalidColor;
                vctReChecked.add(originID);
            } else {
                vctReChecked.add(id);
            }
            ++i;
        }
        this.vctResultColors = new Vector(vctReChecked.size());
        Vector<String> vctReCheckedBak = vctReChecked;
        vctReChecked = new Vector();
        int i2 = 0;
        while (i2 < vctReCheckedBak.size()) {
            String id2 = (String)vctReCheckedBak.get(i2);
            vctReChecked.add(id2);
            this.vctResultColors.add(colors[i2]);
            if (colors[i2] == updatedColor && !this.isValidID(id2, vctReCheckedBak)) {
                colors[i2] = invalidColor;
                this.vctResultColors.set(i2, colors[i2]);
                Vector data2 = (Vector)listOfTableData.elementAt(i2);
                String originID2 = (String)data2.get(0);
                vctReChecked.setElementAt(originID2, i2);
            }
            ++i2;
        }
        Vector vTmp = this.vctResultColors;
        vctReCheckedBak = vctReChecked;
        vctReChecked = new Vector();
        Vector data3 = this.getSortedData();
        int i3 = 0;
        while (i3 < vTmp.size()) {
            String id3 = (String)vctReCheckedBak.get(i3);
            vctReChecked.add(id3);
            if (colors[i3] == updatedColor) {
                int j = 0;
                while (j < data3.size()) {
                    String strOrgID = (String)((Vector)data3.get(j)).get(0);
                    if (id3.equals(strOrgID)) {
                        colors[i3] = invalidColor;
                        vTmp.set(i3, colors[i3]);
                        vctReChecked.setElementAt(strOrgID, i3);
                        break;
                    }
                    ++j;
                }
            }
            ++i3;
        }
        this.vctResultColors = vTmp;
        ListOf lstProts = sbModel.getListOfProteins();
        ListOf lstGenes = sbModel.getListOfGenes();
        ListOf lstRnas = sbModel.getListOfRNAs();
        ListOf lstArnas = sbModel.getListOfAntiSenseRNAs();
        ListOfSpecies lstSpecs = sbModel.getModel().getListOfSpecies();
        ListOfReactions lstReacs = sbModel.getModel().getListOfReactions();
        ListOfCompartments lstComps = sbModel.getModel().getListOfCompartments();
        ListOfParameters lstParas = sbModel.getModel().getListOfParameters();
        ListOfFunctionDefinitions lstFuncs = sbModel.getModel().getListOfFunctionDefinitions();
        ListOfUnitDefinitions lstUnits = sbModel.getModel().getListOfUnitDefinitions();
        ListOfEvents lstEvens = sbModel.getModel().getListOfEvents();
        Vector vTmp2 = this.vctResultColors;
        Vector<String> vctReCheckedBak2 = vctReChecked;
        vctReChecked = new Vector();
        int i4 = 0;
        while (i4 < vTmp2.size()) {
            String strOrgID = (String)((Vector)data3.get(i4)).get(0);
            String id4 = (String)vctReCheckedBak2.get(i4);
            vctReChecked.add(id4);
            if (colors[i4] == updatedColor) {
                boolean isBeenUsed;
                boolean bl = isBeenUsed = SpeciesIDEditDialog.isThisIDHavingBeenUsed(lstProts, id4) || SpeciesIDEditDialog.isThisIDHavingBeenUsed(lstGenes, id4) || SpeciesIDEditDialog.isThisIDHavingBeenUsed(lstRnas, id4) || SpeciesIDEditDialog.isThisIDHavingBeenUsed(lstArnas, id4) || !this.isSpeciesIdEdit && SpeciesIDEditDialog.isThisIDHavingBeenUsed((ListOf)lstSpecs, id4) || this.isSpeciesIdEdit && SpeciesIDEditDialog.isThisIDHavingBeenUsed((ListOf)lstReacs, id4) || SpeciesIDEditDialog.isThisIDHavingBeenUsed((ListOf)lstComps, id4) || SpeciesIDEditDialog.isThisIDHavingBeenUsed((ListOf)lstParas, id4) || SpeciesIDEditDialog.isThisIDHavingBeenUsed((ListOf)lstFuncs, id4) || SpeciesIDEditDialog.isThisIDHavingBeenUsed((ListOf)lstUnits, id4) || SpeciesIDEditDialog.isThisIDHavingBeenUsed((ListOf)lstEvens, id4);
                if (isBeenUsed) {
                    colors[i4] = invalidColor;
                    vTmp2.set(i4, colors[i4]);
                    vctReChecked.setElementAt(strOrgID, i4);
                }
            }
            ++i4;
        }
        this.vctResultColors = vTmp2;
        i4 = 0;
        while (i4 < this.table.getColumnCount()) {
            TableColumn column = this.table.getColumnModel().getColumn(i4);
            column.setCellRenderer(new ColoredTableCellRenderer(colors));
            column.setCellEditor(new DefaultCellEditor((JTextField)InnerTable.COL_LIST[2]));
            ++i4;
        }
    }

    protected void update() {
        this.updateCellRenderer();
        this.table.repaint();
    }

    private boolean isValidID(String value, Vector vec) {
        try {
            SId.check(value);
        }
        catch (Exception e) {
            return false;
        }
        int count = 0;
        int i = 0;
        while (i < vec.size()) {
            String id = (String)vec.get(i);
            if (id.equals(value) && ++count > 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void createSouthPanel() {
        JPanel panel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SpeciesIDEditDialog.this.actionPerformed_OK();
            }
        });
        this.resetButton = new JButton("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SpeciesIDEditDialog.this.actionPerformed_Reset();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SpeciesIDEditDialog.this.actionPerformed_Cancel();
            }
        });
        this.copyButton = new JButton("Copy 'Name' into 'New ID'");
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SpeciesIDEditDialog.this.actionPerformed_Copy();
            }
        });
        panel.add(this.okButton);
        panel.add(this.resetButton);
        panel.add(this.cancelButton);
        panel.add(this.copyButton);
        this.getContentPane().add("South", panel);
    }

    private void actionPerformed_OK() {
        this.table.clearSelectedStatus(this.table.isEditing());
        Vector listOfTableData = this.getSortedData();
        Vector<Integer> vctIndexOfUpdatedID = new Vector<Integer>();
        boolean existInvalidID = false;
        int i = 0;
        while (i < listOfTableData.size()) {
            Color color = (Color)this.vctResultColors.get(i);
            if (color == invalidColor) {
                existInvalidID = true;
            } else if (color == updatedColor) {
                vctIndexOfUpdatedID.add(new Integer(i));
            }
            ++i;
        }
        if (vctIndexOfUpdatedID.size() > 0) {
            if (JOptionPane.showConfirmDialog(this, UpdateMessage, UpdateTitle, 0) != 0) {
                return;
            }
        } else {
            if (existInvalidID) {
                JOptionPane.showMessageDialog(this, WarningMessage, WarningTitle, 2);
                return;
            }
            this.actionPerformed_Cancel();
            return;
        }
        Model model = MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel();
        SBModelFrame sbframe = MainWindow.getLastInstance().getCurrentModel();
        SBModel sbModel = sbframe.getSBModel();
        if (!this.isSpeciesIdEdit) {
            this.replaceReactionsID(sbframe, vctIndexOfUpdatedID, listOfTableData);
            return;
        }
        int i2 = 0;
        while (i2 < vctIndexOfUpdatedID.size()) {
            int index = (Integer)vctIndexOfUpdatedID.get(i2);
            Vector data = (Vector)listOfTableData.elementAt(index);
            Species sp = model.getSpecies((String)data.get(0));
            String new_id = (String)data.get(2);
            String old_id = sp.getId();
            if (!new_id.equals(sp.getId())) {
                boolean bCanSeemAsDefaultSpeciesType = false;
                Any notes = LibSBMLUtil.getNotes((SBase)sp, null);
                sbModel.getHashSpeciesNotes().remove(sp.getId());
                sbModel.getHashSpeciesNotes().put(new_id, notes);
                Any annotation = LibSBMLUtil.getAnnotation((SBase)sp, null);
                sbModel.getHashSpeciesAnnotation().remove(sp.getId());
                sbModel.getHashSpeciesAnnotation().put(new_id, annotation);
                SpeciesAnnotation spAnno = (SpeciesAnnotation)annotation;
                MonoSpeciesProperty prop = (MonoSpeciesProperty)spAnno.getSpeciesProperty();
                if (prop.getType().equals("COMPLEX")) {
                    ArrayList includedSpecies = LibSBMLUtil.getListOfIncludedSpecies((ListOf)model.getListOfSpecies());
                    int k = 0;
                    while (k < includedSpecies.size()) {
                        Species inSp = (Species)includedSpecies.get(k);
                        SpeciesAnnotation inSpAnnotation = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)inSp, null);
                        if (inSpAnnotation.getComplexSpecies().equals(sp.getId())) {
                            inSpAnnotation.setComplexSpecies(new_id);
                        }
                        ++k;
                    }
                }
                sp.setId(new_id);
                LibSBMLUtil.replaceMathID(sbModel, old_id, new_id, 1, "");
            }
            ++i2;
        }
        SBMLPanelLists sbmlPanelLists = sbModel.getSBMLPanelLists();
        SBaseListPanel spPanel = sbmlPanelLists.getSBaseListPanel(6);
        MathEditPanel mePanel = null;
        boolean mathCheck = false;
        boolean nameCheck = false;
        if (spPanel.getElementDialog() != null && spPanel.getElementDialog() instanceof ReactionDialog) {
            ReactionDialog reactionDialog = (ReactionDialog)spPanel.getElementDialog();
            if (reactionDialog.kineticLawDialog != null && reactionDialog.kineticLawDialog.isShowing()) {
                KineticLawDialog kineticDialog = (KineticLawDialog)reactionDialog.kineticLawDialog;
                mePanel = kineticDialog.getMathEditPanel();
                mathCheck = mePanel.getMathCheckValue();
                nameCheck = mePanel.getNameCheckValue();
            }
        }
        sbframe.cancelNotesDialog();
        sbModel.getSBMLPanelLists().updateAllDialog();
        MainWindow.getLastInstance().resetMainWindowTree();
        MainWindow.getLastInstance().componentSelectionChanged();
        sbModel.setChanged(true);
        sbModel.reconfirmSpeciesID(0);
        this.actionPerformed_Cancel();
        if (mePanel != null && (mathCheck || nameCheck)) {
            mePanel.setMathCheckValue(mathCheck);
            mePanel.setNameCheckValue(nameCheck);
            mePanel.setDisplay();
        }
    }

    public String replaceMathID(String str, String oldId, String newId) {
        char[] chars = str.toCharArray();
        boolean isID = false;
        int startIndex = 0;
        StringBuffer math = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            String id;
            char c = chars[i];
            if (isID) {
                if (!SpeciesIDEditDialog.isChar(c) && !SpeciesIDEditDialog.isDigit(c)) {
                    isID = false;
                    id = str.substring(startIndex, i);
                    if (id.equals(oldId)) {
                        math.append(newId);
                    } else {
                        math.append(id);
                    }
                    math.append(c);
                } else if (i + 1 == chars.length) {
                    id = str.substring(startIndex, i + 1);
                    if (id.equals(oldId)) {
                        math.append(newId);
                    } else {
                        math.append(id);
                    }
                }
            } else if (!SpeciesIDEditDialog.isChar(c) && !SpeciesIDEditDialog.isDigit(c)) {
                math.append(c);
            } else {
                isID = true;
                startIndex = i;
                if (i + 1 == chars.length) {
                    id = str.substring(startIndex, i + 1);
                    if (id.equals(oldId)) {
                        math.append(newId);
                    } else {
                        math.append(id);
                    }
                }
            }
            ++i;
        }
        return math.toString();
    }

    private static boolean isChar(char c) {
        int i = 0;
        while (i < CHARS.length) {
            if (CHARS[i] == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isDigit(char c) {
        int i = 0;
        while (i < DIGITS.length) {
            if (DIGITS[i] == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void actionPerformed_Reset() {
        Vector listOfTableData = this.getSortedData();
        int i = 0;
        while (i < listOfTableData.size()) {
            Vector data = (Vector)listOfTableData.elementAt(i);
            data.set(2, data.get(0));
            this.table.getModel().setValueAt(data.get(0), i, 2);
            ++i;
        }
        this.updateCellRenderer();
        this.table.repaint();
    }

    private void actionPerformed_Cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private void actionPerformed_Copy() {
        this.table.clearSelectedStatus(this.table.isEditing());
        this.setNameIntoNewID();
        this.update();
    }

    private void setNameIntoNewID() {
        int rowCount = this.table.getModel().getRowCount();
        int i = 0;
        while (i < rowCount) {
            Object name = ((SortedTableModel)this.table.getModel()).getValueAt(i, 1);
            ((SortedTableModel)this.table.getModel()).setValueAt(name, i, 2);
            ++i;
        }
    }

    private Object[][] getData() {
        Model model = MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel();
        int iTotal = (int)model.getNumSpecies();
        if (!this.isSpeciesIdEdit) {
            iTotal = (int)model.getNumReactions();
        }
        Object[][] arrayData = new Object[iTotal][0];
        Vector listOfSpecies = new Vector();
        int i = 0;
        while (i < iTotal) {
            Object sp = this.isSpeciesIdEdit ? model.getSpecies((long)i) : model.getReaction((long)i);
            Vector<String> rowData = new Vector<String>();
            rowData.addElement(sp.getId());
            rowData.addElement(sp.getName());
            rowData.addElement(new String());
            listOfSpecies.addElement(rowData);
            ++i;
        }
        i = 0;
        while (i < iTotal) {
            Vector data = (Vector)listOfSpecies.elementAt(i);
            arrayData[i] = data.toArray();
            ++i;
        }
        return arrayData;
    }

    public Vector getSortedData() {
        int rowCount = this.table.getModel().getRowCount();
        Vector rowList = new Vector(rowCount);
        int i = 0;
        while (i < rowCount) {
            int colCount = this.table.getModel().getColumnCount();
            Vector<Object> row = new Vector<Object>(colCount);
            int j = 0;
            while (j < colCount) {
                Object value = ((SortedTableModel)this.table.getModel()).getValueAt(i, j);
                row.addElement(value);
                ++j;
            }
            rowList.addElement(row);
            ++i;
        }
        return rowList;
    }

    public static final boolean isThisIDHavingBeenUsed(ListOf listSbases, String sId) {
        SBase sbase;
        return listSbases != null && listSbases.size() > 0L && (sbase = listSbases.get(sId)) != null;
    }

    public void replaceReactionsID(SBModelFrame sbframe, Vector vctIndexOfUpdatedID, Vector listOfTableData) {
        try {
            SBModel sbModel = sbframe.getSBModel();
            Model model = sbModel.getModel();
            int i = 0;
            while (i < vctIndexOfUpdatedID.size()) {
                String old_id;
                int index = (Integer)vctIndexOfUpdatedID.get(i);
                Vector data = (Vector)listOfTableData.elementAt(index);
                Reaction reaction = model.getReaction((String)data.get(0));
                String new_id = (String)data.get(2);
                if (!new_id.equals(old_id = reaction.getId())) {
                    String newkey;
                    Object value;
                    HashMap hsmap;
                    String oldkey;
                    Any notes = LibSBMLUtil.getNotes((SBase)reaction, null);
                    sbModel.getHashReactionNotes().remove(old_id);
                    sbModel.getHashReactionNotes().put(new_id, notes);
                    Any annotation = LibSBMLUtil.getAnnotation((SBase)reaction, null);
                    sbModel.getHashReactionAnnotation().remove(old_id);
                    sbModel.getHashReactionAnnotation().put(new_id, annotation);
                    try {
                        ListOfParameters localparams = reaction.getKineticLaw().getListOfParameters();
                        int j = 0;
                        while ((long)j < localparams.size()) {
                            LibSBMLUtil.changeLocalParameterAnnoReactionID((Parameter)localparams.get((long)j), new_id);
                            ++j;
                        }
                    }
                    catch (Exception localparams) {
                        // empty catch block
                    }
                    int count = (int)reaction.getNumReactants();
                    int j = 0;
                    while (j < count) {
                        oldkey = LibSBMLUtil.getSpeciesReferenceReactantKey(old_id, count - j - 1);
                        hsmap = sbModel.getHashSpeciesReferenceReactantsAnnotation();
                        value = hsmap.get(oldkey);
                        hsmap.remove(oldkey);
                        newkey = LibSBMLUtil.getSpeciesReferenceReactantKey(new_id, count - j - 1);
                        hsmap.put(newkey, value);
                        ++j;
                    }
                    count = (int)reaction.getNumProducts();
                    j = 0;
                    while (j < count) {
                        oldkey = LibSBMLUtil.getSpeciesReferenceProductKey(old_id, count - j - 1);
                        hsmap = sbModel.getHashSpeciesReferenceProductsAnnotation();
                        value = hsmap.get(oldkey);
                        hsmap.remove(oldkey);
                        newkey = LibSBMLUtil.getSpeciesReferenceProductKey(new_id, count - j - 1);
                        hsmap.put(newkey, value);
                        ++j;
                    }
                    count = (int)reaction.getNumModifiers();
                    j = 0;
                    while (j < count) {
                        oldkey = LibSBMLUtil.getSpeciesReferenceModifierKey(old_id, count - j - 1);
                        hsmap = sbModel.getHashModifierSpeciesReferenceAnnotation();
                        value = hsmap.get(oldkey);
                        hsmap.remove(oldkey);
                        newkey = LibSBMLUtil.getSpeciesReferenceModifierKey(new_id, count - j - 1);
                        hsmap.put(newkey, value);
                        ++j;
                    }
                    reaction.setId(new_id);
                }
                ++i;
            }
            SBMLPanelLists sbmlPanelLists = sbModel.getSBMLPanelLists();
            SBaseListPanel spPanel = sbmlPanelLists.getSBaseListPanel(6);
            if (spPanel.getElementDialog() != null && spPanel.getElementDialog() instanceof ReactionDialog) {
                ReactionDialog reactionDialog = (ReactionDialog)spPanel.getElementDialog();
                if (reactionDialog.kineticLawDialog != null && reactionDialog.kineticLawDialog.isShowing()) {
                    reactionDialog.kineticLawDialog.cancelDialog();
                }
            }
            sbframe.cancelNotesDialog();
            sbframe.repaintLogicalArea(sbframe.getLogicalViewArea());
            sbModel.getSBMLPanelLists().updateAllDialog();
            MainWindow.getLastInstance().resetMainWindowTree();
            MainWindow.getLastInstance().componentSelectionChanged();
            sbModel.setChanged(true);
            this.actionPerformed_Cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

