/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.util.CompareSId;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.SBaseDialog;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.ListOfSpeciesTypes;
import org.sbml.libsbml.ListOfUnitDefinitions;
import org.sbml.libsbml.ListOfUnits;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.SpeciesType;
import org.sbml.libsbml.Unit;
import org.sbml.libsbml.UnitDefinition;
import org.sbml.libsbml.libsbml;

public class SpeciesDialog
extends SBaseDialog {
    private JTextField idTextField;
    private JTextField nameTextField;
    private JTextField compartmentTextField;
    private JRadioButton amountRadioButton;
    private JRadioButton concentrationRadioButton;
    private JTextField initialQuantityTextField;
    private JTextField spatialSizeUnitsTextField;
    private JRadioButton hasOnlySubstanceUnitsRadio;
    private JRadioButton hasOnlySubstanceUnitsFalseRadio;
    private JRadioButton boundaryConditionRadio;
    private JRadioButton boundaryConditionFalseRadio;
    private JTextField chargeTextField;
    private JRadioButton constantRadio;
    private JRadioButton constantFalseRadio;
    private JComboBox speciesTypeCombo;
    private JComboBox substanceUnitsCombo;
    public static final String strErrmsgOfSBaseEditingUsedByRuleAndReaction = "Can not update this Species to \n  [ boundaryCondition ]='false'  AND  [ constant ]='false' ,  \nbecause it has been used by Rules & Reactions together.";
    public static final String strErrmsgOfSBaseEditingUsedByReaction = "Can not update this Species to \n  [ boundaryCondition ]='false'  AND  [ constant ]='true' ,  \nbecause it has been used by Reactions.";

    public SpeciesDialog() {
    }

    public SpeciesDialog(Dialog owner) {
        super(owner);
    }

    public SpeciesDialog(Frame owner) {
        super(owner);
    }

    public void setDialogByArg(String initailamount, String units, String charge) {
        this.initialQuantityTextField.setText(initailamount);
        this.initialQuantityTextField.setCaretPosition(initailamount.length());
    }

    @Override
    protected JPanel createDialogPanel() {
        JLabel idLabel = new JLabel("id");
        this.idTextField = new JTextField();
        this.idTextField.setEditable(true);
        this.idTextField.getDocument().addDocumentListener(this.docListener);
        JLabel nameLabel = new JLabel("name");
        this.nameTextField = new JTextField();
        this.nameTextField.setEditable(true);
        this.nameTextField.getDocument().addDocumentListener(this.docListener);
        JLabel speciesTypeLabel = new JLabel("speciesType");
        this.speciesTypeCombo = new JComboBox();
        this.speciesTypeCombo.setEditable(false);
        this.speciesTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemevent) {
                SpeciesDialog.this.okButton.setEnabled(true);
                SpeciesDialog.this.cancelButton.setEnabled(true);
            }
        });
        JLabel compartmentLabel = new JLabel("compartment");
        this.compartmentTextField = new JTextField();
        this.compartmentTextField.setEditable(true);
        this.compartmentTextField.getDocument().addDocumentListener(this.docListener);
        JLabel initialQuantityLabel = new JLabel("initial...");
        JPanel initialQuantityPanel = new JPanel(null);
        initialQuantityPanel.setOpaque(true);
        initialQuantityPanel.setBorder(BorderFactory.createEtchedBorder(1));
        this.amountRadioButton = new JRadioButton("Amount");
        this.amountRadioButton.addActionListener(new MyRadioButtonListener());
        this.concentrationRadioButton = new JRadioButton("Concentration");
        this.concentrationRadioButton.addActionListener(new MyRadioButtonListener());
        ButtonGroup quantityTypeGroup = new ButtonGroup();
        quantityTypeGroup.add(this.amountRadioButton);
        quantityTypeGroup.add(this.concentrationRadioButton);
        this.initialQuantityTextField = new JTextField();
        this.initialQuantityTextField.setEditable(true);
        this.initialQuantityTextField.getDocument().addDocumentListener(this.docListener);
        JLabel substanceUnitsLabel = new JLabel("substanceUnits");
        this.substanceUnitsCombo = new JComboBox();
        this.substanceUnitsCombo.setEditable(false);
        this.substanceUnitsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemevent) {
                SpeciesDialog.this.okButton.setEnabled(true);
                SpeciesDialog.this.cancelButton.setEnabled(true);
            }
        });
        this.spatialSizeUnitsTextField = new JTextField();
        JLabel hasOnlySubstanceUnitsLabel = new JLabel("hasOnlySubstanceUnits");
        this.hasOnlySubstanceUnitsRadio = new JRadioButton("true");
        this.hasOnlySubstanceUnitsRadio.setEnabled(false);
        this.hasOnlySubstanceUnitsRadio.addActionListener(new MyRadioButtonListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeciesDialog.this.someFieldIsEdited();
            }
        });
        this.hasOnlySubstanceUnitsFalseRadio = new JRadioButton("false");
        this.hasOnlySubstanceUnitsFalseRadio.setEnabled(false);
        this.hasOnlySubstanceUnitsFalseRadio.addActionListener(new MyRadioButtonListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeciesDialog.this.someFieldIsEdited();
            }
        });
        ButtonGroup onlySubstanceUnitsGroup = new ButtonGroup();
        onlySubstanceUnitsGroup.add(this.hasOnlySubstanceUnitsRadio);
        onlySubstanceUnitsGroup.add(this.hasOnlySubstanceUnitsFalseRadio);
        JLabel boundaryConditionLabel = new JLabel("boundaryCondition");
        this.boundaryConditionRadio = new JRadioButton("true");
        this.boundaryConditionRadio.addActionListener(this.radioListener);
        this.boundaryConditionFalseRadio = new JRadioButton("false");
        this.boundaryConditionFalseRadio.addActionListener(this.radioListener);
        ButtonGroup boundaryConditionGroup = new ButtonGroup();
        boundaryConditionGroup.add(this.boundaryConditionRadio);
        boundaryConditionGroup.add(this.boundaryConditionFalseRadio);
        this.chargeTextField = new JTextField();
        JLabel constantLabel = new JLabel("constant");
        this.constantRadio = new JRadioButton("true");
        this.constantRadio.addActionListener(this.radioListener);
        this.constantFalseRadio = new JRadioButton("false");
        this.constantFalseRadio.addActionListener(this.radioListener);
        ButtonGroup constantsGroup = new ButtonGroup();
        constantsGroup.add(this.constantRadio);
        constantsGroup.add(this.constantFalseRadio);
        int maxLabelWidth = (int)hasOnlySubstanceUnitsLabel.getPreferredSize().getWidth();
        int amountRadioButtonWidth = (int)(this.amountRadioButton.getPreferredSize().getWidth() + 3.0);
        int concentrationRadioButtonWidth = (int)(this.concentrationRadioButton.getPreferredSize().getWidth() + 3.0);
        int textMaxWidth = amountRadioButtonWidth + this.BUTTON_MARGIN * 2 + concentrationRadioButtonWidth;
        this.LABEL_WIDTH = maxLabelWidth;
        this.TEXT_WIDTH = textMaxWidth;
        this.setLayoutConstants();
        int x1 = this.HORIZONTAL_MARGIN;
        int x2 = this.TEXT_POSITION_X;
        int yline = this.VERTICAL_MARGIN;
        idLabel.setBounds(x1, yline, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.idTextField.setBounds(x2, yline, this.TEXT_WIDTH, this.LINE_HEIGHT);
        nameLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.nameTextField.setBounds(x2, yline, this.TEXT_WIDTH, this.LINE_HEIGHT);
        speciesTypeLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.speciesTypeCombo.setBounds(x2, yline, this.TEXT_WIDTH, this.LINE_HEIGHT);
        compartmentLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.compartmentTextField.setBounds(x2, yline, this.TEXT_WIDTH, this.LINE_HEIGHT);
        initialQuantityLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        int margin = 4;
        initialQuantityPanel.setBounds(x2, yline, this.TEXT_WIDTH, this.BASELINE_SKIP + this.LINE_HEIGHT + 8);
        this.amountRadioButton.setBounds(4, 4, amountRadioButtonWidth, this.LINE_HEIGHT);
        this.concentrationRadioButton.setBounds(4 + amountRadioButtonWidth + this.BUTTON_MARGIN, 4, concentrationRadioButtonWidth, this.LINE_HEIGHT);
        this.initialQuantityTextField.setBounds(4, 4 + this.BASELINE_SKIP, this.TEXT_WIDTH - 8, this.LINE_HEIGHT);
        substanceUnitsLabel.setBounds(x1, yline += 2 * this.BASELINE_SKIP + 8, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.substanceUnitsCombo.setBounds(x2, yline, this.TEXT_WIDTH, this.LINE_HEIGHT);
        hasOnlySubstanceUnitsLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.hasOnlySubstanceUnitsRadio.setBounds(x2, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT);
        this.hasOnlySubstanceUnitsFalseRadio.setBounds(x2 + this.BUTTON_WIDTH + this.BUTTON_MARGIN, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT);
        boundaryConditionLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.boundaryConditionRadio.setBounds(x2, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT);
        this.boundaryConditionFalseRadio.setBounds(x2 + this.BUTTON_WIDTH + this.BUTTON_MARGIN, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT);
        constantLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.constantRadio.setBounds(x2, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT);
        this.constantFalseRadio.setBounds(x2 + this.BUTTON_WIDTH + this.BUTTON_MARGIN, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT);
        this.BUTTON_POSITION_Y = yline += this.BASELINE_SKIP;
        this.setDefaultButtonsLayout();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        this.mainPanel.add((Component)idLabel, null);
        this.mainPanel.add((Component)this.idTextField, null);
        this.mainPanel.add((Component)nameLabel, null);
        this.mainPanel.add((Component)this.nameTextField, null);
        this.mainPanel.add((Component)speciesTypeLabel, null);
        this.mainPanel.add((Component)this.speciesTypeCombo, null);
        this.mainPanel.add((Component)compartmentLabel, null);
        this.mainPanel.add((Component)this.compartmentTextField, null);
        this.mainPanel.add((Component)initialQuantityLabel, null);
        this.mainPanel.add((Component)initialQuantityPanel, null);
        initialQuantityPanel.add((Component)this.amountRadioButton, null);
        initialQuantityPanel.add((Component)this.concentrationRadioButton, null);
        initialQuantityPanel.add((Component)this.initialQuantityTextField, null);
        this.mainPanel.add((Component)substanceUnitsLabel, null);
        this.mainPanel.add((Component)this.substanceUnitsCombo, null);
        this.mainPanel.add((Component)hasOnlySubstanceUnitsLabel, null);
        this.mainPanel.add((Component)this.hasOnlySubstanceUnitsRadio, null);
        this.mainPanel.add((Component)this.hasOnlySubstanceUnitsFalseRadio, null);
        this.mainPanel.add((Component)boundaryConditionLabel, null);
        this.mainPanel.add((Component)this.boundaryConditionRadio, null);
        this.mainPanel.add((Component)this.boundaryConditionFalseRadio, null);
        this.mainPanel.add((Component)constantLabel, null);
        this.mainPanel.add((Component)this.constantRadio, null);
        this.mainPanel.add((Component)this.constantFalseRadio, null);
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new Species();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        String s1;
        if (sbase == null) {
            return;
        }
        Species species = (Species)sbase;
        String id = species.getId();
        this.idTextField.setText(id);
        this.idTextField.setCaretPosition(id.length());
        String name = species.getName();
        this.nameTextField.setText(name);
        this.nameTextField.setCaretPosition(name.length());
        String speciesType = species.getSpeciesType();
        ListOfSpeciesTypes list = null;
        SBModel sbmodel = null;
        try {
            sbmodel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            if (sbmodel == null || sbmodel.getModel() == null) {
                return;
            }
            Model model = sbmodel.getModel();
            list = model.getListOfSpeciesTypes();
        }
        catch (Exception ex) {
            return;
        }
        this.speciesTypeCombo.removeAllItems();
        this.speciesTypeCombo.addItem("");
        this.speciesTypeCombo.setSelectedIndex(0);
        if (list != null) {
            SpeciesType stype;
            Vector<String> uniqu = new Vector<String>();
            Vector<String> multi = new Vector<String>();
            int j = 0;
            while ((long)j < list.size()) {
                stype = (SpeciesType)list.get((long)j);
                String nameSpeciesType = stype.getName();
                if (!multi.contains(nameSpeciesType)) {
                    if (uniqu.contains(nameSpeciesType)) {
                        multi.add(nameSpeciesType);
                    } else {
                        uniqu.add(nameSpeciesType);
                    }
                }
                ++j;
            }
            int i = 0;
            while ((long)i < list.size()) {
                String nameSpeciesType;
                stype = (SpeciesType)list.get((long)i);
                String idSpeciesType = stype.getId();
                String displayName = nameSpeciesType = stype.getName();
                if (nameSpeciesType == null || nameSpeciesType.trim().equals("")) {
                    displayName = "No Name(" + idSpeciesType + ")";
                } else if (multi.contains(nameSpeciesType)) {
                    displayName = String.valueOf(nameSpeciesType) + "(" + idSpeciesType + ")";
                }
                SBaseDialog.comboItem comboitem = new SBaseDialog.comboItem();
                comboitem.id = idSpeciesType;
                comboitem.name = nameSpeciesType;
                comboitem.displayName = displayName;
                this.speciesTypeCombo.addItem(comboitem);
                if (list.get((long)i).getId().equals(speciesType)) {
                    this.speciesTypeCombo.setSelectedIndex(i + 1);
                }
                ++i;
            }
        }
        String compartment = species.getCompartment();
        this.compartmentTextField.setText(compartment);
        this.compartmentTextField.setCaretPosition(compartment.length());
        if (species.isSetInitialAmount()) {
            this.amountRadioButton.setSelected(true);
            s1 = "";
            double initialQuantity = species.getInitialAmount();
            s1 = Double.toString(initialQuantity);
            this.initialQuantityTextField.setText(s1);
            this.initialQuantityTextField.setCaretPosition(s1.length());
        } else if (species.isSetInitialConcentration()) {
            this.concentrationRadioButton.setSelected(true);
            s1 = "";
            double initialQuantity = species.getInitialConcentration();
            s1 = Double.toString(initialQuantity);
            this.initialQuantityTextField.setText(s1);
            this.initialQuantityTextField.setCaretPosition(s1.length());
        } else {
            this.amountRadioButton.setSelected(true);
            s1 = "";
            this.initialQuantityTextField.setText(s1);
            this.initialQuantityTextField.setCaretPosition(s1.length());
        }
        String substanceUnits = species.getSubstanceUnits();
        String spatialSizeUnits = species.getSpatialSizeUnits();
        this.spatialSizeUnitsTextField.setText(spatialSizeUnits);
        this.spatialSizeUnitsTextField.setCaretPosition(spatialSizeUnits.length());
        boolean hasOnly = species.getHasOnlySubstanceUnits();
        this.hasOnlySubstanceUnitsRadio.setSelected(hasOnly);
        this.hasOnlySubstanceUnitsFalseRadio.setSelected(!hasOnly);
        this.setInitialRadioButtonEnable(this.compartmentTextField.getText(), sbmodel);
        this.changeUnitsPulldownItems(hasOnly, substanceUnits);
        this.resetVariableComboBox();
        boolean b1 = species.getBoundaryCondition();
        this.boundaryConditionRadio.setSelected(b1);
        this.boundaryConditionFalseRadio.setSelected(!b1);
        int charge = species.getCharge();
        String s2 = Integer.toString(charge);
        this.chargeTextField.setText(s2);
        this.chargeTextField.setCaretPosition(s2.length());
        boolean b2 = species.getConstant();
        this.constantRadio.setSelected(b2);
        this.constantFalseRadio.setSelected(!b2);
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        Species species = (Species)sbase;
        Species originalSpecies = new Species();
        if (MainWindow.getLastInstance() != null) {
            Model model = MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel();
            originalSpecies = model.getSpecies(species.getId());
        }
        String str = this.idTextField.getText();
        try {
            SId.check(str);
            species.setId(str);
            originalSpecies.setId(str);
        }
        catch (SIdFormatException e) {
            throw new Exception("malformed id string");
        }
        str = this.nameTextField.getText();
        species.setName(str);
        originalSpecies.setName(str);
        str = this.compartmentTextField.getText();
        try {
            SId.check(str);
            species.setCompartment(str);
            originalSpecies.setCompartment(str);
        }
        catch (SIdFormatException e) {
            throw new Exception("malformed compartment string");
        }
        str = "";
        if (this.speciesTypeCombo.getSelectedItem() instanceof SBaseDialog.comboItem) {
            str = ((SBaseDialog.comboItem)this.speciesTypeCombo.getSelectedItem()).id;
        }
        species.setSpeciesType(str);
        originalSpecies.setSpeciesType(str);
        if (!this.amountRadioButton.isSelected()) {
            this.concentrationRadioButton.isSelected();
        }
        if ((str = this.initialQuantityTextField.getText()).equals("")) {
            if (species.isSetInitialAmount()) {
                species.unsetInitialAmount();
                originalSpecies.unsetInitialAmount();
            } else if (species.isSetInitialConcentration()) {
                species.unsetInitialConcentration();
                originalSpecies.unsetInitialConcentration();
            }
        } else {
            try {
                double d = Double.parseDouble(str);
                if (this.amountRadioButton.isSelected()) {
                    species.setInitialAmount(d);
                    originalSpecies.setInitialAmount(d);
                } else if (this.concentrationRadioButton.isSelected()) {
                    species.setInitialConcentration(d);
                    originalSpecies.setInitialConcentration(d);
                }
            }
            catch (NumberFormatException e) {
                throw new Exception("initialAmount/Concentration must be a real");
            }
        }
        species.setSubstanceUnits((String)this.substanceUnitsCombo.getSelectedItem());
        originalSpecies.setSubstanceUnits((String)this.substanceUnitsCombo.getSelectedItem());
        try {
            if (!this.spatialSizeUnitsTextField.getText().equals("")) {
                SId.check(this.spatialSizeUnitsTextField.getText());
            }
            species.setSpatialSizeUnits(this.spatialSizeUnitsTextField.getText());
            originalSpecies.setSpatialSizeUnits(this.spatialSizeUnitsTextField.getText());
        }
        catch (SIdFormatException e) {
            throw new Exception("mulformed spatialSizeUnits string");
        }
        boolean hasOnly = this.hasOnlySubstanceUnitsRadio.isSelected();
        species.setHasOnlySubstanceUnits(hasOnly);
        originalSpecies.setHasOnlySubstanceUnits(hasOnly);
        boolean b = this.boundaryConditionRadio.isSelected();
        species.setBoundaryCondition(b);
        originalSpecies.setBoundaryCondition(b);
        str = this.chargeTextField.getText();
        try {
            int i = Integer.parseInt(str);
            species.setCharge(i);
            originalSpecies.setCharge(i);
        }
        catch (NumberFormatException e) {
            species.setCharge(0);
            originalSpecies.setCharge(0);
        }
        boolean b2 = this.constantRadio.isSelected();
        species.setConstant(b2);
        originalSpecies.setConstant(b2);
    }

    public JRadioButton getBoundaryConditionRadioButton() {
        return this.boundaryConditionRadio;
    }

    public JRadioButton getConstantRadioButton() {
        return this.constantRadio;
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.idTextField.setEnabled(false);
        this.nameTextField.setEnabled(false);
        this.compartmentTextField.setEnabled(false);
        this.amountRadioButton.setEnabled(isEnabled);
        this.concentrationRadioButton.setEnabled(isEnabled);
        this.initialQuantityTextField.setEnabled(isEnabled);
        this.substanceUnitsCombo.setEnabled(isEnabled);
        this.spatialSizeUnitsTextField.setEditable(isEnabled);
        this.boundaryConditionRadio.setEnabled(isEnabled);
        this.boundaryConditionFalseRadio.setEnabled(isEnabled);
        this.chargeTextField.setEnabled(isEnabled);
        this.constantRadio.setEnabled(isEnabled);
        this.constantFalseRadio.setEnabled(isEnabled);
        this.okButton.setEnabled(isEnabled);
        this.cancelButton.setEnabled(isEnabled);
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }

    private void changeUnitsPulldownItems(boolean hasOnly, String strunit) {
        hasOnly = true;
        String unit = null;
        unit = strunit;
        if (unit != null && unit.contains("/")) {
            unit = unit.split("/")[0];
        }
        if (hasOnly) {
            this.setUnitsAndUnitsCombo(false, unit, "");
        } else {
            Compartment compartment = LibSBMLUtil.getCompartmentUsingID(this.compartmentTextField.getText());
            if (compartment != null) {
                long dimensions = compartment.getSpatialDimensions();
                if (dimensions > 0L) {
                    this.setUnitsAndUnitsCombo(true, unit, compartment.getUnits());
                } else if (dimensions == 0L) {
                    this.setUnitsAndUnitsCombo(false, unit, "");
                }
            }
        }
    }

    private void setUnitsAndUnitsCombo(boolean DisplayFlag, String sUnit, String strUnitsForCompartment) {
        DisplayFlag = false;
        if (sUnit == null) {
            sUnit = "";
        }
        this.substanceUnitsCombo.removeAllItems();
        this.substanceUnitsCombo.addItem("");
        String[] strsubstanceUnits = LibSBMLUtil.strListofSubstanceUnits;
        String strSize = "";
        if (DisplayFlag) {
            strSize = "/" + strUnitsForCompartment;
        }
        int i = 0;
        if (strsubstanceUnits != null) {
            while (i < strsubstanceUnits.length) {
                this.substanceUnitsCombo.addItem(String.valueOf(strsubstanceUnits[i]) + strSize);
                if (strsubstanceUnits[i].equals(sUnit)) {
                    this.substanceUnitsCombo.setSelectedIndex(i + 1);
                }
                ++i;
            }
            List listItem = SpeciesDialog.getListOfIdForUnitDefinitions();
            try {
                if (listItem.size() > 1) {
                    Collections.sort(listItem, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            return CompareSId.compareSId((String)o1, (String)o2);
                        }
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ArrayList<String> templist = new ArrayList<String>();
            int cnt = 0;
            while (cnt < listItem.size()) {
                String strId = (String)listItem.get(cnt);
                if (!templist.contains(strId) && !"substance".equals(strId)) {
                    this.substanceUnitsCombo.addItem(String.valueOf(strId) + strSize);
                    if (sUnit.equals(strId)) {
                        this.substanceUnitsCombo.setSelectedIndex(i + templist.size() + 1);
                    }
                    templist.add(strId);
                }
                ++cnt;
            }
            if (this.substanceUnitsCombo.getSelectedIndex() == -1) {
                this.substanceUnitsCombo.setSelectedIndex(0);
            }
        }
    }

    public static List getListOfIdForUnitDefinitions() {
        List listmole = LibSBMLUtil.getListOfIdForCondition(22, 1, true);
        List listitem = LibSBMLUtil.getListOfIdForCondition(11, 1, true);
        List listGram = LibSBMLUtil.getListOfIdForCondition(7, 1, true);
        List listKilogram = LibSBMLUtil.getListOfIdForCondition(15, 1, true);
        List listDimensionless = LibSBMLUtil.getListOfIdForCondition(5, 0, false);
        ArrayList listItem = new ArrayList();
        try {
            listItem.addAll(listmole);
            listItem.addAll(listitem);
            listItem.addAll(listGram);
            listItem.addAll(listKilogram);
            listItem.addAll(listDimensionless);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return listItem;
    }

    private void resetVariableComboBox() {
        this.substanceUnitsCombo.setEnabled(true);
        try {
            if (this.amountRadioButton.isSelected()) {
                this.hasOnlySubstanceUnitsRadio.setSelected(true);
            } else if (this.concentrationRadioButton.isSelected()) {
                this.hasOnlySubstanceUnitsFalseRadio.setSelected(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setInitialRadioButtonEnable(String strCompartmentId, SBModel sbmodel) {
        this.amountRadioButton.setEnabled(true);
        this.concentrationRadioButton.setEnabled(true);
        Compartment compartment = LibSBMLUtil.getCompartmentUsingID(strCompartmentId);
        if (compartment != null) {
            if (compartment.getSpatialDimensions() == 0L || libsbml.UnitKind_toString((int)5).equals(compartment.getUnits())) {
                this.amountRadioButton.setSelected(true);
                this.amountRadioButton.setEnabled(false);
                this.concentrationRadioButton.setEnabled(false);
            } else {
                String strComUnits = compartment.getUnits();
                try {
                    ListOfUnitDefinitions units = sbmodel.getModel().getListOfUnitDefinitions();
                    int i = 0;
                    while ((long)i < units.size()) {
                        Unit unit;
                        ListOfUnits lsUnits;
                        UnitDefinition unitDefinition = (UnitDefinition)units.get((long)i);
                        if (unitDefinition.getId().equals(strComUnits) && (lsUnits = unitDefinition.getListOfUnits()).size() == 1L && 5 == (unit = (Unit)lsUnits.get(0L)).getKind()) {
                            this.amountRadioButton.setSelected(true);
                            this.amountRadioButton.setEnabled(false);
                            this.concentrationRadioButton.setEnabled(false);
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception ex) {
                    return;
                }
            }
        }
    }

    protected class MyRadioButtonListener
    implements ActionListener {
        protected MyRadioButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpeciesDialog.this.resetVariableComboBox();
            SpeciesDialog.this.someFieldIsEdited();
        }
    }
}

