/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.util.KineticLawFormulaEvaluator;
import jp.sbi.sbml.util.SBaseDialog;
import org.sbml.libsbml.AssignmentRule;
import org.sbml.libsbml.SBase;

public class SpeciesConcentrationRuleDialog
extends SBaseDialog {
    private JTextField formulaTextField;
    private JTextField typeTextField;
    private JTextField speciesTextField;

    public SpeciesConcentrationRuleDialog() {
    }

    public SpeciesConcentrationRuleDialog(Dialog owner) {
        super(owner);
    }

    public SpeciesConcentrationRuleDialog(Frame owner) {
        super(owner);
    }

    public void setDialogByArg(String formula, String type, String species) {
        this.formulaTextField.setText(formula);
        this.typeTextField.setText(type);
        this.speciesTextField.setText(species);
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        JLabel formulaLabel = new JLabel("formula");
        formulaLabel.setBounds(new Rectangle(10, 10, 120, 20));
        this.mainPanel.add((Component)formulaLabel, null);
        this.formulaTextField = new JTextField();
        this.formulaTextField.setBounds(new Rectangle(70, 10, 300, 20));
        this.formulaTextField.setEditable(true);
        this.formulaTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.formulaTextField, null);
        JLabel typeLabel = new JLabel("type");
        typeLabel.setBounds(new Rectangle(10, 34, 120, 20));
        this.mainPanel.add((Component)typeLabel, null);
        this.typeTextField = new JTextField();
        this.typeTextField.setBounds(new Rectangle(70, 34, 300, 20));
        this.typeTextField.setEditable(true);
        this.typeTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.typeTextField, null);
        JLabel speciesLabel = new JLabel("species");
        speciesLabel.setBounds(new Rectangle(10, 58, 120, 20));
        this.mainPanel.add((Component)speciesLabel, null);
        this.speciesTextField = new JTextField();
        this.speciesTextField.setBounds(new Rectangle(70, 58, 300, 20));
        this.speciesTextField.setEditable(true);
        this.speciesTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.speciesTextField, null);
        this.LABEL_WIDTH = 50;
        this.TEXT_WIDTH = 300;
        this.setLayoutConstants();
        this.BUTTON_POSITION_Y = 10 + 4 * this.BASELINE_SKIP;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        AssignmentRule ar = new AssignmentRule();
        ar.setL1TypeCode(24);
        return ar;
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        AssignmentRule speciesConcentrationRule = (AssignmentRule)sbase;
        String formula = speciesConcentrationRule.getFormula();
        this.formulaTextField.setText(formula);
        this.formulaTextField.setCaretPosition(formula.length());
        String type = "speciesConcentrationRule.getType()";
        this.typeTextField.setText(type);
        this.typeTextField.setCaretPosition(type.length());
        String species = speciesConcentrationRule.getVariable();
        this.speciesTextField.setText(species);
        this.speciesTextField.setCaretPosition(species.length());
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        AssignmentRule speciesConcentrationRule = (AssignmentRule)sbase;
        String str = this.formulaTextField.getText();
        try {
            new KineticLawFormulaEvaluator(str);
            speciesConcentrationRule.setFormula(str);
        }
        catch (Exception e) {
            throw new Exception("malformed formula string");
        }
        str = this.typeTextField.getText();
        speciesConcentrationRule.setL1TypeCode(24);
        str = this.speciesTextField.getText();
        try {
            SId.check(str);
            speciesConcentrationRule.setVariable(str);
        }
        catch (SIdFormatException e) {
            throw new Exception("malformed species string");
        }
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.formulaTextField.setEnabled(isEnabled);
        this.typeTextField.setEnabled(isEnabled);
        this.speciesTextField.setEnabled(isEnabled);
        this.okButton.setEnabled(isEnabled);
        this.cancelButton.setEnabled(true);
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }
}

