/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.util.Arrays;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import jp.sbi.sbml.util.ColumnComparator;

class SortedTableModel
extends AbstractTableModel
implements TableModelListener {
    protected DefaultTableModel tableModel;
    protected Integer[] rowIndex;

    public SortedTableModel(DefaultTableModel tableModel) {
        this.tableModel = tableModel;
        this.jbInit();
        this.sortByColumn(0, true);
    }

    public void jbInit() {
        this.tableModel.addTableModelListener(this);
        int rc = this.tableModel.getRowCount();
        Integer[] rowIndex2 = new Integer[rc];
        int i = 0;
        while (i < rc) {
            rowIndex2[i] = this.rowIndex == null || i >= this.rowIndex.length ? new Integer(i) : this.rowIndex[i];
            ++i;
        }
        this.rowIndex = rowIndex2;
    }

    public TableModel getOriginalModel() {
        return this.tableModel;
    }

    @Override
    public Object getValueAt(int row, int column) {
        int r = this.rowIndex[row];
        return this.tableModel.getValueAt(r, column);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        int r = this.rowIndex[row];
        this.tableModel.setValueAt(aValue, r, column);
    }

    public void sortByColumn(int column, boolean ascending) {
        Arrays.sort(this.rowIndex, new ColumnComparator(this.tableModel, column, ascending));
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.fireTableChanged(e);
    }

    public Vector getDataVector() {
        Vector<Vector> dataVector = new Vector<Vector>(this.tableModel.getDataVector().size());
        int i = 0;
        while (i < this.rowIndex.length) {
            dataVector.addElement(this.tableModel.getDataVector().elementAt(this.rowIndex[i]));
            ++i;
        }
        return dataVector;
    }

    public void setDataVector(Vector newData, Vector columnNames) {
        this.tableModel.setDataVector(newData, columnNames);
        this.jbInit();
    }

    public void setDataVector(Object[][] newData, Object[] columnNames) {
        this.tableModel.setDataVector(newData, columnNames);
        this.jbInit();
    }

    public void newDataAvailable(TableModelEvent event) {
        this.tableModel.newDataAvailable(event);
        this.jbInit();
    }

    public void newRowsAdded(TableModelEvent event) {
        this.tableModel.newRowsAdded(event);
        this.jbInit();
    }

    public void rowsRemoved(TableModelEvent event) {
        this.tableModel.rowsRemoved(event);
        this.jbInit();
    }

    public void setColumnIdentifiers(Vector newIdentifiers) {
        this.tableModel.setColumnIdentifiers(newIdentifiers);
        this.jbInit();
    }

    public void setColumnIdentifiers(Object[] newIdentifiers) {
        this.tableModel.setColumnIdentifiers(newIdentifiers);
        this.jbInit();
    }

    public void setNumRows(int newSize) {
        this.tableModel.setNumRows(newSize);
        this.jbInit();
    }

    public void setRowCount(int rowCount) {
        this.tableModel.setRowCount(rowCount);
        this.jbInit();
    }

    public void setColumnCount(int columnCount) {
        this.tableModel.setColumnCount(columnCount);
        this.jbInit();
    }

    public void addColumn(Object columnName) {
        this.tableModel.addColumn(columnName);
        this.jbInit();
    }

    public void addColumn(Object columnName, Vector columnData) {
        this.tableModel.addColumn(columnName, columnData);
        this.jbInit();
    }

    public void addColumn(Object columnName, Object[] columnData) {
        this.tableModel.addColumn(columnName, columnData);
        this.jbInit();
    }

    public void addRow(Vector rowData) {
        this.tableModel.addRow(rowData);
        this.jbInit();
    }

    public void addRow(Object[] rowData) {
        this.tableModel.addRow(rowData);
        this.jbInit();
    }

    public void insertRow(int row, Vector rowData) {
        int r = this.rowIndex[row];
        this.tableModel.insertRow(r, rowData);
        this.jbInit();
    }

    public void insertRow(int row, Object[] rowData) {
        int r = this.rowIndex[row];
        this.tableModel.insertRow(r, rowData);
        this.jbInit();
    }

    public void moveRow(int startIndex, int endIndex, int toIndex) {
        this.tableModel.moveRow(startIndex, endIndex, toIndex);
        this.jbInit();
    }

    public void removeRow(int row) {
        int r = this.rowIndex[row];
        this.tableModel.removeRow(r);
        this.jbInit();
    }

    @Override
    public int getRowCount() {
        return this.tableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.tableModel.getColumnName(column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        int r = this.rowIndex[row];
        return this.tableModel.isCellEditable(r, column);
    }
}

