/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.util.SBaseDialog;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.CompartmentType;
import org.sbml.libsbml.ListOfCompartmentTypes;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.ListOfSpeciesTypes;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.SpeciesType;

public abstract class SBaseTypeDialog
extends SBaseDialog {
    protected JLabel idLabel;
    protected JTextField idTextField;
    protected JLabel nameLabel;
    protected JTextField nameTextField;

    public SBaseTypeDialog() {
    }

    public SBaseTypeDialog(Dialog owner) {
        super(owner);
    }

    public SBaseTypeDialog(Frame owner) {
        super(owner);
    }

    protected abstract String getDefaultDialogTitle();

    protected void initialize() {
        this.setContentPane(this.getMainPanel());
        this.setTitle(SBaseTypeDialog.getSuitableTitle(this, null));
        this.setSize(new Dimension(240, 190));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.idLabel = new JLabel();
            this.idLabel.setBounds(new Rectangle(10, 10, 50, 20));
            this.idLabel.setText("id");
            this.nameLabel = new JLabel();
            this.nameLabel.setBounds(new Rectangle(10, 35, 50, 20));
            this.nameLabel.setText("name");
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(null);
            this.mainPanel.setBounds(0, 0, 390, 140);
            this.mainPanel.setPreferredSize(new Dimension(390, 140));
            this.mainPanel.add((Component)this.idLabel, null);
            this.mainPanel.add((Component)this.getIdTextField(), null);
            this.mainPanel.add((Component)this.nameLabel, null);
            this.mainPanel.add((Component)this.getNameTextField(), null);
            this.LABEL_WIDTH = this.nameLabel.getWidth();
            this.TEXT_WIDTH = this.nameTextField.getWidth();
            this.setLayoutConstants();
            this.BUTTON_POSITION_Y = this.nameTextField.getY() + this.nameTextField.getHeight() + this.BASELINE_SKIP;
            this.setDefaultButtonsLayout();
        }
        return this.mainPanel;
    }

    private JTextField getIdTextField() {
        if (this.idTextField == null) {
            this.idTextField = new JTextField();
            this.idTextField.setBounds(new Rectangle(70, 10, 140, 20));
            this.idTextField.getDocument().addDocumentListener(this.docListener);
        }
        return this.idTextField;
    }

    private JTextField getNameTextField() {
        if (this.nameTextField == null) {
            this.nameTextField = new JTextField();
            this.nameTextField.setBounds(new Rectangle(70, 35, 140, 20));
            this.nameTextField.getDocument().addDocumentListener(this.docListener);
        }
        return this.nameTextField;
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mainPanel = this.getMainPanel();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null || this.mainPanel == null) {
            return;
        }
        String id = sbase.getId();
        this.idTextField.setText(id);
        this.idTextField.setCaretPosition(id.length());
        String name = sbase.getName();
        this.nameTextField.setText(name);
        this.nameTextField.setCaretPosition(name.length());
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        String newId;
        String oldId;
        SBModel sbmodel;
        block21: {
            sbmodel = null;
            try {
                sbmodel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            }
            catch (Exception ex) {
                return;
            }
            if (sbmodel == null || sbmodel.getModel() == null) {
                return;
            }
            if (!SBaseTypeDialog.checkDialogInputed(sbmodel.getModel(), sbase, this.idTextField.getText(), this.nameTextField.getText())) {
                return;
            }
            oldId = sbase.getId();
            newId = this.idTextField.getText();
            boolean isAdded = false;
            if (oldId == null || oldId.equals("")) {
                isAdded = true;
            }
            sbase.setId(newId);
            if (!isAdded && !oldId.equals(newId)) {
                try {
                    ListOfSpecies list;
                    if (sbase instanceof SpeciesType) {
                        list = sbmodel.getModel().getListOfSpecies();
                        if (list == null || list.size() <= 0L) break block21;
                        int i = 0;
                        while ((long)i < list.size()) {
                            try {
                                Species sp = (Species)list.get((long)i);
                                String sid = sp.getSpeciesType();
                                if (sid != null && sid.equals(oldId)) {
                                    sp.setSpeciesType(newId);
                                }
                            }
                            catch (Exception sp) {
                                // empty catch block
                            }
                            ++i;
                        }
                        break block21;
                    }
                    if (!(sbase instanceof CompartmentType) || (list = sbmodel.getModel().getListOfCompartments()) == null || list.size() <= 0L) break block21;
                    int i = 0;
                    while ((long)i < list.size()) {
                        try {
                            Compartment c = (Compartment)list.get((long)i);
                            String sid = c.getCompartmentType();
                            if (sid != null && sid.equals(oldId)) {
                                c.setCompartmentType(newId);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
                catch (Exception list) {
                    // empty catch block
                }
            }
        }
        if (!newId.equals(oldId)) {
            if (sbase instanceof SpeciesType) {
                HashMap hashSpeciesTypeNotes = sbmodel.getHashSpeciesTypeNotes();
                this.changeNotesforIdChange(hashSpeciesTypeNotes, oldId, newId);
            } else if (sbase instanceof CompartmentType) {
                HashMap hashCompartmentTypeNotes = sbmodel.getHashCompartmentTypeNotes();
                this.changeNotesforIdChange(hashCompartmentTypeNotes, oldId, newId);
            }
        }
        sbase.setName(this.nameTextField.getText());
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        if (this.mainPanel != null) {
            this.idTextField.setEnabled(isEnabled);
            this.nameTextField.setEnabled(isEnabled);
            this.okButton.setEnabled(isEnabled);
            this.cancelButton.setEnabled(isEnabled);
        }
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }

    public static final String getSuitableTitle(SBaseDialog dialog, String title) {
        if (title != null) {
            return title;
        }
        if (dialog instanceof SBaseTypeDialog) {
            return ((SBaseTypeDialog)dialog).getDefaultDialogTitle();
        }
        return "No Title";
    }

    public static final boolean checkDialogInputed(Model model, SBase sbase, String id, String name) throws Exception {
        if (model == null) {
            return false;
        }
        SpeciesType sbaseTmp = null;
        if (sbase == null) {
            return false;
        }
        if (sbase instanceof SpeciesType) {
            sbaseTmp = new SpeciesType();
        } else if (sbase instanceof CompartmentType) {
            sbaseTmp = new CompartmentType();
        } else {
            return false;
        }
        try {
            SId.check(id);
        }
        catch (Exception e) {
            throw new Exception("malformed [id] string");
        }
        if (!id.equals(sbase.getId())) {
            try {
                ListOfCompartmentTypes list;
                if (sbase instanceof SpeciesType) {
                    ListOfSpeciesTypes list2 = model.getListOfSpeciesTypes();
                    if (list2 != null && list2.size() > 0L) {
                        int i = 0;
                        while ((long)i < list2.size()) {
                            SpeciesType st = (SpeciesType)list2.get((long)i);
                            String sid = st.getId();
                            if (sid != null && sid.equals(id)) {
                                throw new Exception();
                            }
                            ++i;
                        }
                    }
                } else if (sbase instanceof CompartmentType && (list = model.getListOfCompartmentTypes()) != null && list.size() > 0L) {
                    int i = 0;
                    while ((long)i < list.size()) {
                        CompartmentType ct = (CompartmentType)list.get((long)i);
                        String sid = ct.getId();
                        if (sid != null && sid.equals(id)) {
                            throw new Exception();
                        }
                        ++i;
                    }
                }
            }
            catch (Exception ex) {
                throw new Exception("malformed [id] string");
            }
        }
        try {
            sbaseTmp.setName(name);
        }
        catch (Exception e) {
            throw new Exception("malformed [name] string");
        }
        return true;
    }
}

