/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MainWindowAccess;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNA;
import jp.sbi.celldesigner.sbmlExtension.Gene;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.RNA;
import jp.sbi.sbml.MiriamDefinition;
import jp.sbi.sbml.MiriamSubDefinition;
import jp.sbi.sbml.Notes;
import jp.sbi.sbml.util.ExportCSVEditDialog;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.ListPanel;
import jp.sbi.sbml.util.ParameterListPanel;
import jp.sbi.sbml.util.SBaseDialog;
import jp.sbi.sbml.util.SBaseListPanelListener;
import jp.sbi.sbml.util.SpeciesReferenceDialog;
import net.sourceforge.jeuclid.util.ResourceEntityResolver;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfCompartmentTypes;
import org.sbml.libsbml.ListOfConstraints;
import org.sbml.libsbml.ListOfEvents;
import org.sbml.libsbml.ListOfFunctionDefinitions;
import org.sbml.libsbml.ListOfInitialAssignments;
import org.sbml.libsbml.ListOfParameters;
import org.sbml.libsbml.ListOfRules;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.ListOfSpeciesTypes;
import org.sbml.libsbml.ListOfUnitDefinitions;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.SimpleSpeciesReference;
import org.sbml.libsbml.Species;
import org.xml.sax.EntityResolver;

public abstract class SBaseListPanel
extends JPanel
implements Observer {
    protected ListOf sbaseList = null;
    protected int elementDlgMode = 1;
    protected Vector listeners = new Vector();
    protected boolean isSelfOperational = true;
    protected MyListSelectionListener selectionListener;
    protected MyKeyListener keyListener;
    protected MyTableModel listTableModel;
    protected JTable table = null;
    protected static final Insets buttonInsets = new Insets(0, 4, 0, 4);
    protected boolean[] editable = null;
    protected boolean[] editable1 = null;
    protected boolean[] editable2 = null;
    protected boolean[] editable3 = null;
    protected boolean shiftPressed = false;
    protected boolean tableedited = false;
    protected MainWindowAccess mainwindowaccess = null;
    protected boolean fromTreeEvent = false;
    protected boolean fromCanvasEvent = false;
    private boolean valuechanged_skip = false;
    protected boolean isDialogVisiable = false;
    private SBase parentSBase;
    protected boolean bCanRespond = true;
    protected JPopupMenu popupMenu = new JPopupMenu();
    private static final String strEditingMiriamInfo = "Edit MIRIAM Info";
    public static final int MODE_EACH_MODAL = 1;
    public static final int MODE_EACH_NONMODAL = 2;
    private static final int MODE_MULTI_NONMODAL = 3;
    public static final String PROTEINS = "Proteins";
    public static final String GENES = "Genes";
    public static final String RNAs = "RNAs";
    public static final String ASRNAS = "asRNAs";
    private static final String SP_RF_DIALOG = "SpeciesReferenceDialog";
    private static final String MD_RF_DIALOG = "ModifierSpeciesReferenceDialog";

    protected SBaseListPanel() {
        JMenuItem menuItem = new JMenuItem(strEditingMiriamInfo);
        menuItem.addActionListener(new EditingMiriamInfoAction());
        this.popupMenu.add(menuItem);
    }

    public void setMainWindowAccess(MainWindowAccess mainwindowaccess) {
        this.mainwindowaccess = mainwindowaccess;
    }

    public void setFromTreeEvent(boolean flg) {
        this.fromTreeEvent = flg;
    }

    public void setSkipflg(boolean val) {
        this.valuechanged_skip = val;
    }

    public void setFromCanvasEvent(boolean flg) {
        this.fromCanvasEvent = flg;
    }

    public void setEditableInfo(boolean[] editable) {
        this.editable = editable;
    }

    public void setEditableInfo(boolean[] editable, boolean[] editable1, boolean[] editable2, boolean[] editable3) {
        this.editable = editable;
        this.editable1 = editable1;
        this.editable2 = editable2;
        this.editable3 = editable3;
    }

    public void setElementSample(SBase sample) {
        if (sample == null) {
            return;
        }
        this.initTableModel(sample);
        this.changeButtonsEnability();
    }

    public void releaseSBaseList() {
        this.sbaseList = null;
    }

    public ListOf getSBaseList() {
        return this.sbaseList;
    }

    public SBase getLastSelectedElement() {
        if (this.sbaseList == null) {
            return null;
        }
        int i = this.table.getSelectedRow();
        if (i >= 0 && (long)i < this.sbaseList.size()) {
            return this.sbaseList.get((long)i);
        }
        return null;
    }

    public SBase[] getSelectedElements() {
        if (this.sbaseList == null) {
            SBase[] array = new SBase[]{};
            return array;
        }
        int[] cnt = this.table.getSelectedRows();
        SBase[] array = new SBase[cnt.length];
        int i = 0;
        while (i < cnt.length) {
            int index = cnt[i];
            array[i] = this.sbaseList.get((long)index);
            ++i;
        }
        return array;
    }

    public void updateDialog() {
        try {
            SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            if (sbModel != null && sbModel.isprivateReconfirmSpeciesIDinProcessing()) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.listTableModel == null) {
            return;
        }
        this.listTableModel.fireTableDataChanged();
        this.changeButtonsEnability();
        if (this.isShowing()) {
            this.repaint();
        }
        this.updateChildDialog();
    }

    public void selectElement(int[] indices) {
        if (indices == null) {
            return;
        }
        boolean treeevent = this.fromTreeEvent;
        boolean canvasevent = this.fromCanvasEvent;
        this.table.clearSelection();
        this.valuechanged_skip = true;
        int idx = 0;
        int j = indices.length - 1;
        while (j >= 0) {
            if (indices[j] >= 0 && indices[j] < this.table.getRowCount()) {
                idx = j;
                break;
            }
            --j;
        }
        if (indices[idx] < 0 || indices[idx] >= this.table.getRowCount()) {
            return;
        }
        int i = 0;
        while (i < idx) {
            if (indices[i] >= 0 && indices[i] < this.table.getRowCount()) {
                this.fromTreeEvent = treeevent;
                this.fromCanvasEvent = canvasevent;
                this.table.addRowSelectionInterval(indices[i], indices[i]);
            }
            ++i;
        }
        this.fromTreeEvent = treeevent;
        this.fromCanvasEvent = canvasevent;
        this.valuechanged_skip = false;
        this.table.addRowSelectionInterval(indices[idx], indices[idx]);
    }

    public void clearSelectElement() {
        this.table.clearSelection();
    }

    public Object getValueAt(int row, int col) {
        return this.table.getValueAt(row, col);
    }

    public Object getValueAt(int row, String label) {
        JTableHeader header = this.table.getTableHeader();
        TableColumnModel columnmodel = header.getColumnModel();
        int column = columnmodel.getColumnIndex(label);
        return this.table.getValueAt(row, column);
    }

    public int getColumnCount() {
        return this.table.getColumnCount();
    }

    public int getRowCount() {
        return this.table.getRowCount();
    }

    public void setParentSBase(SBase parentSBase) {
        this.parentSBase = parentSBase;
    }

    public SBase getParentSBase() {
        return this.parentSBase;
    }

    public abstract SBaseDialog getElementDialog();

    public abstract SBaseDialog getElementDialog(int var1);

    public abstract void setElementDialog(SBaseDialog var1);

    public abstract void setElementDialog(SBaseDialog var1, int var2);

    public abstract void setElementDialogMode(int var1);

    public abstract void setSelfOperational(boolean var1);

    public abstract void setSBaseList(ListOf var1);

    public abstract void releaseAll();

    public abstract void disableChildDialog();

    public abstract void setButtonVisible(int var1, boolean var2);

    public void enableDeleteKey(boolean isDeleteKeyEnabled) {
        this.keyListener.isDeleteKeyEnabled = isDeleteKeyEnabled;
    }

    public abstract void valueSettedToCell(Object var1, int var2, int var3);

    protected abstract void changeButtonsEnability();

    protected abstract void changeElementDialogEnability();

    protected abstract void updateChildDialog();

    protected abstract void removeButton_actionPerformed();

    protected abstract void initTableModel(SBase var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSBaseListPanelListener(SBaseListPanelListener l) {
        Vector vector = this.listeners;
        synchronized (vector) {
            boolean exists = false;
            int i = 0;
            while (i < this.listeners.size()) {
                SBaseListPanelListener listener = (SBaseListPanelListener)this.listeners.elementAt(i);
                if (listener.equals(l)) {
                    exists = true;
                    break;
                }
                ++i;
            }
            if (!exists) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSBaseListPanelListener(SBaseListPanelListener l) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.remove(l);
        }
    }

    public int getSelectedRowCount() {
        return this.table.getSelectedRowCount();
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public StringBuffer getListAsCSV(ArrayList listOfCheckBoxes) throws IOException {
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        TableModel tmodel = this.table.getModel();
        String csvhead = "";
        Vector csvdatalines = new Vector();
        int selectedCount = 0;
        boolean outputMiriam = false;
        int j = 0;
        while (j < listOfCheckBoxes.size()) {
            JCheckBox check = (JCheckBox)listOfCheckBoxes.get(j);
            if (check.isSelected()) {
                ++selectedCount;
                if (check.getText().equals("MIRIAM")) {
                    outputMiriam = true;
                }
            }
            ++j;
        }
        int row = tmodel.getRowCount();
        int column = listOfCheckBoxes.size();
        int count = 0;
        int j2 = 0;
        while (j2 < column) {
            JCheckBox check = (JCheckBox)listOfCheckBoxes.get(j2);
            if (check.isSelected()) {
                ++count;
                if (j2 < tmodel.getColumnCount()) {
                    csvhead = String.valueOf(csvhead) + tmodel.getColumnName(j2);
                } else if ("notes".equals(check.getText())) {
                    csvhead = String.valueOf(csvhead) + "notes";
                } else {
                    "MIRIAM".equals(check.getText());
                }
                if (count >= selectedCount) {
                    if (csvhead == null || !csvhead.endsWith(",")) break;
                    csvhead = csvhead.substring(0, csvhead.lastIndexOf(","));
                    break;
                }
                csvhead = String.valueOf(csvhead) + ",";
            }
            ++j2;
        }
        int iMaxMiriamInfos = 0;
        int i = 0;
        while (i < row) {
            block62: {
                Vector<String> onelinedatas;
                block61: {
                    onelinedatas = new Vector<String>();
                    try {
                        Object obj = null;
                        if (!(this.getName().toLowerCase().equals("species") ? (obj = this.getValueAt(i, "class")) != null && obj instanceof String && ((String)obj).toUpperCase().equals("TAG".toUpperCase()) : this.getName().toLowerCase().equals("reactions") && (obj = this.getValueAt(i, "type")) != null && obj instanceof String && ((String)obj).toUpperCase().equals("DIRECT_SINGLE_LINE".toUpperCase()))) break block61;
                        break block62;
                    }
                    catch (Exception obj) {
                        // empty catch block
                    }
                }
                String idForFindNotes = "";
                try {
                    idForFindNotes = (String)this.getValueAt(i, "id");
                }
                catch (Exception myErr) {
                    idForFindNotes = "";
                }
                count = 0;
                int j3 = 0;
                while (j3 < column) {
                    JCheckBox check = (JCheckBox)listOfCheckBoxes.get(j3);
                    if (check.isSelected()) {
                        ++count;
                        if (tmodel.getColumnCount() > j3) {
                            String field = (String)tmodel.getValueAt(i, j3);
                            if (field.split(",", -1).length > 1) {
                                field = "\"" + field + "\"";
                            }
                            if (field == null) {
                                field = "";
                            }
                            onelinedatas.add(field);
                        } else if ("notes".equals(check.getText())) {
                            Species targetSbase = null;
                            String sbaseType = this.getName();
                            if (sbaseType.equals(ExportCSVEditDialog.listPanel[0])) {
                                int k = 0;
                                while ((long)k < this.sbaseList.getLine()) {
                                    if (((Species)this.sbaseList.get((long)k)).getId().equals(idForFindNotes)) {
                                        targetSbase = (Species)this.sbaseList.get((long)k);
                                        break;
                                    }
                                    ++k;
                                }
                            } else if (sbaseType.equals(ExportCSVEditDialog.listPanel[1])) {
                                targetSbase = sbModel.getProtein(idForFindNotes);
                            } else if (sbaseType.equals(ExportCSVEditDialog.listPanel[2])) {
                                targetSbase = sbModel.getGene(idForFindNotes);
                            } else if (sbaseType.equals(ExportCSVEditDialog.listPanel[3])) {
                                targetSbase = sbModel.getRNA(idForFindNotes);
                            } else if (sbaseType.equals(ExportCSVEditDialog.listPanel[4])) {
                                targetSbase = sbModel.getAntiSenseRNA(idForFindNotes);
                            } else if (sbaseType.equals(ExportCSVEditDialog.listPanel[5])) {
                                int k = 0;
                                while ((long)k < this.sbaseList.getLine()) {
                                    if (((Reaction)this.sbaseList.get((long)k)).getId().equals(idForFindNotes)) {
                                        targetSbase = (Reaction)this.sbaseList.get((long)k);
                                        break;
                                    }
                                    ++k;
                                }
                            } else if (sbaseType.equals(ExportCSVEditDialog.listPanel[6])) {
                                int k = 0;
                                while ((long)k < this.sbaseList.getLine()) {
                                    if (((Compartment)this.sbaseList.get((long)k)).getId().equals(idForFindNotes)) {
                                        targetSbase = (Compartment)this.sbaseList.get((long)k);
                                        break;
                                    }
                                    ++k;
                                }
                            }
                            String notesString = "";
                            if (targetSbase != null) {
                                Notes notes = (Notes)LibSBMLUtil.getNotes((SBase)targetSbase, null);
                                notesString = notes.getText();
                                notesString = this.addQuotation(notesString);
                            }
                            if (notesString == null) {
                                notesString = "";
                            }
                            onelinedatas.add(notesString);
                        } else {
                            "MIRIAM".equals(check.getText());
                        }
                        if (count >= selectedCount) {
                            if (outputMiriam) {
                                int iMiriamInfos = 0;
                                Vector vecData = null;
                                try {
                                    vecData = this.sbaseList instanceof ListOfSpecies || this.sbaseList instanceof ListOfParameters ? LibSBMLUtil.getMiriamDatasFromAnnotationOfSBase(this.sbaseList.get(idForFindNotes)) : LibSBMLUtil.getMiriamDatasFromAnnotationOfSBase(this.sbaseList.get((long)i));
                                }
                                catch (RuntimeException notesString) {
                                    // empty catch block
                                }
                                if (vecData != null && vecData.size() > 0) {
                                    int t = 0;
                                    while (t < vecData.size()) {
                                        MiriamDefinition miriamDefinition = (MiriamDefinition)vecData.get(t);
                                        Vector miriamDatas = miriamDefinition.getDatas();
                                        if (miriamDatas != null && miriamDatas.size() > 0) {
                                            iMiriamInfos += miriamDatas.size();
                                            int u = 0;
                                            while (u < miriamDatas.size()) {
                                                onelinedatas.add(miriamDefinition.getRelation());
                                                MiriamSubDefinition subdata = (MiriamSubDefinition)miriamDatas.get(u);
                                                onelinedatas.add(subdata.strDataType);
                                                onelinedatas.add(subdata.strId);
                                                ++u;
                                            }
                                        }
                                        ++t;
                                    }
                                }
                                if (iMaxMiriamInfos < iMiriamInfos) {
                                    iMaxMiriamInfos = iMiriamInfos;
                                }
                            }
                            csvdatalines.add(onelinedatas);
                            break;
                        }
                    }
                    ++j3;
                }
            }
            ++i;
        }
        int iMaxCvsDataCols = selectedCount;
        if (outputMiriam) {
            iMaxCvsDataCols = iMaxCvsDataCols - 1 + iMaxMiriamInfos * 3;
        }
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        String strCm = ",";
        if (csvhead == null || csvhead.trim().equals("")) {
            csvhead = "";
            strCm = "";
        }
        int j4 = 0;
        while (j4 < iMaxMiriamInfos) {
            csvhead = String.valueOf(csvhead) + strCm + "MIRIAM[relation]" + "," + "MIRIAM[datatype]" + "," + "MIRIAM[id]";
            strCm = ",";
            ++j4;
        }
        bw.write(csvhead);
        bw.newLine();
        int i2 = 0;
        while (i2 < csvdatalines.size()) {
            Vector onelinedatas = (Vector)csvdatalines.get(i2);
            int j5 = 0;
            boolean havedata = false;
            if (onelinedatas != null && onelinedatas.size() > 0) {
                havedata = true;
                bw.write((String)onelinedatas.get(j5++));
                while (j5 < onelinedatas.size()) {
                    bw.write("," + (String)onelinedatas.get(j5));
                    ++j5;
                }
            }
            if (!havedata) {
                ++j5;
            }
            while (j5 < iMaxCvsDataCols) {
                bw.write(",");
                ++j5;
            }
            bw.newLine();
            ++i2;
        }
        bw.flush();
        return sw.getBuffer();
    }

    private String addQuotation(String notesString) {
        char c;
        char[] chars = notesString.toCharArray();
        boolean flg = false;
        boolean n = false;
        char doubleQuotation = '\"';
        char enter = '\n';
        int offset = 0;
        boolean doubleQuotationInclued = false;
        boolean enterInclued = false;
        int i = 0;
        while (i < chars.length) {
            c = chars[i];
            if (c == doubleQuotation) {
                doubleQuotationInclued = true;
            } else if (c == enter) {
                enterInclued = true;
            }
            ++i;
        }
        if (!doubleQuotationInclued && !enterInclued) {
            return notesString;
        }
        if (doubleQuotationInclued && !enterInclued) {
            return notesString;
        }
        if (!doubleQuotationInclued && enterInclued) {
            notesString = String.valueOf(doubleQuotation) + notesString + doubleQuotation;
            return notesString;
        }
        i = 0;
        while (i < chars.length) {
            c = chars[i];
            if (c == doubleQuotation) {
                if (!flg) {
                    notesString = StringTool.insertString(notesString, "\"", i + offset);
                    flg = true;
                } else {
                    notesString = StringTool.insertString(notesString, "\"", i + 1 + offset);
                    flg = false;
                }
                ++offset;
            } else if (c == enter) {
                n = true;
            }
            ++i;
        }
        if (n) {
            notesString = "\"" + notesString + "\"";
        }
        return notesString;
    }

    public abstract void showElementDialog(SBase var1);

    public void selectElement(Object[] sbase) {
        boolean treeevent = this.fromTreeEvent;
        boolean canvasevent = this.fromCanvasEvent;
        this.table.clearSelection();
        this.valuechanged_skip = true;
        int columnindex = 0;
        int icol = 0;
        while (icol < this.table.getColumnCount()) {
            if (this.table.getColumnName(icol).compareToIgnoreCase("id") == 0) {
                columnindex = icol;
                break;
            }
            ++icol;
        }
        int i = 0;
        while (i < this.table.getRowCount()) {
            int j = 0;
            while (j < sbase.length) {
                if (this.table.getValueAt(i, columnindex).toString().compareToIgnoreCase(((Species)sbase[j]).getId()) == 0) {
                    this.table.addRowSelectionInterval(i, i);
                }
                ++j;
            }
            ++i;
        }
        this.changeElementDialogEnability();
        this.fromTreeEvent = treeevent;
        this.fromCanvasEvent = canvasevent;
        this.valuechanged_skip = false;
    }

    public void selectElement(Vector bases) {
        boolean treeevent = this.fromTreeEvent;
        boolean canvasevent = this.fromCanvasEvent;
        this.table.clearSelection();
        this.valuechanged_skip = true;
        int columnindex = 0;
        int icol = 0;
        while (icol < this.table.getColumnCount()) {
            if (this.table.getColumnName(icol).compareToIgnoreCase("name") == 0) {
                columnindex = icol;
                break;
            }
            ++icol;
        }
        String columnName = "";
        Object ob2 = null;
        for (Object ob2 : bases) {
            if (ob2 instanceof Species) {
                columnName = ((Species)ob2).getName();
            }
            if (columnName == null || columnName.equals("")) continue;
            int i = 0;
            while (i < this.table.getRowCount()) {
                if (this.table.getValueAt(i, columnindex).toString().compareToIgnoreCase(columnName) == 0) {
                    this.table.addRowSelectionInterval(i, i);
                }
                ++i;
            }
        }
        this.changeElementDialogEnability();
        this.fromTreeEvent = treeevent;
        this.fromCanvasEvent = canvasevent;
        this.valuechanged_skip = false;
    }

    public void setSBaseListPanelCanRespond(boolean flag) {
        this.bCanRespond = flag;
    }

    public void SelectionChanged() {
        if (this instanceof ParameterListPanel) {
            ParameterListPanel parameterListPanel = (ParameterListPanel)this;
            parameterListPanel.SelectionChangedforKineticLawParameter();
        }
    }

    protected void doActionOfShowPopupMenu(MouseEvent e) {
    }

    protected void doActionOfEditingMiriamInfo() {
    }

    public void doChangeTabbedPane(SBModel sbModel) {
        if (sbModel != null) {
            if (this.sbaseList instanceof ListOfFunctionDefinitions || this.sbaseList instanceof ListOfUnitDefinitions || this.sbaseList instanceof ListOfRules || this.sbaseList instanceof ListOfEvents || this.sbaseList instanceof ListOfSpeciesTypes || this.sbaseList instanceof ListOfCompartmentTypes || this.sbaseList instanceof ListOfInitialAssignments || this.sbaseList instanceof ListOfConstraints) {
                if (this.getSelectedElements() != null && this.getSelectedElements().length == 1) {
                    sbModel.setPanelSelectedSbase(this.getSelectedElements());
                    MainWindow.getLastInstance().componentSelectionChanged();
                    sbModel.setPanelSelectedSbase(null);
                } else {
                    sbModel.panelchange(null, true);
                }
            } else {
                String strPanelName = this.getName();
                if (PROTEINS.equals(strPanelName) || GENES.equals(strPanelName) || RNAs.equals(strPanelName) || ASRNAS.equals(strPanelName)) {
                    MainWindow.getMiriamMainPanel().setDialogFromObject(null);
                } else if (this.getSelectedElements() != null && this.getSelectedElements().length == 1) {
                    MainWindow.getMiriamMainPanel().setDialogFromObject(this.getSelectedElements()[0]);
                } else {
                    MainWindow.getMiriamMainPanel().setDialogFromObject(null);
                }
            }
        }
    }

    public void editCancel() {
        if (this.table != null) {
            ChangeEvent ce = new ChangeEvent(this.table);
            this.table.editingCanceled(ce);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    class EditingMiriamInfoAction
    implements ActionListener {
        EditingMiriamInfoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SBaseListPanel.this.doActionOfEditingMiriamInfo();
        }
    }

    protected class MyKeyListener
    extends KeyAdapter {
        boolean isDeleteKeyEnabled;
        boolean isButtonsVisible;

        protected MyKeyListener() {
            this.isDeleteKeyEnabled = SBaseListPanel.this.isSelfOperational;
            this.isButtonsVisible = true;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if ((e.getKeyCode() == 8 || e.getKeyCode() == 127) && SBaseListPanel.this.isSelfOperational && this.isDeleteKeyEnabled) {
                SBaseListPanel.this.removeButton_actionPerformed();
            }
            if (e.getKeyCode() == 16) {
                SBaseListPanel.this.shiftPressed = true;
            }
            if (e.getKeyCode() == 66) {
                if (this.isButtonsVisible) {
                    SBaseListPanel.this.setSelfOperational(false);
                } else {
                    SBaseListPanel.this.setSelfOperational(true);
                }
                boolean bl = this.isButtonsVisible = !this.isButtonsVisible;
            }
            if (e.getKeyCode() == 82 && SBaseListPanel.this.isSelfOperational) {
                SBaseListPanel.this.updateDialog();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyevent) {
            SBaseListPanel.this.shiftPressed = false;
            SBaseListPanel.this.mainwindowaccess.setMultiSelectionMode(false);
        }
    }

    protected class MyListSelectionListener
    implements ListSelectionListener {
        boolean hasLastSelected = false;

        protected MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (SBaseListPanel.this.valuechanged_skip) {
                return;
            }
            SBase[] selected = SBaseListPanel.this.getSelectedElements();
            if (SBaseListPanel.this.sbaseList instanceof ListOfParameters) {
                if (SBaseListPanel.this.table == null) {
                    return;
                }
                if (SBaseListPanel.this.table.getSelectedRows() == null) {
                    return;
                }
                if (SBaseListPanel.this.table.getSelectedRows().length > 1) {
                    SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
                    sbModel.panelchange(null, true);
                    if (selected.length >= 1) {
                        SBaseListPanel.this.changeButtonsEnability();
                        if (selected.length > 1) {
                            ((ListPanel)SBaseListPanel.this).elementDlg.cancelDialog();
                        } else {
                            SBaseListPanel.this.changeElementDialogEnability();
                        }
                    }
                    return;
                }
                if (selected.length == 0) {
                    SBaseListPanel.this.changeButtonsEnability();
                    SBaseListPanel.this.changeElementDialogEnability();
                    SBaseListPanel.this.SelectionChanged();
                    return;
                }
            }
            if (selected.length > 1) {
                if (SBaseListPanel.this.sbaseList instanceof ListOfFunctionDefinitions || SBaseListPanel.this.sbaseList instanceof ListOfUnitDefinitions || SBaseListPanel.this.sbaseList instanceof ListOfRules || SBaseListPanel.this.sbaseList instanceof ListOfEvents || SBaseListPanel.this.sbaseList instanceof ListOfSpeciesTypes || SBaseListPanel.this.sbaseList instanceof ListOfCompartmentTypes || SBaseListPanel.this.sbaseList instanceof ListOfInitialAssignments || SBaseListPanel.this.sbaseList instanceof ListOfConstraints) {
                    SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
                    sbModel.panelchange(null, true);
                } else {
                    MainWindow.getMiriamMainPanel().setDialogFromObject(null);
                }
                SBaseListPanel.this.changeButtonsEnability();
                ((ListPanel)SBaseListPanel.this).elementDlg.cancelDialog();
            }
            if (!e.getValueIsAdjusting() || SBaseListPanel.this.tableedited) {
                SBaseListPanel.this.tableedited = false;
                SBaseListPanel.this.changeButtonsEnability();
                SBaseListPanel.this.changeElementDialogEnability();
                Vector list = (Vector)SBaseListPanel.this.listeners.clone();
                int i = 0;
                while (i < list.size()) {
                    SBaseListPanelListener listener = (SBaseListPanelListener)list.elementAt(i);
                    String string = listener.toString();
                    if (!(SBaseListPanel.this.fromCanvasEvent && string.indexOf("SBModelHighlighter") != -1 || SBaseListPanel.this.fromTreeEvent && string.indexOf("MainWindow") != -1)) {
                        if (selected.length > 0) {
                            listener.elementsSelected(selected);
                        } else if (this.hasLastSelected) {
                            listener.elementsDeselected();
                        }
                    }
                    ++i;
                }
                this.hasLastSelected = selected.length != 0;
            }
            SBaseListPanel.this.fromCanvasEvent = false;
            SBaseListPanel.this.fromTreeEvent = false;
        }
    }

    protected class MyTableModel
    extends AbstractTableModel {
        String[] columnNames;
        ListPanel parent;
        Source source;
        Transformer transformer;
        DocumentBuilder parser;

        MyTableModel(String[] columnNames) {
            this.columnNames = columnNames;
        }

        MyTableModel(String[] columnNames, ListPanel parent) {
            this.columnNames = columnNames;
            this.parent = parent;
        }

        MyTableModel(String[] columnNames, ListPanel parent, Source source) {
            this(columnNames, parent);
            this.source = source;
            this.initMyTableModel();
        }

        void initMyTableModel() {
            try {
                this.transformer = TransformerFactory.newInstance().newTransformer(this.source);
                this.transformer.setOutputProperty("encoding", "UTF-8");
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                this.parser = documentBuilderFactory.newDocumentBuilder();
                this.parser.setEntityResolver((EntityResolver)new ResourceEntityResolver());
            }
            catch (Exception e) {
                e.getStackTrace();
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (SBaseListPanel.this.sbaseList == null) {
                return null;
            }
            SBModel sbModel = null;
            if (MainWindow.getLastInstance() != null) {
                sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            }
            if (this.parent != null && this.parent.getName() != null) {
                if (this.parent.getName().equals(SBaseListPanel.PROTEINS)) {
                    Species target = (Species)SBaseListPanel.this.sbaseList.get((long)row);
                    Protein protein = sbModel.getProtein(target.getId());
                    return LibSBMLUtil.toStrings((SBase)protein)[col];
                }
                if (this.parent.getName().equals(SBaseListPanel.GENES)) {
                    Species target = (Species)SBaseListPanel.this.sbaseList.get((long)row);
                    Gene protein = sbModel.getGene(target.getId());
                    return LibSBMLUtil.toStrings((SBase)protein)[col];
                }
                if (this.parent.getName().equals(SBaseListPanel.RNAs)) {
                    Species target = (Species)SBaseListPanel.this.sbaseList.get((long)row);
                    RNA protein = sbModel.getRNA(target.getId());
                    return LibSBMLUtil.toStrings((SBase)protein)[col];
                }
                if (this.parent.getName().equals(SBaseListPanel.ASRNAS)) {
                    Species target = (Species)SBaseListPanel.this.sbaseList.get((long)row);
                    AntiSenseRNA protein = sbModel.getAntiSenseRNA(target.getId());
                    return LibSBMLUtil.toStrings((SBase)protein)[col];
                }
                if (this.parent.getName().equals(SBaseListPanel.SP_RF_DIALOG)) {
                    SimpleSpeciesReference target = (SimpleSpeciesReference)SBaseListPanel.this.sbaseList.get((long)row);
                    Reaction reaction = (Reaction)this.parent.getParentSBase();
                    if (((SpeciesReferenceDialog)this.parent.getElementDialog()).getType().equals("Reactants")) {
                        return LibSBMLUtil.toStrings(reaction, (SBase)target, "Reactants", row)[col];
                    }
                    return LibSBMLUtil.toStrings(reaction, (SBase)target, "Products", row)[col];
                }
                if (this.parent.getName().equals(SBaseListPanel.MD_RF_DIALOG)) {
                    SimpleSpeciesReference target = (SimpleSpeciesReference)SBaseListPanel.this.sbaseList.get((long)row);
                    Reaction reaction = (Reaction)this.parent.getParentSBase();
                    return LibSBMLUtil.toStrings(reaction, (SBase)target, null, row)[col];
                }
            }
            return LibSBMLUtil.getListOfValueAt(SBaseListPanel.this.sbaseList, row, col);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (SBaseListPanel.this.sbaseList == null) {
                return 0;
            }
            return (int)SBaseListPanel.this.sbaseList.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            SBaseListPanel.this.valueSettedToCell(value, rowIndex, columnIndex);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (SBaseListPanel.this.isDialogVisiable) {
                return false;
            }
            if (SBaseListPanel.this.editable != null) {
                if (SBaseListPanel.this.editable1 == null) {
                    return SBaseListPanel.this.editable[column];
                }
                boolean[] flagarray = null;
                String kind = (String)SBaseListPanel.this.table.getValueAt(row, 0);
                if (kind.equals("Algebraic")) {
                    flagarray = SBaseListPanel.this.editable;
                } else if (kind.equals("Assignment")) {
                    flagarray = SBaseListPanel.this.editable1;
                } else if (kind.equals("Rate")) {
                    flagarray = SBaseListPanel.this.editable2;
                }
                return flagarray[column];
            }
            return false;
        }
    }

    class PopupMenuListener
    extends MouseAdapter {
        PopupMenuListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showPopupMenu(e);
        }

        private void showPopupMenu(MouseEvent e) {
            SBaseListPanel.this.doActionOfShowPopupMenu(e);
        }
    }
}

