/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.SBaseDialog;
import jp.sbi.sbml.util.SBaseListDialogListener;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.SBase;

public abstract class SBaseListDialog
extends JDialog {
    protected ListOf sbaseList = null;
    protected int elementDlgMode = 1;
    protected Vector listeners = new Vector();
    protected boolean isSelfOperational = true;
    protected MyListSelectionListener selectionListener;
    protected MyKeyListener keyListener;
    protected MyTableModel listTableModel;
    protected JTable table = null;
    public static final int MODE_EACH_MODAL = 1;
    public static final int MODE_EACH_NONMODAL = 2;
    private static final int MODE_MULTI_NONMODAL = 3;

    protected SBaseListDialog() {
    }

    protected SBaseListDialog(Dialog owner) {
        super(owner);
    }

    protected SBaseListDialog(Frame owner) {
        super(owner);
    }

    public void setElementSample(SBase sample) {
        if (sample == null) {
            return;
        }
        this.initTableModel(sample);
        this.changeButtonsEnability();
    }

    public ListOf getSBaseList() {
        return this.sbaseList;
    }

    public void releaseSBaseList() {
        this.sbaseList = null;
    }

    public SBase getLastSelectedElement() {
        if (this.sbaseList == null) {
            return null;
        }
        int i = this.table.getSelectedRow();
        if (i >= 0 && (long)i < this.sbaseList.size()) {
            return this.sbaseList.get((long)i);
        }
        return null;
    }

    public SBase[] getSelectedElements() {
        if (this.sbaseList == null) {
            SBase[] array = new SBase[]{};
            return array;
        }
        int[] cnt = this.table.getSelectedRows();
        SBase[] array = new SBase[cnt.length];
        int i = 0;
        while (i < cnt.length) {
            int index = cnt[i];
            array[i] = this.sbaseList.get((long)index);
            ++i;
        }
        return array;
    }

    public void updateDialog() {
        if (this.listTableModel == null) {
            return;
        }
        this.listTableModel.fireTableDataChanged();
        this.changeButtonsEnability();
        if (this.isShowing()) {
            this.repaint();
        }
        this.updateChildDialog();
    }

    public void selectElement(int[] indices) {
        this.table.clearSelection();
        int i = 0;
        while (i < indices.length) {
            if (indices[i] >= 0 && indices[i] < this.table.getRowCount()) {
                this.table.addRowSelectionInterval(indices[i], indices[i]);
            }
            ++i;
        }
    }

    public abstract SBaseDialog getElementDialog();

    public abstract SBaseDialog getElementDialog(int var1);

    public abstract void setElementDialog(SBaseDialog var1);

    public abstract void setElementDialog(SBaseDialog var1, int var2);

    public abstract void setElementDialogMode(int var1);

    public abstract void setSelfOperational(boolean var1);

    public abstract void setSBaseList(ListOf var1);

    public abstract void releaseAll();

    public abstract void disableChildDialog();

    public abstract void setButtonVisible(int var1, boolean var2);

    public void enableDeleteKey(boolean isDeleteKeyEnabled) {
        this.keyListener.isDeleteKeyEnabled = isDeleteKeyEnabled;
    }

    protected abstract void changeButtonsEnability();

    protected abstract void changeElementDialogEnability();

    protected abstract void updateChildDialog();

    protected abstract void removeButton_actionPerformed();

    protected abstract void initTableModel(SBase var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSBaseListDialogListener(SBaseListDialogListener l) {
        Vector vector = this.listeners;
        synchronized (vector) {
            boolean exists = false;
            int i = 0;
            while (i < this.listeners.size()) {
                SBaseListDialogListener listener = (SBaseListDialogListener)this.listeners.elementAt(i);
                if (listener.equals(l)) {
                    exists = true;
                    break;
                }
                ++i;
            }
            if (!exists) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSBaseListDialogListener(SBaseListDialogListener l) {
        Vector vector = this.listeners;
        synchronized (vector) {
            int i = 0;
            while (i < this.listeners.size()) {
                SBaseListDialogListener listener = (SBaseListDialogListener)this.listeners.elementAt(i);
                if (listener.equals(l)) {
                    this.listeners.remove(listener);
                    break;
                }
                ++i;
            }
        }
    }

    protected class MyKeyListener
    extends KeyAdapter {
        boolean isDeleteKeyEnabled;
        boolean isButtonsVisible;

        protected MyKeyListener() {
            this.isDeleteKeyEnabled = SBaseListDialog.this.isSelfOperational;
            this.isButtonsVisible = true;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if ((e.getKeyCode() == 8 || e.getKeyCode() == 127) && SBaseListDialog.this.isSelfOperational && this.isDeleteKeyEnabled) {
                SBaseListDialog.this.removeButton_actionPerformed();
            }
            if (e.getKeyCode() == 66) {
                if (this.isButtonsVisible) {
                    SBaseListDialog.this.setSelfOperational(false);
                } else {
                    SBaseListDialog.this.setSelfOperational(true);
                }
                boolean bl = this.isButtonsVisible = !this.isButtonsVisible;
            }
            if (e.getKeyCode() == 82 && SBaseListDialog.this.isSelfOperational) {
                SBaseListDialog.this.updateDialog();
            }
        }
    }

    protected class MyListSelectionListener
    implements ListSelectionListener {
        boolean hasLastSelected = false;

        protected MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                SBaseListDialog.this.changeButtonsEnability();
                SBaseListDialog.this.changeElementDialogEnability();
                SBase[] selected = SBaseListDialog.this.getSelectedElements();
                Vector list = (Vector)SBaseListDialog.this.listeners.clone();
                int i = 0;
                while (i < list.size()) {
                    SBaseListDialogListener listener = (SBaseListDialogListener)list.elementAt(i);
                    if (selected.length > 0) {
                        listener.elementsSelected(selected);
                    } else if (this.hasLastSelected) {
                        listener.elementsDeselected();
                    }
                    ++i;
                }
                this.hasLastSelected = selected.length != 0;
            }
        }
    }

    protected class MyTableModel
    extends AbstractTableModel {
        String[] columnNames;

        MyTableModel(String[] columnNames) {
            this.columnNames = columnNames;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return LibSBMLUtil.getListOfValueAt(SBaseListDialog.this.sbaseList, row, col);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (SBaseListDialog.this.sbaseList == null) {
                return 0;
            }
            return (int)SBaseListDialog.this.sbaseList.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }
    }
}

